<?php
/**
 * 单页预览
 */
namespace app\index\controller;

use app\common\controller\BaseController;
use app\common\model\PageModel;
use think\Db;

class PageController extends BaseController
{
    public function index()
    {
        $id = $this->request->param('id/d');

        $page = PageModel::get($id);

        if (empty($page))
            return $this->redirect('index/index/index');

        Db::name('page')->where('id', $id)->setInc('hits', 1, 10);

        $page['content'] = htmlspecialchars_decode($page['content']);

        $this->assign(['page' => $page]);

        return $this->fetch('/page');
    }
}
