<?php
namespace app\index\controller;

use app\common\model\ArticleModel;
use think\Db;
use app\common\controller\BaseController;

class ListController extends BaseController
{
    public function index()
    {
        $catID = $this->request->param('id/d',0, 'intval');

        $cate = Db::name('category')->get($catID);

        $count = Db::name('article')->where('status', 1)->where('category_id', $catID)->count();

        $articles = ArticleModel::where('category_id', $catID)
            ->where('status', 1)
            ->order('id desc')
            ->limit(0, 10)
            ->all();

        foreach ($articles as $key => $vo) {
            $articles[$key]['link'] = url('index/article/index', 'id=' . $vo['id']);
        }

        $this->assign(['cate'=>$cate,'count'=>$count,'articles'=>$articles]);

        return $this->fetch('/list');
    }

    public function get_article_flow()
    {
        $res['code'] = 1;
        $res['msg'] = 'success';

        $catID = $this->request->param('id/d',0, 'intval');

        $count = Db::name('article')->where('status', 1)->where('category_id', $catID)->count();

        $page = $this->request->param('page');
        $articles = ArticleModel::where('category_id', $catID)
        ->where('status', 1)
        ->order('id desc')
        ->limit($page * 10, 10)
        ->all();

        foreach ($articles as $key => $vo) {
            $articles[$key]['link'] = url('index/article/index', 'id=' . $vo['id']);
        }
        $res['data'] = $articles;
        $res['pages'] = $count / 10;
        return $res;
    }
}
