<?php
namespace app\index\controller;

use app\common\controller\BaseController;
use app\common\model\ArticleModel;
use app\common\model\SlideModel;
use think\Db;

class IndexController extends BaseController
{
    public function index()
    {
        $count = ArticleModel::where('status', 1)->count();
        $articles = ArticleModel::where('status', 1)->field('id,title,excerpt,create_time')
        ->order('id desc')
        ->limit(0, 10)
        ->all();
        foreach ($articles as $key=>$vo){
            $articles[$key]['link'] = url('index/article/index','id='.$vo['id']);
        }

//        $slide = get_slide('index_carousel');

        $this->assign(['count'=>$count,'articles'=>$articles]);//,'slide'=>$slide

        return $this->fetch('/index');
    }

    public function get_article_flow()
    {
        $res['code'] = 1;
        $res['msg'] = 'success';

        $count = ArticleModel::where('status', 1)->count();

        $page = $this->request->param('page');
        $articles = ArticleModel::where('status', 1)
            ->field('id,title,excerpt,create_time')
        ->order('id desc')
        ->limit($page * 10, 10)
        ->all();
        foreach ($articles as $key=>$vo){
            $articles[$key]['link'] = url('index/article/index','id='.$vo['id']);
        }
        $res['data'] = $articles;
        $res['pages'] = $count / 10;
        return $res;
    }

    /**
     * 联系我们
     * @return mixed
     */
    public function contact()
    {
        if ($this->request->isPost()) {
            $data = $this->request->param();

            $res['code'] = 1;
            $res['msg'] = '感谢您的留言！';

            $data['create_time'] = date('Y-m-d H:i:s',time());

            $result = Db::name('contact')->insert($data);

            if ($result === false) {
                $res['code'] = 0;
                $res['msg'] = '添加失败！';
            }

            return json($res);
        }

        return $this->fetch('/contact');
    }
}
