<?php
// +----------------------------------------------------------------------
// | 文章展示控制器详情页
// +----------------------------------------------------------------------
// | Author:  Eric <ieyangxiaoguo@126.com>
// +----------------------------------------------------------------------
// | Copyright ©2018  http://www.zzuyxg.top  All rights reserved.
// +----------------------------------------------------------------------
// | 2018年3月22日
// +----------------------------------------------------------------------
namespace app\index\controller;

use app\common\controller\BaseController;
use app\common\model\ArticleModel;
use think\Db;

class ArticleController extends BaseController
{
    public function index()
    {
        $id = $this->request->param('id/d');

        $article = ArticleModel::with('category')->get($id);

        if (empty($article))
            return $this->redirect('index/index/index');

        Db::name('article')->where('id', $id)->setInc('hits', 1, 10);

        $front = Db::name('article')->field('id,title')->where("id", '<', $id)->order('id asc')->limit('1')->find();
        $next = Db::name('article')->field('id,title')->where("id", '>', $id)->order('id asc')->limit('1')->find();

        $article['content'] = htmlspecialchars_decode($article['content']);

        $this->assign(['article' => $article, 'front' => $front, 'next' => $next]);

        return $this->fetch('/article');
    }
}
