<?php
/**
 *
 * 单页模型
 */
namespace app\common\model;

use think\Model;
use think\model\concern\SoftDelete;

class PageModel extends Model
{
    use SoftDelete;
    protected $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;

    /**
     * 关联 user表
     * @return $this
     */
    public function user()
    {
        return $this->belongsTo('AdminModel', 'user_id')->setEagerlyType(1);
    }

    public function setContentAttr($value){
        return htmlspecialchars($value);
    }

    public function getContentAttr($value)
    {
        return htmlspecialchars_decode($value);
    }
}
