<?php
// +----------------------------------------------------------------------
// | 文章模型
// +----------------------------------------------------------------------
// | Author:  Eric <ieyangxiaoguo@126.com>
// +----------------------------------------------------------------------
// | Copyright ©2017  http://www.zzuyxg.top  All rights reserved.
// +----------------------------------------------------------------------
// | 2017年10月12日
// +----------------------------------------------------------------------
namespace app\common\model;

use think\Model;
use think\model\concern\SoftDelete;

class ArticleModel extends Model
{
    use SoftDelete;
    protected $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;

    /**
     * 关联 user表
     * @return $this
     */
    public function user()
    {
        return $this->belongsTo('AdminModel', 'user_id')->setEagerlyType(1);
    }

    /**
     * 关联分类表
     */
    public function category(){
        //一对一
        return $this->belongsTo('CategoryModel','category_id');
    }

    public function setContentAttr($value){
        return htmlspecialchars($value);
    }

    public function getContentAttr($value)
    {
        return htmlspecialchars_decode($value);
    }

    /**
     * published_time 自动完成
     * @param $value
     * @return false|int
     */
    public function setPublishedTimeAttr($value)
    {
        return strtotime($value);
    }
}
