<?php
// +----------------------------------------------------------------------
// | 单页管理
// +----------------------------------------------------------------------
// | Author:  Eric <ieyangxiaoguo@126.com>
// +----------------------------------------------------------------------
// | Copyright ©2018  http://www.zzuyxg.top  All rights reserved.
// +----------------------------------------------------------------------
// | 2018年3月25日
// +----------------------------------------------------------------------
namespace app\admin\controller;

use app\common\controller\AdminBaseController;
use app\common\model\ArticleModel;
use app\common\model\PageModel;

class PageController extends AdminBaseController
{
    public function index()
    {
        $model = new PageModel();
        $pages = $model->all();

        $this->assign('pages', $pages);

        return $this->fetch();
    }

    public function add()
    {
        if ($this->request->isPost()) {
            $data = $this->request->param();

            $data['user_id'] = get_current_admin_id();
//             $data['content'] = htmlspecialchars($data['content']);

            $res['code'] = 1;
            $res['msg'] = '添加成功！';

            $model = new PageModel();

            $result = $model->allowField(true)->save($data);

            if ($result === false) {
                $res['code'] = 0;
                $res['msg'] = '添加失败！';
            } else {
                $res['url'] = url('page/index');
            }

            return $res;
        } else {
            return $this->fetch();
        }
    }

    /**
     * 编辑文章
     */
    public function edit()
    {
        if ($this->request->isPost()) {
            $page = $this->request->param();
            $res['code'] = 1;
            $res['msg'] = '保存成功！';
            $res['url'] = url('admin/page/index');

            $model = new PageModel();

            $result = $model->allowField(true)->isUpdate()->save($page);

            if ($result === false) {
                $res['code'] = 0;
                $res['msg'] = '保存失败！';
            }
            return $res;
        } else {
            $id = $this->request->param('id', 0, 'intval');
            $page = PageModel::get($id);

            $this->assign('page', $page);

            return $this->fetch();
        }
    }
}
