<?php
// +----------------------------------------------------------------------
// | 邮箱设置
// +----------------------------------------------------------------------
// | Author: Eric <ieyangxiaoguo@126.com>
// +----------------------------------------------------------------------
// | Copyright ©2017 http://www.zzuyxg.top All rights reserved.
// +----------------------------------------------------------------------
// | 2017年9月28日
// +----------------------------------------------------------------------
namespace app\admin\controller;

use app\common\controller\AdminBaseController;

class MailerController extends AdminBaseController
{
    public function index()
    {
        if ($this->request->isPost()) {
            $post = array_map('trim', $this->request->param());
            
            set_option('smtp_setting', $post);
            
            $this->success("保存成功！");
        } else {
            $emailSetting = get_option('smtp_setting');
            $this->assign($emailSetting);
            return $this->fetch();
        }
    }
    
    public function template()
    {
        if ($this->request->isPost()) {
            $templateKey  = $this->request->param('template_key');
            
            $data = $this->request->param();
            
            unset($data['template_key']);
            
            set_option('email_template_' . $templateKey, $data);
            
            $this->success("保存成功！");
        } else {
            $templateKey = $this->request->param('template_key','order');
            
            $template = get_option('email_template_' . $templateKey);
            $this->assign($template);
            return $this->fetch();
        }
    }
}

