<?php
// +----------------------------------------------------------------------
// | LinkController.php 文件用途描述
// +----------------------------------------------------------------------
// | Copyright (c) 2016-2018  http://www.zzuyxg.top All rights reserved.
// +----------------------------------------------------------------------
// | Author: Eric <ieyangxiaoguo@126.com>
// +----------------------------------------------------------------------
// | Date:2018年3月24日
// +----------------------------------------------------------------------
namespace app\admin\controller;

use app\common\model\LinkModel;
use app\common\controller\AdminBaseController;
use think\facade\Cache;

class LinkController extends AdminBaseController
{
    protected $targets = [
        "_blank" => "新标签页打开",
        "_self" => "本窗口打开"
    ];

    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        Cache::rm('friend_links');
    }

    public function index()
    {
        return $this->fetch();
    }

    public function getRows()
    {
    	$links = LinkModel::all();
    	$res['code'] = 0;
    	$res['msg'] = 'success';
    	$res['data'] = $links;
    	return $res;
    }

    /**
     * 添加友情链接
     */
    public function add()
    {
        if ($this->request->isPost()) {
        	$data = $this->request->param();
        	$res['code'] = 1;
        	$res['msg'] = '添加成功！';
        	$model = new LinkModel();
        	$result = $model->allowField(true)->save($data);

        	if ($result === false) {
        		$res['code'] = 0;
        		$res['msg'] = '添加失败！';
        	} else {
        		$res['url'] = url('index');
        	}

        	return $res;
        } else {
            $this->assign('targets', $this->targets);
            return $this->fetch();
        }
    }

    public function delete()
    {
        $id = $this->request->param('id', 0, 'intval');
        LinkModel::destroy($id);

        $res['code'] = 1;
        $res['msg'] = '删除成功！';

        return $res;
    }

    public function changeShow()
    {
    	return parent::switchOperate(new LinkModel());
    }

    public function updateField() {
    	return parent::fieldUpdate(new LinkModel());
    }
}
