<?php
/**
 * 留言管理
 */
namespace app\admin\controller;

use app\common\controller\AdminBaseController;
use app\common\model\ContactModel;
use think\Db;

class ContactController extends AdminBaseController
{
    public function index()
    {
        return $this->fetch();
    }

    public function getContacts()
    {
        $count = Db::name('contact')->count();

        $page = $this->request->param('page',1,'intval');
        $limit = $this->request->param('limit',10,'intval');

        $lists = Db::name('contact')->order('id','desc')->limit(($page-1)*$limit,$limit)->all();

    	$res['code'] = 0;
    	$res['msg'] = 'success';
    	$res['data'] = $lists;
        $res['count'] = $count;
    	return $res;
    }

    public function delete()
    {
        $id = $this->request->param('id', 0, 'intval');
        Db::name('contact')->delete($id);

        $res['code'] = 1;
        $res['msg'] = '删除成功！';

        return $res;
    }

    public function updateField() {
        return parent::fieldUpdate(new ContactModel());
    }
}
