<?php
// +----------------------------------------------------------------------
// | AssetController.php 附近上传
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2018  http://www.zzuyxg.top All rights reserved.
// +----------------------------------------------------------------------
// | Author: Eric <ieyangxiaoguo@126.com>
// +----------------------------------------------------------------------
// | Date:2018-06-03
// +----------------------------------------------------------------------
namespace app\admin\controller;

use app\common\controller\AdminBaseController;
use app\common\model\AssetModel;

class AssetController extends AdminBaseController
{
    public function index()
    {
        return $this->fetch();
    }

    /**
     * 获取文件分页数据
     * User: Eric
     * DateTime: 2019/5/14 22:54
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getAssets(){

        $count = AssetModel::count();

        $page = $this->request->param('page', 1, 'intval');
        $limit = $this->request->param('limit', 10, 'intval');

        $lists = AssetModel::order('id desc')->limit(($page - 1) * $limit, $limit)->select();

        $res['code'] = 0;
        $res['msg'] = 'success';
        $res['data'] = $lists;
        $res['count'] = $count;

        return $res;
    }

    /**
     * User: Eric
     * DateTime: 2019/5/14 23:07
     * @return \think\response\Json
     * 使用api/asset/umeUpload接口
     */
    public function umeUpload()
    {
        if ($this->request->isPost()) {
            $res['state'] = 'SUCCESS';
            $res['msg'] = '上传成功！';

            $file = $this->request->file('upfile');
            $date = date('Ymd',time());
            $info = $file->rule('uniqid')->move('../public/upload/umeditor/'.$date.'/');
            if ($info) {
                $res['url'] = 'upload/umeditor/'.$date.'/'.$info->getSaveName();
            } else {
                $res['state'] = 'ERROR';
            }

            return json($res);
        }
    }
}
