<?php
// +----------------------------------------------------------------------
// | 后台文章管理控制器
// +----------------------------------------------------------------------
// | Author: Eric <ieyangxiaoguo@126.com>
// +----------------------------------------------------------------------
// | Copyright ©2017 http://www.zzuyxg.top All rights reserved.
// +----------------------------------------------------------------------
// | 2017年10月12日
// +----------------------------------------------------------------------
namespace app\admin\controller;

use app\common\controller\AdminBaseController;
use app\common\model\ArticleModel;

class ArticleController extends AdminBaseController
{
    /**
     * 文章列表
     */
    public function index()
    {
        $categoryCtr = new CategoryController();

        $categories = $categoryCtr->apiGetCategorys(0);

        $this->assign(['categories'=>$categories['data'],'page_title'=>'文章列表']);

        return $this->fetch();
    }

    public function getArticleList(){
        $map = [];
        $catID = $this->request->param('catID/d', 0, 'intval');
        $keyword = $this->request->param('keyword', '');

        $map[] = ['post_type','=',0];

        if ($catID) {
            $map[] = ['category_id','=',$catID];
        }
        if ($keyword != '') {
            $map[] = ['title','like',$keyword.'%'];
        }

        $count = ArticleModel::where($map)->count();

        $page = $this->request->param('page',1,'intval');
        $limit = $this->request->param('limit',10,'intval');

        $lists = ArticleModel::where($map)->with('category')->order('id desc')->limit(($page-1)*$limit,$limit)->all();

        $res['code'] = 0;
        $res['msg'] = 'success';
        $res['data'] = $lists;
        $res['count'] = $count;
        return $res;
    }

    public function trashed()
    {
        $categoryCtr = new CategoryController();

        $categories = $categoryCtr->apiGetCategorys(0);

        $this->assign('categories', $categories['data']);

        return $this->fetch();
    }
    public function getArticleListTrashed(){
        $map = [];
        $catID = $this->request->param('catID/d', 0, 'intval');
        $keyword = $this->request->param('keyword', '');

        if ($catID) {
            $map[] = ['category_id','=',$catID];
        }
        if ($keyword != '') {
            $map[] = ['title','like',$keyword.'%'];
        }

        $count = ArticleModel::onlyTrashed()->where($map)->count();

        $page = $this->request->param('page',1,'intval');
        $limit = $this->request->param('limit',10,'intval');

        $lists = ArticleModel::onlyTrashed()->where($map)->with('category')->order('id desc')->limit(($page-1)*$limit,$limit)->all();

        $res['code'] = 0;
        $res['msg'] = 'success';
        $res['data'] = $lists;
        $res['count'] = $count;
        return $res;
    }

    /**
     * 添加文章
     */
    public function add()
    {
        if ($this->request->isPost()) {
            $post = $this->request->param();
            $count = $post['thumbs_count'];

            if ($count) {
                for ($i = 0; $i < $count; $i ++) {
                    $post['thumbs'][] = array(
                        "src" => $_POST['pc_src'][$i],
                        "url" => $_POST['pc_url'][$i],
                        "alt" => $_POST['pc_alt'][$i]
                    );
                }
                $post['thumbs'] = json_encode($post['thumbs']);
            }

            $post['user_id'] = get_current_admin_id();
            $post['content'] = htmlspecialchars($post['content']);

            $res['code'] = 1;
            $res['msg'] = '添加成功！';

            $result = ArticleModel::create($post);

            if ($result === false) {
                $res['code'] = 0;
                $res['msg'] = '添加失败！';
            } else {
                $res['url'] = url('article/edit', [
                    'id' => $result->id
                ]);
            }

            return $res;
        } else {
            $categoryCtr = new CategoryController();

            $categories = $categoryCtr->apiGetCategorys(0);

            $this->assign(['categories'=>$categories['data'],'page_title'=>'软文发布']);

            return $this->fetch();
        }
    }

    /**
     * 编辑文章
     */
    public function edit()
    {
        if ($this->request->isPost()) {
            $data = $this->request->param();

            $res['code'] = 1;
            $res['msg'] = '保存成功！';

            $data['content'] = htmlspecialchars($data['content']);

            $result = ArticleModel::update($data,['id'=>$data['id']]);

            if ($result === false) {
                $res['code'] = 0;
                $res['msg'] = '保存失败！';
            }

            return $res;
        } else {
            $id = $this->request->param('id/d', 0, 'intval');

            $post = ArticleModel::get($id);

            $categoryCtr = new CategoryController();

            $categories = $categoryCtr->apiGetCategorys(0);

            $this->assign(['categories'=>$categories['data'],'post'=>$post,'page_title'=>'软文编辑']);

            return $this->fetch();
        }
    }

    /**
     * 加入回收站
     * @return mixed
     */
    public function recycle()
    {
        $param = $this->request->param();

        if (isset($param['id'])) {
            $id = $this->request->param('id', 0, 'intval');

            ArticleModel::destroy($id);

            $res['code'] = 1;
            $res['msg'] = '回收成功！';
            return $res;
        }

        if (isset($param['ids'])) {
            $ids = $this->request->param('ids/a');
            ArticleModel::destroy($ids);

            $res['code'] = 1;
            $res['msg'] = '回收成功！';
            return $res;
        }
    }

    /**
     * 彻底删除数据
     * @return mixed
     */
    public function delete()
    {
        $param = $this->request->param();

        if (isset($param['id'])) {
            $id = $this->request->param('id', 0, 'intval');

            ArticleModel::destroy($id,true);

            $res['code'] = 1;
            $res['msg'] = '删除成功！';
            return $res;
        }

        if (isset($param['ids'])) {
            $ids = $this->request->param('ids/a');
            ArticleModel::destroy($ids,true);

            $res['code'] = 1;
            $res['msg'] = '删除成功！';
            return $res;
        }
    }

    /**
     * 恢复文章到列表
     * @author Eric
     * @return mixed
     * @throws \think\exception\DbException
     */
    public function restore()
    {
        $param = $this->request->param();

        if (isset($param['id'])) {
            $id = $this->request->param('id', 0, 'intval');

            $article = ArticleModel::onlyTrashed()->get($id);
            $article->restore();

            $res['code'] = 1;
            $res['msg'] = '恢复成功！';
            return $res;
        }
    }

    /**
     * 显示/开启操作
     *
     * @author Eric ieyangxiaoguo@126.com
     * @date 2017年11月29日
     */
    public function doSwitch()
    {
        return parent::switchOperate(new ArticleModel());
    }
}
