<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTemplateTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('templates', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->bigInteger('app_id')->index()->comment('所属小程序');
            $table->string('template_id')->comment('模板ID');
            $table->string('title')->comment('消息模板标题');
            $table->text('content')->nullable()->comment('模板消息内容');
            $table->jsonb('keyword_ids')->comment('消息模板关键字组合模板排列ID');

            $table->timestamp('created_at')->nullable()->index();
            $table->timestamp('updated_at')->nullable()->index();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('templates');
    }
}
