# OSTEP-HW

[Operating Systems: Three Easy Pieces](https://pages.cs.wisc.edu/~remzi/OSTEP) homework solutions

[CS-537 videos](https://pages.cs.wisc.edu/~remzi/Classes/537/Spring2018/Discussion/videos.html)

## Requirements

- Unix-like operating system

- [Clang](https://clang.llvm.org)/[GCC](https://gcc.gnu.org)

- [LLDB](https://lldb.llvm.org)/[GDB](https://www.gnu.org/software/gdb)

- [Valgrind](https://valgrind.org)

- [Gawk](https://www.gnu.org/software/gawk)

- [Python](https://www.python.org)

- 🐈

## [ostep-projects](./projects)

C/Linux Projects and Kernel Hacking Projects (xv6)

## Chapters

### Virtualization

4. [The Abstraction: The Process](./4)

5. [Interlude: Process API](./5)

6. [Mechanism: Limited Direct Execution](./6)

7. [Scheduling: Introduction](./7)

8. [Scheduling: The Multi-Level Feedback Queue](./8)

9. [Scheduling: Proportional Share](./9)

10. [Multiprocessor Scheduling (Advanced)](./10)

11. Summary Dialogue on CPU Virtualization

12. A Dialogue on Memory Virtualization

13. [The Abstraction: Address Spaces](./13)

14. [Interlude: Memory API](./14)

15. [Mechanism: Address Translation](./15)

16. [Segmentation](./16)

17. [Free-Space Management](./17)

18. [Paging: Introduction](./18)

19. [Paging: Faster Translations (TLBs)](./19)

20. [Paging: Smaller Tables](./20)

21. [Beyond Physical Memory: Mechanisms](./21)

22. [Beyond Physical Memory: Policies](./22)

### Concurrency

26. [Concurrency: An Introduction](./26)

27. [Interlude: Thread API](./27)

28. [Locks](./28)

29. [Lock-based Concurrent Data Structures](./29)

30. [Condition Variables](./30)

31. [Semaphores](./31)

32. [Common Concurrency Problems](./32)

33. [Event-based Concurrency (Advanced)](./33)

### Persistence

37. [Hard Disk Drives](./37)

38. [Redundant Arrays of Inexpensive Disks (RAIDs)](./38)

39. [Interlude: Files and Directories](./39)

40. [File System Implementation](./40)

41. [Locality and The Fast File System](./41)

42. [Crash Consistency: FSCK and Journaling](./42)

43. [Log-structured File Systems](./43)

44. [Flash-based SSDs](./44)

45. [Data Integrity and Protection](./45)

46. Summary Dialogue on Persistence

47. A Dialogue on Distribution

48. [Distributed Systems](./48)

49. [Sun’s Network File System (NFS)](./49)

50. [The Andrew File System (AFS)](./50)

## License

This work is licensed under the GPLv3 or any later version.
