# Contribution Guide
> [English](/CONTRIBUTING.md)


## 새 아이콘 요청 
기본 아이콘 셋을 제외한 새로운 아이콘은 [Github XEIcon커뮤니티](../../issues)에서 요청되어 제작하게 됩니다. 아래 내용을 준수하여 아이콘 제작요청을 진행합니다.

1. 작성하려는 이슈가 이미 있는지 [검색](../../search?type=Issues) 후 등록해주세요. 이미 등록된 요청이라면, 해당 이슈에 "+1" 댓글을 달아주세요.
2. 일반적인 세트 아이콘(e.g., 좋아요, 싫어요)을 제외하고, 하나의 이슈에 한개의 아이콘을 요청합니다. 
3. 요청 시, 아래 상세 항목을 포함하면 더 빠른 이슈 처리가 가능합니다.
	- [새 이슈 등록](../../issues/new?title=Icon%20Request:%20icon-) 시, 제목은 `Icon request: icon-name`으로 작성합니다. (e.g., `Icon request: xpressengine`)
	- 요청되는 아이콘의 실 사용 예를 간략히 설명해주세요. 
	- 요청하는 아이콘의 샘플 이미지를 한두 개 첨부하여 주세요.
	- 구체적인 개체를 요청하여 주세요. 

## 이슈 작성
이슈는 아이콘 요청, 버그 제보, 기능 요청에 한해서 작성해주세요. 버그는 XEIcon 시스템 내에서 해결/개선할 수 있는 문제여야 합니다. 아래 지침을 참조해주세요.

1. **동일한 이슈가 있는지 확인합니다.** 비슷한 이슈가 있다면 댓글로 추가 내용을 덧붙일 수 있습니다.
2. **이슈에는 하나의 문제 또는 제안을 작성합니다.** 하나의 이슈에 2개 이상의 내용을 적지 않습니다.
3. 해당 내용을 분리하여 재현된 **테스트 케이스를 작성합니다.**
4. 되도록 **예제 파일을 포함합니다.** [jsFiddle](http://jsfiddle.net/), [jsBin](http://jsbin.com/) 또는 [Codepen](http://codepen.io/) 등을 사용하여 예제를 만들 수 있습니다.
5. 운영체제와 버전, 브라우저, XEIcon의 버전 등, 최대한 상세한 정보를 공유합니다.


## Branches 정보
- `master`는 최근 배포된 버전 브랜치입니다.
- `*-wip`는 다음 배포를 위한 내부 작업 저장소입니다. 
- `gh-pages`는 호스팅된 문서페이지입니다.
- `orginallibary`는 라이브러리 페이지 그런트 배포 문서입니다. 


## 저장소에 대한 참고사항
- `orginallibary branch, src/` - 문서 및 LESS, SCSS, CSS에 대한 모든 편집은 이 디렉토리 안의 파일과 템플릿으로 만들어져야 합니다.  
- `orginallibary branch,  selection.json` - 모든 LESS, SCSS 및 CSS icon 정의는 이 단일 파일로부터 생성됩니다.


## 코딩 기준 : HTML
- 들여쓰기는 스페이스가 아닌 탭으로 합니다.
- 인용부호는 큰따옴표를 사용해야 하며, 작은 따옴표는 사용하지 않습니다.
- 항상 적절한 들여쓰기를 사용합니다.
- HTML5 문서에 적합한 엘리멘트와 태그들을 사용합니다.


## 코딩 기준 : CSS
- CSS 코드의 가독성을 위해 한줄로 작성합니다.
- CSS 코드는 공백을 최소화합니다. 
- SASS, LESS의 경우 모든 라인의 끝은 세미콜론으로 끝나야 합니다.
- `input[type="text"]` 와 같은 속성 선택자는 일관성과 보안을 위해서 항상 큰 따옴표로 감싸야 합니다. (인용부호를 사용하지 않는 속성 값은 XSS 공격의 대상이 될 수 있음)


## Pull requests
- 아이콘이 포함된 pull requests는 승인하지 않습니다.
- 모든 pull requests는 머지를 쉽게 하기 위해 적절한 `*-wip` 브런치에 서브밋합니다.
- 스타일에 대한 모든 변경 사항은 `src` 디렉토리에 .less과 .scss 파일을 변경해야 합니다.
- 만약 less, scss파일을 수정한다면, 항상 재컴파일하고 컴파일된 파일을 커밋해야 합니다.
- 의도치 않은 결과를 초래하는 pull request는 요청하지 않습니다.
- Pull request를 하기 전에 테스트 된 브라우저를 공유합니다.


## License
코드기여는 [MIT라이선스](http://opensource.org/licenses/mit-license.html)의 조건에 동의함을 의미합니다.
