---
title: 面试速成
category: 学习路线
icon: "xitongsheji"
---

## 1. 算法与数据结构

专业的事交给专业的人做，虽然我算法也还行，但是怎样去总结出一套优秀的模板，专题去帮助别人更好理解算法却是不在行。

因此我此模块我没有把自己的算法笔记写出来，不过，这里会记录我的刷题经验与心得，并且指出一条好的学习路线。

### 刷题指导

`1.学习方式`

**口诀**：`效率至上、以练带学、熟能生巧`

**效率至上**

如果你不是专业的算法工程师，或者特别喜欢算法，建议不要去买一大本书或者网上找几十集视频挨着从头到尾学习。这样见效慢，效率低下，浪费时间。

**以练带学**

我的建议是，`先简单看看理论概念，学完直接刷题`，做题过程中遇到不会的并且该类型题没遇到过，直接看题解，别在那苦思冥想，算法这玩意你如果不是功力深厚基本靠自己想破脑子你还是不会，做出来了也是暴力破解，浪费时间，打击信心。

如果是做过的类型可以自己试着能不能举一反三，自己先试试，最多10分钟没思路就看题解，快速过题。然后**看题解过程遇到不懂的再百度看看**，比如提到二叉树，你忘了不懂，可以直接百度 关于二叉树的介绍 题解看懂了再自己又做。

其实你看题解和写代码过程中就把那些常考的数据结构与算法逐渐掌握了。所以没太大必要挨着逐个去看书，大厂面试基本就是考力口，牛客那些类型的题，你做个几十道题基本就把常考的数据结构与算法类型过了一遍了。

如果实在想系统学一下，也不建议买一本厚厚的书来看，也不用看视频系统学，好的办法是可以直接看一些优秀的专栏学习。

专利把精华都提炼出来了，而且几乎涵盖了所有面试会考的数据结构与算法。

**熟能生巧**

然后，再给大家分享一个小技巧，这是我当时用的一个笨方法，如果你觉得有用也可以借鉴一下，哈哈。这是我的「**算法统计**」

![image-20220213200413626](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212469.png)

正如你所看到的，在备战期间，为了保持手感，我基本不会再做新题，基本就是刷 `top200` 的题，从高排名往后排名刷。

然后为了重复往返记忆，每当我做一道题，我会记录他的序号，链接，并做上特殊符号，就像上面 （* 代表背着做对一次， X 代表没做起 数字代表做了多少次了）。

然后今天刷完，第二天我就会把之前没对的题先再做一遍，快速拉过，如此反复循环，争取每道题至少连续做对3遍，这样在你理解的基础上，基本你都可以把代码默写出来了。

`2.相关资料`

极客时间:《数据结构与算法之美》、极客训练营

**下载方式：微信搜索公众号「*小龙coding*」**，也可以直接截图扫描下方二维码，在后台回复「**刷题笔记**」即可获取此处提到的刷题笔记

![MySQL](https://cdn.jsdelivr.net/gh/xlcoding/ImageHost/imgs/xlcoding2.png)

`3.刷题指南`

刷题网站(top200＋剑指offer)

> 力扣：https://leetcode-cn.com/problem-list/2cktkvj

> 牛客：https://www.nowcoder.com/exam/oj?tab=%E7%AE%97%E6%B3%95%E7%AF%87&topicId=117&page=1

> 刷题顺序：https://github.com/greyireland/algorithm-pattern

> 大厂题库：https://codetop.cc/#/home

有的同学不知道怎么刷题，我这里给大家分情况谈论一下。

你无非就两种情况，不着急找工作和着急找工作。

怎样界定你是否属于着急和不着急呢？比如我需要参加2个月后的春招，并且想在春招中找一个实习或者校招offer，那么你就可以划定为着急找工作。

**不着急找工作**

- 每日一题
- 按tag 标签刷题，把力口每种标签类型的题都刷个几道

**着急找工作**

- **平时**：直接刷热题，高频题，根据我的经验100-200左右基本就涵盖了经常考的那些题。可以刷 top200 +剑指offer（剑指offer很多题 top200 都有）

  ![image-20220213194721564](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212476.png)

  

- **临近面试几天**：刷牛客`上周考过` 并根据自己需要的岗位+公司进行筛选

  ![image-20220213194849242](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212478.png)

### 刷题笔记

此外，我还整理了几份优质「**刷题笔记**」，秋招时便是时常查阅学习其算法思想。

#### 刷题笔记101—谷歌

这是一位在谷歌无人车部门（Waymo）的工程师，从事计算机视觉和机器学习方向。

他在美国卡内基梅隆大学攻读硕士学位时，为了准备实习秋招，他从夏天开始整理某 code 上的题目，几个月的时间，刷了几百道题目。

话不多说，可以简单看看该笔记的目录，精简核心。题不多不杂，几乎每种类型的题目都有涉及。

![](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212481.png)

个人感觉，这是一份非常哇塞的笔记，真的非常非常nice，就像高考时的总复习资料一样，有每一个知识的例题讲解，每个例题开始会给你归纳涉及的知识点，然后给你例题，解析，教你分析。

最重要的是它不是仅仅的出一些例题，而是算法的常用技巧，如：双指针、动态规划、回溯等等每个方法还没有专题，再出例题讲解，很哇塞。![image-20220124105904891](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212480.png)

![image-20220124105636166](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212483.png)

**下载方式：微信搜索公众号「*小龙coding*」**，也可以直接截图扫描下方二维码，在后台回复「**刷题笔记**」即可获取此处提到的刷题笔记

![MySQL](https://cdn.jsdelivr.net/gh/xlcoding/ImageHost/imgs/xlcoding2.png)

如果是学习算法、数据结构、或者是刷题找工作的小伙伴，一定不要错过啦！

#### BAT刷题笔记—halfrost

这本书包含了 LeetCode Online Judge 所有题目的答案，所有的代码实现是非常优雅且执行效率极高的。

不管你是 Python、C++、Go、Java 都可以学习算法思想，编码规范良好，适合刷题的同学反复学习，揣摩其中的框架思维。

这是一本非常用心的刷题类书籍，全书总共 1200 页，`分编程技巧、线性表、字符串、栈队列、树、排序、查找、BFS、DFS、贪心、动态规划`等。

最主要的是该笔记里面的题目的代码全是 beats 100%%，暴力大部分人都能做到，但是如何做到最优，却是极其困难。

而面试中，面试官对于暴力解法也不会满意，经常会来一句：“还有没有更优解？”

再来个更优雅的解法，面试绝对能加分。

看完这本笔记，在 Leetcode 上`遇到中等难度的题基本不会卡顿`了。

话不多说，简单看一看该笔记的风格与内容目录：

![BAT算法-01](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212447.png)

如果说《刷题笔记101》是**总复习资料**，教会你每种算法技巧思维，那么这本笔记可以说是**总复习刷题指南**，每一个章节都先讲解框架思维，然后挑选非常典型的十几道 LeetCode 题进行实战讲解：

![BAT算法-02](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212484.png)

![BAT算法-03](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212486.png)

![BAT算法-04](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212496.png)

**下载方式：微信搜索公众号「*小龙coding*」**，也可以直接截图扫描下方二维码，在后台回复「**刷题笔记**」即可获取此处提到的刷题笔记

![MySQL](https://cdn.jsdelivr.net/gh/xlcoding/ImageHost/imgs/xlcoding2.png)

此外，我还收集了国内外大厂手撕算法考察题目的频率，全部打包在了「**刷题笔记**」中，直接关注公众号「**小龙coding**」进行领取

![image-20220213195351763](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212502.png)

同样上面的记录了我备战期间的「算法统计」也放在刷题笔记中，可以去领来借鉴学习一下，哈哈。

按照上面认真学习准备，大厂面试手撕算法可以说**乱杀**了，我也不说啥几乎没问题，直接肯定乱杀。

## 2. 项目

### 4.2.1 如何打造一个好的项目？

在校招求职模块中提及，此处不再赘述。

### 4.2.2 优质开源项目推荐

求职 | 可以写进简历，让面试官眼前一亮的几款经典开源项目！

此处想和大家分享一些校招和日常实习中值得借鉴写进简历的一些精品开源项目。

#### 小龙有话说

在「**校招求职**」模块中，教会了你 [如何打造一份优质简历？](https://mp.weixin.qq.com/s?__biz=MzkxMjE5NzUxNQ==&mid=2247485766&idx=1&sn=3cc6c89d0696a2a1a06059f8da551af6&chksm=c111dba2f66652b41ef2ff070e300ef7e1ceddad3a19bb9198134d789669060b8d69f385ea9a&token=964498787&lang=zh_CN#rd)，[如何找寻一个合适项目，如何封装项目亮点？](https://mp.weixin.qq.com/s?__biz=MzkxMjE5NzUxNQ==&mid=2247485711&idx=1&sn=2d78f6b46e1af4d2b6c1029627fc2193&chksm=c111dbebf66652fdaf92b784c7f88d12b4d834d28221b4ba1a47d10583b107af0d0fd065c308&token=964498787&lang=zh_CN#rd)，[二本上岸大厂经验？](https://mp.weixin.qq.com/s?__biz=MzkxMjE5NzUxNQ==&mid=2247485633&idx=1&sn=543fbab63b8af09ef80ae9059272d070&chksm=c111da25f6665333e6cc108d6d680c3016ad736227ee281d8688948b95444bcd2ad981ba531f&token=964498787&lang=zh_CN#rd)

关于项目这块是特别重要的，可以说项目间接决定了你的生死，在此前的文章介绍了可以从 github 等找寻一个适合自己的开源项目，但是网上项目资源满天飞，去找到一款可以让面试官眼前一亮的项目还是有点困难，今天给大家分享我小仓库里的几个项目。

和人手一个的秒杀，商城，管理系统说拜拜吧，您~，

#### 项目推荐

##### 1、从零实现一个操作系统内核

对于编程学习来说， 学习操作系统有助于我们了解计算机的工作原理。操作系统中的很多思想、很多经典的算法，你都可以在我们日常开发使用的各种工具或者框架中找到它们的影子。

在学校我们老师也会叫我们写一个简单的操作系统来体会其中的原理。

如果你能够自己独立写一个操作系统内核的话，即使是简易的实现，我相信也能够为自己的简历加分不少。

> 项目地址：https://github.com/Simple-XX/SimpleKernel

##### 2、proxyee-down（Http下载器）

`Proxyee Down` 是一款开源的免费 HTTP 高速下载器，底层使用`netty`开发，支持自定义 HTTP 请求下载且支持扩展功能，可以通过安装扩展实现特殊的下载需求。

本项目后端主要使用 `java` + `spring` + `boot` + `netty`，前端使用 `vue.js` + `iview`

> 项目地址：https://github.com/proxyee-down-org/proxyee-down

##### 3、一个手把手教你造轮子的项目

通过这个项目，你能学会如何创造自己的操作系统、编程语言、搜索引擎、框架，工具库……

这个项目聚集了很多车轮子项目。

**构建一个简易Doker**

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304151653663.webp)

> https://github.com/danistefanovic/build-your-own-x#build-your-own-docker

**构建一个简易数据库**

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304151653992.webp)

> https://github.com/danistefanovic/build-your-own-x#build-your-own-database

.........

**整个仓库地址**

> 项目地址：https://github.com/danistefanovic/build-your-own-x

##### 4、其他我不怎么推荐的项目

这里收集的一些开源项目也可以看看~

**电商类**

- 天猫整站 Springboot：https://how2j.cn/module/156.html
- mall-learning：https://github.com/macrozheng/mall-learningmall（学习教程，架构、业务、技术要点全方位解析）
- miaosha：https://github.com/qiurunze123/miaosha （秒杀系统设计与实现）
- mall-swarm：https://github.com/macrozheng/mall-swarm（一套微服务商城系统，采用了 Spring Cloud Greenwich、Spring Boot 2、MyBatis、Docker、Elasticsearch 等核心技术，同时提供了基于 Vue 的管理后台方便快速搭建系统）

**管理系统类**

- [Spring-Cloud-Admin](https://github.com/wxiaoqi/Spring-Cloud-Admin)：Cloud-Admin 是国内首个基于 Spring Cloud 微服务化开发平台，具有统一授权、认证后台管理系统，其中包含具备用户管理、资源权限管理、网关 API 管理等多个模块，支持多业务系统并行开发，可以作为后端服务的开发脚手架。代码简洁，架构清晰，适合学习和直接项目中使用。核心技术采用 Spring Boot2 以及 Spring Cloud Gateway 相关核心组件，前端采用 vue-element-admin 组件。
- [pig](https://gitee.com/log4j/pig)：基于 Spring Boot 2.2、 Spring Cloud Hoxton & Alibaba、 OAuth2 的 RBAC 权限管理系统。
- [悟空CRM](https://github.com/72crm/72crm-java)：基于jfinal+vue+ElementUI的前后端分离CRM系统

**博客类**

- [favorites-web](https://github.com/cloudfavorites/favorites-web):云收藏 Spring Boot 2.X 开源项目。云收藏是一个使用 Spring Boot 构建的开源网站，可以让用户在线随时随地收藏的一个网站，在网站上分类整理收藏的网站或者文章。
- [community](https://github.com/codedrinker/community)：码问，开源论坛、问答系统，现有功能提问、回复、通知、最新、最热、消除零回复功能。技术栈 Spring、Spring Boot、MyBatis、MySQL/H2、Bootstrap
- [vhr](https://github.com/lenve/vhr)：微人事是一个前后端分离的人力资源管理系统，项目采用 SpringBoot+Vue 开发。

**其他**

- [PassJava-Platform](https://github.com/Jackson0714/PassJava-Platform)：一款面试刷题的 Spring Cloud 开源系统
- [moti-cloud](https://github.com/373675032/moti-cloud)：莫提网盘，基于 SpringBoot+MyBatis+ThymeLeaf+BootStrap，适合初学者
- [threadandjuc](https://github.com/qiurunze123/threadandjuc)：three-high-import 高可用\高可靠\高性能，三高多线程导入系统（该项目意义为理论贯通)

#### 篇末

我个人觉得，现在这个状况，相比于做分布式什么的，做一些偏基础或者车轮子（**体会计算机运行原理，体会先人思想**）的项目可能反而让面试官眼前一面，只是个人看法，每个人根据自己的想法去找到一个适合自己项目认真准备就可以。

### 4.2.3 我的几个秋招项目

如果你还是不知道项目怎样去写，哪里找？不妨使用小龙的几个秋招求职项目。

#### 4.2.3.1 基于人工智能的智慧校园助手

本项目旨在为同城高校学子提供一个集校园服务，商城服务，二手交易，智能问答，消息推送，动态分享功能于一体的综合性智慧服务平台

技术栈：SpringBoot+SpringCloud+Redis+Kafka+XXL-Job+Vue.js+其他第三方 SDK 等

- 将校内服务与百度地图结合实现信息视觉呈现；采用人脸识别打造安全机制，通过模型训练数据采集提供了智能系统问 

  答服务

- 对系统慢 SQL 进行优化，使得系统性能大幅度提高。 

- 用 Redis 存储登录 ticket 和验证码，解决分布式 session 问题 

- 定义热点数据并缓存在 Redis，降低了数据库访问压力 

- 将校内服务与百度地图结合实现信息视觉呈现；采用人脸识别打造安全机制，通过模型训练数据采集提供了智能系统问 

  答服务 

- 对热帖排行模块，使用分布式缓存 Redis 和本地缓存 Caffeine 作为多级缓存，避免了缓存雪崩，将 QPS 提升了20倍 

  (10-200)，大大提升了网站访问速度。并使用 Quartz 定时更新热帖排行 

- 利用 JVM 指令排查出 GC 问题，调整 JVM 配置，降低 GC 次数使 

- 用 Kafka 打造强大的异步消息系统

version1.0可以*扫描下方二维码，关注公众号【**小龙coding**】*，回复*【**基于人工智能的智慧校园助手**】*

![MySQL](https://cdn.jsdelivr.net/gh/xlcoding/ImageHost/imgs/xlcoding2.png)

后期迭代升级更新优化 会发布 github 持续关注，第一时间接收通知。

> 项目演示：https://www.bilibili.com/video/BV1XT4y1w7Xc

#### 4.2.3.2  牛客论坛

一个仿照牛客网实现的讨论社区，不仅实现了基本的注册，登录，发帖，评论，点赞，回复功能，同时使用前缀树实现敏感词过滤，使用wkhtmltopdf生成长图和pdf，实现网站UV和DAU统计，并将用户头像等信息存于七牛云服务器。

**功能介绍**

- 使用Spring Security 做权限控制，替代拦截器的拦截控制，并使用自己的认证方案替代Security 认证流程，使权限认证和控制更加方便灵活。
- 使用Redis的set实现点赞，zset实现关注，并使用Redis存储登录ticket和验证码，解决分布式session问题。
- 使用Redis高级数据类型HyperLogLog统计UV(Unique Visitor),使用Bitmap统计DAU(Daily Active User)。
- 使用Kafka处理发送评论、点赞和关注等系统通知，并使用事件进行封装，构建了强大的异步消息系统。
- 使用Elasticsearch做全局搜索，并通过事件封装，增加关键词高亮显示等功能。
- 对热帖排行模块，使用分布式缓存Redis和本地缓存Caffeine作为多级缓存，避免了缓存雪崩，将QPS提升了20倍(10-200)，大大提升了网站访问速度。并使用Quartz定时更新热帖排行。

> 项目地址：https://www.nowcoder.com/study/live/246

## 4.3 计算机基础

`CS指南 | 我爱计算机，这才是猛男的学习方式！`

> 校招面试求职，大厂学习导航
>
> 认准「**小龙coding**」，致力于打造全网最佳大厂进阶平台~

大家好，我是小龙。

我们都知道无论是在工作还是学习中，对于每个程序员，计算机基础一定是特别重要的。

### 为何要学计算机基础？

从`知识体系角度来`讲，学好计算机基础，相当于在你脑袋初步构建了一个计算机。

`知道计算机大体是怎样组成的，知道我们平时使用的系统是怎么运行的，知道我们平时上网数据是怎样传输的，知道我们程序可以怎样去尽可能优化时间和空间使得性能更佳，知道我们数据是怎样存储的。。。。`

相当于为自己打造了一个坚实的基础，以便后续学习可以更加轻松。这样说吧，也许你直接学各种编程语言，框架知识什么的依然可以学的很好，但或许你可能就不能很好很快的把各个知识联系在一起，建立一个完整的知识体系网络，学到后面你会发现，其实很多知识都是相通的，并且你所谓的各种语言、框架最终还是需要操作底层来协调工作。

从`课程学习角度`来讲，大学计算机专业计算机基础课程是必修的专业课程，而且特别重要。因此，为了考个考成绩，拿点什么奖学金，证书，学好计算机基础课程是很重要的。

从工作求职角度来讲，也许你觉得成绩，奖学金其他什么的对你不重要，那找一份好的工作应该是你所盼望的吧。先不说互联网大厂，就是目前稍微大一点的公司，就要求应届生熟练掌握计算机基础。

而且某些大厂比如 `字节跳动` ，招聘要求即使你什么都不会，只要会一门编程语言，计算机基础掌握的好，便可以被录取。你要相信，越是大的公司反而会越在乎你的基础知识；

因为校招生并没有太多公司的真实项目经验，业务场景接触的也少，因此，考察你基础知识便是最好的选人标准，而且大厂注重人才培养，只要你基础好，培养上手就快。

由于**读者可能基础不一样，并且目前需求不一样**，也许有的是零基础，也许有的之前大概学过，但是对于面试的考察却摸不着头脑，因此我会从**两个维度**来介绍学习方式，以便迎合不同程序需求的同学。

### 初入道场

如果你是零基础、基础薄弱、想系统学习计算机基础知识就看这里。

![image-20220219110746388](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212537.png)

#### **操作系统**

`Operating System:`

1、操作系统（哈工大李治军老师）32讲（全）超清

> MOOC：https://www.icourse163.org/course/HIT-1002531008
>
> 配套实验课：https://www.shiyanlou.com/courses/115

我愿称之为一绝，李老师的这门课。绝对牛逼绝对硬核，这门课建议先去学习汇编课程基础，再来看会有更深刻的收获；不然看到中间会很晕。

2、 2020 南京大学 “操作系统：设计与实现” (蒋炎岩)

> B站：https://www.bilibili.com/video/BV1N741177F5
>
> 南大操作系统，yyds，不多这个人感觉更适合加餐和加深理解

如果是为了考研，建议看传统的操作系统课程，北大的课程理论讲解比较细致，清华的课程更深入难度更大。
如果是想真正的提升实战能力，强烈推荐蒋岩炎老师的相关视频，MIT也很好，不过英语能力有较高的要求。

3、清华出版

> 清华出版的操作系统课程，配套实验是 UCore：
>
> https://www.xuetangx.com/course/THU08091000267/5883104

4、【麻省理工学院】MIT 6.S081 操作系统工程 operating system engineering

> 官网（英文）：https://pdos.csail.mit.edu/6.828/2020/schedule.html
>
> 中文字幕：https://www.bilibili.com/video/BV1Dy4y1m7ZE/

这门课，我个人觉得直接封神。虽然它小但是却很完整，重现了经典的 **UNI XV6**，可以学习到设计思维，循序渐进，一步一步在你的脑海里建立起 OS 的大厦框架。相信程序员大部分都知道这门课，国外的课就是牛逼~

5、其他

个人感觉，上述的相关课程对建立完整知识体系和加餐补给都很够了，十分不错。但是可能对新人有些难度，大家也去网上找一些基础视频先大概看看，对于上面可能更好理解。

**我该学到什么程度？**

对于大部分同学，其实大概梳理一下整个操作系统的知识体系即可，对于你构建你的完整知识体系和找工作已经足够。不过如果你想往研究方向或者就个人兴趣爱好而言，可能需要再深度研究。

在看视频学习同时可以结合一些经典书籍学习，比如

- 《现代操作系统》

  ![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212598.jpg)

其中内存、进程、IO 是重点，这几块是最贴近我们平时学习工作的，之后面试也重点考察这几点。

#### 计算机网络

学习计算机网络我给大家分享一个方法，按照「`总—分—总`」的思路来学习。（此总分总是我胡乱用词，相信大家可以贴切理解）

**`什么意思？`**

##### 体系流程—总

首先，不要着急去学某个单独的章节，或者一来就从头到尾挨着去学。这样效率和收获会极低。

我们应该首先了解计算机网络整个脉络，「`数据是怎样在网络中传送`」的，也没有叫你每个细节都要搞清，浅尝即止。不过我们需要在脑海形成一个整体流转过程。

------

> 推荐【网络】半小时看懂<计算机网络>
>
> https://www.bilibili.com/video/BV124411k7uV

除了那些搞研究的专业者之外，我们这些普通人，需要的不是特别深的理论，不是上来就计算各种进制，我们渴求的，是能从整体上，把我们生活中常见的，以通俗易懂的话语解释的让人能听懂。

从另一方面说，这也是一个引子，感兴趣的人自然会去深入研究，再不感兴趣的人，像路由、网络这些，生活中常见的，总会有用得到的时候。

![image-20220219153807686](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212601.png)

------

##### 知识详解—分

然后，我们再根据脑海的大体映像，带着可能存在的某些细节问题再逐步去学习，剖析细节，全面学习。

> 推荐-中科大-计算机网络
>
> https://www.bilibili.com/video/BV1JV411t7ow

其中对于HTTP、TCP、IP 等协议是特别重要的，此处为大家推荐几本优质书籍。

《图解HTTP》、《图解TCP/IP》,这两本书都以图文形式很好的去讲解知识，有趣易懂。

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212650.jpg)

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212659.jpg)

##### 实战抓包—总

最后，我们再通过自己抓包实战去亲自体会各个层，各个协议。

推荐使用 `Wireshark `工具，可以去抓取每一个数据报文的信息，可以清楚的查看各个数据报文的结构，亲自去验证书本的知识啦。

而且当你 「抓取」到报文自己去验证分析一遍，你会有种豁然开朗的感觉，而且觉得挺有成就感，并且再也不会感到枯燥。最重要的是再次把整个知识网络连接起来啦。

> 推荐书籍：《Wireshark 网络分析的艺术》

另外，想要功力更上一层楼，给大家推荐基本经典书籍：

- 《计算机网络 - 自顶向下方法》

对于 TCP/IP 网络模型深入学习的话，推荐《计算机网络 - 自顶向下方法》，这本书从 HTTP 开始，逐层剖析，详解，对建立完整且有深度的知识体系很有帮助。

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212663.jpg)

- 《TCP/IP 详解 卷一：协议》

其次，如果想要深入学习 TCP，推荐大家赋有计算机网络圣经之说的《TCP/IP 详解 卷一：协议》，此书虽然枯燥，但是真的讲得很细，很好。

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092212668.jpg)

### 历劫飞升

如果你是 “老油条”、或者最近找工作需要应付面试的，就看这里。

求职在于针对准备，快、准、狠。个人觉得，此时不再适合挨着看书去学习，这样效率极低，而且在极短时间下，再加上自己心里慌，容易把脑袋绕晕却什么没记住理解。

**我们只需要分两步走：**

- 第一步：自述整体体系（不懂百度）
- 第二步：分解核心知识，着重复习（哪个核心哪个细节不清楚去找相关资料），最后临考之前看常考面试题。
- 应付面试：推荐看「**小龙coding**」后台回复「**面试笔记**」

#### 计算机网络

首先你需要去搞懂这几个问题：

- 从 URL 输入到页面展现到底发生什么？
- 一个数据包是如何发送出去的？

然后分解核心知识，可以围绕这几个常考面试题去学习理解。

- TCP三次握手、四次挥手相关？
- TCP粘包、拆包相关？
- TCP 状态中 TIME_WAITT 什么时候·产生？为何产生？怎样避免？  
- 拥塞控制、流量控制相关？
- HTTPS连接过程相关？
- TCP 如何实现可靠传输的？（类比问题：如何基于 UDP 实现可靠传输）

一方面：通过常考面试题可以着重有针对去学习核心知识点；

二方面：可以针对准备，应付面试（主要目的）；

#### 操作系统

首先你需要去搞懂这个几个问题：

- 一个程序是怎样运行起来的？（不用太细，具体到每个细节）
- 操作系统主要由哪些模块组成，操作系统作用？

然后同样分解核心知识，可以围绕这几个常考面试题去学习理解。

- 进程间通信方式（消息队列、共享内存、管道、信号量等）

- 进程和线程的区别

- 进程的状态、切换、调度

- 协程

- 虚拟内存

- 互斥与同步（信号量、管程、锁）

- 死锁检测与避免

- 并发经典的问题：哲学家就餐问题

- 内存为什么分段、分页

- 页面置换算法（LRU要能简单模拟，熟练说出其实现思路）、进程调度算法


## 4.4 Java系列

## 4.5 设计模式

## 4.6 面试模拟

曾几何时，大家是否有这样的困惑？

知道相关的知识点，但是面试时面试官**换一种问法**，你便不知道怎样回答，**给你一个场景**，你就联系不到相关的知识点上，或者不知道用对应知识去分析相关问题。

比如 “`你知道垂直定理，但是你遇到相关几何题，就是想不到用这个定理去解决问题`”。

新的篇章将开启，本系列会`结合小龙面试经历`以及`身边上岸大厂的朋友们的面试经历、面试录音、面试分享`，尽可能**还原面试现场**。

带大家**感受面试现场**，**结合情景学会灵活的应用知识**。看一看大佬们都是怎样面试的。

记得每期结束，问问自己，你真的对知识掌握了吗？

《你好，面试官》系列目前已经连载7篇了，据说看了这个系列的朋友都拿到了大厂offer~

- [你好，面试官 | 你真的理解面向 "对象"？](https://mp.weixin.qq.com/s/NluK43g5qi2ArihgWtGNug)
- [你好，面试官 | 我用Java List 狂怼面试官~](https://mp.weixin.qq.com/s/3YTCYwI_nIHiGQdQ9U8UBg)
- [你好，面试官 | 你拿Java Map考验老干部？](https://mp.weixin.qq.com/s/RmpzIc9sddmVgvwZnM9OSw)
- [你好，面试官 | 你觉得MySQL自增主键连续吗？](https://mp.weixin.qq.com/s/NHXXTr-8_tOije7IqdTDkA)
- [你好，面试官 | 呵，我怎么可能不知道索引！](https://mp.weixin.qq.com/s/oMGx6ZXmNg2JbIq37aP18g)
- [你好，面试官 | 我不仅知道MySQL索引，还会优化呢~](https://mp.weixin.qq.com/s/t5rR_VLVEk_H9gAvCb4E1Q)
- [你好，面试官 | 我可以凭借MySQL架构体系，事务锁机制原理进你公司吗？？](https://mp.weixin.qq.com/s/6YwXMDCFCVqGkHF8qsvdtA)
- 欢迎星标+订阅，持续更新中。。。致力打造校招核心面试攻略~