---
title: 零基础小白
category: 学习路线
icon: "xitongsheji"
---

## 1.1 知识体系

### 1.1.1 Java基础

`学习目标`

**前期**
1、对Java语言形成一个大概理解与认识。
2、熟悉基本语法的使用，如果你有C与C++的基础，上手也会更快。
3、最后能独立的做一个简单的系统。
**后期**
1、深入剖析源码，比如HashMap、ArrayList等集合，并发包JUC下的相关类等。
2、深入理解JVM
3、理解反射机制等

`学习途径`

> `视频`
>
> 尚硅谷宋红康Java基础教程：www.bilibili.com/video/BV1Kb411W75N

> `书籍`
>
> 《Java核心技术》

> `其他辅助网站`
>
> 菜鸟教程：https://www.runoob.com/
>
> 速学堂学习笔记：https://www.sxt.cn/Java_jQuery_in_action/%20Java_Characteristics_and_advantages.html
>
> 廖雪峰Java教程：https://www.liaoxuefeng.com/wiki/1252599548343744/

`学习建议`

Java基础一定要学习扎实，开始慢而求稳，扎实，后期可适当快。所谓地基不牢，地动山摇。前期没学扎实，后期吃 “回锅饭” 更浪费时间，因为后面都基于前面基础进阶的。

遇到问题实在不能理解，可以记录下来，继续往后看，等后面可能老师还会结合例子讲，或则等你学完以后已经有了一定认识再回来看就更容易理解啦。

**建议**：你们在学视频或则学校课程开设可能会讲GUI，这玩意后期根本不用的，只是学校考试罢了，所以不必深究浪费时间。

**项目**：学完Java基础知识，可以做一个控制台打印的XX管理系统之类的，把所学知识串起来，加深映印象。也会给你带来满满成就感，增加学习趣味与动力。

### 1.1.2 MySQL

`学习目标`

**前期**
掌握基本语法，形成大体映像，切记把SQL练熟，各种连接查询。
**后期**
看书、看专栏，深入了解底层原理，如锁、索引、事务实现原理、引擎、架构、主从等。

`学习途径`

> `视频`
>
> 尚硅谷MYSQL入门基础教程：www.bilibili.com/video/BV12b411K7Zu

> `书籍`
>
> **基础**：《MYSQL必知必会》(专栏)
>
> **进阶**：《高性能MYSQL》（书籍）
>
> **面试补充**：极客时间《MYSQL实战45讲》（专栏）
>
> **获取方式**：百度 / 公众号【小龙coding】后台加群，本指南提及资料我都有，都看过。

`学习建议`

MYSQL有很多要学习的，基础+高级进阶。高级进阶会有：`索引`、`锁`、`主从同步`、

`分库分表`、集群等知识，本阶段对于新手建议就学习基础即可，等后期高级进阶阶段才学。

相关面试题可以扫下方二维码，关注公众号【小龙coding】，有小龙秋招整理的【面试笔记】

![MySQL](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304092159400.png)

下面 部分笔记 节选【面试笔记】

> 面试笔记——《MySQL30问与答》
>
> https://mp.weixin.qq.com/s/GNR5Q7BZS5pdKGj8wuasoQ

### 1.1.3 JavaWeb

`学习目标`

**前期**
熟悉基本使用即可，为后期学习SSM、SpringBoot等框架奠定扎实基础。
**后期**
针对大厂面试这块，主要就考一些常见的面试题，比如`Cookie`、`Session`、`Servlet生命周期`，`一个请求来，Servlet怎样处理的`等，看看即可，属于基础。

没必要花时间去看书仔细深究，公司基本不使用，面试基本不问，认真学一遍理解思路就够用了

`学习途径`

> `视频`
>
> 尚硅谷Java Web教程：www.bilibili.com/video/BV1Y7411K7zz

> `书籍`
>
> 基础：《MYSQL必知必会》(专栏)
>
> 进阶：《高性能MYSQL》（书籍）
>
> 面试补充：极客时间《MYSQL实战45讲》（专栏）
>
> 获取方式：百度 / 公众号【小龙coding】后台加群，本指南提及资料我都有，都看过。

`学习建议`

JavaWeb 也很重要，它是最原始的web系统网站开发技术，也是后面主流框架的基础，但是现在大一点的公司都不会使用这项技术，都是用框架开发，**自己掂量分量**吧。

学习 JavaWeb 前，你的需要去学习一下**前端三剑客**：`Html、CSS、Java Script`。初学，只学习这些基础知识就行，适用于 Java Web 的一些框架Layui、BootStrap等可以简单了解。

但不要浪费太多时间，如果想要做出更好的交互想过，建议去学习`Vue、Uniapp（小程序）、React`等主流框架技术。

话说回来，Java Web 其实就是服务器开发技术，你学会便可以做个简单的通过网址访问的项目啦。主要包括：Servlet、Filter、Session、Cookie、JSP（不用浪费太多时间）等。

### 1.1.4 主流框架

#### 后端

这部分我们要学习的框架有Spring、Spring MVC和Mybatis、俗称SSM，这是目前最主流的开发框架，SSH不推荐学了。

在学习框架技术之前，推荐学习Maven与Git。

##### Maven

`学习目标`

这个属于 “`工欲善其事必先利其器`” 的感觉，得认真学习，后面项目何时何地都得涉及它的使用。简单来说就是以前需要手动导入Jar包、管理项目等，现在可以直接用 Maven 进行包管理等操作，Java系列开发必用。

1、学会利用它进行项目的构建、报告和文档

2、学会利用它进行依赖坐标导入，管理等

`学习途径`

> `视频`
>
> Maven基础入门：www.bilibili.com/video/BV1dp4y1Q7Hf

> `官方文档`
>
> https://maven.apache.org/

##### Git

Git 是一个开源的分布式版本控制系统，可以用来对项目进行版本管理，团发协同开发，代码托管等。

GitHub 是基于 Git 的代码托管库，同时平时没事也可以去 GitHub 看看，有很多不错的开源项目与学习资料。

个人认为，Git 很简单，看看书就上手了，看书进度快，视频很慢。

`学习途径`

> 视频
>
> www.bilibili.com/video/BV1FE411P7B3

> 其他辅助网站
>
> www.liaoxuefeng.com/wiki/896043488029600

> 小龙整理的学习文档
>
> 公众号【小龙coding】后台【Git】

##### SSM

接下来就是 SSM 框架的学习了。SSM 就是一套框架，也是用于 Web 系统开发的，之前 Java Web 开发需要程序员做的事很多，开发效率底，SSM 框架帮助我们做了很多事，可以高效开发，让其更多关注业务逻辑。

具体细节不多介绍，自己按照我的路线去学习：

`学习目标`

**前期**
认真体会各个框架的思想，灵活应用各个注解等配置，能上手做一个项目，后期可以将其他中间件联系在一起做项目。
**后期**
针对面试这块，后期主要是加深对 Spring 的理解，AOP、IOC 等核心思想，Bean 生命周期等。

`学习途径`

> `视频`
>
> 推荐看黑马的 SSM 系列课，同时，尚硅谷[雷丰阳](https://www.zhihu.com/search?q=雷丰阳&search_source=Entity&hybrid_search_source=Entity&hybrid_search_extra={"sourceType"%3A"answer"%2C"sourceId"%3A2306092510})老师讲的也不错，看自己吧。
>
> www.bilibili.com/video/BV1mE411X7yp

> `官方文档`
>
> https://spring.io/
>
> http://mybatis.org/spring/zh/index.html

> `书籍`
>
> 《Spring源码解析》

`学习建议`

虽然目前很多大厂都用 `SpringBoot`，但是 `SpringBoot` 的知识点很多来源于 `SSM`，如果要快，可以直接学 `SpringBoot`，如果要稳中求进，建议先把 SSM 好好学习 。

##### SpringBoot 

`学习途径`

> `视频`
>
> 推荐尚硅谷[雷丰阳](https://www.zhihu.com/search?q=雷丰阳&search_source=Entity&hybrid_search_source=Entity&hybrid_search_extra={"sourceType"%3A"answer"%2C"sourceId"%3A2306092510})老师讲的，直接细节拉满，通俗易懂
>
> www.bilibili.com/video/BV19K4y1L7MT

`学习建议`

SpringBoot 与 SSM 开发最大区别在于 SpringBoot 搭建环境更方便，省去了 SSM 繁琐的 xml 配置，引入自动配置原理，更方便。

学习 Spring Boot，推荐雷丰阳老师的 Spring Boot课程，课程基于 SpringBoot2.X，无论从知识深度和广度还是从讲课风格来说，我认为都挺不错的，包含核心基础、Web 原理、单元测试、数据访问、指标监控等章节。

#### 前端（了解）

对于前端这块，我觉得不管你是前端、后端，Html、CSS、JS的基础知识是每个人必备的

其次，作为后端，可以学习一下 Vue.js，这个框架，你需要理解`前后端分离开发`，需要理解`前后端请求对接`

**为什么呢？**

- 一方面：你可以独自做个简单前端完成一个完整项目开发，平时学习作业等
- 二方面：即使面试可能不问，但是你进入稍微大一点的公司都是前后端分离开发，这时作为后端的你务必会与前端进行接口对接，若你不会，那么效率会特别底下，浪费很多时间的。

上述我认为是必须要掌握的，然后若你对小程序开发感兴趣，可以学习 uniapp。

### 1.1.5 中间件

#### Redis

`学习目标`

**前期**

只要学会基本使用，跟着视频学着搭搭集群、哨兵之类的，熟悉常用的基本命令、场景。能在项目简单使用。

**后期**

主要针对面试，网上的视频千千万万，不过都讲的很基础，只能作入门视频，想要深入理解与学习，还得看书与一些好的专栏论坛等。需要掌握各种`数据结构底层`实现，`持久化`、`缓存淘汰策略`、基本实现原理、`各种使用场景`、`缓存雪崩/击穿/穿透`，`集群`等等。

`学习途径`

> `视频`
>
> https://www.bilibili.com/video/BV1S54y1R7SB

> `书籍与专栏`
>
> 《Redis设计与实现》（书籍）
>
> 极客时间：《Redis核心技术与实战》（专栏）
>
> 面试笔记：公众号【小龙coding】回复【面试笔记】

`学习建议`

前期跟着视频学习基本操作，大概了解 Redis，再根据相关项目结合理解使用，后期看专栏，书籍深入理解，再项目实践。

**其他中间件**

MQ、Elasticsearch，这个若会用，会是面试的加分项，若不会简历不提，面试官也不会问，可以自行加餐。不过我建议还是学习一下这二者，它们在项目开发中起到很大作用，全文检索、削峰填谷，发布订阅等。

### 1.1.6 微服务与分布式

`学习目标`

SpringBoot 你起码应该会，然后Springcloud 可以简单看看，理解其用法思想。对于校招面试，个人认为只要会基本的分布式理论就可以了，当然某些厂可能秀逗要问原理，架构设计，我觉得这是无脑行为，没有真实工作经验，很大程度是搞不清真正的分布式的。

`学习途径`

> `分布式理论基础`
>
> 公众号【小龙coding】【面试笔记】/ 百度

> `Dubbo与Zookeeper`
>
> 【大海哥】https://www.bilibili.com/video/BV1to4y1C7gw

> `Spring Cloud`
>
> 【阳哥】https://www.bilibili.com/video/BV18E411x7eT

## 1.2 扎实基础

## 1.3 项目归纳

`学习目标`

**1、巩固知识**

其实，在构建知识体系模块中，每个阶段JavaSe+IO、JavaSe+JDBC、JavaWeb+JDBC、SSM、SpringBoot、SpringBoot+其他中间件，每个阶段都应该找对应项目作为练习和巩固知识。

然后，当你已经构建了较为完善的知识体系时，应该拉通所有技术做一个完整的项目，不仅可以带你回忆之前的知识，也可以增加项目开发经验，需要知道的是，眼睛会了和手会了是两码事，手会了和真实项目能规避问题和解决问题又是两码事。

**2、参加比赛**

当然，你可以跟着网上做一个完整的项目，适当变换一下场景和细节，还可以用来参加比赛，然后获奖了以后找工作还可以往简历写，既巩固了知识，还为以后找工作做了好的铺垫。

**3、找工作**

找工作时，除了学历之外，项目经验和实习经验就是特别重要的了。并且，对于学历不占优势的同学，反超机会很大程度在于项目，甚至你有一段好的实习经验都不如一个好的项目经验，若找工作时，你拿不出一个合适的项目在简历上，可能会给你找工作增加很多难度。

`学习途径`

**Javaweb**

简单的商城，全面覆盖知识：[JavaWeb版—《书城》](https://www.bilibili.com/video/BV1AS4y177xJ?p=69)

基础入门项目，普通的增删改：[JavaWeb版—学生管理系统](https://www.bilibili.com/video/BV1vR4y1H7jF)

**SSM**

基础入门—《图书管理系统》—上手快，快速掌握SSM项目开发流程：https://www.bilibili.com/video/BV15a4y1a7kS

中级—黑马程序员 Java 项目《传智健康》，超完整的企业级医疗行业项目-SSM+ZK：https://www.bilibili.com/video/BV1Bo4y117zV

高级—尚筹网 - Java项目实战开发教程 - SSM 框架 + 微服务架构：https://www.bilibili.com/video/BV1bE411T7oZ

**SpringBoot**

尚硅谷 - 谷粒学院 - 微服务 + 全栈 - 在线教育实战项目：https://www.bilibili.com/video/BV1dQ4y1A75e

商城类—乐优商城—涉及知识广，含有支护讲解：https://www.bilibili.com/video/BV14E411i7rc

黑马程序员 Java 大型分布式微服务闪聚支付项目，Java 移动支付全生态系统：https://www.bilibili.com/video/BV17v411V79c

黑马程序员 Java 项目《好客租房》：https://www.bilibili.com/video/BV1sZ4y1F7PD

`学习建议`

若能力差一点，经验不足，建议跟着视频做个几个项目，当你做了几个项目后会发现功力直线上升。

若能力强一点，可以根据自己的创意与想法来做自己想做的项目，并且可以参加一些竞赛，巩固知识、拿奖、收获项目经历一举三得。

若再牛逼一点，可以在GitHub 上找经典高星开源项目撸源码学习。