---
title: 《面试实录》 字节二面， MySQL自增主键一定连续吗？
category: 
  - 对线面试官
  - 面试实录
  - Java
tag:
  - Java
  - Map
head:
  - - meta
    - name: keywords
      content: 面试实录,集合,JAVA,大厂面试,Map
    - name: description
      content: 阿里一面面试现场，深剖Java Map底层结构与原理。涉及知识点：Map 常使用实现类使用场景，特性；Hash算法；HashMap原			     	理剖析；分段锁；ConcurrentHashMap；

---

本期是【**面试实录**】系列文章的第 **3** 期，持续更新中.....。

- 欢迎关注+订阅，持续更新中！！！致力打造校招核心面试攻略~
- 根据秋招春招上岸大厂面试经历以及身边朋友上岸面试录音模拟面试现场，并整合面试常考知识点，通俗有趣的去讲解 `八股文`，不一样的系列，轻松掌握知识~

【**面试实录**】专栏系列目前已经连载 3 篇了，据说看了这个系列的朋友都拿到了大厂offer~

- [【面试实录】百度二面，Sychronized原理详解](./1)
- [【面试实录】字节二面，SQL执行慢的原因？如何优化？](./2)

# 考题速查

本期会模拟面试 MySQL 相关内容。

涉及知识点，MySQL 自增主键的理解，关于 `自增值修改机制` 、`自增值修改时机`与 `自增值新增机制` 。

`本期题改编自 ——2022届春招 阿里蚂蚁金服 二面`

# 面试现场

叮叮叮......

**面试官**：“你好，我是XX面试官，请问是小龙吗？”

**小龙**：“您好，面试官，我是小龙”

**面试官**：“好的，现在有空吗，我们开始面试吧”

**小龙**：“嗯嗯，准备好啦”

.......

other questions

.......

**面试官**：“我看你简历上有提到你对 MySQL 掌握得挺好的对吧？。”

**小龙**：“哈哈，还算可以吧！”

**面试官**：“好的，那平时对于 MySQL `主键`你一般怎样用的呢？能简单聊聊吗？”

**独白**：“嘿嘿，面试官肯定又想问 InnoDB 引擎索引特性相关知识，幸好早烂熟于心了！”

**小龙**：“平时主键我一般用自增主键！因为自增 ID 有序，会按顺序往最后插入，而 UUID 无序，随机生成，随机插入，会造成频繁页分裂，内存碎片化，大量随机 IO，巴拉巴拉。。。。。”

**独白**：“这波稳啦！[手动狗头] 😎”

然后，面试官又来一套组合拳。

**面试官**：“en！好，那你知道`自增主键是否严格递增`呢？”

**独白**：“这还不简单，肯定递增啊！不对，仔细一想，有一些情况下自增主键是断开的。”

**小龙**：“肯定不是递增的啊！”

以为到这里结束啦，只是考考我是否实际真正用过，没想到还是天真啦。。。

**面试官**：“那你知道为啥不是严格递增的吗？换句话来说，`为何不是连续的`？”

**小龙**：“裂开！还真不知道，不会真要考那么底层吧！我去”

**面试官**：“回去等通知吧。。。”

.......

哈哈，开玩笑的，接下来正式开始表演~

.......

**小龙**：“我们都知道，由于自增主键可以让主键索引尽量地`保持递增顺序插入`，避免了页分裂，大量的随机 IO。”

**面试官**：“嗯嗯”

**小龙**：“至于`为何自增主键不是严格递增的`？为何在某些时候会出现 `断层` ，我们可以创建一个表 xl_tb 来仔细剖析一下。”

**小龙**：“其中 id 是自增主键字段、a 是唯一索引，如下表：”

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304051818616.png)

**小龙**：“然后插入一条数据：”

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304051818987.png)

**小龙**：“我们再查看它的表结构：”

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304051818783.png)

**小龙**：“可以看到，表定义里面出现了一个 AUTO_INCREMENT=4，表示下一次插入数据时，如果需要自动生成自增值，会生成 id=4 。”

**小龙**：“这是我亲自实验过的”

**独白**：“凸显自己动手实践能力，不是简单背八股（还真做过实验哈~）”

**小龙**：“看到这里，你可能会问`自增值存在表结构里吗`？当然不是哈”

**面试官**：“哈哈，那你说说看呢！”

**小龙**：“这个嘛，还得看是什么引擎。不同的存储引擎，自增值保存策略不一样的。”

**小龙**：“ MyISAM 引擎的自增值保存在数据文件中。”

**面试官**：“嗯，那 InnoDB 呢？”

**小龙**：“ InnoDB 引擎的自增值，其实是保存在了内存里，并且到了MySQL 8.0版本后，才有了 `自增值持久化` 的能力，也就是才实现了 `如果发生重启，表的自增值可以恢复为 MySQL 重启前的值`。”

**面试官**：“能展开说说吗？”

**小龙**：“好，在 MySQL 5.7 及之前的版本，自增值保存在内存里，并没有持久化。每次重启后，第一次打开表的时候，都会去找自增值的最大值 max(id)，然后将 max(id)+1 作为这个表当前的自增值。”

**小龙**：“举例来说，如果一个表当前数据行里最大的 id 是 10，AUTO_INCREMENT=11。这时候，我们删除 id=10 的行，AUTO_INCREMENT 还是 11。但如果马上重启实例，重启后这个表的 AUTO_INCREMENT 就会变成 10。”

**小龙**：“也就是说，MySQL 重启可能会修改一个表的 AUTO_INCREMENT 的值。”

**小龙**：“在 MySQL 8.0 版本，将自增值的变更记录在了 redo log 中，重启的时候依靠 redo log 恢复重启之前的值”

**面试官**：“好的，你能再给我讲讲关于自增值是怎样修改的吗？简单来说，当你插入一条数据，自增值会做出怎样变化？”

**小龙**：“如果插入数据时 id 字段指定为 0、null 或未指定值，那么就把这个表当前的 AUTO_INCREMENT 值填到自增字段。”

**面试官**：“那如果 id 指定了具体值呢？”

**小龙**：“ 如果插入数据时 id 字段指定了具体的值，id 就直接使用语句里指定的值 ”

**小龙**：“如果准备插入的值 >= 当前自增值，新的自增值就是 `准备插入的值 +1，否则，自增值不变`”

**面试官**：“你能举个具体例子吗？不太理解”

**小龙**：“假设，表 xl_tb 里面已经有了(1,1,1)这条记录，这时我再执行一条插入数据命令：”

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304051818129.png)

**小龙**：“这个语句的执行流程就是：1、执行器调用 InnoDB 引擎接口写入一行，传入的这一行的值是 (0,1,1)； 2、InnoDB发现用户没有指定自增 id 的值，获取表 xl_tb 当前的自增值 ；”

**小龙**：“3、将传入的行的值改成 (4,1,1)；4、将表的自增值改成5；继续执行插入数据操作，由于已经存在a=1的记录，所以报 Duplicate key error，语句返回。”

**小龙**：“这个表的自增值改成 5，是在真正执行插入数据的操作之前。这个语句真正执行的时候，因为 **碰到唯一键a冲突**，所以 id=2 这一行并没有插入成功，但也没有将自增值再改回去。”

**小龙**：“所以，在这之后，再插入新的数据行时，拿到的自增id就是5。也就是说，出现了自增主键不连续的情况。因此，**唯一键冲突是导致自增主键id不连续的第一种原因。**”

**小龙**：“同样地，事务**回滚也会产生类似的现象，这就是第二种原因。**”

**面试官**：“照你这样说，那为什么在出现唯一键冲突或者回滚的时候，MySQL 没有把表 xl_tb 的自增值改回去呢？

**面试官**：“如果把表 xl_tb 的当前自增值从 5 改回 4，再插入新数据的时候，不就可以生成 id=2 的一行数据了吗？”

**小龙**：“这个很好理解啊，我们接着分析”

**小龙**：“首先，我们假设有两个并行执行的事务 A、B，在申请自增值的时候，为了避免两个事务申请到相同的自增 id，肯定要加锁，然后顺序申请。”

![img](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/java/k202304051818430.png)

**小龙**：“结合上图。首先，事务A申请到 id=2，此时当前自增值为 3，由于加锁顺序申请，事务 B 申请到 id=3（当前自增值），此时，当前自增值变为 3+1=4 ”

**小龙**：“然后，事务 A、B都插入，假设事务B先插入然后成功插入，然后事务A插入发生了**唯一键冲突**”

**小龙**：“如果假设允许**自增值后退，自增值就变为 2** 啦。假如事务A继续插入，申请到 id=2（当前自增值=2），成功插入；事务A继续申请id，申请到 id=3（之前自增值2+1=3），插入。由于之前事务 B 已经插入 id=3 的数据，此时发生 **主键冲突。**”

**小龙**：“如果要解决这个问题”

**小龙**：“`可以每次申请id之前，先判断表里面是否已经存在这个id` 或则 `扩大锁范围，必须等事务执行完，才能申请下一个`”

**小龙**：“虽然这两种方法可以解决，但是无疑`性能极低`。”

**小龙**：“于是，便让自增值不能回退，而避免造成主键冲突等问题。（也许还有其他问题我没有想到）。”

**面试官**：“好的，已经可以啦。顺带问一句，这些你是哪里看到的？”

**小龙**：“我平时有看很多付费专栏，书籍之类的，最主要还是官方文档~”

**面试官**：“可以可以，继续加油！”

# 知识总结

本期我们通过面试模拟简单介绍了 MySQL 关于自增主键的理解，通过例子重点剖析了 `自增值修改机制` 、`自增值修改时机`与 `自增值新增机制` 。下期再见，**订阅专栏+关注** 持续追更。

**面试重点**

`为什么自增主键不连续？`

- 在MySQL 5.7及之前的版本，自增值保存在内存里，并没有持久化
- 事务回滚（自增值不能回退，因为并发插入数据时，回退自增ID可能造成主键冲突）
- 唯一键冲突（由于表的自增值已变，但是主键发生冲突没插进去，下一次插入主键=现在变了的子增值+1，所以不连续）