# 有了HTTP，为啥还要用RPC

> 原文链接：https://www.jianshu.com/p/9d42b926d40d

## 既然有 HTTP 请求，为什么还要用 RPC 调用？

一直以来都没有深究过RPC和HTTP的区别，不都是写一个服务然后在客户端调用么？

HTTP和RPC最本质的区别，就是 **RPC 主要是基于 TCP/IP 协议的**，而 **HTTP 服务主要是基于 HTTP 协议的**。

我们都知道 HTTP 协议是在传输层协议 TCP 之上的，所以效率来看的话，RPC 当然是要更胜一筹啦！

HTTP和RPC的相同点是，底层通讯都是基于socket，都可以实现远程调用，都可以实现服务调用服务

### HTTP 的本质

首先你要明确 HTTP 是一个协议，是一个超文本传输协议。

HTTP 它是协议，不是运输通道。

它基于 TCP/IP 来传输文本、图片、视频、音频等。

重点来了。

HTTP 不提供数据包的传输功能，也就是数据包从浏览器到服务端再来回的传输和它没关系。

这是 TCP/IP 干的。

那 HTTP 有啥用？我们来分析一波。

我们上网要么就是获取一些信息来看，要么就是修改一些信息。

比如你用浏览器刷微博就是获取信息，发微博就是修改信息。

所以说浏览器需要告知服务器它需要什么，这次的请求是要获取哪些信息？发怎么样的微博。

这就涉及到浏览器和服务器之间的通信交互。

而交互就需要一种格式。

像你我之间的谈话就用中文，你要突然换成俄语我听不懂那不就 GG 了。

所以说 HTTP 它规定了一种格式，一种通信格式，大家都用这个格式来交谈。

这样不论你是什么服务器、什么浏览器都能顺利的交流，减少交互的成本。

就像全世界如果都讲中文，那我们不就不需要学英文了，那不就较少交互的成本了。

不像现在我们还得学英文，不然就看不懂文档等等。

万一之后俄语又起来了，咱还得对接俄文，这交互成本是不是就上来了。

而网络世界还好，咱们现在的 Web 交互基本上就是 HTTP 了。

其实 HTTP 协议的格式很像我们信封，有个固定的格式。

![](http://img.topjavaer.cn/img/http-rpc1.png)

左上角写邮编，右上角贴邮票，然后地址姓名啥的依次来。

因为计算机是很死板的，不像我们人一样有一种立体扫描感，所以要规定先写头、再写尾。

你要是先写尾，再写头计算机就认不出来了。

所以 HTTP 就规定了请求先搞请求行、再搞请求报头、再搞请求体。

响应就状态行、响应报头、响应体。

![](http://img.topjavaer.cn/img/http-rpc2.png)

所以 HTTP 的本质是什么？

**就是客户端和服务端约定好的一种通信格式。**

### HTTP 和 RPC 的关系

HTTP 和 RPC 其实是两个维度的东西， HTTP 指的是通信协议。

而 RPC 则是远程调用，其对应的是本地调用。

RPC 的通信可以用 HTTP 协议，也可以自定义协议，是不做约束的。

像之前的单体时代，我们的 service 调用就是自己实现的方法，是本地进程内的调用。

```
public User getUserById(Long id) {
       return userDao.getUserById(id); // 这叫本地调用
    }
```

现在都是微服务了，根据业务模块做了不同的拆分，像用户的服务不用我这个小组负责，我这小组只要写订单服务就行了。

但是我们服务需要用到用户的信息，于是我们需要调用用户小组的服务，于是代码变成了以下这种

```
public User getUserById(Long id) {
       return userConsumer.getUserById(id); // 这是远程调用，逻辑是用户小组的服务实现的。
    }
```

可能还有些小伙伴不太清楚，再来看个图。

![](http://img.topjavaer.cn/img/http-rpc3.png)

把之前的用户实现拆分出来弄了一个用户服务，订单相关的也拆成了订单服务，都单独部署。

这样订单相关的服务要获取用户的信息就需要远程调用了。

可以看到 RPC 就是通过网络进行远程调用，订单服务其实就是客户端，而用户服务是服务端。

这又涉及到交互了，所以也需要约定一个格式，至于要不要用 HTTP 这个格式，就是大家自己看着办。

至此相信你对 HTTP 是啥也清楚了。

RPC 和 HTTP 的之间的关系也清楚了。

### 那为什么要有 RPC？

可能你常听到什么什么之间是 RPC 调用的，那你有没有想过为什么要 RPC， 我们直接 WebClient HTTP 调用不行么？

其实 RPC 调用是因为服务的拆分，或者本身公司内部的多个服务之间的通信。

服务的拆分独立部署，那服务间的调用就必然需要网络通信，用 WebClient 调用当然可行，但是比较麻烦。

我们想即使服务被拆分了但是使用起来还是和之前本地调用一样方便。

所以就出现了 RPC 框架，来屏蔽这些底层调用细节，使得我们编码上还是和之前本地调用相差不多。

并且 HTTP 协议比较的冗余，RPC 都是内部调用所以不需要太考虑通用性，只要公司内部保持格式统一即可。

所以可以做各种定制化的协议来使得通信更高效。

比如规定 yes 代表 yes的练级攻略，你看是不是更高效了，少传输的 5 个字。

就像特殊行动的暗号，高效简洁！

所以公司内部服务的调用一般都用 RPC，而 HTTP 的优势在于通用，大家都认可这个协议。

所以三方平台提供的接口都是通过 HTTP 协议调用的。

所以现在知道为什么我们调用第三方都是 HTTP ，公司内部用 RPC 了吧？

上面这段话看起来仿佛 HTTP 和 RPC 是对等关系，不过相信大家看了之前的解析心里应该都有数了。

下面来具体说一说 RPC 服务和 HTTP 服务的区别。

#### OSI 网络七层模型

在说 RPC 和 HTTP 的区别之前，我觉的有必要了解一下 OSI 的七层网络结构模型（

![](http://img.topjavaer.cn/img/http-rpc4.png)

它可以分为以下几层：（从上到下）

- **第一层：应用层。**定义了用于在网络中进行通信和传输数据的接口。
- **第二层：表示层。**定义不同的系统中数据的传输格式，编码和解码规范等。
- **第三层：会话层。**管理用户的会话，控制用户间逻辑连接的建立和中断。
- **第四层：传输层。**管理着网络中的端到端的数据传输。
- **第五层：网络层。**定义网络设备间如何传输数据。
- **第六层：链路层。**将上面的网络层的数据包封装成数据帧，便于物理层传输。
- **第七层：物理层。**这一层主要就是传输这些二进制数据。

![](http://img.topjavaer.cn/img/http-rpc5.png)

> **实际应用过程中，五层协议结构里面是没有表示层和会话层的。应该说它们和应用层合并了。**

我们应该将重点放在应用层和传输层这两个层面。因为 HTTP 是应用层协议，而 TCP 是传输层协议。

好，知道了网络的分层模型以后我们可以更好地理解为什么 RPC 服务相比 HTTP 服务要 Nice 一些！

### RPC 服务

从三个角度来介绍 RPC 服务，分别是：

- **RPC 架构**
- **同步异步调用**
- **流行的 RPC 框架**

**RPC 架构**

先说说 RPC 服务的基本架构吧。我们可以很清楚地看到，一个完整的 RPC 架构里面包含了四个核心的组件。

分别是：

- **Client**
- **Server**
- **Client Stub**
- **Server Stub（这个Stub大家可以理解为存根）**

![](http://img.topjavaer.cn/img/http-rpc6.png)

分别说说这几个组件：

- **客户端（Client），**服务的调用方。
- **服务端（Server），**真正的服务提供者。
- **客户端存根，**存放服务端的地址消息，再将客户端的请求参数打包成网络消息，然后通过网络远程发送给服务方。微信搜索公众号：Linux技术迷，回复：linux 领取资料 。
- 服务端存根，接收客户端发送过来的消息，将消息解包，并调用本地的方法。

RPC 主要是用在大型企业里面，因为大型企业里面系统繁多，业务线复杂，而且效率优势非常重要的一块，这个时候 RPC 的优势就比较明显了。

![](http://img.topjavaer.cn/img/http-rpc7.png)

比如我们有一个处理订单的系统服务，先声明它的所有的接口，然后将整个项目打包，服务端这边引入，然后实现相应的功能，客户端这边也只需要引入就可以调用了。

为什么这么做？

主要是为了减少客户端这边的包大小，因为每一次打包发布的时候，包太多总是会影响效率。

另外也是将客户端和服务端解耦，提高代码的可移植性。

**同步调用与异步调用**

什么是同步调用？什么是异步调用？

同步调用就是客户端等待调用执行完成并返回结果。

异步调用就是客户端不等待调用执行完成返回结果，不过依然可以通过回调函数等接收到返回结果的通知。如果客户端并不关心结果，则可以变成一个单向的调用。

#### 流行的 RPC 框架

目前流行的开源 RPC 框架还是比较多的。下面重点介绍三种：

**①gRPC** 是 Google 最近公布的开源软件，基于最新的 HTTP2.0 协议，并支持常见的众多编程语言。

我们知道 HTTP2.0 是基于二进制的 HTTP 协议升级版本，目前各大浏览器都在快马加鞭的加以支持。

这个 RPC 框架是基于 HTTP 协议实现的，底层使用到了 Netty 框架的支持。

**②Thrift** 是 Facebook 的一个开源项目，主要是一个跨语言的服务开发框架。它有一个代码生成器来对它所定义的 IDL 定义文件自动生成服务代码框架。

用户只要在其之前进行二次开发就行，对于底层的 RPC 通讯等都是透明的。不过这个对于用户来说的话需要学习特定领域语言这个特性，还是有一定成本的。

**③Dubbo** 是阿里集团开源的一个极为出名的 RPC 框架，在很多互联网公司和企业应用中广泛使用。协议和序列化框架都可以插拔是及其鲜明的特色。

### HTTP 服务

通常，我们的开发模式一直定性为 HTTP 接口开发，也就是我们常说的 RESTful 风格的服务接口。

的确，对于在接口不多、系统与系统交互较少的情况下，解决信息孤岛初期常使用的一种通信手段；优点就是简单、直接、开发方便。

利用现成的 HTTP 协议进行传输。

平时的工作主要就是进行接口的开发，还要写一大份接口文档，严格地标明输入输出是什么？说清楚每一个接口的请求方法，以及请求参数需要注意的事项等。

![](http://img.topjavaer.cn/img/http-rpc8.png)

比如下面这个例子：

```
POST http://www.httpexample.com/restful/buyer/info/shar
```

接口可能返回一个 JSON 字符串或者是 XML 文档。然后客户端再去处理这个返回的信息，从而可以比较快速地进行开发。

但是对于大型企业来说，内部子系统较多、接口非常多的情况下，RPC 框架的好处就显示出来了，首先就是长链接，不必每次通信都要像 HTTP 一样去 3 次握手什么的，减少了网络开销。

其次就是 RPC 框架一般都有注册中心，有丰富的监控管理；发布、下线接口、动态扩展等，对调用方来说是无感知、统一化的操作。

### 小结

RPC 服务和 HTTP 服务还是存在很多的不同点的，一般来说，RPC 服务主要是针对大型企业的，而 HTTP 服务主要是针对小企业的，因为 RPC 效率更高，而 HTTP 服务开发迭代会更快。

很多RPC框架包含了重试机制，路由策略，负载均衡策略，高可用策略，流量控制策略等等。如果应用进程之间只使用HTTP协议通信，显然是无法完成上述功能的。

总之，选用什么样的框架不是按照市场上流行什么而决定的，而是要对整个项目进行完整地评估，从而在仔细比较两种开发框架对于整个项目的影响，最后再决定什么才是最适合这个项目的。

一定不要为了使用 RPC 而每个项目都用 RPC，而是要因地制宜，具体情况具体分析。