<!-- DOCTOC SKIP -->

# Java2Top |「Java学习+面试指南+编程资源」

## 📖在线阅读网址👉：[www.java2top.cn](http://www.java2top.cn/)

## 👁‍🗨Java2Top介绍

「Java学习+面试指南+编程资源」一份涵盖 Javacoder 从零基础到进阶大厂的全面学习与面试指南~。

**本指南名曰**：[《Java2Top》](www.java2top.cn)，意为 Java To Top 希望大家都能成为 Java 界的佼佼者，毕业能进行业的 Top 企业公司。

致力于打造全网最佳 Java 学习进阶平台，让你 BAT Code Road 没有信息差。

- **求个Star**：如果觉得 JavaGuide 的内容对你有帮助的话，还请点个免费的 Star，这是对我最大的鼓励，感谢各位一起同行，共勉！Github 地址：[https://github.com/xlcoding/Java2Top](https://github.com/xlcoding/Java2Top) 。

## 👨‍💻关于作者

小龙二本出身，一路自学 Java，校招斩获腾讯、美团、网易SP、ViVo提前批、讯飞多个大厂offer。作为一名后端 coder，深感一路的不易。**希望我的分享可以帮助更多的小伙伴，我踩过的坑你们不要再踩**！

[<img src="https://img.shields.io/badge/WhChat-微信交流群-yellowgreen">](https://img.shields.io/badge/WhChat-微信交流群-yellowgreen)[<img src="https://img.shields.io/badge/公众号-小龙coding-brightgreen">](https://mp.weixin.qq.com/s/9HZng1BcsLHnOpPKVBt6IQ)[<img src="https://img.shields.io/badge/知乎-小龙coding-orange">](https://www.zhihu.com/people/jakelong-37)[<img src="https://img.shields.io/badge/在线-计算机经典书籍-blue">](https://mp.weixin.qq.com/s/Co4UCJfPfCsbfwUXQC24Wg)

**学前须知：**

* [项目介绍](../java2top/intro.md)
* [网站规划](../java2top/todo.md)

## 面前准备

[面试官眼前一亮的项目怎样写？](./docs/guide/interview/project.md)

[求职 | 学弟用了我的简历，给我说去腾讯了！👍](./docs/guide/interview/recruit.md)

[校招求职六大策略📚](./docs/guide/interview/six-method.md)

## BAT高频面题

### Java基础

**知识点/面试题总结** : (必看:+1: )：

[《BAT高频面点》Java基础高频面试题合集（精选）](./docs/guide/java/basic/java-basic.md)

### JDK集合

**知识点/面试题总结** : (必看:+1: )：

[《BAT高频面点》JDK集合框架面试题精选](./docs/guide/java/collection/java-collection.md)

**源码分析**

* [ArrayList 源码+扩容机制分析](docs/java/collection/arraylist-source-code.md)
* [HashMap(JDK1.8)源码+底层数据结构分析](docs/java/collection/hashmap-source-code.md)
* [ConcurrentHashMap 源码+底层数据结构分析](docs/java/collection/concurrent-hash-map-source-code.md)

[源码分析（推荐👍）](./docs/guide/java/collection/java-collection-code.md)

### 并发编程

[《BAT高频面点》(Java并发编程面试题八股文）必看](./docs/guide/java/concurrent/java-concurrent.md)

### JVM

[《BAT高频面点》JVM高频面试题八股文🔥](./docs/guide/java/jvm/java-jvm.md)

### 计算机基础

[《BAT高频面点》计算机网络高频面试题合集（必看👍）](./docs/guide/java/computer-basic/network.md)

[《BAT高频面点》操作系统高频面试题合集（必看👍）](./docs/guide/java/computer-basic/operate-system.md)

### MySQL

[MySQL-架构篇（hot🔥）](./docs/guidejava/database/mysql/java-mysql-0-structure.md)

MySQL-索引篇（hot🔥）

MySQL-事务篇（hot🔥）

MySQL-锁机制篇（hot🔥）

MySQL-架构日志篇（hot🔥）

MySQL-高可用篇（hot🔥）

MySQL-调优篇（hot🔥）

### 分布式

## 海量数据统计（更新中 ing 🔥）

[大数据中 TopK 问题的常用套路🎈](./docs/guide/mass-data/0-topk-template.md)

[1.统计不同号码的个数](./docs/guide/mass-data/1-count-phone-num.md)

[2.出现频率最高的100个词](./mass-data/2-find-hign-frequency-word.md)

[3.查找两个大文件共同的URL](./mass-data/3-find-same-url.md)

[4.如何从大量的 URL 中找出相同的 URL？](./mass-data/4-find-mid-num.md)

[5.如何查询最热门的查询串？](./mass-data/5-find-hot-string.md)

[6.如何找出排名前 500 的数？](./mass-data/6-top-500-num.md)

[7.如何按照 query 的频度排序？](./mass-data/7-query-frequency-sort.md)

[8.如何从大量数据中找出高频词？](./mass-data/8-high-frequency.md)

[9.几亿个数的大文件怎么排序？](./mass-data/9-sort-500-million-large-files.md)

## 系统设计

[0.开篇-如何设计大型系统？]()

[1.扫码登录的原理？]()

[2.订单30分钟未支付自动取消怎么实现?]()

[3.如何把——个文件较快的发送到 100 服务器?]()

[4.如何设计一个短链系统?]()

[5.如何解决超卖问题?]()

[6.如何设计一个秒杀系统?]()

[7.微信红包后台系统设计详解？]()

[8.单点登录（SSO）的设计与实现？]()

[9.如何设计一个优惠券系统?]()

[10.如何用Redis 统计用户访问量?]()

[11.实时订阅推送设计与实现]()

[12.如何设计一个抢红包系统如何设计一个消息队列?购物车系统怎么设计?]()

## 面试实录 (必看 :+1:)

根据秋招春招上岸大厂面试经历以及身边朋友**上岸面试录音模拟面试现场**，并整合面试常考知识点，通俗有趣的去讲解 `八股文`，不一样的系列，轻松掌握知识~

专栏系列目前已经连载 **N** 篇了，据说看了这个系列的朋友都拿到了大厂offer~

- [《面试实录》百度二面，Sychronized原理详解](./docs/guide/memoir/1.md)
- [《面试实录》字节二面，SQL执行慢的原因？如何优化？](./docs/guide/memoir/2.md)
- [《面试实录》 字节二面， MySQL自增主键一定连续吗？](./docs/guide/memoir/3.md)
- [《面试实录》 阿里一面，深剖Map底层结构与原理](./docs/guide/memoir/4.md)
- [《面试实录》携程二面，JVM 底层剖析](./docs/guide/memoir/5.md)

## 公众号

![我的公众号](https://xiaolongcoder.oss-cn-beijing.aliyuncs.com/imgs/Java2Top/concurrent202303202215699.png)

如果大家想要实时关注我更新的文章以及分享的干货的话，可以关注我的公众号。【**小龙coding**】

