## 无密码 SSH 访问设置

要在两台服务器之间设置无密码 SSH 访问，你需要在服务器 A 上生成一对 SSH 密钥（如果还没有的话），然后将公钥复制到服务器 B 的授权密钥列表中。以下是具体步骤：

1. 在服务器 A 上生成 SSH 密钥（如果你还没有的话）：
```angular2html
   ssh-keygen -t rsa -b 4096
```
当提示你输入文件保存密钥时，可以按回车接受默认位置。当提示你输入密码时，直接按回车以创建无密码的密钥。

2. 将公钥复制到服务器 B：
```angular2html
ssh-copy-id user@server-B
```
这里 user 是你在服务器 B 上的用户名，server-B 是服务器 B 的主机名或 IP 地址。这个命令会要求你输入服务器 B 上该用户的密码。

3. 测试无密码 SSH 访问：
```angular2html
  ssh user@server-B
```
如果一切设置正确，你应该能够在不输入密码的情况下登录到服务器 B。

重复这些步骤，将服务器 B 的公钥也复制到服务器 A，确保两台服务器都能够互相无密码访问。