# MovieDatabase
Movie Database Management System with ASP.NET and Blazor Pages.

This project is a comprehensive Movie Database Management System developed using ASP.NET and Blazor Pages, leveraging the power of MVC architectural design pattern. It includes robust CRUD operations for efficient handling of movie inventories.

Key Features:

ASP.NET MVC Architecture: Built following the Model-View-Controller architectural pattern for a structured and maintainable codebase.
Blazor Pages Integration: Utilizes Blazor Pages to create dynamic, interactive user interfaces with seamless server-side rendering.
CRUD Operations: Employs Create, Read, Update, and Delete operations for effective management of movie entries.
Inventory Management: Enables users to effortlessly add, edit, and remove movies from the database.
Image Uploading: Supports image uploading for each movie entry, enhancing visual representation and user engagement.
Table Paginations: Implements table paginations for convenient browsing through large inventories.

How to Use:

Clone the repository to your local machine.
Configure the database connection settings in the appsettings.json file.
Run the application and navigate to the provided URL.
Contribute, report issues, or suggest improvements to make this Movie Database Management System even more powerful and user-friendly. Happy coding!
