<?php

namespace Bundle\CommonBundle\Entity;

use Bundle\CommonBundle\Entity\BaseEntity;
use Bundle\CommonBundle\Entity\BaseRepository;
use FOS\UserBundle\Util\TokenGenerator;

/**
 * UserRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class UserRepository extends BaseRepository
{
    /** Get top users
     * @return mixed
     */
    public function getTopUsers()
    {
        $query = $this->createQueryBuilder('u');
        $query
            ->setMaxResults(10)
            ->addOrderBy('u.likeReceiveCount', 'DESC');

        return $query->getQuery()->getResult();
    }
    
    /** Get top users
     * @return mixed
     */
    public function getToken()
    {
        $token = null;
        if($this->currentUser instanceof User) {
            $token = $this->currentUser->getToken();
            if(empty($token)) {
                $tokenGenerator = new TokenGenerator();
                $token = $tokenGenerator->generateToken();
                $this->currentUser->setToken($token);
                $this->save($this->currentUser);
            }
        }
        
        return $token;
    }
}
