<?php

namespace Bundle\CommonBundle\Entity\Song;

use Bundle\CommonBundle\Entity\BaseEntity;
use Bundle\CommonBundle\Entity\BaseRepository;

/**
 * SongRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SongRepository extends BaseRepository
{
    /** Event before save entity
     * @param BaseEntity $entity
     */
    protected function prePersist(BaseEntity $entity)
    {
        parent::prePersist($entity);

        $entity->getAuthor()->incrementSongCount();
    }

    /**
     * Get song portion by counter
     * @param integer $offset
     * @param integer $limit
     *
     * @return mixed
     */
    public function getSongPortion($offset, $limit)
    {
        $query = $this->createQueryBuilder('s');
        $query
            ->where('s.deleted = 0')
            ->andWhere('s.room = :room')
                ->setParameter('room', $this->getCurrentUser()->getRoom())
            ->setFirstResult($offset)
            ->setMaxResults($limit);

        $query->addOrderBy('s.createdAt', 'DESC');

        return $query->getQuery()->getResult();
    }

    /**
     * Get song portion for log top
     * @param integer $limit
     * @param integer $search
     *
     * @return mixed
     */
    public function getLogTop($limit, $search = null)
    {
        $query = $this->createQueryBuilder('s');
        $query
            ->where('s.deleted = 1')
            ->andWhere('s.skip = 0')
            ->andWhere('s.room = :room')
            ->setParameter('room', $this->getCurrentUser()->getRoom())
            ->setMaxResults($limit);

        if (!empty($search)) {
            $query
                ->andWhere('s.title LIKE :title')
                ->setParameter('title', "%%$search%%");
        }

        $query->orderBy('s.counter', 'DESC');
        $query->addOrderBy('s.createdAt', 'DESC');

        return $query->getQuery()->getResult();
    }

    /**
     * Get top songs
     *
     * @return mixed
     */
    public function getTopSongs()
    {
        // TODO: group by title
        $query = $this->createQueryBuilder('s');
        $query
            ->setMaxResults(10)
            ->addOrderBy('s.counter', 'DESC');

        return $query->getQuery()->getResult();
    }
}
