Examples
===

Examples of the available fonts using the font name for the text.

1Row.flf
```
'| /? () \/\/ 
              
```


3D-ASCII.flf
```
 ________  ________                 ________  ________  ________  ___  ___     
|\_____  \|\   ___ \               |\   __  \|\   ____\|\   ____\|\  \|\  \    
\|____|\ /\ \  \_|\ \  ____________\ \  \|\  \ \  \___|\ \  \___|\ \  \ \  \   
      \|\  \ \  \ \\ \|\____________\ \   __  \ \_____  \ \  \    \ \  \ \  \  
     __\_\  \ \  \_\\ \|____________|\ \  \ \  \|____|\  \ \  \____\ \  \ \  \ 
    |\_______\ \_______\              \ \__\ \__\____\_\  \ \_______\ \__\ \__\
    \|_______|\|_______|               \|__|\|__|\_________\|_______|\|__|\|__|
                                                \|_________|                   
                                                                               
                                                                               
```


3D Diagonal.flf
```
                                                                                                                           
  .--,-``-.                                                                                                                
 /   /     '.      ,---,                ,---,                                                                      ,--,    
/ ../        ;   .'  .' `\            .'  .' `\    ,--,                                                          ,--.'|    
\ ``\  .`-    ',---.'     \         ,---.'     \ ,--.'|                            ,---.        ,---,            |  | :    
 \___\/   \   :|   |  .`\  |        |   |  .`\  ||  |,                 ,----._,.  '   ,'\   ,-+-. /  |           :  : '    
      \   :   |:   : |  '  |        :   : |  '  |`--'_      ,--.--.   /   /  ' / /   /   | ,--.'|'   |  ,--.--.  |  ' |    
      /  /   / |   ' '  ;  :        |   ' '  ;  :,' ,'|    /       \ |   :     |.   ; ,. :|   |  ,"' | /       \ '  | |    
      \  \   \ '   | ;  .  |        '   | ;  .  |'  | |   .--.  .-. ||   | .\  .'   | |: :|   | /  | |.--.  .-. ||  | :    
  ___ /   :   ||   | :  |  '        |   | :  |  '|  | :    \__\/: . ..   ; ';  |'   | .; :|   | |  | | \__\/: . .'  : |__  
 /   /\   /   :'   : | /  ;         '   : | /  ; '  : |__  ," .--.; |'   .   . ||   :    ||   | |  |/  ," .--.; ||  | '.'| 
/ ,,/  ',-    .|   | '` ,/          |   | '` ,/  |  | '.'|/  /  ,.  | `---`-'| | \   \  / |   | |--'  /  /  ,.  |;  :    ; 
\ ''\        ; ;   :  .'            ;   :  .'    ;  :    ;  :   .'   \.'__/\_: |  `----'  |   |/     ;  :   .'   \  ,   /  
 \   \     .'  |   ,.'              |   ,.'      |  ,   /|  ,     .-./|   :    :          '---'      |  ,     .-./---`-'   
  `--`-,,-'    '---'                '---'         ---`-'  `--`---'     \   \  /                       `--`---'             
                                                                        `--`-'                                             
```


3d_diagonal.flf
```
                                                                                                                          
  .--,-``-.                                                                                                               
 /   /     '.                                                                                                     ,--,    
/ ../        ;       ,---,                 ,---,  ,--,                                                          ,--.'|    
\ ``\  .`-    '    ,---.'|               ,---.'|,--.'|                            ,---.        ,---,            |  | :    
 \___\/   \   :    |   | :               |   | :|  |,                 ,----._,.  '   ,'\   ,-+-. /  |           :  : '    
      \   :   |    |   | |               |   | |`--'_      ,--.--.   /   /  ' / /   /   | ,--.'|'   |  ,--.--.  |  ' |    
      /  /   /   ,--.__| |             ,--.__| |,' ,'|    /       \ |   :     |.   ; ,. :|   |  ,"' | /       \ '  | |    
      \  \   \  /   ,'   |            /   ,'   |'  | |   .--.  .-. ||   | .\  .'   | |: :|   | /  | |.--.  .-. ||  | :    
  ___ /   :   |.   '  /  |           .   '  /  ||  | :    \__\/: . ..   ; ';  |'   | .; :|   | |  | | \__\/: . .'  : |__  
 /   /\   /   :'   ; |:  |       ___ '   ; |:  |'  : |__  ," .--.; |'   .   . ||   :    ||   | |  |/  ," .--.; ||  | '.'| 
/ ,,/  ',-    .|   | '/  '    .'  .`||   | '/  '|  | '.'|/  /  ,.  | `---`-'| | \   \  / |   | |--'  /  /  ,.  |;  :    ; 
\ ''\        ; |   :    :| .'  .'   :|   :    :|;  :    ;  :   .'   \.'__/\_: |  `----'  |   |/     ;  :   .'   \  ,   /  
 \   \     .'   \   \  /,---, '   .'  \   \  /  |  ,   /|  ,     .-./|   :    :          '---'      |  ,     .-./---`-'   
  `--`-,,-'      `----' ;   |  .'      `----'    ---`-'  `--`---'     \   \  /                       `--`---'             
                        `---'                                          `--`-'                                             
```


3-D.flf
```
  ****        *******  
 */// *      /**////** 
/    /*      /**    /**
   ***  *****/**    /**
  /// *///// /**    /**
 *   /*      /**    ** 
/ ****       /*******  
 ////        ///////   
```


3d.flf
```
  ████       ██
 █░░░ █     ░██
░    ░█     ░██
   ███   ██████
  ░░░ █ ██░░░██
 █   ░█░██  ░██
░ ████ ░░██████
 ░░░░   ░░░░░░ 
```


3x5.flf
```
            
###     ### 
  # # # #   
 ##  #  ### 
  # # #   # 
###     ### 
```


4Max.flf
```
  dP88  8b    d8    db    Yb  dP 
 dP 88  88b  d88   dPYb    YbdP  
d888888 88YbdP88  dP__Yb   dPYb  
    88  88 YY 88 dP""""Yb dP  Yb 
```


5 Line Oblique.flf
```
                                                                                                        
     ____        / /                                  //   ) )                                          
   //           / /        ( )   __      ___         //   / / / __     // ( )  ___               ___    
  //__         / /        / / //   ) ) //___) )     //   / / //   ) ) // / / //   ) ) //   / / //___) ) 
      ) )     / /        / / //   / / //           //   / / //   / / // / / ((___/ / //   / / //        
((___/ /     / /____/ / / / //   / / ((____       ((___/ / ((___/ / // / /      ( ( ((___( ( ((____     
```


5lineoblique.flf
```
                                                                                        
                                                                                        
     ____                                                                               
   //       // ( )   __      ___      ___     / __     // ( )  ___               ___    
  //__     // / / //   ) ) //___) ) //   ) ) //   ) ) // / / //   ) ) //   / / //___) ) 
      ) ) // / / //   / / //       //   / / //   / / // / / ((___/ / //   / / //        
((___/ / // / / //   / / ((____   ((___/ / ((___/ / // / /      ( ( ((___( ( ((____     
```


Acrobatic.flf
```
         o                                            o                         o        o              
        <|>                                          <|>                       <|>     _<|>_            
        / \                                          / >                       < >                      
      o/   \o         __o__  \o__ __o     o__ __o    \o__ __o        o__ __o/   |        o        __o__ 
     <|__ __|>       />  \    |     |>   /v     v\    |     v\      /v     |    o__/_   <|>      />  \  
     /       \     o/        / \   < >  />       <\  / \     <\    />     / \   |       / \    o/       
   o/         \o  <|         \o/        \         /  \o/      /    \      \o/   |       \o/   <|        
  /v           v\  \\         |          o       o    |      o      o      |    o        |     \\       
 />             <\  _\o__</  / \         <\__ __/>   / \  __/>      <\__  / \   <\__    / \     _\o__</ 
                                                                                                        
                                                                                                        
                                                                                                        
```


Alligator2.flf
```
    :::    :::       :::       :::::::::::::::::::     :::::::::::::::::::::: :::::::::  ::::::::  
  :+: :+:  :+:       :+:           :+:   :+:    :+:  :+: :+:  :+:   :+:    :+::+:    :+::+:    :+: 
 +:+   +:+ +:+       +:+           +:+   +:+        +:+   +:+ +:+   +:+    +:++:+    +:+      +:+  
+#++:++#++:+#+       +#+           +#+   :#:       +#++:++#++:+#+   +#+    +:++#++:++#:     +#+    
+#+     +#++#+       +#+           +#+   +#+   +#+#+#+     +#++#+   +#+    +#++#+    +#+  +#+      
#+#     #+##+#       #+#           #+#   #+#    #+##+#     #+##+#   #+#    #+##+#    #+# #+#       
###     ########################################## ###     ######    ######## ###    ############# 
```


alligator3.flf
```
    :::    :::       :::       :::::::::::::::::::     :::::::::::::::::::::: :::::::::  ::::::::  
  :+: :+:  :+:       :+:           :+:   :+:    :+:  :+: :+:  :+:   :+:    :+::+:    :+::+:    :+: 
 +:+   +:+ +:+       +:+           +:+   +:+        +:+   +:+ +:+   +:+    +:++:+    +:+       +:+ 
+#++:++#++:+#+       +#+           +#+   :#:       +#++:++#++:+#+   +#+    +:++#++:++#:     +#++:  
+#+     +#++#+       +#+           +#+   +#+   +#+#+#+     +#++#+   +#+    +#++#+    +#+       +#+ 
#+#     #+##+#       #+#           #+#   #+#    #+##+#     #+##+#   #+#    #+##+#    #+##+#    #+# 
###     ########################################## ###     ######    ######## ###    ### ########  
```


Alligator.flf
```
          :::    :::       :::       :::::::::::::::::::     :::::::::::::::::::::: ::::::::: 
       :+: :+:  :+:       :+:           :+:   :+:    :+:  :+: :+:  :+:   :+:    :+::+:    :+: 
     +:+   +:+ +:+       +:+           +:+   +:+        +:+   +:+ +:+   +:+    +:++:+    +:+  
   +#++:++#++:+#+       +#+           +#+   :#:       +#++:++#++:+#+   +#+    +:++#++:++#:    
  +#+     +#++#+       +#+           +#+   +#+   +#+#+#+     +#++#+   +#+    +#++#+    +#+    
 #+#     #+##+#       #+#           #+#   #+#    #+##+#     #+##+#   #+#    #+##+#    #+#     
###     ########################################## ###     ######    ######## ###    ###      
```


Alphabet.flf
```
 AA  l      h        b         t  
A  A l      h        b         t  
AAAA l ppp  hhh   aa bbb  eee ttt 
A  A l p  p h  h a a b  b e e  t  
A  A l ppp  h  h aaa bbb  ee   tt 
       p                          
       p                          
```


Alpha.flf
```
          _____                    _____            _____                    _____                    _____          
         /\    \                  /\    \          /\    \                  /\    \                  /\    \         
        /::\    \                /::\____\        /::\    \                /::\____\                /::\    \        
       /::::\    \              /:::/    /       /::::\    \              /:::/    /               /::::\    \       
      /::::::\    \            /:::/    /       /::::::\    \            /:::/    /               /::::::\    \      
     /:::/\:::\    \          /:::/    /       /:::/\:::\    \          /:::/    /               /:::/\:::\    \     
    /:::/__\:::\    \        /:::/    /       /:::/__\:::\    \        /:::/____/               /:::/__\:::\    \    
   /::::\   \:::\    \      /:::/    /       /::::\   \:::\    \      /::::\    \              /::::\   \:::\    \   
  /::::::\   \:::\    \    /:::/    /       /::::::\   \:::\    \    /::::::\    \   _____    /::::::\   \:::\    \  
 /:::/\:::\   \:::\    \  /:::/    /       /:::/\:::\   \:::\____\  /:::/\:::\    \ /\    \  /:::/\:::\   \:::\    \ 
/:::/  \:::\   \:::\____\/:::/____/       /:::/  \:::\   \:::|    |/:::/  \:::\    /::\____\/:::/  \:::\   \:::\____\
\::/    \:::\  /:::/    /\:::\    \       \::/    \:::\  /:::|____|\::/    \:::\  /:::/    /\::/    \:::\  /:::/    /
 \/____/ \:::\/:::/    /  \:::\    \       \/_____/\:::\/:::/    /  \/____/ \:::\/:::/    /  \/____/ \:::\/:::/    / 
          \::::::/    /    \:::\    \               \::::::/    /            \::::::/    /            \::::::/    /  
           \::::/    /      \:::\    \               \::::/    /              \::::/    /              \::::/    /   
           /:::/    /        \:::\    \               \::/____/               /:::/    /               /:::/    /    
          /:::/    /          \:::\    \               ~~                    /:::/    /               /:::/    /     
         /:::/    /            \:::\    \                                   /:::/    /               /:::/    /      
        /:::/    /              \:::\____\                                 /:::/    /               /:::/    /       
        \::/    /                \::/    /                                 \::/    /                \::/    /        
         \/____/                  \/____/                                   \/____/                  \/____/         
                                                                                                                     
```


AMC 3 Line.flf
```
.-. .  . .-.   -.   .   .-. . . .-. 
|-| |\/| |     -|   |    |  |\| |-  
` ' '  ` `-'   -'   `-' `-' ' ` `-' 
                                    
```


amc3line.flf
```
.-. .  . .-. -. .   .-. . . .-. 
|-| |\/| |   -| |    |  |\| |-  
` ' '  ` `-' -' `-' `-' ' ` `-' 
                                
```


AMC 3 Liv1.flf
```
.:;S;:. .:;S;:.              .:;.;:.           :.         .:;S;.        . 
S  S     )      S     S      S  S  S            S .:;s;:'      :: .:;s;:: 
`:;S;:' `:;S;:' `:;S;:'      `     '      `:;S;:'         `:;S;'  `     ' 
                                                                          
```


amc3liv1.flf
```
.:;S;:. .:;S;:.         .:;.;:.      :.         .:;S;.        . 
S  S     )      S     S S  S  S       S .:;s;:'      :: .:;s;:: 
`:;S;:' `:;S;:' `:;S;:' `     ' `:;S;:'         `:;S;'  `     ' 
                                                                
```


AMC AAA01.flf
```
 .S_SSSs     .S_SsS_S.     sSSs         .S_SSSs     .S_SSSs     .S_SSSs    
.SS~SSSSS   .SS~S*S~SS.   d%%SP        .SS~SSSSS   .SS~SSSSS   .SS~SSSSS   
S%S   SSSS  S%S `Y' S%S  d%S'          S%S   SSSS  S%S   SSSS  S%S   SSSS  
S%S    S%S  S%S     S%S  S%S           S%S    S%S  S%S    S%S  S%S    S%S  
S%S SSSS%S  S%S     S%S  S&S           S%S SSSS%S  S%S SSSS%S  S%S SSSS%S  
S&S  SSS%S  S&S     S&S  S&S           S&S  SSS%S  S&S  SSS%S  S&S  SSS%S  
S&S    S&S  S&S     S&S  S&S           S&S    S&S  S&S    S&S  S&S    S&S  
S&S    S&S  S&S     S&S  S&S           S&S    S&S  S&S    S&S  S&S    S&S  
S*S    S&S  S*S     S*S  S*b           S*S    S&S  S*S    S&S  S*S    S&S  
S*S    S*S  S*S     S*S  S*S.          S*S    S*S  S*S    S*S  S*S    S*S  
S*S    S*S  S*S     S*S   SSSbs        S*S    S*S  S*S    S*S  S*S    S*S  
SSS    S*S  SSS     S*S    YSSP        SSS    S*S  SSS    S*S  SSS    S*S  
       SP           SP                        SP          SP          SP   
       Y            Y                         Y           Y           Y    
                                                                           
```


amcaaa01.flf
```
 .S_SSSs     .S_SsS_S.     sSSs   .S_SSSs     .S_SSSs     .S_SSSs    
.SS~SSSSS   .SS~S*S~SS.   d%%SP  .SS~SSSSS   .SS~SSSSS   .SS~SSSSS   
S%S   SSSS  S%S `Y' S%S  d%S'    S%S   SSSS  S%S   SSSS  S%S   SSSS  
S%S    S%S  S%S     S%S  S%S     S%S    S%S  S%S    S%S  S%S    S%S  
S%S SSSS%S  S%S     S%S  S&S     S%S SSSS%S  S%S SSSS%S  S%S SSSS%S  
S&S  SSS%S  S&S     S&S  S&S     S&S  SSS%S  S&S  SSS%S  S&S  SSS%S  
S&S    S&S  S&S     S&S  S&S     S&S    S&S  S&S    S&S  S&S    S&S  
S&S    S&S  S&S     S&S  S&S     S&S    S&S  S&S    S&S  S&S    S&S  
S*S    S&S  S*S     S*S  S*b     S*S    S&S  S*S    S&S  S*S    S&S  
S*S    S*S  S*S     S*S  S*S.    S*S    S*S  S*S    S*S  S*S    S*S  
S*S    S*S  S*S     S*S   SSSbs  S*S    S*S  S*S    S*S  S*S    S*S  
SSS    S*S  SSS     S*S    YSSP  SSS    S*S  SSS    S*S  SSS    S*S  
       SP           SP                  SP          SP          SP   
       Y            Y                   Y           Y           Y    
                                                                     
```


AMC Neko.flf
```
.sSSSSs.    .sSSSsSS SSsSSSSS .sSSSSs.         .sSSSs.  SSSSS                                       
SSSSSSSSSs. SSSSS  SSS  SSSSS SSSSSSSSSs.      SSSSS SS SSSSS .sSSSSs.    .sSSS  SSSSS  .sSSSSs.    
S SSS SSSSS S SSS   S   SSSSS S SSS SSSSS      S SSS  `sSSSSS S SSSSSSSs. S SSS SSSSS   S SSSSSSSs. 
S  SS SSSSS S  SS       SSSSS S  SS SSSS'      S  SS    SSSSS S  SS SSSS' S  SS SSSSS   S  SS SSSSS 
S..SSsSSSSS S..SS       SSSSS S..SS            S..SS    SSSSS S..SS       S..SSsSSSSS   S..SS SSSSS 
S:::S SSSSS S:::S       SSSSS S:::S SSSSS      S:::S    SSSSS S:::SSSS    S:::S SSSSS   S:::S SSSSS 
S;;;S SSSSS S;;;S       SSSSS S;;;S SSSSS      S;;;S    SSSSS S;;;S       S;;;S  SSSSS  S;;;S SSSSS 
S%%%S SSSSS S%%%S       SSSSS S%%%S SSSSS      S%%%S    SSSSS S%%%S SSSSS S%%%S  SSSSS  S%%%S SSSSS 
SSSSS SSSSS SSSSS       SSSSS SSSSSsSSSSS      SSSSS    SSSSS SSSSSsSS;:' SSSSS   SSSSS SSSSSsSSSSS 
                                                                                                    
```


amcneko.flf
```
                                                                                               
.sSSSSs.    .sSSSsSS SSsSSSSS .sSSSSs.    .sSSSs.  SSSSS .sSSSSs.    .sSSS  SSSSS  .sSSSSs.    
S SSSSSSSs. S SSS  SSS  SSSSS S SSSSSSSs. S SSS SS SSSSS S SSSSSSSs. S SSS SSSSS   S SSSSSSSs. 
S  SS SSSSS S  SS   S   SSSSS S  SS SSSS' S  SS  `sSSSSS S  SS SSSS' S  SS SSSSS   S  SS SSSSS 
S..SSsSSSSS S..SS       SSSSS S..SS       S..SS    SSSSS S..SS       S..SSsSSSSS   S..SS SSSSS 
S:::S SSSSS S:::S       SSSSS S:::S SSSSS S:::S    SSSSS S:::SSSS    S:::S SSSSS   S:::S SSSSS 
S;;;S SSSSS S;;;S       SSSSS S;;;S SSSSS S;;;S    SSSSS S;;;S       S;;;S  SSSSS  S;;;S SSSSS 
S%%%S SSSSS S%%%S       SSSSS S%%%S SSSSS S%%%S    SSSSS S%%%S SSSSS S%%%S  SSSSS  S%%%S SSSSS 
SSSSS SSSSS SSSSS       SSSSS SSSSSsSSSSS SSSSS    SSSSS SSSSSsSS;:' SSSSS   SSSSS SSSSSsSSSSS 
                                                                                               
```


amcrazo2.flf
```
   . .       . .    .       . .       . .       . .                 . .       . .    
.+'|=|`+. .+'|=|`+.=|`+. .+'|=|`+. .+'|=|`+. .+'|=|`+. |~~|=|~~| .+'|=|`+. .+'|=|`+. 
|  | |  | |  | `+ | `+ | |  | `+.| |  | |  | |  | |  | |.+' |  | |  | |  | |.+' |  | 
|  |=|  | |  |  | |  | | |  |      |  |'. '. |  |=|  |      |.+' |  | |  |    . |  | 
|  | |  | |  |  | |  | | |  |      |  | |  | |  | |  |    .='    |  | |  | .+'|=|.+' 
|  | |  | |  |  | |  | | |  |    . |  | |  | |  | |  | .+'|    . |  | |  | |  |    . 
|  | |  | |  |  | |  | | |  | .+'| |  | |  | |  | |  | |  | .+'| |  | |  | |  | .+'| 
`+.| |..| `+.|  |.|  |+' `+.|=|.+' `+.| |.+' `+.| |..| |..|=|..| `+.|=|.+' `+.|=|.+' 
                                                                                     
```


AMC Razor2.flf
```
   . .       . .    .       . .          . .       . .                 . .       . .       . .    
.+'|=|`+. .+'|=|`+.=|`+. .+'|=|`+.    .+'|=|`+. .+'|=|`+. |~~|=|~~| .+'|=|`+. .+'|=|`+. .+'|=|`+. 
|  | |  | |  | `+ | `+ | |  | `+.|    |  | |  | |  | |  | |.+' |  | |  | |  | |  | |  | |.+' |  | 
|  |=|  | |  |  | |  | | |  |         |  |'. '. |  |=|  |      |.+' |  | |  | |  |'. '.    . |  | 
|  | |  | |  |  | |  | | |  |         |  | |  | |  | |  |    .='    |  | |  | |  | |  | .+'|=|.+' 
|  | |  | |  |  | |  | | |  |    .    |  | |  | |  | |  | .+'|    . |  | |  | |  | |  | |  |    . 
|  | |  | |  |  | |  | | |  | .+'|    |  | |  | |  | |  | |  | .+'| |  | |  | |  | |  | |  | .+'| 
`+.| |..| `+.|  |.|  |+' `+.|=|.+'    `+.| |.+' `+.| |..| |..|=|..| `+.|=|.+' `+.| |.+' `+.|=|.+' 
                                                                                                  
```


AMC Razor.flf
```
                                ___           __               ___   ___                     __  
  .'|=|`.     .'|\/|`.     .'|=|_.'      .'|=|  |   .'|=|`.    `._|=|   |   .'|=|`.     .'|=|  | 
.'  | |  `. .'  |  |  `. .'  |         .'  | |  | .'  | |  `.       |  .' .'  | |  `. .'  | |  | 
|   |=|   | |   |  |   | |   |         |   |=|.'  |   |=|   |   .'|=|.'   |   | |   | |   |=|.'  
|   | |   | |   |  |   | `.  |  ___    |   |  |`. |   | |   | .'  |  ___  `.  | |  .' |   |  |`. 
|___| |___| |___|  |___|   `.|=|_.'    |___|  |_| |___| |___| |___|=|_.'    `.|=|.'   |___|  |_| 
                                                                                                 
```


amcrazor.flf
```
                                ___        __               ___   ___                     __  
  .'|=|`.     .'|\/|`.     .'|=|_.'   .'|=|  |   .'|=|`.    `._|=|   |   .'|=|`.     .'|=|  | 
.'  | |  `. .'  |  |  `. .'  |      .'  | |  | .'  | |  `.       |  .' .'  | |  `. .'  | |  | 
|   |=|   | |   |  |   | |   |      |   |=|.'  |   |=|   |   .'|=|.'   |   | |   | |   |=|.'  
|   | |   | |   |  |   | `.  |  ___ |   |  |`. |   | |   | .'  |  ___  `.  | |  .' |   |  |`. 
|___| |___| |___|  |___|   `.|=|_.' |___|  |_| |___| |___| |___|=|_.'    `.|=|.'   |___|  |_| 
                                                                                              
```


AMC Slash.flf
```
.s5SSSs.  .s5ssSs.  .s5SSSs.      .s5SSSs.                                          
      SS.    SS SS.       SS.           SS. .s        .s5SSSs.  .s5SSSs.  .s    s.  
sS    S%S sS SS S%S sS    `:;     sS    `:;                 SS.       SS.       SS. 
SS    S%S SS :; S%S SS            SS        sS        sS    S%S sS    `:; sS    S%S 
SSSs. S%S SS    S%S SS            `:;;;;.   SS        SSSs. S%S `:;;;;.   SSSs. S%S 
SS    S%S SS    S%S SS                  ;;. SS        SS    S%S       ;;. SS    S%S 
SS    `:; SS    `:; SS                  `:; SS        SS    `:;       `:; SS    `:; 
SS    ;,. SS    ;,. SS    ;,.     .,;   ;,. SS    ;,. SS    ;,. .,;   ;,. SS    ;,. 
:;    ;:' :;    ;:' `:;;;;;:'     `:;;;;;:' `:;;;;;:' :;    ;:' `:;;;;;:' :;    ;:' 
                                                                                    
```


amcslash.flf
```
                                                                                
.s5SSSs.  .s5ssSs.  .s5SSSs.  .s5SSSs.  .s        .s5SSSs.  .s5SSSs.  .s    s.  
      SS.    SS SS.       SS.       SS.                 SS.       SS.       SS. 
sS    S%S sS SS S%S sS    `:; sS    `:; sS        sS    S%S sS    `:; sS    S%S 
SSSs. S%S SS :; S%S SS        `:;;;;.   SS        SSSs. S%S `:;;;;.   SSSs. S%S 
SS    S%S SS    S%S SS              ;;. SS        SS    S%S       ;;. SS    S%S 
SS    `:; SS    `:; SS              `:; SS        SS    `:;       `:; SS    `:; 
SS    ;,. SS    ;,. SS    ;,. .,;   ;,. SS    ;,. SS    ;,. .,;   ;,. SS    ;,. 
:;    ;:' :;    ;:' `:;;;;;:' `:;;;;;:' `:;;;;;:' :;    ;:' `:;;;;;:' :;    ;:' 
                                                                                
```


amcslder.flf
```
                                       ______                                          ____                    
      .'.             .'. .`.        .~      ~.             ..'''' |        |``````.  |            |`````````, 
    .''```.         .'   `   `.     |                    .''       |        |       | |______      |'''|'''''  
  .'       `.     .'           `.   |                 ..'          |        |       | |            |    `.     
.'           `. .'               `.  `.______.' ....''             |_______ |......'  |___________ |      `.   
                                                                                                               
```


AMC Slider.flf
```
                                       ______                                                   ____                    
      .'.             .'. .`.        .~      ~.                    ..'''' |        | |``````.  |            |`````````, 
    .''```.         .'   `   `.     |                           .''       |        | |       | |______      |'''|'''''  
  .'       `.     .'           `.   |                        ..'          |        | |       | |            |    `.     
.'           `. .'               `.  `.______.'        ....''             |_______ | |......'  |___________ |      `.   
                                                                                                                        
```


AMC Thin.flf
```
.-..-..-. .-.-. .-.-. .-..--.     .-..-..-. .-.   .-. .-. .-..-.  .-. 
| | ~ | | | |~.-.~| | | | ~~       ~ | | ~  | | _ | | | | | | ~.-.| | 
| |.-.| | | |  ~  | | | |            | |    | |`-'| | | | | |   ~ | | 
| | ~ | | | |     | | | |            | |    | |   | | | | | |     | | 
| |   | | | |     | | | | __         | |    | |   | | | | | |     | | 
`-'   `-' `-'     `-' `-'`--'        `-'    `-'   `-' `-' `-'     `-' 
                                                                      
```


amcthin.flf
```
.-..-..-. .-.-. .-.-. .-..--. .-..-..-. .-.   .-. .-. .-..-.  .-. 
| | ~ | | | |~.-.~| | | | ~~   ~ | | ~  | | _ | | | | | | ~.-.| | 
| |.-.| | | |  ~  | | | |        | |    | |`-'| | | | | |   ~ | | 
| | ~ | | | |     | | | |        | |    | |   | | | | | |     | | 
| |   | | | |     | | | | __     | |    | |   | | | | | |     | | 
`-'   `-' `-'     `-' `-'`--'    `-'    `-'   `-' `-' `-'     `-' 
                                                                  
```


AMC Tubes.flf
```
d s.   d s   sb   sSSs.      sss sssss d       b d ss.  d sss     sss. 
S  ~O  S  S S S  S               S     S       S S    b S       d      
S   `b S   S  S S                S     S       S S    P S       Y      
S sSSO S      S S                S     S       S S sSS' S sSSs    ss.  
S    O S      S S                S     S       S S    b S            b 
S    O S      S  S               S      S     S  S    P S            P 
P    P P      P   "sss'          P       "sss"   P `SS  P sSSss ` ss'  
                                                                       
```


amctubes.flf
```
d s.   d s   sb   sSSs. sss sssss d       b d ss.  d sss     sss. 
S  ~O  S  S S S  S          S     S       S S    b S       d      
S   `b S   S  S S           S     S       S S    P S       Y      
S sSSO S      S S           S     S       S S sSS' S sSSs    ss.  
S    O S      S S           S     S       S S    b S            b 
S    O S      S  S          S      S     S  S    P S            P 
P    P P      P   "sss'     P       "sss"   P `SS  P sSSss ` ss'  
                                                                  
```


amcun1.flf
```
                                                  ,'''''', 
                                                  ',,';  ; 
,'',,''', ,'',,'',,'', ,'',,'', ,',  ,', ,'',,'',     ;  ; 
;  ;',  ; ;  ;', ;', ; ;  ;',,' ; ;  ; ; ;  ;', ;     ;  ; 
;  ;,'  ; ;  ; ; ; ; ; ;  ;     ; ;  ; ; ;  ; ; ;     ;  ; 
;  ;',  ; ;  ; ; ; ; ; ;  ;,'', ; ',,' ; ;  ; ; ;     ;  ; 
',,' ',,' ',,' ',' ',' ',,'',,' ',,'',,' ',,' ','     ',,' 
                                                           
```


AMC Untitled.flf
```
,'',,''', ,'',,'',,'', ,'',,'',     ,'',  ,'',                                                                     
;  ;',  ; ;  ;', ;', ; ;  ;',,'     ;  ;  ;  ;                                                                     
;  ;,'  ; ;  ; ; ; ; ; ;  ;         ;  ;  ;  ; ,'',,'', ,'',,'',,'', ,'', ,'',,'',,'', ,'',     ,'',,'', ,'',,'',  
;  ;',  ; ;  ; ; ; ; ; ;  ;         ;  ;  ;  ; ;  ;', ; ',,';  ;',,' ;  ; ',,';  ;',,' ;  ;     ;  ;',,' ;  ;;   ; 
;  ; ;  ; ;  ; ; ; ; ; ;  ;         ;  ;  ;  ; ;  ; ; ;     ;  ;     ;  ;     ;  ;     ;  ;     ;  ;',,' ;  ;;   ; 
;  ; ;  ; ;  ; ; ; ; ; ;  ;,'',     ;  ',,'  ; ;  ; ; ;     ;  ;     ;  ;     ;  ;     ;  ;,'', ;  ; ,,  ;  ;;   ; 
',,' ',,' ',,' ',' ',' ',,'',,'     ',,,'',,,' ',,' ','     ',,'     ',,'     ',,'     ',,'',,' ',,'',,' ',,'',,'  
                                                                                                                   
```


ANSI Regular.flf
```
 █████  ███    ██ ███████ ██     ██████  ███████  ██████  ██    ██ ██       █████  ██████  
██   ██ ████   ██ ██      ██     ██   ██ ██      ██       ██    ██ ██      ██   ██ ██   ██ 
███████ ██ ██  ██ ███████ ██     ██████  █████   ██   ███ ██    ██ ██      ███████ ██████  
██   ██ ██  ██ ██      ██ ██     ██   ██ ██      ██    ██ ██    ██ ██      ██   ██ ██   ██ 
██   ██ ██   ████ ███████ ██     ██   ██ ███████  ██████   ██████  ███████ ██   ██ ██   ██ 
                                                                                           
                                                                                           
```


ANSI Shadow.flf
```
 █████╗ ███╗   ██╗███████╗██╗    ███████╗██╗  ██╗ █████╗ ██████╗  ██████╗ ██╗    ██╗
██╔══██╗████╗  ██║██╔════╝██║    ██╔════╝██║  ██║██╔══██╗██╔══██╗██╔═══██╗██║    ██║
███████║██╔██╗ ██║███████╗██║    ███████╗███████║███████║██║  ██║██║   ██║██║ █╗ ██║
██╔══██║██║╚██╗██║╚════██║██║    ╚════██║██╔══██║██╔══██║██║  ██║██║   ██║██║███╗██║
██║  ██║██║ ╚████║███████║██║    ███████║██║  ██║██║  ██║██████╔╝╚██████╔╝╚███╔███╔╝
╚═╝  ╚═╝╚═╝  ╚═══╝╚══════╝╚═╝    ╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝╚═════╝  ╚═════╝  ╚══╝╚══╝ 
                                                                                    
```


Arrows.flf
```
      >>                                                       
     >>=>                                                      
    >> >=>     >> >==> >> >==>    >=>     >=>      >=>  >===>  
   >=>  >=>     >=>     >=>     >=>  >=>   >=>  >  >=> >=>     
  >=====>>=>    >=>     >=>    >=>    >=>  >=> >>  >=>   >==>  
 >=>      >=>   >=>     >=>     >=>  >=>   >=>>  >=>=>     >=> 
>=>        >=> >==>    >==>       >=>     >==>    >==> >=> >=> 
                                                               
```


ASCII New Roman.flf
```
  ____,____,____,__, __,   _,  _,____,_   _,  ____, ____, __, _, ____,_,  _,
 (-/_|(-(__(-/  (-| (-|   (-|\ |(-|_,(-|  |  (-|__)(-/  \(-|\/| (-/_|(-|\ | 
 _/  |,____)_\__,_|_,_|_,  _| \|,_|__,_|/\|,  _|  \,_\__/,_| _|,_/  |,_| \|,
(     (    (    (   (     (     (    (       (     (     (     (     (      
```


ascii_new_roman.flf
```
  ____,____,____,__, __, __,  _,____,_   _,_____, ____, __, _, ____,_,  _,
 (-/_|(-(__(-/  (-| (-|  (-|\ |(-|_,(-|  | (-|__)(-/  \(-|\/| (-/_|(-|\ | 
 _/  |,____)_\__,_|_,_|_, _| \|,_|__,_|/\|, _|  \,_\__/,_| _|,_/  |,_| \|,
(     (    (    (   (    (     (    (      (     (     (     (     (      
```


Avatar.flf
```
 ____  _     ____ _____ ____  ____ 
/  _ \/ \ |\/  _ Y__ __Y  _ \/  __\
| / \|| | //| / \| / \ | / \||  \/|
| |-||| \// | |-|| | | | |-|||    /
\_/ \|\__/  \_/ \| \_/ \_/ \|\_/\_\
                                   
```


B1FF.flf
```
|31FF
```


Banner3-D.flf
```
'########:::::'###::::'##::: ##:'##::: ##:'########:'########:::'#######:::::::::::'########::
 ##.... ##:::'## ##::: ###:: ##: ###:: ##: ##.....:: ##.... ##:'##.... ##:::::::::: ##.... ##:
 ##:::: ##::'##:. ##:: ####: ##: ####: ##: ##::::::: ##:::: ##:..::::: ##:::::::::: ##:::: ##:
 ########::'##:::. ##: ## ## ##: ## ## ##: ######::: ########:::'#######::'#######: ##:::: ##:
 ##.... ##: #########: ##. ####: ##. ####: ##...:::: ##.. ##::::...... ##:........: ##:::: ##:
 ##:::: ##: ##.... ##: ##:. ###: ##:. ###: ##::::::: ##::. ##::'##:::: ##:::::::::: ##:::: ##:
 ########:: ##:::: ##: ##::. ##: ##::. ##: ########: ##:::. ##:. #######::::::::::: ########::
........:::..:::::..::..::::..::..::::..::........::..:::::..:::.......::::::::::::........:::
```


Banner3.flf
```
########     ###    ##    ## ##    ## ######## ########   #######  
##     ##   ## ##   ###   ## ###   ## ##       ##     ## ##     ## 
##     ##  ##   ##  ####  ## ####  ## ##       ##     ##        ## 
########  ##     ## ## ## ## ## ## ## ######   ########   #######  
##     ## ######### ##  #### ##  #### ##       ##   ##          ## 
##     ## ##     ## ##   ### ##   ### ##       ##    ##  ##     ## 
########  ##     ## ##    ## ##    ## ######## ##     ##  #######  
```


Banner4.flf
```
.########.....###....##....##.##....##.########.########..##.......
.##.....##...##.##...###...##.###...##.##.......##.....##.##....##.
.##.....##..##...##..####..##.####..##.##.......##.....##.##....##.
.########..##.....##.##.##.##.##.##.##.######...########..##....##.
.##.....##.#########.##..####.##..####.##.......##...##...#########
.##.....##.##.....##.##...###.##...###.##.......##....##........##.
.########..##.....##.##....##.##....##.########.##.....##.......##.
```


Banner.flf
```
######                                     
#     #   ##   #    # #    # ###### #####  
#     #  #  #  ##   # ##   # #      #    # 
######  #    # # #  # # #  # #####  #    # 
#     # ###### #  # # #  # # #      #####  
#     # #    # #   ## #   ## #      #   #  
######  #    # #    # #    # ###### #    # 
                                           
```


Barbwire.flf
```
><< ><<                    ><<                                      
><    ><<                  ><<                   ><                 
><     ><<   ><<    >< ><<<><<      ><<     ><<<   >< ><<<   ><<    
><<< ><    ><<  ><<  ><<   ><< ><<   ><<  <  ><<><< ><<    ><   ><< 
><     ><<><<   ><<  ><<   ><<   ><< ><< ><  ><<><< ><<   ><<<<< ><<
><      ><><<   ><<  ><<   ><<   ><< >< >< ><><<><< ><<   ><        
><<<< ><<   ><< ><<<><<<   ><< ><<  ><<<    ><<<><<><<<     ><<<<   
                                                                    
```


Basic.flf
```
d8888b.  .d8b.  .d8888. d888888b  .o88b. 
88  `8D d8' `8b 88'  YP   `88'   d8P  Y8 
88oooY' 88ooo88 `8bo.      88    8P      
88~~~b. 88~~~88   `Y8b.    88    8b      
88   8D 88   88 db   8D   .88.   Y8b  d8 
Y8888P' YP   YP `8888Y' Y888888P  `Y88P' 
                                         
                                         
```


Bear.flf
```
   _     _      _     _      _     _      _     _   
  (c).-.(c)    (c).-.(c)    (c).-.(c)    (c).-.(c)  
   / ._. \      / ._. \      / ._. \      / ._. \   
 __\( Y )/__  __\( Y )/__  __\( Y )/__  __\( Y )/__ 
(_.-/'-'\-._)(_.-/'-'\-._)(_.-/'-'\-._)(_.-/'-'\-._)
   || B ||      || E ||      || A ||      || R ||   
 _.' `-' '._  _.' `-' '._  _.' `-' '._  _.' `-' '._ 
(.-./`-'\.-.)(.-./`-'\.-.)(.-./`-'\.-.)(.-./`-`\.-.)
 `-'     `-'  `-'     `-'  `-'     `-'  `-'     `-' 
```


Bell.flf
```
 ____           .    .  
 /   \    ___   |    |  
 |,_-<  .'   `  |    |  
 |    ` |----'  |    |  
 `----' `.___, /\__ /\__
                        
```


Benjamin.flf
```
|3[-|\|.]/-\|\/|||\|
```


Big Chief.flf
```
________________________________________________________
    ____                     __                       _ 
    /   )    ,             /    )   /     ,         /  `
---/__ /---------__-------/--------/__--------__--_/__--
  /    )   /   /   )     /        /   ) /   /___) /     
_/____/___/___(___/_____(____/___/___/_/___(___ _/______
                 /                                      
             (_ /                                       
```


bigchief.flf
```
______________________________________________
                                            _ 
    /     ,               /     ,         /  `
---/__--------__----__---/__--------__--_/__--
  /   ) /   /   ) /   ' /   ) /   /___) /     
_(___/_/___(___/_(___ _/___/_/___(___ _/______
              /                               
          (_ /                                
```


Bigfig.flf
```
 _     _   _    _ 
|_) o (_|_|_ o (_|
|_) | __| |  | __|
```


Big.flf
```
 ____  _       
|  _ \(_)      
| |_) |_  __ _ 
|  _ <| |/ _` |
| |_) | | (_| |
|____/|_|\__, |
          __/ |
         |___/ 
```


Big Money-ne.flf
```
 /$$$$$$$  /$$                 /$$      /$$                                                                    
| $$__  $$|__/                | $$$    /$$$                                                                    
| $$  \ $$ /$$  /$$$$$$       | $$$$  /$$$$  /$$$$$$  /$$$$$$$   /$$$$$$  /$$   /$$         /$$$$$$$   /$$$$$$ 
| $$$$$$$ | $$ /$$__  $$      | $$ $$/$$ $$ /$$__  $$| $$__  $$ /$$__  $$| $$  | $$ /$$$$$$| $$__  $$ /$$__  $$
| $$__  $$| $$| $$  \ $$      | $$  $$$| $$| $$  \ $$| $$  \ $$| $$$$$$$$| $$  | $$|______/| $$  \ $$| $$$$$$$$
| $$  \ $$| $$| $$  | $$      | $$\  $ | $$| $$  | $$| $$  | $$| $$_____/| $$  | $$        | $$  | $$| $$_____/
| $$$$$$$/| $$|  $$$$$$$      | $$ \/  | $$|  $$$$$$/| $$  | $$|  $$$$$$$|  $$$$$$$        | $$  | $$|  $$$$$$$
|_______/ |__/ \____  $$      |__/     |__/ \______/ |__/  |__/ \_______/ \____  $$        |__/  |__/ \_______/
               /$$  \ $$                                                  /$$  | $$                            
              |  $$$$$$/                                                 |  $$$$$$/                            
               \______/                                                   \______/                             
```


Big Money-nw.flf
```
$$$$$$$\  $$\                 $$\      $$\                                                                         
$$  __$$\ \__|                $$$\    $$$ |                                                                        
$$ |  $$ |$$\  $$$$$$\        $$$$\  $$$$ | $$$$$$\  $$$$$$$\   $$$$$$\  $$\   $$\         $$$$$$$\  $$\  $$\  $$\ 
$$$$$$$\ |$$ |$$  __$$\       $$\$$\$$ $$ |$$  __$$\ $$  __$$\ $$  __$$\ $$ |  $$ |$$$$$$\ $$  __$$\ $$ | $$ | $$ |
$$  __$$\ $$ |$$ /  $$ |      $$ \$$$  $$ |$$ /  $$ |$$ |  $$ |$$$$$$$$ |$$ |  $$ |\______|$$ |  $$ |$$ | $$ | $$ |
$$ |  $$ |$$ |$$ |  $$ |      $$ |\$  /$$ |$$ |  $$ |$$ |  $$ |$$   ____|$$ |  $$ |        $$ |  $$ |$$ | $$ | $$ |
$$$$$$$  |$$ |\$$$$$$$ |      $$ | \_/ $$ |\$$$$$$  |$$ |  $$ |\$$$$$$$\ \$$$$$$$ |        $$ |  $$ |\$$$$$\$$$$  |
\_______/ \__| \____$$ |      \__|     \__| \______/ \__|  \__| \_______| \____$$ |        \__|  \__| \_____\____/ 
              $$\   $$ |                                                 $$\   $$ |                                
              \$$$$$$  |                                                 \$$$$$$  |                                
               \______/                                                   \______/                                 
```


Big Money-se.flf
```
 _______   __                  __       __                                                                     
|       \ |  \                |  \     /  \                                                                    
| $$$$$$$\ \$$  ______        | $$\   /  $$  ______   _______    ______   __    __           _______   ______  
| $$__/ $$|  \ /      \       | $$$\ /  $$$ /      \ |       \  /      \ |  \  |  \ ______  /       \ /      \ 
| $$    $$| $$|  $$$$$$\      | $$$$\  $$$$|  $$$$$$\| $$$$$$$\|  $$$$$$\| $$  | $$|      \|  $$$$$$$|  $$$$$$\
| $$$$$$$\| $$| $$  | $$      | $$\$$ $$ $$| $$  | $$| $$  | $$| $$    $$| $$  | $$ \$$$$$$ \$$    \ | $$    $$
| $$__/ $$| $$| $$__| $$      | $$ \$$$| $$| $$__/ $$| $$  | $$| $$$$$$$$| $$__/ $$         _\$$$$$$\| $$$$$$$$
| $$    $$| $$ \$$    $$      | $$  \$ | $$ \$$    $$| $$  | $$ \$$     \ \$$    $$        |       $$ \$$     \
 \$$$$$$$  \$$ _\$$$$$$$       \$$      \$$  \$$$$$$  \$$   \$$  \$$$$$$$ _\$$$$$$$         \$$$$$$$   \$$$$$$$
              |  \__| $$                                                 |  \__| $$                            
               \$$    $$                                                  \$$    $$                            
                \$$$$$$                                                    \$$$$$$                             
```


Big Money-sw.flf
```
 _______   __                  __       __                                                                         
/       \ /  |                /  \     /  |                                                                        
$$$$$$$  |$$/   ______        $$  \   /$$ |  ______   _______    ______   __    __           _______  __   __   __ 
$$ |__$$ |/  | /      \       $$$  \ /$$$ | /      \ /       \  /      \ /  |  /  | ______  /       |/  | /  | /  |
$$    $$< $$ |/$$$$$$  |      $$$$  /$$$$ |/$$$$$$  |$$$$$$$  |/$$$$$$  |$$ |  $$ |/      |/$$$$$$$/ $$ | $$ | $$ |
$$$$$$$  |$$ |$$ |  $$ |      $$ $$ $$/$$ |$$ |  $$ |$$ |  $$ |$$    $$ |$$ |  $$ |$$$$$$/ $$      \ $$ | $$ | $$ |
$$ |__$$ |$$ |$$ \__$$ |      $$ |$$$/ $$ |$$ \__$$ |$$ |  $$ |$$$$$$$$/ $$ \__$$ |         $$$$$$  |$$ \_$$ \_$$ |
$$    $$/ $$ |$$    $$ |      $$ | $/  $$ |$$    $$/ $$ |  $$ |$$       |$$    $$ |        /     $$/ $$   $$   $$/ 
$$$$$$$/  $$/  $$$$$$$ |      $$/      $$/  $$$$$$/  $$/   $$/  $$$$$$$/  $$$$$$$ |        $$$$$$$/   $$$$$/$$$$/  
              /  \__$$ |                                                 /  \__$$ |                                
              $$    $$/                                                  $$    $$/                                 
               $$$$$$/                                                    $$$$$$/                                  
```


Binary.flf
```
01000010 01101001 01101110 01100001 01110010 01111001 
```


Block.flf
```
                                            
_|_|_|    _|                      _|        
_|    _|  _|    _|_|      _|_|_|  _|  _|    
_|_|_|    _|  _|    _|  _|        _|_|      
_|    _|  _|  _|    _|  _|        _|  _|    
_|_|_|    _|    _|_|      _|_|_|  _|    _|  
                                            
                                            
```


Blocks.flf
```
 .----------------.  .----------------.  .----------------.  .----------------.  .----------------.  .----------------. 
| .--------------. || .--------------. || .--------------. || .--------------. || .--------------. || .--------------. |
| |   ______     | || |   _____      | || |     ____     | || |     ______   | || |  ___  ____   | || |    _______   | |
| |  |_   _ \    | || |  |_   _|     | || |   .'    `.   | || |   .' ___  |  | || | |_  ||_  _|  | || |   /  ___  |  | |
| |    | |_) |   | || |    | |       | || |  /  .--.  \  | || |  / .'   \_|  | || |   | |_/ /    | || |  |  (__ \_|  | |
| |    |  __'.   | || |    | |   _   | || |  | |    | |  | || |  | |         | || |   |  __'.    | || |   '.___`-.   | |
| |   _| |__) |  | || |   _| |__/ |  | || |  \  `--'  /  | || |  \ `.___.'\  | || |  _| |  \ \_  | || |  |`\____) |  | |
| |  |_______/   | || |  |________|  | || |   `.____.'   | || |   `._____.'  | || | |____||____| | || |  |_______.'  | |
| |              | || |              | || |              | || |              | || |              | || |              | |
| '--------------' || '--------------' || '--------------' || '--------------' || '--------------' || '--------------' |
 '----------------'  '----------------'  '----------------'  '----------------'  '----------------'  '----------------' 
```


Bloody.flf
```
 ▄▄▄▄    ██▓     ▒█████   ▒█████  ▓█████▄▓██   ██▓
▓█████▄ ▓██▒    ▒██▒  ██▒▒██▒  ██▒▒██▀ ██▌▒██  ██▒
▒██▒ ▄██▒██░    ▒██░  ██▒▒██░  ██▒░██   █▌ ▒██ ██░
▒██░█▀  ▒██░    ▒██   ██░▒██   ██░░▓█▄   ▌ ░ ▐██▓░
░▓█  ▀█▓░██████▒░ ████▓▒░░ ████▓▒░░▒████▓  ░ ██▒▓░
░▒▓███▀▒░ ▒░▓  ░░ ▒░▒░▒░ ░ ▒░▒░▒░  ▒▒▓  ▒   ██▒▒▒ 
▒░▒   ░ ░ ░ ▒  ░  ░ ▒ ▒░   ░ ▒ ▒░  ░ ▒  ▒ ▓██ ░▒░ 
 ░    ░   ░ ░   ░ ░ ░ ▒  ░ ░ ░ ▒   ░ ░  ░ ▒ ▒ ░░  
 ░          ░  ░    ░ ░      ░ ░     ░    ░ ░     
      ░                            ░      ░ ░     
```


Bolger.flf
```
888~~\           888       /                  
888   |  e88~-_  888 e88~88e  e88~~8e  888-~\ 
888 _/  d888   i 888 888 888 d888  88b 888    
888  \  8888   | 888 "88_88" 8888__888 888    
888   | Y888   ' 888  /      Y888    , 888    
888__/   "88_-~  888 Cb       "88___/  888    
                      Y8""8D                  
```


Braced.flf
```
.----. .---.  .--.  .----..----..----.  
| {_} }} }}_}/ {} \ | }`-'} |__}} {-. \ 
| {_} }| } \/  /\  \| },-.} '__}} '-} / 
`----' `-'-'`-'  `-'`----'`----'`----'  
                                        
```


Bright.flf
```
.#####...#####...######...####...##..##..######.
.##..##..##..##....##....##......##..##....##...
.#####...#####.....##....##.###..######....##...
.##..##..##..##....##....##..##..##..##....##...
.#####...##..##..######...####...##..##....##...
................................................
```


Broadway.flf
```
                                                                                                                                           
8 888888888o   8 888888888o.      ,o888888o.           .8.          8 888888888o.    `8.`888b                 ,8' .8.   `8.`8888.      ,8' 
8 8888    `88. 8 8888    `88.  . 8888     `88.        .888.         8 8888    `^888.  `8.`888b               ,8' .888.   `8.`8888.    ,8'  
8 8888     `88 8 8888     `88 ,8 8888       `8b      :88888.        8 8888        `88. `8.`888b             ,8' :88888.   `8.`8888.  ,8'   
8 8888     ,88 8 8888     ,88 88 8888        `8b    . `88888.       8 8888         `88  `8.`888b     .b    ,8' . `88888.   `8.`8888.,8'    
8 8888.   ,88' 8 8888.   ,88' 88 8888         88   .8. `88888.      8 8888          88   `8.`888b    88b  ,8' .8. `88888.   `8.`88888'     
8 8888888888   8 888888888P'  88 8888         88  .8`8. `88888.     8 8888          88    `8.`888b .`888b,8' .8`8. `88888.   `8. 8888      
8 8888    `88. 8 8888`8b      88 8888        ,8P .8' `8. `88888.    8 8888         ,88     `8.`888b8.`8888' .8' `8. `88888.   `8 8888      
8 8888      88 8 8888 `8b.    `8 8888       ,8P .8'   `8. `88888.   8 8888        ,88'      `8.`888`8.`88' .8'   `8. `88888.   8 8888      
8 8888    ,88' 8 8888   `8b.   ` 8888     ,88' .888888888. `88888.  8 8888    ,o88P'         `8.`8' `8,`' .888888888. `88888.  8 8888      
8 888888888P   8 8888     `88.    `8888888P'  .8'       `8. `88888. 8 888888888P'             `8.`   `8' .8'       `8. `88888. 8 8888      
```


Broadway KB.flf
```
 ___   ___   ___    __    ___   _        __    _         _     ___  
| |_) | |_) / / \  / /\  | | \ \ \    / / /\  \ \_/     | |_/ | |_) 
|_|_) |_| \ \_\_/ /_/--\ |_|_/  \_\/\/ /_/--\  |_|      |_| \ |_|_) 
```


broadway_kb.flf
```
 ___   ___   ___    __    ___   _        __    _           _     ___  
| |_) | |_) / / \  / /\  | | \ \ \    / / /\  \ \_/  ___  | |_/ | |_) 
|_|_) |_| \ \_\_/ /_/--\ |_|_/  \_\/\/ /_/--\  |_|  |___| |_| \ |_|_) 
```


Bubble.flf
```
  _   _   _   _   _   _  
 / \ / \ / \ / \ / \ / \ 
( B | u | b | b | l | e )
 \_/ \_/ \_/ \_/ \_/ \_/ 
```


Bulbhead.flf
```
 ____  __  __  __    ____  _   _  ____    __    ____  
(  _ \(  )(  )(  )  (  _ \( )_( )( ___)  /__\  (  _ \ 
 ) _ < )(__)(  )(__  ) _ < ) _ (  )__)  /(__)\  )(_) )
(____/(______)(____)(____/(_) (_)(____)(__)(__)(____/ 
```


calgphy2.flf
```
                                                                            
                   ###                              /                       
                    ###                           #/                        
                     ##                           ##                        
                     ##                           ##                        
                     ##                           ##                        
   /###      /###    ##      /###         /###    ##  /##  ##   ####        
  / ###  /  / ###  / ##     /  ###  /    / ###  / ## / ###  ##    ###  /    
 /   ###/  /   ###/  ##    /    ###/    /   ###/  ##/   ### ##     ###/     
##        ##    ##   ##   ##     ##    ##    ##   ##     ## ##      ##      
##        ##    ##   ##   ##     ##    ##    ##   ##     ## ##      ##      
##        ##    ##   ##   ##     ##    ##    ##   ##     ## ##      ##      
##        ##    ##   ##   ##     ##    ##    ##   ##     ## ##      ##      
###     / ##    /#   ##   ##     ##    ##    ##   ##     ## ##      ##    n 
 ######/   ####/ ##  ### / ########    #######    ##     ##  #########    u 
  #####     ###   ##  ##/    ### ###   ######      ##    ##    #### ###   m 
                                  ###  ##                /           ###  b 
                            ####   ### ##               /     #####   ### e 
                          /######  /#  ##              /    /#######  /#  r 
                         /     ###/     ##            /    /      ###/    2 
```


Caligraphy2.flf
```
                                                                                                          
      # ###            ###                                                        /                       
    /  /###  /          ###    #                                                #/                        
   /  /  ###/            ##   ###                                               ##                        
  /  ##   ##             ##    #                                                ##                        
 /  ###                  ##                                                     ##                        
##   ##          /###    ##  ###       /###    ###  /###     /###       /###    ##  /##  ##   ####        
##   ##         / ###  / ##   ###     /  ###  / ###/ #### / / ###  /   / ###  / ## / ###  ##    ###  /    
##   ##        /   ###/  ##    ##    /    ###/   ##   ###/ /   ###/   /   ###/  ##/   ### ##     ###/     
##   ##       ##    ##   ##    ##   ##     ##    ##       ##    ##   ##    ##   ##     ## ##      ##      
##   ##       ##    ##   ##    ##   ##     ##    ##       ##    ##   ##    ##   ##     ## ##      ##      
 ##  ##       ##    ##   ##    ##   ##     ##    ##       ##    ##   ##    ##   ##     ## ##      ##      
  ## #      / ##    ##   ##    ##   ##     ##    ##       ##    ##   ##    ##   ##     ## ##      ##      
   ###     /  ##    /#   ##    ##   ##     ##    ##       ##    /#   ##    ##   ##     ## ##      ##    n 
    ######/    ####/ ##  ### / ### / ########    ###       ####/ ##  #######    ##     ##  #########    u 
      ###       ###   ##  ##/   ##/    ### ###    ###       ###   ## ######      ##    ##    #### ###   m 
                                            ###                      ##                /           ###  b 
                                      ####   ###                     ##               /     #####   ### e 
                                    /######  /#                      ##              /    /#######  /#  r 
                                   /     ###/                         ##            /    /      ###/    2 
```


Caligraphy.flf
```
                                                                                                                    
      * ***               ***                                                                *                      
    *  ****  *             ***      *                                                      **                       
   *  *  ****               **     ***                                                     **                       
  *  **   **                **      *                                                      **                       
 *  ***                     **                          ***  ****                  ****    **        **   ****      
**   **           ****      **    ***         ****       **** **** *    ****      * ***  * **  ***    **    ***  *  
**   **          * ***  *   **     ***       *  ***  *    **   ****    * ***  *  *   ****  ** * ***   **     ****   
**   **         *   ****    **      **      *    ****     **          *   ****  **    **   ***   ***  **      **    
**   **        **    **     **      **     **     **      **         **    **   **    **   **     **  **      **    
**   **        **    **     **      **     **     **      **         **    **   **    **   **     **  **      **    
 **  **        **    **     **      **     **     **      **         **    **   **    **   **     **  **      **    
  ** *      *  **    **     **      **     **     **      **         **    **   **    **   **     **  **      **    
   ***     *   **    **     **      **     **     **      ***        **    **   *******    **     **   *********    
    *******     ***** **    *** *   *** *   ********       ***        ***** **  ******     **     **     **** ***   
      ***        ***   **    ***     ***      *** ***                  ***   ** **          **    **           ***  
                                                   ***                          **                *     *****   *** 
                                             ****   ***                         **               *    ********  **  
                                           *******  **                           **             *    *      ****    
                                          *     ****                                           *                    
                                                                                                                    
```


Calvin S.flf
```
╔═╗┌─┐┬ ┬  ┬┬┌┐┌  ╔═╗
║  ├─┤│ └┐┌┘││││  ╚═╗
╚═╝┴ ┴┴─┘└┘ ┴┘└┘  ╚═╝
```


Cards.flf
```
.------..------..------..------..------.
|C.--. ||A.--. ||R.--. ||D.--. ||S.--. |
| :/\: || (\/) || :(): || :/\: || :/\: |
| :\/: || :\/: || ()() || (__) || :\/: |
| '--'C|| '--'A|| '--'R|| '--'D|| '--'S|
`------'`------'`------'`------'`------'
```


Catwalk.flf
```
    _//               _//                         _//_//     
 _//   _//            _//                         _//_//     
_//          _//    _/_/ _/_//     _///   _//     _//_//  _//
_//        _//  _//   _//   _//  /  _// _//  _//  _//_// _// 
_//       _//   _//   _//   _// _/  _//_//   _//  _//_/_//   
 _//   _//_//   _//   _//   _/ _/ _/_//_//   _//  _//_// _// 
   _////    _// _///   _// _///    _///  _// _///_///_//  _//
                                                             
```


Chiseled.flf
```
   _,.----.  ,--.-,,-,--, .=-.-.  ,-,--.     ,----.                ,----.               
 .' .' -   \/==/  /|=|  |/==/_ /,-.'-  _\ ,-.--` , \   _.-.     ,-.--` , \  _,..---._   
/==/  ,  ,-'|==|_ ||=|, |==|, |/==/_ ,_.'|==|-  _.-` .-,.'|    |==|-  _.-`/==/,   -  \  
|==|-   |  .|==| ,|/=| _|==|  |\==\  \   |==|   `.-.|==|, |    |==|   `.-.|==|   _   _\ 
|==|_   `-' \==|- `-' _ |==|- | \==\ -\ /==/_ ,    /|==|- |   /==/_ ,    /|==|  .=.   | 
|==|   _  , |==|  _     |==| ,| _\==\ ,\|==|    .-' |==|, |   |==|    .-' |==|,|   | -| 
\==\.       /==|   .-. ,\==|- |/==/\/ _ |==|_  ,`-._|==|- `-._|==|_  ,`-._|==|  '='   / 
 `-.`.___.-'/==/, //=/  /==/. /\==\ - , /==/ ,     //==/ - , ,/==/ ,     /|==|-,   _`/  
            `--`-' `-`--`--`-`  `--`---'`--`-----`` `--`-----'`--`-----`` `-.`.____.'   
```


Chunky.flf
```
 ______ __                 __          
|      |  |--.--.--.-----.|  |--.--.--.
|   ---|     |  |  |     ||    <|  |  |
|______|__|__|_____|__|__||__|__|___  |
                                |_____|
```


Coinstak.flf
```
    O))                                  O))            O))     
 O))   O))           O)                  O))            O))     
O))          O))       O)) O))   O)))) O)O) O)   O))    O))  O))
O))        O))  O)) O)) O))  O))O))      O))   O))  O)) O)) O)) 
O))       O))    O))O)) O))  O))  O)))   O))  O))   O)) O)O))   
 O))   O)) O))  O)) O)) O))  O))    O))  O))  O))   O)) O)) O)) 
   O))))     O))    O))O)))  O))O)) O))   O))   O)) O)))O))  O))
                                                                
```


Cola.flf
```
  .-._   .-._.  .;       
.: (_)`-'      .;'       
::      .-.   .;  .-.    
::   _ ;   ;'::  ;   :   
`: .; )`;;'_;;_.-`:::'-' 
  `--'                   
```


Colossal.flf
```
 .d8888b.         888                                888 
d88P  Y88b        888                                888 
888    888        888                                888 
888        .d88b. 888 .d88b. .d8888b .d8888b  8888b. 888 
888       d88""88b888d88""88b88K     88K         "88b888 
888    888888  888888888  888"Y8888b."Y8888b..d888888888 
Y88b  d88PY88..88P888Y88..88P     X88     X88888  888888 
 "Y8888P"  "Y88P" 888 "Y88P"  88888P' 88888P'"Y888888888 
                                                         
                                                         
                                                         
```


Computer.flf
```
8""""8                                             
8    " eeeee eeeeeee eeeee e   e eeeee eeee eeeee  
8e     8  88 8  8  8 8   8 8   8   8   8    8   8  
88     8   8 8e 8  8 8eee8 8e  8   8e  8eee 8eee8e 
88   e 8   8 88 8  8 88    88  8   88  88   88   8 
88eee8 8eee8 88 8  8 88    88ee8   88  88ee 88   8 
                                                   
```


Contessa.flf
```
 __        ,             
/  ` _ ._ -+- _  __ __ _.
\__.(_)[ ) | (/,_) _) (_]
                         
```


Contrast.flf
```
..%%%%....%%%%...%%..%%..%%%%%%..%%%%%....%%%%....%%%%...%%%%%%.
.%%..%%..%%..%%..%%%.%%....%%....%%..%%..%%..%%..%%........%%...
.%%......%%..%%..%%.%%%....%%....%%%%%...%%%%%%...%%%%.....%%...
.%%..%%..%%..%%..%%..%%....%%....%%..%%..%%..%%......%%....%%...
..%%%%....%%%%...%%..%%....%%....%%..%%..%%..%%...%%%%.....%%...
................................................................
```


cosmic.flf
```
  .,-:::::     ...      .::::::. .        :   :::  .,-:::::  
,;;;'````'  .;;;;;;;.  ;;;`    ` ;;,.    ;;;  ;;;,;;;'````'  
[[[        ,[[     \[[,'[==/[[[[,[[[[, ,[[[[, [[[[[[         
$$$        $$$,     $$$  '''    $$$$$$$$$"$$$ $$$$$$         
`88bo,__,o,"888,_ _,88P 88b    dP888 Y88" 888o888`88bo,__,o, 
  "YUMMMMMP" "YMMMMMP"   "YMmMY" MMM  M'  "MMMMMM  "YUMMMMMP"
```


Cosmike.flf
```
  .,-:::::     ...      .::::::. .        :   ::: :::  .   .,::::::  
,;;;'````'  .;;;;;;;.  ;;;`    ` ;;,.    ;;;  ;;; ;;; .;;,.;;;;''''  
[[[        ,[[     \[[,'[==/[[[[,[[[[, ,[[[[, [[[ [[[[[/'   [[cccc   
$$$        $$$,     $$$  '''    $$$$$$$$$"$$$ $$$_$$$$,     $$""""   
`88bo,__,o,"888,_ _,88P 88b    dP888 Y88" 888o888"888"88o,  888oo,__ 
  "YUMMMMMP" "YMMMMMP"   "YMmMY" MMM  M'  "MMMMMM MMM "MMP" """"YUMMM
```


Crawford2.flf
```
    __  ____    ____  __    __  _____   ___   ____   ___   
   /  ]|    \  /    ||  |__|  ||     | /   \ |    \ |   \  
  /  / |  D  )|  o  ||  |  |  ||   __||     ||  D  )|    \ 
 /  /  |    / |     ||  |  |  ||  |_  |  O  ||    / |  D  |
/   \_ |    \ |  _  ||  `  '  ||   _] |     ||    \ |     |
\     ||  .  \|  |  | \      / |  |   |     ||  .  \|     |
 \____||__|\_||__|__|  \_/\_/  |__|    \___/ |__|\_||_____|
                                                           
```


Crawford.flf
```
    __  ____    ____  __    __  _____   ___   ____   ___   
   /  ]|    \  /    T|  T__T  T|     | /   \ |    \ |   \  
  /  / |  D  )Y  o  ||  |  |  ||   __jY     Y|  D  )|    \ 
 /  /  |    / |     ||  |  |  ||  l_  |  O  ||    / |  D  Y
/   \_ |    \ |  _  |l  `  '  !|   _] |     ||    \ |     |
\     ||  .  Y|  |  | \      / |  T   l     !|  .  Y|     |
 \____jl__j\_jl__j__j  \_/\_/  l__j    \___/ l__j\_jl_____j
                                                           
```


Crazy.flf
```
       _..._                                               
    .-'_..._''.                                            
  .' .'      '.\                                           
 / .'                                      .-.          .- 
. '             .-,.--.                     \ \        / / 
| |             |  .-. |    __               \ \      / /  
| |             | |  | | .:--.'.  .--------.  \ \    / /   
. '             | |  | |/ |   \ | |____    |   \ \  / /    
 \ '.          .| |  '- `" __ | |     /   /     \ `  /     
  '. `._____.-'/| |      .'.''| |   .'   /       \  /      
    `-.______ / | |     / /   | |_ /    /___     / /       
             `  |_|     \ \._,\ '/|         ||`-' /        
                         `--'  `" |_________| '..'         
```


Cricket.flf
```
 _______      __      __          __   
|   _   .----|__.----|  |--.-----|  |_ 
|.  1___|   _|  |  __|    <|  -__|   _|
|.  |___|__| |__|____|__|__|_____|____|
|:  1   |                              
|::.. . |                              
`-------'                              
                                       
```


Cursive.flf
```
   __                  
  /  )                 
 /   . . __  _   o, __ 
(__/(_/_/ (_/_)_<_\/</_
                       
                       
```


Cyberlarge.flf
```
 _______ __   __ ______  _______  ______        _______  ______  ______ _______
 |         \_/   |_____] |______ |_____/ |      |_____| |_____/ |  ____ |______
 |_____     |    |_____] |______ |    \_ |_____ |     | |    \_ |_____| |______
                                                                               
```


Cybermedium.flf
```
____ _   _ ___  ____ ____ _  _ ____ ___  _ _  _ _  _ 
|     \_/  |__] |___ |__/ |\/| |___ |  \ | |  | |\/| 
|___   |   |__] |___ |  \ |  | |___ |__/ | |__| |  | 
                                                     
```


Cybersmall.flf
```
 ____ _ _ ___  ____ ____ ____ _  _ ____ _    _   
 |___  Y  |==] |=== |--< ==== |\/| |--| |___ |___
```


Cygnet.flf
```
                  
 .-             . 
(  . ..-..-..-,-|-
 `-'-|`-|' '`'- '-
   `-'`-'         
```


DANC4.flf
```
'\   /`  \O/#   O/# \O    O  
  \ /     Y_   <|    |#   |\ 
   Y     /  |  / \  / \  / \ 
   O\# ./   |__| |__\ /__\ /_
```


Dancing Font.flf
```
  ____       _      _   _      ____              _   _     ____        _____   U  ___ u  _   _     _____   
 |  _"\  U  /"\  u | \ |"|  U /"___|    ___     | \ |"| U /"___|u     |" ___|   \/"_ \/ | \ |"|   |_ " _|  
/| | | |  \/ _ \/ <|  \| |> \| | u     |_"_|   <|  \| |>\| |  _ /    U| |_  u   | | | |<|  \| |>    | |    
U| |_| |\ / ___ \ U| |\  |u  | |/__     | |    U| |\  |u | |_| |     \|  _|/.-,_| |_| |U| |\  |u   /| |\   
 |____/ u/_/   \_\ |_| \_|    \____|  U/| |\u   |_| \_|   \____|      |_|    \_)-\___/  |_| \_|   u |_|U   
  |||_    \\    >> ||   \\,-._// \\.-,_|___|_,-.||   \\,-._)(|_       )(\\,-      \\    ||   \\,-._// \\_  
 (__)_)  (__)  (__)(_")  (_/(__)(__)\_)-' '-(_/ (_")  (_/(__)__)     (__)(_/     (__)   (_")  (_/(__) (__) 
```


dancingfont.flf
```
  ____       _      _   _      ____              _   _     ____    _____   U  ___ u  _   _     _____   
 |  _"\  U  /"\  u | \ |"|  U /"___|    ___     | \ |"| U /"___|u |" ___|   \/"_ \/ | \ |"|   |_ " _|  
/| | | |  \/ _ \/ <|  \| |> \| | u     |_"_|   <|  \| |>\| |  _ /U| |_  u   | | | |<|  \| |>    | |    
U| |_| |\ / ___ \ U| |\  |u  | |/__     | |    U| |\  |u | |_| | \|  _|/.-,_| |_| |U| |\  |u   /| |\   
 |____/ u/_/   \_\ |_| \_|    \____|  U/| |\u   |_| \_|   \____|  |_|    \_)-\___/  |_| \_|   u |_|U   
  |||_    \\    >> ||   \\,-._// \\.-,_|___|_,-.||   \\,-._)(|_   )(\\,-      \\    ||   \\,-._// \\_  
 (__)_)  (__)  (__)(_")  (_/(__)(__)\_)-' '-(_/ (_")  (_/(__)__) (__)(_/     (__)   (_")  (_/(__) (__) 
```


Decimal.flf
```
68 101 99 105 109 97 108 
```


Def Leppard.flf
```
 ;                        ,                                                                              ;           
 ED.                      Et                                                                             ED.         
 E#Wi                 ,;  E#t                                ,;                                          E#Wi        
 E###G.             f#i   E##t                      i      f#i t         t                    j.         E###G.      
 E#fD#W;          .E#t    E#W#t                    LE    .E#t  ED.       ED.               .. EW,        E#fD#W;     
 E#t t##L        i#W,     E#tfL.                  L#E   i#W,   E#K:      E#K:             ;W, E##j       E#t t##L    
 E#t  .E#K,     L#D.      E#t                    G#W.  L#D.    E##W;     E##W;           j##, E###D.     E#t  .E#K,  
 E#t    j##f  :K#Wfff; ,ffW#Dffj.               D#K. :K#Wfff;  E#E##t    E#E##t         G###, E#jG#W;    E#t    j##f 
 E#t    :E#K: i##WLLLLt ;LW#ELLLf.             E#K.  i##WLLLLt E#ti##f   E#ti##f      :E####, E#t t##f   E#t    :E#K:
 E#t   t##L    .E#L       E#t                .E#E.    .E#L     E#t ;##D. E#t ;##D.   ;W#DG##, E#t  :K#E: E#t   t##L  
 E#t .D#W;       f#E:     E#t               .K#E        f#E:   E#ELLE##K:E#ELLE##K: j###DW##, E#KDDDD###iE#t .D#W;   
 E#tiW#G.         ,WW;    E#t              .K#D          ,WW;  E#L;;;;;;,E#L;;;;;;,G##i,,G##, E#f,t#Wi,,,E#tiW#G.    
 E#K##i            .D#;   E#t             .W#G            .D#; E#t       E#t     :K#K:   L##, E#t  ;#W:  E#K##i      
 E##D.               tt   E#t            :W##########Wt     tt E#t       E#t    ;##D.    L##, DWi   ,KK: E##D.       
 E#t                      ;#t            :,,,,,,,,,,,,,.                        ,,,      .,,             E#t         
 L:                        :;                                                                            L:          
```


defleppard.flf
```
 ;                        ,                                                                   ;           
 ED.                      Et                                                                  ED.         
 E#Wi                 ,;  E#t                     ,;                                          E#Wi        
 E###G.             f#i   E##t           i      f#i t         t                    j.         E###G.      
 E#fD#W;          .E#t    E#W#t         LE    .E#t  ED.       ED.               .. EW,        E#fD#W;     
 E#t t##L        i#W,     E#tfL.       L#E   i#W,   E#K:      E#K:             ;W, E##j       E#t t##L    
 E#t  .E#K,     L#D.      E#t         G#W.  L#D.    E##W;     E##W;           j##, E###D.     E#t  .E#K,  
 E#t    j##f  :K#Wfff; ,ffW#Dffj.    D#K. :K#Wfff;  E#E##t    E#E##t         G###, E#jG#W;    E#t    j##f 
 E#t    :E#K: i##WLLLLt ;LW#ELLLf.  E#K.  i##WLLLLt E#ti##f   E#ti##f      :E####, E#t t##f   E#t    :E#K:
 E#t   t##L    .E#L       E#t     .E#E.    .E#L     E#t ;##D. E#t ;##D.   ;W#DG##, E#t  :K#E: E#t   t##L  
 E#t .D#W;       f#E:     E#t    .K#E        f#E:   E#ELLE##K:E#ELLE##K: j###DW##, E#KDDDD###iE#t .D#W;   
 E#tiW#G.         ,WW;    E#t   .K#D          ,WW;  E#L;;;;;;,E#L;;;;;;,G##i,,G##, E#f,t#Wi,,,E#tiW#G.    
 E#K##i            .D#;   E#t  .W#G            .D#; E#t       E#t     :K#K:   L##, E#t  ;#W:  E#K##i      
 E##D.               tt   E#t :W##########Wt     tt E#t       E#t    ;##D.    L##, DWi   ,KK: E##D.       
 E#t                      ;#t :,,,,,,,,,,,,,.                        ,,,      .,,             E#t         
 L:                        :;                                                                 L:          
```


Delta Corps Priest 1.flf
```
████████▄     ▄████████  ▄█           ███        ▄████████       ▄████████  ▄██████▄     ▄████████    ▄███████▄    ▄████████ 
███   ▀███   ███    ███ ███       ▀█████████▄   ███    ███      ███    ███ ███    ███   ███    ███   ███    ███   ███    ███ 
███    ███   ███    █▀  ███          ▀███▀▀██   ███    ███      ███    █▀  ███    ███   ███    ███   ███    ███   ███    █▀  
███    ███  ▄███▄▄▄     ███           ███   ▀   ███    ███      ███        ███    ███  ▄███▄▄▄▄██▀   ███    ███   ███        
███    ███ ▀▀███▀▀▀     ███           ███     ▀███████████      ███        ███    ███ ▀▀███▀▀▀▀▀   ▀█████████▀  ▀███████████ 
███    ███   ███    █▄  ███           ███       ███    ███      ███    █▄  ███    ███ ▀███████████   ███                 ███ 
███   ▄███   ███    ███ ███▌    ▄     ███       ███    ███      ███    ███ ███    ███   ███    ███   ███           ▄█    ███ 
████████▀    ██████████ █████▄▄██    ▄████▀     ███    █▀       ████████▀   ▀██████▀    ███    ███  ▄████▀       ▄████████▀  
                        ▀                                                               ███    ███                           
   ▄███████▄    ▄████████  ▄█     ▄████████    ▄████████     ███          
  ███    ███   ███    ███ ███    ███    ███   ███    ███ ▀█████████▄      
  ███    ███   ███    ███ ███▌   ███    █▀    ███    █▀     ▀███▀▀██      
  ███    ███  ▄███▄▄▄▄██▀ ███▌  ▄███▄▄▄       ███            ███   ▀      
▀█████████▀  ▀▀███▀▀▀▀▀   ███▌ ▀▀███▀▀▀     ▀███████████     ███          
  ███        ▀███████████ ███    ███    █▄           ███     ███          
  ███          ███    ███ ███    ███    ███    ▄█    ███     ███          
 ▄████▀        ███    ███ █▀     ██████████  ▄████████▀     ▄████▀        
               ███    ███                                                 
```


Diamond.flf
```
/\\\\\                                                      /\\
/\\   /\\  /\                                               /\\
/\\    /\\      /\\    /\\\ /\\ /\\    /\\    /\\ /\\       /\\
/\\    /\\/\\ /\\  /\\  /\\  /\  /\\ /\\  /\\  /\\  /\\ /\\ /\\
/\\    /\\/\\/\\   /\\  /\\  /\  /\\/\\    /\\ /\\  /\\/\   /\\
/\\   /\\ /\\/\\   /\\  /\\  /\  /\\ /\\  /\\  /\\  /\\/\   /\\
/\\\\\    /\\  /\\ /\\\/\\\  /\  /\\   /\\    /\\\  /\\ /\\ /\\
                                                               
```


Diet Cola.flf
```
   .-.                           .-._   .-._.  .     
  (_) )-.       .-.        /   ..' (_)`-'      /      
     /   \      `-' .-.---/--- |       .-._. / .-.   
    /     \    /  ./.-'_ /     |    _ (   ) / (  |   
 .-/.      )_.(__.(__.' /      `.    ) `-'_/_.-`-'-' 
(_/  `----'                      `--'                
```


dietcola.flf
```
       .                              .     
      /    .-.        /              /      
 .-../     `-' .-.---/---.-.  .-._. / .-.   
(   /     /  ./.-'_ /   (    (   ) / (  |   
 `-'-.._.(__.(__.' /     `---'`-'_/_.-`-'-' 
                                            
```


Digital.flf
```
+-+-+-+-+-+-+-+
|D|i|g|i|t|a|l|
+-+-+-+-+-+-+-+
```


Doh.flf
```
                                                         
                                                         
DDDDDDDDDDDDD                        hhhhhhh             
D::::::::::::DDD                     h:::::h             
D:::::::::::::::DD                   h:::::h             
DDD:::::DDDDD:::::D                  h:::::h             
  D:::::D    D:::::D    ooooooooooo   h::::h hhhhh       
  D:::::D     D:::::D oo:::::::::::oo h::::hh:::::hhh    
  D:::::D     D:::::Do:::::::::::::::oh::::::::::::::hh  
  D:::::D     D:::::Do:::::ooooo:::::oh:::::::hhh::::::h 
  D:::::D     D:::::Do::::o     o::::oh::::::h   h::::::h
  D:::::D     D:::::Do::::o     o::::oh:::::h     h:::::h
  D:::::D     D:::::Do::::o     o::::oh:::::h     h:::::h
  D:::::D    D:::::D o::::o     o::::oh:::::h     h:::::h
DDD:::::DDDDD:::::D  o:::::ooooo:::::oh:::::h     h:::::h
D:::::::::::::::DD   o:::::::::::::::oh:::::h     h:::::h
D::::::::::::DDD      oo:::::::::::oo h:::::h     h:::::h
DDDDDDDDDDDDD           ooooooooooo   hhhhhhh     hhhhhhh
                                                         
                                                         
                                                         
                                                         
                                                         
                                                         
                                                         
```


Doom.flf
```
______                      
|  _  \                     
| | | |___   ___  _ __ ___  
| | | / _ \ / _ \| '_ ` _ \ 
| |/ / (_) | (_) | | | | | |
|___/ \___/ \___/|_| |_| |_|
                            
                            
```


DOS Rebel.flf
```
 ██████████      ███████     █████████     ███████████            █████              ████ 
░░███░░░░███   ███░░░░░███  ███░░░░░███   ░░███░░░░░███          ░░███              ░░███ 
 ░███   ░░███ ███     ░░███░███    ░░░     ░███    ░███   ██████  ░███████   ██████  ░███ 
 ░███    ░███░███      ░███░░█████████     ░██████████   ███░░███ ░███░░███ ███░░███ ░███ 
 ░███    ░███░███      ░███ ░░░░░░░░███    ░███░░░░░███ ░███████  ░███ ░███░███████  ░███ 
 ░███    ███ ░░███     ███  ███    ░███    ░███    ░███ ░███░░░   ░███ ░███░███░░░   ░███ 
 ██████████   ░░░███████░  ░░█████████     █████   █████░░██████  ████████ ░░██████  █████
░░░░░░░░░░      ░░░░░░░     ░░░░░░░░░     ░░░░░   ░░░░░  ░░░░░░  ░░░░░░░░   ░░░░░░  ░░░░░ 
                                                                                          
                                                                                          
                                                                                          
```


dosrebel.flf
```
                                             
                                             






                                                                       
                                                                       
                                                                       
```


Dot Matrix.flf
```
 _  _  _  _                      _                  _           _                  _                         _                     
(_)(_)(_)(_)                    (_)                (_) _     _ (_)                (_)                       (_)                    
 (_)      (_)_     _  _  _    _ (_) _  _           (_)(_)   (_)(_)   _  _  _    _ (_) _  _  _       _  _  _  _     _         _     
 (_)        (_) _ (_)(_)(_) _(_)(_)(_)(_)          (_) (_)_(_) (_)  (_)(_)(_) _(_)(_)(_)(_)(_)_  _ (_)(_)(_)(_)   (_) _   _ (_)    
 (_)        (_)(_)         (_)  (_)                (_)   (_)   (_)   _  _  _ (_)  (_)        (_)(_)         (_)      (_)_(_)       
 (_)       _(_)(_)         (_)  (_)     _          (_)         (_) _(_)(_)(_)(_)  (_)     _  (_)            (_)       _(_)_        
 (_)_  _  (_)  (_) _  _  _ (_)  (_)_  _(_)         (_)         (_)(_)_  _  _ (_)_ (_)_  _(_) (_)          _ (_) _  _ (_) (_) _     
(_)(_)(_)(_)      (_)(_)(_)       (_)(_)           (_)         (_)  (_)(_)(_)  (_)  (_)(_)   (_)         (_)(_)(_)(_)       (_)    
                                                                                                                                   
                                                                                                                                   
```


dotmatrix.flf
```
            _                   _                                        _                         _                     
           (_)                 (_)                                      (_)                       (_)                    
   _  _  _ (_)    _  _  _    _ (_) _  _    _  _   _  _     _  _  _    _ (_) _  _  _       _  _  _  _     _         _     
 _(_)(_)(_)(_) _ (_)(_)(_) _(_)(_)(_)(_)  (_)(_)_(_)(_)   (_)(_)(_) _(_)(_)(_)(_)(_)_  _ (_)(_)(_)(_)   (_) _   _ (_)    
(_)        (_)(_)         (_)  (_)       (_)   (_)   (_)   _  _  _ (_)  (_)        (_)(_)         (_)      (_)_(_)       
(_)        (_)(_)         (_)  (_)     _ (_)   (_)   (_) _(_)(_)(_)(_)  (_)     _  (_)            (_)       _(_)_        
(_)_  _  _ (_)(_) _  _  _ (_)  (_)_  _(_)(_)   (_)   (_)(_)_  _  _ (_)_ (_)_  _(_) (_)          _ (_) _  _ (_) (_) _     
  (_)(_)(_)(_)   (_)(_)(_)       (_)(_)  (_)   (_)   (_)  (_)(_)(_)  (_)  (_)(_)   (_)         (_)(_)(_)(_)       (_)    
                                                                                                                         
                                                                                                                         
```


Double.flf
```
____   ___ __ ________    ____
|| \\ // \\|| |||| ))|   ||   
||  )|(   ))| ||||=)||   ||== 
||_// \\_//\\_//||_))|__|||___
                              
```


Double Shorts.flf
```
_____  _____  __ __ ____  __    _____      __ __  __  _____  _____ _____   __ 
||  ) ((   )) || || ||=)  ||    ||==      ((  ||==|| ((   )) ||_//  ||    ((  
||_//  \\_//  \\_// ||_)) ||__| ||___    \_)) ||  ||  \\_//  || \\  ||   \_)) 
```


doubleshorts.flf
```
_____  _____  __ __ ____  __    _____   __ __  __  _____  _____ _____   __ 
||  ) ((   )) || || ||=)  ||    ||==   ((  ||==|| ((   )) ||_//  ||    ((  
||_//  \\_//  \\_// ||_)) ||__| ||___ \_)) ||  ||  \\_//  || \\  ||   \_)) 
```


Dr Pepper.flf
```
 ___        ___                          
| . \ _ _  | . \ ___  ___  ___  ___  _ _ 
| | || '_> |  _// ._>| . \| . \/ ._>| '_>
|___/|_|   |_|  \___.|  _/|  _/\___.|_|  
                     |_|  |_|            
```


drpepper.flf
```
   _                                    
 _| | _ _  ___  ___  ___  ___  ___  _ _ 
/ . || '_>| . \/ ._>| . \| . \/ ._>| '_>
\___||_|  |  _/\___.|  _/|  _/\___.|_|  
          |_|       |_|  |_|            
```


DWhistled.flf
```
 Whistl  
x      XX
x      XX
x      XX
x      XX
x      XX
x      .X
         
DWhistled
         
```


Efti Chess.flf
```
#########                  
##[`'`']#           \`~'/  
###|::|##           (o o)  
###|::|##            \ / \ 
#########             "    
```


eftichess.flf
```
##################
##[`'`']###\`~'/##
###|::|####(o o)##
###|::|#####\ / \#
#############"####
```


Efti Font.flf
```
 ___  __       ___         
| __|/ _|||() | __|   _ || 
| _| | ] | ]| | _/o\|/ \| ]
|___|L|  L|L| |_|\_/L_n|L| 
                           
```


eftifont.flf
```
   __      __         
 _/ _|||()/ _|   _ || 
/o\ ] | ]|| ]o\|/ \| ]
\(L|  L|L|L|\_/L_n|L| 
                      
```


Efti Italic.flf
```
   ___   _        __               
  / _/ ,'_7/7 () / //7  _   /7() __
 / _/ /_7 /_7/7 / //_7,'o| ///7,','
/___///  // // /_///  |_,7//// \_\ 
                                   
```


Efti Piti.flf
```
 __      _    
[|-fti  ||)iti
 `-     L|    
```


eftipiti.flf
```
        
eftipiti
        
```


Efti Robot.flf
```
 ____   _  _   _    ___       _         _  
(  __),'_)( ) (_)  (   )     ( )       ( ) 
| |_  | | | |  _   | O  |___ | |_  ___ | | 
(  _) ( _)( _)( )  ( _ (( o )( o \( o )( _)
/____\/_\ /_\ /_\  /_\\_|\_/ /___/ \_/ /_\ 
                                           
```


eftirobot.flf
```
       _  _   _           _         _  
     ,'_)( ) (_)         ( )       ( ) 
 ___ | | | |  _  __  ___ | |_  ___ | | 
( o_)( _)( _)( )( _)( o )( o \( o )( _)
 \(  /_\ /_\ /_\/_\  \_/ /___/ \_/ /_\ 
                                       
```


eftitalic.flf
```
       _                     
  __ ,'_7/7 ()/7  _   /7() __
,'o//_7 /_7/7/_7,'o| ///7,','
|_(//  // ////  |_,7//// \_\ 
                             
```


Efti Wall.flf
```
                    _                        .      .                       |             _     _       _     _    
     +++          _|_|_         ()_()      .  .:::.             )|(         |.===.      o' \,=./ `o   o' \,=./ `o  
    (o o)         (o o)         (o o)        :(o o):  .        (o o)        {}o o{}        (o o)         (o o)     
ooO--(_)--Ooo-ooO--(_)--Ooo-ooO--`o'--Ooo-ooO--(_)--Ooo----ooO--(_)--Ooo-ooO--(_)--Ooo-ooO--(_)--Ooo-ooO--(_)--Ooo-
```


eftiwall.flf
```
     |"|            _                        .      .    #  #  #  #      |             _     _       _     _    
    _|_|_         _|_|_         ()_()      .  .:::.      #  #..#  #      |.===.      o' \,=./ `o   o' \,=./ `o  
    (o o)         (o o)         (o o)        :(o o):  .  #  #O #) #      {}o o{}        (o o)         (o o)     
ooO--(_)--Ooo-ooO--(_)--Ooo-ooO--`o'--Ooo-ooO--(_)--Ooo-o#O-#(_#--#oo-ooO--(_)--Ooo-ooO--(_)--Ooo-ooO--(_)--Ooo-
```


Efti Water.flf
```
 ___ __ _  o    _ _ _       _        
 )L  )L`)L _    ))`)`) ___  )L __ __ 
((_ (( (( ((   ((,(,' ((_( (( (('(|  
                                     
```


eftiwater.flf
```
    __ _  o             _        
 __ )L`)L _ __ _ _ ___  )L __ __ 
(('(( (( (( \(((/'((_( (( (('(|  
                                 
```


Electronic.flf
```
 ▄▄▄▄▄▄▄▄▄▄▄  ▄            ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄▄        ▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄ 
▐░░░░░░░░░░░▌▐░▌          ▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░▌      ▐░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌
▐░█▀▀▀▀▀▀▀▀▀ ▐░▌          ▐░█▀▀▀▀▀▀▀▀▀ ▐░█▀▀▀▀▀▀▀▀▀  ▀▀▀▀█░█▀▀▀▀ ▐░█▀▀▀▀▀▀▀█░▌▐░█▀▀▀▀▀▀▀█░▌▐░▌░▌     ▐░▌ ▀▀▀▀█░█▀▀▀▀ ▐░█▀▀▀▀▀▀▀▀▀ 
▐░▌          ▐░▌          ▐░▌          ▐░▌               ▐░▌     ▐░▌       ▐░▌▐░▌       ▐░▌▐░▌▐░▌    ▐░▌     ▐░▌     ▐░▌          
▐░█▄▄▄▄▄▄▄▄▄ ▐░▌          ▐░█▄▄▄▄▄▄▄▄▄ ▐░▌               ▐░▌     ▐░█▄▄▄▄▄▄▄█░▌▐░▌       ▐░▌▐░▌ ▐░▌   ▐░▌     ▐░▌     ▐░▌          
▐░░░░░░░░░░░▌▐░▌          ▐░░░░░░░░░░░▌▐░▌               ▐░▌     ▐░░░░░░░░░░░▌▐░▌       ▐░▌▐░▌  ▐░▌  ▐░▌     ▐░▌     ▐░▌          
▐░█▀▀▀▀▀▀▀▀▀ ▐░▌          ▐░█▀▀▀▀▀▀▀▀▀ ▐░▌               ▐░▌     ▐░█▀▀▀▀█░█▀▀ ▐░▌       ▐░▌▐░▌   ▐░▌ ▐░▌     ▐░▌     ▐░▌          
▐░▌          ▐░▌          ▐░▌          ▐░▌               ▐░▌     ▐░▌     ▐░▌  ▐░▌       ▐░▌▐░▌    ▐░▌▐░▌     ▐░▌     ▐░▌          
▐░█▄▄▄▄▄▄▄▄▄ ▐░█▄▄▄▄▄▄▄▄▄ ▐░█▄▄▄▄▄▄▄▄▄ ▐░█▄▄▄▄▄▄▄▄▄      ▐░▌     ▐░▌      ▐░▌ ▐░█▄▄▄▄▄▄▄█░▌▐░▌     ▐░▐░▌ ▄▄▄▄█░█▄▄▄▄ ▐░█▄▄▄▄▄▄▄▄▄ 
▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌     ▐░▌     ▐░▌       ▐░▌▐░░░░░░░░░░░▌▐░▌      ▐░░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌
 ▀▀▀▀▀▀▀▀▀▀▀  ▀▀▀▀▀▀▀▀▀▀▀  ▀▀▀▀▀▀▀▀▀▀▀  ▀▀▀▀▀▀▀▀▀▀▀       ▀       ▀         ▀  ▀▀▀▀▀▀▀▀▀▀▀  ▀        ▀▀  ▀▀▀▀▀▀▀▀▀▀▀  ▀▀▀▀▀▀▀▀▀▀▀ 
                                                                                                                                  
```


Elite.flf
```
▄▄▄ .▄▄▌  ▪  ▄▄▄▄▄▄▄▄ .
▀▄.▀·██•  ██ •██  ▀▄.▀·
▐▀▀▪▄██▪  ▐█· ▐█.▪▐▀▀▪▄
▐█▄▄▌▐█▌▐▌▐█▌ ▐█▌·▐█▄▄▌
 ▀▀▀ .▀▀▀ ▀▀▀ ▀▀▀  ▀▀▀ 
```


Epic.flf
```
 _______  _______ _________ _______ 
(  ____ \(  ____ )\__   __/(  ____ \
| (    \/| (    )|   ) (   | (    \/
| (__    | (____)|   | |   | |      
|  __)   |  _____)   | |   | |      
| (      | (         | |   | |      
| (____/\| )      ___) (___| (____/\
(_______/|/       \_______/(_______/
                                    
```


Fender.flf
```
'||''''|                     ||`               
 ||  .                       ||                
 ||''|   .|''|, `||''|,  .|''||  .|''|, '||''| 
 ||      ||..||  ||  ||  ||  ||  ||..||  ||    
.||.     `|...  .||  ||. `|..||. `|...  .||.   
                                               
                                               
```


Filter.flf
```
  o8boooo    8888 888      888888888   ,d8PPPP   ,dbPPPp 
  88booop    8888 888         '88d     d88ooo    d88ooP' 
  88b        8888 888        '888    ,88'      ,88' P'   
  88P        8888 888PPPPP '88p      88bdPPP   88  do    
                                                         
```


Fire Font-k.flf
```
 (                     (                                
 )\ )                  )\ )                )         )  
(()/(  (   (      (   (()/(             ( /(      ( /(  
 /(_)) )\  )(    ))\   /(_)) (    (     )\())___  )\()) 
(_))_|((_)(()\  /((_) (_))_| )\   )\ ) (_))/|___|((_)\  
| |_   (_) ((_)(_))   | |_  ((_) _(_/( | |_      | |(_) 
| __|  | || '_|/ -_)  | __|/ _ \| ' \))|  _|     | / /  
|_|    |_||_|  \___|  |_|  \___/|_||_|  \__|     |_\_\  
                                                        
```


fire_font-k.flf
```
                                                           
 (                       (                    )         )  
 )\ )  (   (      (      )\ )              ( /(      ( /(  
(()/(  )\  )(    ))\    (()/(   (    (     )\())___  )\()) 
 /(_))((_)(()\  /((_)    /(_))  )\   )\ ) (_))/|___|((_)\  
(_) _| (_) ((_)(_))     (_) _| ((_) _(_/( | |_      | |(_) 
 |  _| | || '_|/ -_)     |  _|/ _ \| ' \))|  _|     | / /  
 |_|   |_||_|  \___|_____|_|  \___/|_||_|  \__|     |_\_\  
                   |_____|                                 
```


Fire Font-s.flf
```
 (                  (                        
 )\ )               )\ )             )       
(()/( (  (     (   (()/(          ( /(       
 /(_)))\ )(   ))\   /(_))(   (    )\())__(   
(_))_((_|()\ /((_) (_))_|)\  )\ )(_))/___)\  
| |_  (_)((_|_))   | |_ ((_)_(_/(| |_   ((_) 
| __| | | '_/ -_)  | __/ _ \ ' \))  _|  (_-< 
|_|   |_|_| \___|  |_| \___/_||_| \__|  /__/ 
                                             
```


fire_font-s.flf
```
                                              
 (                  (                 )       
 )\ ) (  (     (    )\ )           ( /(       
(()/( )\ )(   ))\  (()/(  (   (    )\())__(   
 /(_)|(_|()\ /((_)  /(_)) )\  )\ )(_))/___)\  
(_) _|(_)((_|_))   (_) _|((_)_(_/(| |_   ((_) 
 |  _|| | '_/ -_)   |  _/ _ \ ' \))  _|  (_-< 
 |_|  |_|_| \___|___|_| \___/_||_| \__|  /__/ 
               |_____|                        
```


Flipped.flf
```
 ____              ____  ____  ____  ____ 
|_   | ____  ____ |_   ||_   ||    || __ |
  || ||  __||____|  || |  || |||_| || |/ |
   |_||_|           \__/  \__/|_||_|\___/ 
```


Flower Power.flf
```
 ________   .---.       ,-----.    .--.      .--.    .-''-.  .-------.            .-------.     ,-----.    .--.      .--.    .-''-.  .-------.     
|        |  | ,_|     .'  .-,  '.  |  |_     |  |  .'_ _   \ |  _ _   \           \  _(`)_ \  .'  .-,  '.  |  |_     |  |  .'_ _   \ |  _ _   \    
|   .----',-./  )    / ,-.|  \ _ \ | _( )_   |  | / ( ` )   '| ( ' )  |           | (_ o._)| / ,-.|  \ _ \ | _( )_   |  | / ( ` )   '| ( ' )  |    
|  _|____ \  '_ '`) ;  \  '_ /  | :|(_ o _)  |  |. (_ o _)  ||(_ o _) /           |  (_,_) /;  \  '_ /  | :|(_ o _)  |  |. (_ o _)  ||(_ o _) /    
|_( )_   | > (_)  ) |  _`,/ \ _/  || (_,_) \ |  ||  (_,_)___|| (_,_).' __         |   '-.-' |  _`,/ \ _/  || (_,_) \ |  ||  (_,_)___|| (_,_).' __  
(_ o._)__|(  .  .-' : (  '\_/ \   ;|  |/    \|  |'  \   .---.|  |\ \  |  |        |   |     : (  '\_/ \   ;|  |/    \|  |'  \   .---.|  |\ \  |  | 
|(_,_)     `-'`-'|___\ `"/  \  ) / |  '  /\  `  | \  `-'    /|  | \ `'   /        |   |      \ `"/  \  ) / |  '  /\  `  | \  `-'    /|  | \ `'   / 
|   |       |        \'. \_/``".'  |    /  \    |  \       / |  |  \    /         /   )       '. \_/``".'  |    /  \    |  \       / |  |  \    /  
'---'       `--------`  '-----'    `---'    `---`   `'-..-'  ''-'   `'-'          `---'         '-----'    `---'    `---`   `'-..-'  ''-'   `'-'   
                                                                                                                                                   
```


flowerpower.flf
```
 ________   .---.       ,-----.    .--.      .--.    .-''-.  .-------.    .-------.     ,-----.    .--.      .--.    .-''-.  .-------.     
|        |  | ,_|     .'  .-,  '.  |  |_     |  |  .'_ _   \ |  _ _   \   \  _(`)_ \  .'  .-,  '.  |  |_     |  |  .'_ _   \ |  _ _   \    
|   .----',-./  )    / ,-.|  \ _ \ | _( )_   |  | / ( ` )   '| ( ' )  |   | (_ o._)| / ,-.|  \ _ \ | _( )_   |  | / ( ` )   '| ( ' )  |    
|  _|____ \  '_ '`) ;  \  '_ /  | :|(_ o _)  |  |. (_ o _)  ||(_ o _) /   |  (_,_) /;  \  '_ /  | :|(_ o _)  |  |. (_ o _)  ||(_ o _) /    
|_( )_   | > (_)  ) |  _`,/ \ _/  || (_,_) \ |  ||  (_,_)___|| (_,_).' __ |   '-.-' |  _`,/ \ _/  || (_,_) \ |  ||  (_,_)___|| (_,_).' __  
(_ o._)__|(  .  .-' : (  '\_/ \   ;|  |/    \|  |'  \   .---.|  |\ \  |  ||   |     : (  '\_/ \   ;|  |/    \|  |'  \   .---.|  |\ \  |  | 
|(_,_)     `-'`-'|___\ `"/  \  ) / |  '  /\  `  | \  `-'    /|  | \ `'   /|   |      \ `"/  \  ) / |  '  /\  `  | \  `-'    /|  | \ `'   / 
|   |       |        \'. \_/``".'  |    /  \    |  \       / |  |  \    / /   )       '. \_/``".'  |    /  \    |  \       / |  |  \    /  
'---'       `--------`  '-----'    `---'    `---`   `'-..-'  ''-'   `'-'  `---'         '-----'    `---'    `---`   `'-..-'  ''-'   `'-'   
                                                                                                                                           
```


Four Tops.flf
```
|~~              ~~|~~       
|--/~\|   ||/~\    |/~\|~~\(~
|  \_/ \_/||       |\_/|__/_)
                       |     
```


fourtops.flf
```
 /~\            |          
-|-/~\|   ||/~\~|~/~\|~~\(~
 | \_/ \_/||    | \_/|__/_)
                     |     
```


Fraktur.flf
```
    .....                                         ..           s                                
 .H8888888x.  '`+                           < .z@8"`          :8                                
:888888888888x.  !    .u    .                !@88E           .88       x.    .        .u    .   
8~    `"*88888888"  .d88B :@8c        u      '888E   u      :888ooo  .@88k  z88u    .d88B :@8c  
!      .  `f""""   ="8888f8888r    us888u.    888E u@8NL  -*8888888 ~"8888 ^8888   ="8888f8888r 
 ~:...-` :8L <)88:   4888>'88"  .@88 "8888"   888E`"88*"    8888      8888  888R     4888>'88"  
    .   :888:>X88!   4888> '    9888  9888    888E .dN.     8888      8888  888R     4888> '    
 :~"88x 48888X ^`    4888>      9888  9888    888E~8888     8888      8888  888R     4888>      
<  :888k'88888X     .d888L .+   9888  9888    888E '888&   .8888Lu=   8888 ,888B .  .d888L .+   
  d8888f '88888X    ^"8888*"    9888  9888    888E  9888.  ^%888*    "8888Y 8888"   ^"8888*"    
 :8888!    ?8888>      "Y"      "888*""888" '"888*" 4888"    'Y"      `Y"   'YP        "Y"      
 X888!      8888~                ^Y"   ^Y'     ""    ""                                         
 '888       X88f                                                                                
  '%8:     .8*"                                                                                 
     ^----~"`                                                                                   
```


Fun Face.flf
```
        wWw  wWw\\\  ///                   c  c        
  wWw   (O)  (O)((O)(O))      wWw   /)     (OO)  wWw   
  (O)_  / )  ( \ | \ ||       (O)_(o)(O) ,'.--.) (O)_  
 .' __)/ /    \ \||\\||      .' __)//\\ / //_|_\.' __) 
(  _)  | \____/ ||| \ |     (  _) |(__)|| \___ (  _)   
 )/    '. `--' .`||  ||      )/   /,-. |'.    ) `.__)  
(        `-..-' (_/  \_)    (    -'   ''  `-.'         
```


funface.flf
```
        wWw  wWw\\\  ///               c  c        
  wWw   (O)  (O)((O)(O))  wWw   /)     (OO)  wWw   
  (O)_  / )  ( \ | \ ||   (O)_(o)(O) ,'.--.) (O)_  
 .' __)/ /    \ \||\\||  .' __)//\\ / //_|_\.' __) 
(  _)  | \____/ ||| \ | (  _) |(__)|| \___ (  _)   
 )/    '. `--' .`||  ||  )/   /,-. |'.    ) `.__)  
(        `-..-' (_/  \_)(    -'   ''  `-.'         
```


Fun Faces.flf
```
  wWw  wWw  wWw\\\  ///      wWw           c  c  wWw   oo_    
  (O)_ (O)  (O)((O)(O))      (O)_   /)     (OO)  (O)_ /  _)-< 
  / __)/ )  ( \ | \ ||       / __)(o)(O) ,'.--.) / __)\__ `.  
 / (  / /    \ \||\\||      / (    //\\ / //_|_\/ (      `. | 
(  _) | \____/ ||| \ |     (  _)  |(__)|| \___ (  _)     _| | 
/ /   '. `--' .`||  ||     / /    /,-. |'.    ) \ \_  ,-'   | 
)/      `-..-' (_/  \_)    )/    -'   ''  `-.'   \__)(_..--'  
```


funfaces.flf
```
  wWw  wWw  wWw\\\  ///  wWw           c  c  wWw   oo_    
  (O)_ (O)  (O)((O)(O))  (O)_   /)     (OO)  (O)_ /  _)-< 
  / __)/ )  ( \ | \ ||   / __)(o)(O) ,'.--.) / __)\__ `.  
 / (  / /    \ \||\\||  / (    //\\ / //_|_\/ (      `. | 
(  _) | \____/ ||| \ | (  _)  |(__)|| \___ (  _)     _| | 
/ /   '. `--' .`||  || / /    /,-. |'.    ) \ \_  ,-'   | 
)/      `-..-' (_/  \_))/    -'   ''  `-.'   \__)(_..--'  
```


Fuzzy.flf
```
.---.                       
: .--'                      
: `;.-..-..---. .---. .-..-.
: : : :; :`-'_.'`-'_.': :; :
:_; `.__.'`.___;`.___;`._. ;
                       .-. :
                       `._.'
```


Georgi16.flf
```
                                                                
                                                                
   ____                                                   ,6P   
  6MMMMb/                                     68b       6MM'    
 8P    YM                                     Y89      6M'      
6M      Y   ____     _____   ___  __   __     ___ __/ 6M ____   
MM         6MMMMb   6MMMMMb  `MM 6MM  6MMbMMM `MM `MM MMMMMMMb  
MM        6M'  `Mb 6M'   `Mb  MM69 " 6M'`Mb    MM  MM MM'   `Mb 
MM     ___MM    MM MM     MM  MM'    MM  MM    MM  MM MM     MM 
MM     `M'MMMMMMMM MM     MM  MM     YM.,M9    MM  MM MM     MM 
YM      M MM       MM     MM  MM      YMM9     MM  MM MM     MM 
 8b    d9 YM    d9 YM.   ,M9  MM     (M        MM  MM YM.   ,M9 
  YMMMM9   YMMMM9   YMMMMM9  _MM_     YMMMMb. _MM__MM_ YMMMMM9  
                                     6M    Yb                   
                                     YM.   d9                   
                                      YMMMM9                    
```


Georgia11.flf
```
                                                                           
                                                  ,,                       
  .g8"""bgd                                       db                       
.dP'     `M                                                     __,   __,  
dM'       `   .gP"Ya   ,pW"Wq.`7Mb,od8 .P"Ybmmm `7MM   ,6"Yb.  `7MM  `7MM  
MM           ,M'   Yb 6W'   `Wb MM' "':MI  I8     MM  8)   MM    MM    MM  
MM.    `7MMF'8M"""""" 8M     M8 MM     WmmmP"     MM   ,pm9MM    MM    MM  
`Mb.     MM  YM.    , YA.   ,A9 MM    8M          MM  8M   MM    MM    MM  
  `"bmmmdPY   `Mbmmd'  `Ybmd9'.JMML.   YMMMMMb  .JMML.`Moo9^Yo..JMML..JMML.
                                      6'     dP                            
                                      Ybmmmd'                              
```


Ghost.flf
```
             ('-. .-.               .-')    .-') _    
            ( OO )  /              ( OO ). (  OO) )   
  ,----.    ,--. ,--. .-'),-----. (_)---\_)/     '._  
 '  .-./-') |  | |  |( OO'  .-.  '/    _ | |'--...__) 
 |  |_( O- )|   .|  |/   |  | |  |\  :` `. '--.  .--' 
 |  | .--, \|       |\_) |  |\|  | '..`''.)   |  |    
(|  | '. (_/|  .-.  |  \ |  | |  |.-._)   \   |  |    
 |  '--'  | |  | |  |   `'  '-'  '\       /   |  |    
  `------'  `--' `--'     `-----'  `-----'    `--'    
```


Ghoulish.flf
```
   )\.-.        .'(     .-./(       .-.   .')      .'(    )\.--.       .'(  
 ,' ,-,_)   ,') \  )  ,'     )  ,'  /  ) ( /       \  )  (   ._.'  ,') \  ) 
(  .   __  (  '-' (  (  .-, (  (  ) | (   ))       ) (    `-.`.   (  '-' (  
 ) '._\ _)  ) .-.  )  ) '._\ )  ) '._\ )  )'._.-.  \  )  ,_ (  \   ) .-.  ) 
(  ,   (   (  ,  ) \ (  ,   (  (  ,   (  (       )  ) \ (  '.)  ) (  ,  ) \ 
 )/'._.'    )/    )/  )/ ._.'   )/ ._.'   )/,__.'    )/  '._,_.'   )/    )/ 
                                                                            
```


Glenyn.flf
```
____ __   ____ __   _    __   
|  _\| |  | __\| \|\||_/\| \|\
| [ \| |__|  ]_|  \|| __/|  \|
|___/|___/|___/|/\_/|/   |/\_/
```


Goofy.flf
```
__       _____     _____     ___        ___   __   __
  )  ____)    )   (     )   (   \    ___) (  (  )  ) 
 /  /  __    /     \   /     \   |  (__    \  \/  /  
(  (  (  \  (       ) (       )  |   __)    \    /   
 \  \__)  )  \     /   \     /   |  (        )  /    
__)      (____)   (_____)   (___/    \______/  (_____
```


Gothic.flf
```
    __ ,                           
  ,-| ~           ,  ,,            
 ('||/__,        ||  ||     '      
(( |||  |  /'\\ =||= ||/\\ \\  _-_ 
(( |||==| || ||  ||  || || || ||   
 ( / |  , || ||  ||  || || || ||   
  -____/  \\,/   \\, \\ |/ \\ \\,/ 
                       _/          
                                   
```


Graceful.flf
```
  ___  ____   __    ___  ____  ____  _  _  __   
 / __)(  _ \ / _\  / __)(  __)(  __)/ )( \(  )  
( (_ \ )   //    \( (__  ) _)  ) _) ) \/ (/ (_/\
 \___/(__\_)\_/\_/ \___)(____)(__)  \____/\____/
```


Gradient.flf
```
.eeeeee..eeeeeee...eeeeee..eeeeeee..eee.eeeeee.eeeeeee..eeeeeeeee.
@@@@@@@@:@@@@@@@@:@@@@@@@@:@@@@@@@@:@@@:@@@@@@:@@@@@@@@:@@@@@@@@@:
%%%------%%%--%%%-%%%--%%%-%%%--%%%-%%%-%%%----%%%--%%%----%%%----
&&&++++++&&&&&&&++&&&&&&&&+&&&++&&&+&&&+&&&&&++&&&++&&&++++&&&++++
|||*||||*||||||***||||||||*|||**|||*|||*|||||**|||**|||****|||****
!!!==!!!=!!!=!!!==!!!==!!!=!!!==!!!=!!!=!!!====!!!==!!!====!!!====
::::::::#:::##:::#:::##:::#::::::::#:::#::::::#:::##:::####:::####
@......@@...@@...@...@@...@.......@@...@......@...@@...@@@@...@@@@
                                                                  
```


Graffiti.flf
```
  ________              _____  _____.__  __  .__ 
 /  _____/___________ _/ ____\/ ____\__|/  |_|__|
/   \  __\_  __ \__  \\   __\\   __\|  \   __\  |
\    \_\  \  | \// __ \|  |   |  |  |  ||  | |  |
 \______  /__|  (____  /__|   |__|  |__||__| |__|
        \/           \/                          
```


Greek.flf
```
                       
 _____                 
|  ___)                
| |  ___  ___ ___ _  __
| | / _ \/ __) __) |/ /
| || |_) > _)> _)|   < 
|_||  __/\___)___)_|\_\
   | |                 
   |_|                 
```


Heart Left.flf
```
 .-.-. .-.-. .-.-. .-.-. .-.-.      .-.-. .-.-. .-.-. .-.-. 
( H .'( e .'( a .'( r .'( t .'.-.-.( L .'( e .'( f .'( t .' 
 `.(   `.(   `.(   `.(   `.(  '._.' `.(   `.(   `.(   `.(   
                                                            
```


heart_left.flf
```
 .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. 
( h .'( e .'( a .'( r .'( t .'( _ .'( l .'( e .'( f .'( t .' 
 `.(   `.(   `.(   `.(   `.(   '.(   `.(   `.(   `.(   `.(   
                                                             
```


Heart Right.flf
```
.-.-. .-.-. .-.-. .-.-. .-.-.      .-.-. .-.-. .-.-. .-.-. .-.-.  
'. H )'. e )'. a )'. r )'. t ).-.-.'. R )'. i )'. g )'. h )'. t ) 
  ).'   ).'   ).'   ).'   ).' '._.'  ).'   ).'   ).'   ).'   ).'  
                                                                  
```


heart_right.flf
```
.-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. .-.-.  
'. h )'. e )'. a )'. r )'. t )'. _ )'. r )'. i )'. g )'. h )'. t ) 
  ).'   ).'   ).'   ).'   ).'   ).'   ).'   ).'   ).'   ).'   ).'  
                                                                   
```


Henry 3D.flf
```
   _  _                                               ____      ___   
  FJ  L]     ____     _ ___     _ ___   _    _       F___ J    F __". 
 J |__| L   F __ J   J '__ J   J '__ ",J |  | L      `-__| L  J |--\ L
 |  __  |  | _____J  | |__| |  | |__|-J| |  | |       |__  (  | |  J |
 F L__J J  F L___--. F L  J J  F L  `-'F L__J J    .-____] J  F L__J |
J__L  J__LJ\______/FJ__L  J__LJ__L     )-____  L   J\______/FJ______/F
|__L  J__| J______F |__L  J__||__L    J\______/F    J______F |______F 
                                       J______F                       
```


henry3d.flf
```
   _                                               ____         _   
  FJ___      ____     _ ___     _ ___   _    _    F___ J     ___FJ  
 J  __ `.   F __ J   J '__ J   J '__ ",J |  | L   `-__| L   F __  L 
 | |--| |  | _____J  | |__| |  | |__|-J| |  | |    |__  (  | |--| | 
 F L  J J  F L___--. F L  J J  F L  `-'F L__J J .-____] J  F L__J J 
J__L  J__LJ\______/FJ__L  J__LJ__L     )-____  LJ\______/FJ\____,__L
|__L  J__| J______F |__L  J__||__L    J\______/F J______F  J____,__F
                                       J______F                     
```


Hex.flf
```
48 65 78 
```


Hieroglyphs.flf
```
()  ;.                                    ,-.       ,-.\\ \\               ,-. 
() ; |          ||          .-.   ____   <,- \_____/  ` \\ \\         ___  | | 
() `.| ....     ||  .---.  _|_ \  /  \     /  ___. \     \\ \\   __  |   | | ' 
/\   | `=.`''===.' '.___.' (_)   /_/\_\ ,_(__/ ,_(__\     \\ \\ |__| | |_| |   
```


Hollywood.flf
```
           _                                                                     
          ' )     )           /' /'                                            /'
          /'    /'          /' /'                                            /'  
       ,/'    /' ____     /' /'      .   . ,   ,   ____     ____     _____,/'    
      /`---,/' /'    )--/' /' /'    /|   |/   /  /'    )--/'    )--/'    /'      
    /'    /' /'    /' /' /' /'    /' |  /|  /' /'    /' /'    /' /'    /'        
(,/'     (_,(___,/'  (__(__(___,/(___|/' |/(__(___,/'  (___,/'  (___,/(__        
                              /'                                                 
                      /     /'                                                   
                     (___,/'                                                     
```


Horizontal Left.flf
```
 _______   _______   _______   _     _   _     _   _______   _______   _          ______   _______     _______   _______   _______   _        
\__   __\ /  ____ \ / ___  _| | |___| | | |  .` | /  ____ \ `._   __| | /_____  .`  _ ._| /______ \   /______ \ | ._ _. | |  _ ___| | /_____  
 __| |__  | /___/ | | \_/  \  |  ___  | | |.`_. | | /___/ |  _`. `._  | ______/ \  \_||_        / |         / | | \ v / | | ||_\    | ______/ 
\_______\ \_______/ `.__.`\_| |_|   |_| |__.` |_| \_______/ |_______| |_\        `._____|       \_|         \_| |_/   \_| |_/       |_\       
                                                                                                                                              
                                                                                                                                              
```


horizontalleft.flf
```
 _______   _______   _______   _     _   _     _   _______   _______   _          ______   _______   _______   _______   _______   _        
\__   __\ /  ____ \ / ___  _| | |___| | | |  .` | /  ____ \ `._   __| | /_____  .`  _ ._| /______ \ /______ \ | ._ _. | |  _ ___| | /_____  
 __| |__  | /___/ | | \_/  \  |  ___  | | |.`_. | | /___/ |  _`. `._  | ______/ \  \_||_        / |       / | | \ v / | | ||_\    | ______/ 
\_______\ \_______/ `.__.`\_| |_|   |_| |__.` |_| \_______/ |_______| |_\        `._____|       \_|       \_| |_/   \_| |_/       |_\       
                                                                                                                                            
                                                                                                                                            
```


Horizontal Right.flf
```
 _______   _______   _______   _     _   _     _   _______   _______         _   ______    _______     _______   _     _   _______   _______         _  
\__   __\ /  ____ \ |_  ___ \ | |___| | | '.  | | /  ____ \ |__   _.'  _____\ | |_. _  '. / ______\   |_  ___ \ | |___| | / .---. \ \__   __\  _____\ | 
 __| |__  | /___/ |  /  \_/ | |  ___  | | ._'.| | | /___/ |  _.' .'_  \______ |  _||_/  / | \          /  \_/ | |  ___  | \_'-. / |  __| |__  \______ | 
\_______\ \_______/ |_/'.__.' |_|   |_| |_| '.__| \_______/ |_______|       /_| |_____.'  |_/         |_/'.__.' |_|   |_|   '.| \_/ \_______\       /_| 
                                                                                                                                                        
                                                                                                                                                        
```


horizontalright.flf
```
 _______   _______   _______   _     _   _     _   _______   _______         _   ______    _______   _______   _     _   _______   _______         _  
\__   __\ /  ____ \ |_  ___ \ | |___| | | '.  | | /  ____ \ |__   _.'  _____\ | |_. _  '. / ______\ |_  ___ \ | |___| | / .---. \ \__   __\  _____\ | 
 __| |__  | /___/ |  /  \_/ | |  ___  | | ._'.| | | /___/ |  _.' .'_  \______ |  _||_/  / | \        /  \_/ | |  ___  | \_'-. / |  __| |__  \______ | 
\_______\ \_______/ |_/'.__.' |_|   |_| |_| '.__| \_______/ |_______|       /_| |_____.'  |_/       |_/'.__.' |_|   |_|   '.| \_/ \_______\       /_| 
                                                                                                                                                      
                                                                                                                                                      
```


ICL-1900.flf
```
ICL-1900
**      
  **    
      **
    *   
        
 **     
        
        
        
        
        
*    *  
```


Impossible.flf
```
          _         _   _         _          _            _           _           _          _               _             _      
         /\ \      /\_\/\_\ _    /\ \       /\ \         / /\        / /\        /\ \       / /\            _\ \          /\ \    
         \ \ \    / / / / //\_\ /  \ \     /  \ \       / /  \      / /  \       \ \ \     / /  \          /\__ \        /  \ \   
         /\ \_\  /\ \/ \ \/ / // /\ \ \   / /\ \ \     / / /\ \__  / / /\ \__    /\ \_\   / / /\ \        / /_ \_\      / /\ \ \  
        / /\/_/ /  \____\__/ // / /\ \_\ / / /\ \ \   / / /\ \___\/ / /\ \___\  / /\/_/  / / /\ \ \      / / /\/_/     / / /\ \_\ 
       / / /   / /\/________// / /_/ / // / /  \ \_\  \ \ \ \/___/\ \ \ \/___/ / / /    / / /\ \_\ \    / / /         / /_/_ \/_/ 
      / / /   / / /\/_// / // / /__\/ // / /   / / /   \ \ \       \ \ \      / / /    / / /\ \ \___\  / / /         / /____/\    
     / / /   / / /    / / // / /_____// / /   / / /_    \ \ \  _    \ \ \    / / /    / / /  \ \ \__/ / / / ____    / /\____\/    
 ___/ / /__ / / /    / / // / /      / / /___/ / //_/\__/ / / /_/\__/ / /___/ / /__  / / /____\_\ \  / /_/_/ ___/\ / / /______    
/\__\/_/___\\/_/    / / // / /      / / /____\/ / \ \/___/ /  \ \/___/ //\__\/_/___\/ / /__________\/_______/\__\// / /_______\   
\/_________/        \/_/ \/_/       \/_________/   \_____\/    \_____\/ \/_________/\/_____________/\_______\/    \/__________/   
                                                                                                                                  
```


Invita.flf
```
     _____                
    (, /          ,       
      / __  _ _    _/_ _  
  ___/__/ (_(/___(_(__(_(_
(__ /                     
                          
```


Isometric1.flf
```
                  ___           ___           ___           ___           ___           ___                       ___     
      ___        /\  \         /\  \         /\__\         /\  \         /\  \         /\  \          ___        /\  \    
     /\  \      /::\  \       /::\  \       /::|  |       /::\  \        \:\  \       /::\  \        /\  \      /::\  \   
     \:\  \    /:/\ \  \     /:/\:\  \     /:|:|  |      /:/\:\  \        \:\  \     /:/\:\  \       \:\  \    /:/\:\  \  
     /::\__\  _\:\~\ \  \   /:/  \:\  \   /:/|:|__|__   /::\~\:\  \       /::\  \   /::\~\:\  \      /::\__\  /:/  \:\  \ 
  __/:/\/__/ /\ \:\ \ \__\ /:/__/ \:\__\ /:/ |::::\__\ /:/\:\ \:\__\     /:/\:\__\ /:/\:\ \:\__\  __/:/\/__/ /:/__/ \:\__\
 /\/:/  /    \:\ \:\ \/__/ \:\  \ /:/  / \/__/~~/:/  / \:\~\:\ \/__/    /:/  \/__/ \/_|::\/:/  / /\/:/  /    \:\  \  \/__/
 \::/__/      \:\ \:\__\    \:\  /:/  /        /:/  /   \:\ \:\__\     /:/  /         |:|::/  /  \::/__/      \:\  \      
  \:\__\       \:\/:/  /     \:\/:/  /        /:/  /     \:\ \/__/     \/__/          |:|\/__/    \:\__\       \:\  \     
   \/__/        \::/  /       \::/  /        /:/  /       \:\__\                      |:|  |       \/__/        \:\__\    
                 \/__/         \/__/         \/__/         \/__/                       \|__|                     \/__/    
```


Isometric2.flf
```
                  ___           ___           ___           ___                         ___                       ___     
                 /\__\         /\  \         /\  \         /\__\                       /\  \                     /\__\    
    ___         /:/ _/_       /::\  \       |::\  \       /:/ _/_         ___         /::\  \       ___         /:/  /    
   /\__\       /:/ /\  \     /:/\:\  \      |:|:\  \     /:/ /\__\       /\__\       /:/\:\__\     /\__\       /:/  /     
  /:/__/      /:/ /::\  \   /:/  \:\  \   __|:|\:\  \   /:/ /:/ _/_     /:/  /      /:/ /:/  /    /:/__/      /:/  /  ___ 
 /::\  \     /:/_/:/\:\__\ /:/__/ \:\__\ /::::|_\:\__\ /:/_/:/ /\__\   /:/__/      /:/_/:/__/___ /::\  \     /:/__/  /\__\
 \/\:\  \__  \:\/:/ /:/  / \:\  \ /:/  / \:\~~\  \/__/ \:\/:/ /:/  /  /::\  \      \:\/:::::/  / \/\:\  \__  \:\  \ /:/  /
  ~~\:\/\__\  \::/ /:/  /   \:\  /:/  /   \:\  \        \::/_/:/  /  /:/\:\  \      \::/~~/~~~~   ~~\:\/\__\  \:\  /:/  / 
     \::/  /   \/_/:/  /     \:\/:/  /     \:\  \        \:\/:/  /   \/__\:\  \      \:\~~\          \::/  /   \:\/:/  /  
     /:/  /      /:/  /       \::/  /       \:\__\        \::/  /         \:\__\      \:\__\         /:/  /     \::/  /   
     \/__/       \/__/         \/__/         \/__/         \/__/           \/__/       \/__/         \/__/       \/__/    
```


Isometric3.flf
```
                  ___           ___           ___           ___                       ___                       ___     
    ___          /  /\         /  /\         /__/\         /  /\          ___        /  /\        ___          /  /\    
   /  /\        /  /:/_       /  /::\       |  |::\       /  /:/_        /  /\      /  /::\      /  /\        /  /:/    
  /  /:/       /  /:/ /\     /  /:/\:\      |  |:|:\     /  /:/ /\      /  /:/     /  /:/\:\    /  /:/       /  /:/     
 /__/::\      /  /:/ /::\   /  /:/  \:\   __|__|:|\:\   /  /:/ /:/_    /  /:/     /  /:/~/:/   /__/::\      /  /:/  ___ 
 \__\/\:\__  /__/:/ /:/\:\ /__/:/ \__\:\ /__/::::| \:\ /__/:/ /:/ /\  /  /::\    /__/:/ /:/___ \__\/\:\__  /__/:/  /  /\
    \  \:\/\ \  \:\/:/~/:/ \  \:\ /  /:/ \  \:\~~\__\/ \  \:\/:/ /:/ /__/:/\:\   \  \:\/:::::/    \  \:\/\ \  \:\ /  /:/
     \__\::/  \  \::/ /:/   \  \:\  /:/   \  \:\        \  \::/ /:/  \__\/  \:\   \  \::/~~~~      \__\::/  \  \:\  /:/ 
     /__/:/    \__\/ /:/     \  \:\/:/     \  \:\        \  \:\/:/        \  \:\   \  \:\          /__/:/    \  \:\/:/  
     \__\/       /__/:/       \  \::/       \  \:\        \  \::/          \__\/    \  \:\         \__\/      \  \::/   
                 \__\/         \__\/         \__\/         \__\/                     \__\/                     \__\/    
```


Isometric4.flf
```
                   ___           ___           ___           ___                         ___                        ___     
       ___        /  /\         /  /\         /  /\         /  /\          ___          /  /\           ___        /  /\    
      /__/\      /  /::\       /  /::\       /  /::|       /  /::\        /__/\        /  /::\         /__/\      /  /::\   
      \__\:\    /__/:/\:\     /  /:/\:\     /  /:|:|      /  /:/\:\       \  \:\      /  /:/\:\        \__\:\    /  /:/\:\  
      /  /::\  _\_ \:\ \:\   /  /:/  \:\   /  /:/|:|__   /  /::\ \:\       \__\:\    /  /::\ \:\       /  /::\  /  /:/  \:\ 
   __/  /:/\/ /__/\ \:\ \:\ /__/:/ \__\:\ /__/:/_|::::\ /__/:/\:\ \:\      /  /::\  /__/:/\:\_\:\   __/  /:/\/ /__/:/ \  \:\
  /__/\/:/~~  \  \:\ \:\_\/ \  \:\ /  /:/ \__\/  /~~/:/ \  \:\ \:\_\/     /  /:/\:\ \__\/~|::\/:/  /__/\/:/~~  \  \:\  \__\/
  \  \::/      \  \:\_\:\    \  \:\  /:/        /  /:/   \  \:\ \:\      /  /:/__\/    |  |:|::/   \  \::/      \  \:\      
   \  \:\       \  \:\/:/     \  \:\/:/        /  /:/     \  \:\_\/     /__/:/         |  |:|\/     \  \:\       \  \:\     
    \__\/        \  \::/       \  \::/        /__/:/       \  \:\       \__\/          |__|:|~       \__\/        \  \:\    
                  \__\/         \__\/         \__\/         \__\/                       \__\|                      \__\/    
```


Italic.flf
```
          
 /_/_ /'_ 
( /(/(/(  
          
```


Ivrit.flf
```
                                                                                                                                          _   _            ___ 
                                                                                                                                         | |_(_)_ ____   _|_ _|
                                                                                                                                         | __| | '__\ \ / /| | 
                                                                                                                                         | |_| | |   \ V / | | 
                                                                                                                                          \__|_|_|    \_/ |___|
                                                                                                                                                               
```


Jacky.flf
```
  ________     ____       ____    __   ___  __      __ 
 (___  ___)   (    )     / ___)  () ) / __) ) \    / ( 
     ) )      / /\ \    / /      ( (_/ /     \ \  / /  
    ( (      ( (__) )  ( (       ()   (       \ \/ /   
 __  ) )      )    (   ( (       () /\ \       \  /    
( (_/ /      /  /\  \   \ \___   ( (  \ \       )(     
 \___/      /__(  )__\   \____)  ()_)  \_\     /__\    
                                                       
```


Jazmine.flf
```
                                          
  o                        o              
  8                                       
  8 .oPYo. .oooo. ooYoYo. o8 odYo. .oPYo. 
  8 .oooo8   .dP  8' 8  8  8 8' `8 8oooo8 
  8 8    8  oP'   8  8  8  8 8   8 8.     
oP' `YooP8 `Yooo' 8  8  8  8 8   8 `Yooo' 
...::.....::.....:..:..:..:....::..:.....:
::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::
```


Jerusalem.flf
```
                                                                                                                                                               
                                                                                              __   __.______ _______ _   _   _ _______ ___ ______ ______     _ 
                                                                                              \ \ / /|____  |____  .| | | | | |____   |_  |____  |____  |   | |
                                                                                               \ V /   _  | |    | || | | | | |    | |  | |    | | _  | |_  | |
                                                                                             ___\  \  | | |_|    | || |/ /_/ /     | |  | |    | || | |_| |_| |
                                                                                            |______|  | |        | ||_______/      |_|  |_|    |_|| |    \___/ 
                                                                                                      |_|        |_|                              |_|          
```


JS Block Letters.flf
```
  __   ____    _____  _     ____  ____  __  __     _     ____  _____  _____  ____ _____   ____ 
__) | (_ (_`   | () )| |__ / () \/ (__`|  |/  /   | |__ | ===||_   _||_   _|| ===|| () ) (_ (_`
\___/.__)__)   |_()_)|____|\____/\____)|__|\__\   |____||____|  |_|    |_|  |____||_|\_\.__)__)
```


JS Bracket Letters.flf
```
   .-. .----.   .----. .----.   .--.   .---. .-. .-..----..---.    .-.   .----..---.  .---. .----..----.  .----.
.-.| |{ {__     | {}  }| {}  } / {} \ /  ___}| |/ / | {_ {_   _}   | |   | {_ {_   _}{_   _}| {_  | {}  }{ {__  
| {} |.-._} }   | {}  }| .-. \/  /\  \\     }| |\ \ | {__  | |     | `--.| {__  | |    | |  | {__ | .-. \.-._} }
`----'`----'    `----' `-' `-'`-'  `-' `---' `-' `-'`----' `-'     `----'`----' `-'    `-'  `----'`-' `-'`----' 
```


JS Capital Curves.flf
```
  ____, ____     ____   ___,   ___, ____, ____, ___,   __       ____   __   _, ___,   __  _, ____, ____ 
 (-|   (-(__`   (-/  ` (-|_\_,(-|_)(-|   (-|   (-|_\_,(-|      (-/  ` (-|  |  (-|_)  (-\ |  (-|_, (-(__`
 _ |    ____)     \___, _|  )  _|   _|__, _|    _|  )  _|__,     \___,  |__|_, _| \_,   \|   _|__, ____)
(__/   (               (      (    (     (     (      (                       (             (     (     
```


JS Cursive.flf
```
                                             
    .  ,       __        ,_   ,    ._,     _ 
  _/__/_)_   _(_,__(_/__/ (__/_)__/_ (_/__(/_
 _/_                                         
(/                                           
                                             
```


JS Stick Letters.flf
```
      __      __  ___    __                ___ ___ ___  ___  __   __  
   | /__`    /__`  |  | /  ` |__/    |    |__   |   |  |__  |__) /__` 
\__/ .__/    .__/  |  | \__, |  \    |___ |___  |   |  |___ |  \ .__/ 
                                                                      
```


Katakana.flf
```
  #    #   #             #     #                   #          ######   #        
########## #   ###    #######  #   ###    ######   #   ###             #   ###  
  #    #   ####        # #     ####            #   ####     ########## ####     
       #   #           # #     #               #   #        #        # #        
      #    #        ########## #               #   #               ##  #        
     #     #             #     #        ########## #             ##    #        
   #        #######      #      #######             #######    ##       ####### 
                                                                                
```


Kban.flf
```
'||'  |'  '||                       
 || .'     || ...   ....   .. ...   
 ||'|.     ||'  || '' .||   ||  ||  
 ||  ||    ||    | .|' ||   ||  ||  
.||.  ||.  '|...'  '|..'|' .||. ||. 
                                    
                                    
```


Keyboard.flf
```
                                                                 
 _______ _______ _______ _______ _______ _______ _______ _______ 
|\     /|\     /|\     /|\     /|\     /|\     /|\     /|\     /|
| +---+ | +---+ | +---+ | +---+ | +---+ | +---+ | +---+ | +---+ |
| |   | | |   | | |   | | |   | | |   | | |   | | |   | | |   | |
| |K  | | |e  | | |y  | | |b  | | |o  | | |a  | | |r  | | |d  | |
| +---+ | +---+ | +---+ | +---+ | +---+ | +---+ | +---+ | +---+ |
|/_____\|/_____\|/_____\|/_____\|/_____\|/_____\|/_____\|/_____\|
                                                                 
```


Knob.flf
```
 _________  _________  _________  _________ 
(___    __)(______  _)(  _____  )(  _   _  )
 __/ __ \_  _____/ /_ | |_____| || |_| |_| |
(___/  \__)(_________)(_________)(____/\___)
```


Konto.flf
```
I, `I`.I .., `
I`. `..' I `I   I   `..' 
```


Konto Slant.flf
```
 / /1 /1 / .. /1   / /  /1  /1 / ..
/./  / 1/  /   /./    ../  /. /// 1/  /   
```


kontoslant.flf
```
 / /1 /1 / .. /1 / /  /1  /1 / ..
/./  / 1/  /   /./  ../  /. /// 1/  /   
```


Larry 3D 2.flf
```
 __                                             __    ____            ___     
/\ \                                          /'__`\ /\  _`\        /'___`\   
\ \ \         __     _ __   _ __   __  __    /\_\L\ \\ \ \/\ \     /\_\ /\ \  
 \ \ \  __  /'__`\  /\`'__\/\`'__\/\ \/\ \   \/_/_\_<_\ \ \ \ \    \/_/// /__ 
  \ \ \L\ \/\ \L\.\_\ \ \/ \ \ \/ \ \ \_\ \    /\ \L\ \\ \ \_\ \      // /_\ \
   \ \____/\ \__/.\_\\ \_\  \ \_\  \/`____ \   \ \____/ \ \____/     /\______/
    \/___/  \/__/\/_/ \/_/   \/_/   `/___/> \   \/___/   \/___/      \/_____/ 
                                       /\___/                                 
                                       \/__/                                  
```


Larry 3D.flf
```
 __                                             __    ____      
/\ \                                          /'__`\ /\  _`\    
\ \ \         __     _ __   _ __   __  __    /\_\L\ \\ \ \/\ \  
 \ \ \  __  /'__`\  /\`'__\/\`'__\/\ \/\ \   \/_/_\_<_\ \ \ \ \ 
  \ \ \L\ \/\ \L\.\_\ \ \/ \ \ \/ \ \ \_\ \    /\ \L\ \\ \ \_\ \
   \ \____/\ \__/.\_\\ \_\  \ \_\  \/`____ \   \ \____/ \ \____/
    \/___/  \/__/\/_/ \/_/   \/_/   `/___/> \   \/___/   \/___/ 
                                       /\___/                   
                                       \/__/                    
```


larry3d.flf
```
 ___                                      __       __     
/\_ \                                   /'__`\    /\ \    
\//\ \      __     _ __   _ __   __  __/\_\L\ \   \_\ \   
  \ \ \   /'__`\  /\`'__\/\`'__\/\ \/\ \/_/_\_<_  /'_` \  
   \_\ \_/\ \L\.\_\ \ \/ \ \ \/ \ \ \_\ \/\ \L\ \/\ \L\ \ 
   /\____\ \__/.\_\\ \_\  \ \_\  \/`____ \ \____/\ \___,_\
   \/____/\/__/\/_/ \/_/   \/_/   `/___/> \/___/  \/__,_ /
                                     /\___/               
                                     \/__/                
```


LCD.flf
```
       ___   ___  
|     |       | | 
|     |       + | 
|     |       | | 
 ---   ---   ---  
                  
```


Lean.flf
```
                                           
    _/                                     
   _/          _/_/      _/_/_/  _/_/_/    
  _/        _/_/_/_/  _/    _/  _/    _/   
 _/        _/        _/    _/  _/    _/    
_/_/_/_/    _/_/_/    _/_/_/  _/    _/     
                                           
                                           
```


Letters.flf
```
LL             tt    tt                        
LL        eee  tt    tt      eee  rr rr   sss  
LL      ee   e tttt  tttt  ee   e rrr  r s     
LL      eeeee  tt    tt    eeeee  rr      sss  
LLLLLLL  eeeee  tttt  tttt  eeeee rr         s 
                                          sss  
```


Lil Devil.flf
```
           _                  _(`-')    (`-')  _      (`-')  _              
   <-.    (_)      <-.       ( (OO ).-> ( OO).-/     _(OO ) (_)      <-.    
 ,--. )   ,-(`-'),--. )       \    .'_ (,------.,--.(_/,-.\ ,-(`-'),--. )   
 |  (`-') | ( OO)|  (`-')     '`'-..__) |  .---'\   \ / (_/ | ( OO)|  (`-') 
 |  |OO ) |  |  )|  |OO )     |  |  ' |(|  '--.  \   /   /  |  |  )|  |OO ) 
(|  '__ |(|  |_/(|  '__ |     |  |  / : |  .--' _ \     /_)(|  |_/(|  '__ | 
 |     |' |  |'->|     |'     |  '-'  / |  `---.\-'\   /    |  |'->|     |' 
 `-----'  `--'   `-----'      `------'  `------'    `-'     `--'   `-----'  
```


lildevil.flf
```
           _             _(`-')    (`-')  _      (`-')  _              
   <-.    (_)      <-.  ( (OO ).-> ( OO).-/     _(OO ) (_)      <-.    
 ,--. )   ,-(`-'),--. )  \    .'_ (,------.,--.(_/,-.\ ,-(`-'),--. )   
 |  (`-') | ( OO)|  (`-')'`'-..__) |  .---'\   \ / (_/ | ( OO)|  (`-') 
 |  |OO ) |  |  )|  |OO )|  |  ' |(|  '--.  \   /   /  |  |  )|  |OO ) 
(|  '__ |(|  |_/(|  '__ ||  |  / : |  .--' _ \     /_)(|  |_/(|  '__ | 
 |     |' |  |'->|     |'|  '-'  / |  `---.\-'\   /    |  |'->|     |' 
 `-----'  `--'   `-----' `------'  `------'    `-'     `--'   `-----'  
```


Line Blocks.flf
```
 _       _____  ______   ______    ______   _        ______   ______  _    __  ______  
| |       | |  | |  \ \ | |       | |  | \ | |      / |  | \ | |     | |  / / / |      
| |   _   | |  | |  | | | |----   | |--| < | |   _  | |  | | | |     | |-< <  '------. 
|_|__|_| _|_|_ |_|  |_| |_|____   |_|__|_/ |_|__|_| \_|__|_/ |_|____ |_|  \_\  ____|_/ 
                                                                                       
```


lineblocks.flf
```
 _       _____  ______   ______  ______   _        ______   ______  _    __  ______  
| |       | |  | |  \ \ | |     | |  | \ | |      / |  | \ | |     | |  / / / |      
| |   _   | |  | |  | | | |---- | |--| < | |   _  | |  | | | |     | |-< <  '------. 
|_|__|_| _|_|_ |_|  |_| |_|____ |_|__|_/ |_|__|_| \_|__|_/ |_|____ |_|  \_\  ____|_/ 
                                                                                     
```


Linux.flf
```
.-.   .-..-..-..-..-..-..-.
| |__ | || .` || || | >  < 
`----'`-'`-'`-'`----''-'`-`
                           
```


Lockergnome.flf
```
::|              :|                                      
::|    ,::\ .::/ :|_/ :~~/ :::| /::| :::\ ,::\ :\/| :~~/ 
::::::|`::/ `::\ :|~\ :::, :|   \::| :|:| `::/ :::| :::, 
                                ,.:/                     
```


Madrid.flf
```
/\/\       |        | 
|==| /=| /=| /= = /=| 
\  / \=| \=| |  | \=| 
                      
```


Marquee.flf
```
.::       .::                                                     
.: .::   .:::                                                     
.:: .:: . .::   .::    .: .:::  .::   .::  .::   .::       .::    
.::  .::  .:: .::  .::  .::   .:  .:: .::  .:: .:   .::  .:   .:: 
.::   .:  .::.::   .::  .::   .:  .:: .::  .::.::::: .::.::::: .::
.::       .::.::   .::  .::    .::.:: .::  .::.:        .:        
.::       .::  .:: .:::.:::       .::   .::.::  .::::     .::::   
                                  .:::                            
```


Maxfour.flf
```
|\  /|       /~\           
| \/ |/~~|\/-|-/~\|   ||/~\
|    |\__|/\ | \_/ \_/||   
                           
```


maxiwi.flf
```
              █       █ 
                        
█████ ███ █ █ █ █ █ █ █ 
█ █ █   █  █  █ █ █ █ █ 
█ █ █ ███  █  █ █ █ █ █ 
█ █ █ ███ █ █ █  █ █  █ 
                        
                        
```


Merlin1.flf
```
 ___      ___   _______   _______   ___        __    _____  ___    ____    
|"  \    /"  | /"     "| /"      \ |"  |      |" \  (\"   \|"  \  /  " \   
 \   \  //   |(: ______)|:        |||  |      ||  | |.\\   \    |/__|| |   
 /\\  \/.    | \/    |  |_____/   )|:  |      |:  | |: \.   \\  |   |: |   
|: \.        | // ___)_  //      /  \  |___   |.  | |.  \    \. |  _\  |   
|.  \    /:  |(:      "||:  __   \ ( \_|:  \  /\  |\|    \    \ | /" \_|\  
|___|\__/|___| \_______)|__|  \___) \_______)(__\_|_)\___|\____\)(_______) 
                                                                           
```


Merlin2.flf
```
   _               _        _         _          _      _          _      
 _/\\___ _____  __/\\___  _/\\___   _/\\_      _/\\_  _/\\___   __//\     
(_      v    ))(_  ____))(_   _  ))(_  _))    (____))(_      ))//    \    
 /  :   <\   \\ /  ._))   /  |))//  /  \\      /  \\  /  :   \\\\_/  /    
/:. |   //   ///:. ||___ /:.    \\ /:.  \\__  /:.  \\/:. |   //  /.:/_/\\ 
\___|  //\  // \  _____))\___|  // \__  ____))\__  //\___|  //   \  ___// 
     \//  \//   \//           \//     \//        \//      \//     \//     
                                                                          
                                                                          
```


Mike.flf
```
         |/  _
 ||\ _|  |  |/
              
```


Mini.flf
```
          
|\/|o._ o 
|  ||| || 
          
```


miniwi.flf
```
   ▘  ▘   ▘
▛▛▌▌▛▌▌▌▌▌▌
▌▌▌▌▌▌▌▚▚▘▌
           
```


Mirror.flf
```
                                                                                                                                                      _ __  __ 
                                                                                                                                  __ _  ___ __ _ __ _(_)  \/  |
                                                                                                                                 |__` |/ _ \__` |__` | | |\/| |
                                                                                                                                    | | (_) | | |  | | | |  | |
                                                                                                                                    |_|\___/  |_|  |_|_|_|  |_|
                                                                                                                                                               
```


Mnemonic.flf
```
Mnemonic
```


Modular.flf
```
 __   __  _______  ______   __   __  ___      _______  ______   
|  |_|  ||       ||      | |  | |  ||   |    |   _   ||    _ |  
|       ||   _   ||  _    ||  | |  ||   |    |  |_|  ||   | ||  
|       ||  | |  || | |   ||  |_|  ||   |    |       ||   |_||_ 
|       ||  |_|  || |_|   ||       ||   |___ |       ||    __  |
| ||_|| ||       ||       ||       ||       ||   _   ||   |  | |
|_|   |_||_______||______| |_______||_______||__| |__||___|  |_|
```


Morse2.flf
```
-- --- .-. ... . ..--- 
```


Morse.flf
```
-- --- .-. ... . 
```


Moscow.flf
```
                                    
#   #  ###   #### #   #  ###  #   # 
## ## #   # #     #   # #   # # # # 
# # # #   # #      #### #   # # # # 
#   # #   # #         # #   # # # # 
#   #  ###   ####     #  ###   ###  
```


Mshebrew210.flf
```
                                                                                                                                                               
                                                                                                                                               ""|""| |""||""|'
                                                                                                                                               | '  |_|| '   | 
                                                                                                                                               |       |       
```


Muzzle.flf
```
                        __ 
|\ /| |  | >>> >>> |   |   
| < | |  |  /   /  |   |<< 
|   | '<<' /<< /<< |<< |__ 
```


Nancyj-Fancy.flf
```
M"""""""`YM                                     oo          MM""""""""`M                                     
M  mmmm.  M                                                 MM  mmmmmmmM                                     
M  MMMMM  M .d8888b. 88d888b. .d8888b. dP    dP dP          M'      MMMM .d8888b. 88d888b. .d8888b. dP    dP 
M  MMMMM  M 88'  `88 88'  `88 88'  `"" 88    88 88 88888888 MM  MMMMMMMM 88'  `88 88'  `88 88'  `"" 88    88 
M  MMMMM  M 88.  .88 88    88 88.  ... 88.  .88 88          MM  MMMMMMMM 88.  .88 88    88 88.  ... 88.  .88 
M  MMMMM  M `88888P8 dP    dP `88888P' `8888P88 88          MM  MMMMMMMM `88888P8 dP    dP `88888P' `8888P88 
MMMMMMMMMMM                                 .88 88          MMMMMMMMMMMM                                 .88 
                                        d8888P  dP                                                   d8888P  
```


Nancyj.flf
```
888888ba                                      oo 
88    `8b                                        
88     88 .d8888b. 88d888b. .d8888b. dP    dP dP 
88     88 88'  `88 88'  `88 88'  `"" 88    88 88 
88     88 88.  .88 88    88 88.  ... 88.  .88 88 
dP     dP `88888P8 dP    dP `88888P' `8888P88 88 
                                          .88 88 
                                      d8888P  dP 
```


Nancyj-Improved.flf
```
888888ba                                      oo          dP                                                               dP 
88    `8b                                                 88                                                               88 
88     88 .d8888b. 88d888b. .d8888b. dP    dP dP          88 88d8b.d8b. 88d888b. 88d888b. .d8888b. dP   .dP .d8888b. .d888b88 
88     88 88'  `88 88'  `88 88'  `"" 88    88 88 88888888 88 88'`88'`88 88'  `88 88'  `88 88'  `88 88   d8' 88ooood8 88'  `88 
88     88 88.  .88 88    88 88.  ... 88.  .88 88          88 88  88  88 88.  .88 88       88.  .88 88 .88'  88.  ... 88.  .88 
dP     dP `88888P8 dP    dP `88888P' `8888P88 88          dP dP  dP  dP 88Y888P' dP       `88888P' 8888P'   `88888P' `88888P8 
                                          .88 88                        88                                                    
                                      d8888P  dP                        dP                                                    
```


Nancyj-Underlined.flf
```
888888ba                                      oo          dP     dP                dP                   dP oo                         dP 
88    `8b                                                 88     88                88                   88                            88 
88     88 .d8888b. 88d888b. .d8888b. dP    dP dP          88     88 88d888b. .d888b88 .d8888b. 88d888b. 88 dP 88d888b. .d8888b. .d888b88 
88     88 88'  `88 88'  `88 88'  `"" 88    88 88 88888888 88     88 88'  `88 88'  `88 88ooood8 88'  `88 88 88 88'  `88 88ooood8 88'  `88 
88     88 88.  .88 88    88 88.  ... 88.  .88 88          Y8.   .8P 88    88 88.  .88 88.  ... 88       88 88 88    88 88.  ... 88.  .88 
dP     dP `88888P8 dP    dP `88888P' `8888P88 88          `Y88888P' dP    dP `88888P8 `88888P' dP       dP dP dP    dP `88888P' `88888P8 
oooooooooooooooooooooooooooooooooooooo~~~~.88~88~oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
                                      d8888P  dP                                                                                         
```


Nipples.flf
```
{___     {__                    {__                 
{_ {__   {__ {_                 {__                 
{__ {__  {__   {_ {__  {_ {__   {__   {__     {____ 
{__  {__ {__{__{_  {__ {_  {__  {__ {_   {__ {__    
{__   {_ {__{__{_   {__{_   {__ {__{_____ {__  {___ 
{__    {_ __{__{__ {__ {__ {__  {__{_            {__
{__      {__{__{__     {__     {___  {____   {__ {__
               {__     {__                          
```


NScript.flf
```
 ,ggg, ,ggggggg,        ,gg,                                                  
dP""Y8,8P"""""Y8b      i8""8i                                            I8   
Yb, `8dP'     `88      `8,,8'                                            I8   
 `"  88'       88       `88'                          gg              88888888
     88        88       dP"8,                         ""                 I8   
     88        88      dP' `8a    ,gggg,   ,gggggg,   gg   gg,gggg,      I8   
     88        88     dP'   `Yb  dP"  "Yb  dP""""8I   88   I8P"  "Yb     I8   
     88        88 _ ,dP'     I8 i8'       ,8'    8I   88   I8'    ,8i   ,I8,  
     88        Y8,"888,,____,dP,d8,_    _,dP     Y8,_,88,_,I8 _  ,d8'  ,d88b, 
     88        `Y8a8P"Y88888P" P""Y8888PP8P      `Y88P""Y8PI8 YY88888P88P""Y88
                                                           I8                 
                                                           I8                 
                                                           I8                 
                                                           I8                 
                                                           I8                 
                                                           I8                 
```


NT Greek.flf
```
                                     
 _   _ _____   _____                 
| \ | (_   _) |  ___)                
|  \| | | |   | |  ___  ___ ___ _  __
|     | | |   | | / _ \/ __) __) |/ /
| |\  | | |   | || |_) > _)> _)|   < 
|_| \_| |_|   |_||  __/\___)___)_|\_\
                 | |                 
                 |_|                 
```


ntgreek.flf
```
                                  
                                  
                                  
 _  _____ _   _ ___  ___ ___ _  __
| |/ (   | \ / ) _ \/ __) __) |/ /
| / / | | \ v / |_) > _)> _)|   < 
|__/   \_) | ||  __/\___)___)_|\_\
           | || |                 
           |_||_|                 
```


NV Script.flf
```
 ,ggg, ,ggggggg,  ,ggg,         ,gg       ,gg,                                                 
dP""Y8,8P"""""Y8bdP""Y8a       ,8P       i8""8i                                           I8   
Yb, `8dP'     `88Yb, `88       d8'       `8,,8'                                           I8   
 `"  88'       88 `"  88       88         `88'                          gg             88888888
     88        88     88       88         dP"8,                         ""                I8   
     88        88     I8       8I        dP' `8a    ,gggg,   ,gggggg,   gg   gg,gggg,     I8   
     88        88     `8,     ,8'       dP'   `Yb  dP"  "Yb  dP""""8I   88   I8P"  "Yb    I8   
     88        88      Y8,   ,8P    _ ,dP'     I8 i8'       ,8'    8I   88   I8'    ,8i  ,I8,  
     88        Y8,      Yb,_,dP     "888,,____,dP,d8,_    _,dP     Y8,_,88,_,I8 _  ,d8' ,d88b, 
     88        `Y8       "Y8P"      a8P"Y88888P" P""Y8888PP8P      `Y88P""Y8PI8 YY88888P8P""Y8 
                                                                             I8                
                                                                             I8                
                                                                             I8                
                                                                             I8                
                                                                             I8                
                                                                             I8                
```


O8.flf
```
  ooooooo     ooooooo   
o888   888o o888   888o 
888     888  888888888  
888o   o888 888o   o888 
  88ooo88     88ooo88   
                        
```


Octal.flf
```
117 143 164 141 154 
```


Ogre.flf
```
   ___               
  /___\__ _ _ __ ___ 
 //  // _` | '__/ _ \
/ \_// (_| | | |  __/
\___/ \__, |_|  \___|
      |___/          
```


Old Banner.flf
```
#######                  ######                                     
#     # #      #####     #     #   ##   #    # #    # ###### #####  
#     # #      #    #    #     #  #  #  ##   # ##   # #      #    # 
#     # #      #    #    ######  #    # # #  # # #  # #####  #    # 
#     # #      #    #    #     # ###### #  # # #  # # #      #####  
#     # #      #    #    #     # #    # #   ## #   ## #      #   #  
####### ###### #####     ######  #    # #    # #    # ###### #    # 
```


oldbanner.flf
```
                                                               
 ####  #      #####  #####    ##   #    # #    # ###### #####  
#    # #      #    # #    #  #  #  ##   # ##   # #      #    # 
#    # #      #    # #####  #    # # #  # # #  # #####  #    # 
#    # #      #    # #    # ###### #  # # #  # # #      #####  
#    # #      #    # #    # #    # #   ## #   ## #      #   #  
 ####  ###### #####  #####  #    # #    # #    # ###### #    # 
```


OS2.flf
```
___oooo_____ooooo____ooooo__
_oo____oo__oo___oo_oo____oo_
oo______oo__oo___________oo_
oo______oo____oo_______ooo__
_oo____oo__oo___oo___ooo____
___oooo_____ooooo__oooooooo_
____________________________
```


Patorjk-HeX.flf
```
        ______                                                                                                             -                      
  _____|\     \     _____       ________    ________         ____     ___________               _____    ______   _______        __     __        
 /     / |     |  /      |_    /        \  /        \    ____\_  \__  \          \             |\    \_ |\     \  \      \      /  \   /  \       
|      |/     /| /         \  |\         \/         /|  /     /     \  \    /\    \            \ \     \ \\     \  |     /|    /   /| |\   \      
|      |\____/ ||     /\    \ | \            /\____/ | /     /\      |  |   \_\    |            \|      | \|     |/     //    /   //   \\   \     
|\     \    | / |    |  |    \|  \______/\   \     | ||     |  |     |  |      ___/              |      |  |     |_____//    /    \_____/    \    
| \     \___|/  |     \/      \\ |      | \   \____|/ |     |  |     |  |      \  ____   ______  |      |  |     |\     \   /    /\_____/\    \   
|  \     \      |\      /\     \\|______|  \   \      |     | /     /| /     /\ \/    \ /     / /      /| /     /|\|     | /    //\_____/\\    \  
 \  \_____\     | \_____\ \_____\        \  \___\     |\     \_____/ |/_____/ |\______||      |/______/ |/_____/ |/_____/|/____/ |       | \____\ 
  \ |     |     | |     | |     |         \ |   |     | \_____\   | / |     | | |     ||\_____\      | /|     | / |    | ||    | |       | |    | 
   \|_____|      \|_____|\|_____|          \|___|      \ |    |___|/  |_____|/ \|_____|| |     |_____|/ |_____|/  |____|/ |____|/         \|____| 
                                                        \|____|                         \|_____|                                                  
        _____                    
   _____\    \ _____       _____ 
  /    / |    |\    \     /    / 
 /    /  /___/| \    |   |    /  
|    |__ |___|/  \    \ /    /   
|       \         \    |    /    
|     __/ __      /    |    \    
|\    \  /  \    /    /|\    \   
| \____\/    |  |____|/ \|____|  
| |    |____/|  |    |   |    |  
 \|____|   | |  |____|   |____|  
       |___|/                    
```


Patorjk's Cheese.flf
```
                                                                                                                      
     _____          ____   _________________       _____         _____           ____  ____    ____           ______  
 ___|\    \    ____|\   \ /                 \ ____|\    \    ___|\    \         |    ||    |  |    |      ___|\     \ 
|    |\    \  /    /\    \\______     ______//     /\    \  |    |\    \        |    ||    |  |    |     |    |\     \
|    | |    ||    |  |    |  \( /    /  )/  /     /  \    \ |    | |    |       |    ||    | /    //     |    |/____/|
|    |/____/||    |__|    |   ' |   |   '  |     |    |    ||    |/____/  ____  |    ||    |/ _ _//   ___|    \|   | |
|    ||    |||    .--.    |     |   |      |     |    |    ||    |\    \ |    | |    ||    |\    \'  |    \    \___|/ 
|    ||____|/|    |  |    |    /   //      |\     \  /    /||    | |    ||    | |    ||    | \    \  |    |\     \    
|____|       |____|  |____|   /___//       | \_____\/____/ ||____| |____||\____\|____||____|  \____\ |\ ___\|_____|   
|    |       |    |  |    |  |`   |         \ |    ||    | /|    | |    || |    |    ||    |   |    || |    |     |   
|____|       |____|  |____|  |____|          \|____||____|/ |____| |____| \|____|____||____|   |____| \|____|_____|   
  \(           \(      )/      \(               \(    )/      \(     )/      \(   )/    \(       )/      \(    )/     
   '            '      '        '                '    '        '     '        '   '      '       '        '    '      
                                                                                                                      
                                                                                      
      _____    ____   ____      ______        ______            ______       ______   
  ___|\    \  |    | |    | ___|\     \   ___|\     \       ___|\     \  ___|\     \  
 /    /\    \ |    | |    ||     \     \ |     \     \     |    |\     \|     \     \ 
|    |  |    ||    |_|    ||     ,_____/||     ,_____/|    |    |/____/||     ,_____/|
|    |  |____||    .-.    ||     \--'\_|/|     \--'\_|/ ___|    \|   | ||     \--'\_|/
|    |   ____ |    | |    ||     /___/|  |     /___/|  |    \    \___|/ |     /___/|  
|    |  |    ||    | |    ||     \____|\ |     \____|\ |    |\     \    |     \____|\ 
|\ ___\/    /||____| |____||____ '     /||____ '     /||\ ___\|_____|   |____ '     /|
| |   /____/ ||    | |    ||    /_____/ ||    /_____/ || |    |     |   |    /_____/ |
 \|___|    | /|____| |____||____|     | /|____|     | / \|____|_____|   |____|     | /
   \( |____|/   \(     )/    \( |_____|/   \( |_____|/     \(    )/       \( |_____|/ 
    '   )/       '     '      '    )/       '    )/         '    '         '    )/    
        '                          '             '                              '     
```


Pawp.flf
```
                               
 _____                         
(_____)                        
(_)__(_)____  _   _   _  ____  
(_____)(____)(_) ( ) (_)(____) 
(_)   ( )_( )(_)_(_)_(_)(_)_(_)
(_)    (__)_) (__) (__) (____) 
                        (_)    
                        (_)    
```


Peaks.flf
```
/^^^^^^^                      /^^            
/^^    /^^                    /^^            
/^^    /^^   /^^       /^^    /^^  /^^ /^^^^ 
/^^^^^^^   /^   /^^  /^^  /^^ /^^ /^^ /^^    
/^^       /^^^^^ /^^/^^   /^^ /^/^^     /^^^ 
/^^       /^        /^^   /^^ /^^ /^^     /^^
/^^         /^^^^     /^^ /^^^/^^  /^^/^^ /^^
                                             
```


Peaks Slant.flf
```
     _/\/\/\/\/\____________________________/\/\__________________________/\/\/\/\/\__/\/\______________________________/\/\_____
    _/\/\____/\/\____/\/\/\____/\/\/\______/\/\__/\/\____/\/\/\/\______/\/\__________/\/\____/\/\/\______/\/\/\/\____/\/\/\/\/\_ 
   _/\/\/\/\/\____/\/\/\/\/\______/\/\____/\/\/\/\____/\/\/\/\__________/\/\/\/\____/\/\________/\/\____/\/\__/\/\____/\/\_____  
  _/\/\__________/\/\________/\/\/\/\____/\/\/\/\__________/\/\______________/\/\__/\/\____/\/\/\/\____/\/\__/\/\____/\/\_____   
 _/\/\____________/\/\/\/\__/\/\/\/\/\__/\/\__/\/\__/\/\/\/\________/\/\/\/\/\____/\/\/\__/\/\/\/\/\__/\/\__/\/\____/\/\/\___    
____________________________________________________________________________________________________________________________     
```


peaksslant.flf
```
     _____________________________________/\/\________________________________/\/\______________________________/\/\_____
    _/\/\/\/\______/\/\/\____/\/\/\______/\/\__/\/\____/\/\/\/\____/\/\/\/\__/\/\____/\/\/\______/\/\/\/\____/\/\/\/\/\_ 
   _/\/\__/\/\__/\/\/\/\/\______/\/\____/\/\/\/\____/\/\/\/\____/\/\/\/\____/\/\________/\/\____/\/\__/\/\____/\/\_____  
  _/\/\/\/\____/\/\________/\/\/\/\____/\/\/\/\__________/\/\________/\/\__/\/\____/\/\/\/\____/\/\__/\/\____/\/\_____   
 _/\/\__________/\/\/\/\__/\/\/\/\/\__/\/\__/\/\__/\/\/\/\____/\/\/\/\____/\/\/\__/\/\/\/\/\__/\/\__/\/\____/\/\/\___    
_/\/\_______________________________________________________________________________________________________________     
```


Pebbles.flf
```
OooOOo.         o     o     o             
O     `O       O     O     O              
o      O       O     O     o              
O     .o       o     o     O              
oOooOO'  .oOo. OoOo. OoOo. o  .oOo. .oOo  
o        OooO' O   o O   o O  OooO' `Ooo. 
O        O     o   O o   O o  O         O 
o'       `OoO' `OoO' `OoO' Oo `OoO' `OoO' 
                                          
                                          
```


Pepper.flf
```
  _              
 /_/_  _  _  _  _
/  /_'/_//_//_'/ 
     /  /        
```


Poison.flf
```
                                                       
@@@@@@@    @@@@@@   @@@   @@@@@@    @@@@@@   @@@  @@@  
@@@@@@@@  @@@@@@@@  @@@  @@@@@@@   @@@@@@@@  @@@@ @@@  
@@!  @@@  @@!  @@@  @@!  !@@       @@!  @@@  @@!@!@@@  
!@!  @!@  !@!  @!@  !@!  !@!       !@!  @!@  !@!!@!@!  
@!@@!@!   @!@  !@!  !!@  !!@@!!    @!@  !@!  @!@ !!@!  
!!@!!!    !@!  !!!  !!!   !!@!!!   !@!  !!!  !@!  !!!  
!!:       !!:  !!!  !!:       !:!  !!:  !!!  !!:  !!!  
:!:       :!:  !:!  :!:      !:!   :!:  !:!  :!:  !:!  
 ::       ::::: ::   ::  :::: ::   ::::: ::   ::   ::  
 :         : :  :   :    :: : :     : :  :   ::    :   
                                                       
```


Puffy.flf
```
 ___             ___   ___       
(  _`\         /'___)/'___)      
| |_) ) _   _ | (__ | (__  _   _ 
| ,__/'( ) ( )| ,__)| ,__)( ) ( )
| |    | (_) || |   | |   | (_) |
(_)    `\___/'(_)   (_)   `\__, |
                          ( )_| |
                          `\___/'
```


Puzzle.flf
```
     _         _         _         _         _         _    
   _( )__    _( )__    _( )__    _( )__    _( )__    _( )__ 
 _|     _| _|     _| _|     _| _|     _| _|     _| _|     _|
(_ P _ (_ (_ U _ (_ (_ Z _ (_ (_ Z _ (_ (_ L _ (_ (_ E _ (_ 
  |_( )__|  |_( )__|  |_( )__|  |_( )__|  |_( )__|  |_( )__|
```


Pyramid.flf
```
  ^    ^    ^    ^    ^    ^    ^  
 /P\  /y\  /r\  /a\  /m\  /i\  /d\ 
<___><___><___><___><___><___><___>
```


Rammstein.flf
```
    _____                                                                            
 __|__   |__  ____    ____    __  ____    __  ______   __    ______  ____  ____   _  
|     |     ||    \  |    \  /  ||    \  /  ||   ___|_|  |_ |   ___||    ||    \ | | 
|     \     ||     \ |     \/   ||     \/   | `-.`-.|_    _||   ___||    ||     \| | 
|__|\__\  __||__|\__\|__/\__/|__||__/\__/|__||______| |__|  |______||____||__/\____| 
   |_____|                                                                           
                                                                                     
```


Rectangles.flf
```
                                         
 _____         _               _         
| __  |___ ___| |_ ___ ___ ___| |___ ___ 
|    -| -_|  _|  _| .'|   | . | | -_|_ -|
|__|__|___|___|_| |__,|_|_|_  |_|___|___|
                          |___|          
```


Red Phoenix.flf
```
__________             .___    __________ .__                             .__          
\______   \  ____    __| _/    \______   \|  |__    ____    ____    ____  |__|___  ___ 
 |       _/_/ __ \  / __ |      |     ___/|  |  \  /  _ \ _/ __ \  /    \ |  |\  \/  / 
 |    |   \\  ___/ / /_/ |      |    |    |   Y  \(  <_> )\  ___/ |   |  \|  | >    <  
 |____|_  / \___  >\____ |      |____|    |___|  / \____/  \___  >|___|  /|__|/__/\_ \ 
        \/      \/      \/                     \/              \/      \/           \/ 
                                                                                       
```


red_phoenix.flf
```
                      .___                  .__                                 .__           
_______    ____     __| _/         ______   |  |__     ____     ____     ____   |__| ___  ___ 
\_  __ \ _/ __ \   / __ |          \____ \  |  |  \   /  _ \  _/ __ \   /    \  |  | \  \/  / 
 |  | \/ \  ___/  / /_/ |          |  |_> > |   Y  \ (  <_> ) \  ___/  |   |  \ |  |  >    <  
 |__|     \___  > \____ |   ______ |   __/  |___|  /  \____/   \___  > |___|  / |__| /__/\_ \ 
              \/       \/  /_____/ |__|          \/                \/       \/             \/ 
                                                                                              
```


Relief2.flf
```
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
//////// \\///////// \/// \\\\\\\///// \///////// \///////// \\/////// \
/// \\/// \/// \\\\\\\/// \\\\\\\\/// \\/// \\\\\\\/// \\\\\\\/// \/// \
//////// \\/////// \\\/// \\\\\\\\/// \\/////// \\\/////// \\\\\\/// \\\
/// \\/// \/// \\\\\\\/// \\\\\\\\/// \\/// \\\\\\\/// \\\\\\\\/// \\\\\
/// \\/// \///////// \///////// \///// \///////// \/// \\\\\\\//////// \
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
```


Relief.flf
```
______________________________________________________________
/~~~~~~~\__/~~~~~~~~\_/~~\_______/~~~~\_/~~~~~~~~\_/~~~~~~~~\_
/~~\__/~~\_/~~\_______/~~\________/~~\__/~~\_______/~~\_______
/~~~~~~~\__/~~~~~~\___/~~\________/~~\__/~~~~~~\___/~~~~~~\___
/~~\__/~~\_/~~\_______/~~\________/~~\__/~~\_______/~~\_______
/~~\__/~~\_/~~~~~~~~\_/~~~~~~~~\_/~~~~\_/~~~~~~~~\_/~~\_______
______________________________________________________________
```


Reverse.flf
```
======================================================
=       ==============================================
=  ====  =============================================
=  ====  =============================================
=  ===   ===   ===  =  ===   ===  =   ====   ====   ==
=      ====  =  ==  =  ==  =  ==    =  ==  =  ==  =  =
=  ====  ==     ===   ===     ==  ========  ====     =
=  ====  ==  ======   ===  =====  =========  ===  ====
=  ====  ==  =  ==== ====  =  ==  =======  =  ==  =  =
=  ====  ===   ===== =====   ===  ========   ====   ==
======================================================
```


rev.flf
```
=======================
=======================
=======================
=======================
=  =   ====   ===  =  =
=    =  ==  =  ==  =  =
=  =======     ===   ==
=  =======  ======   ==
=  =======  =  ==== ===
=  ========   ===== ===
=======================
```


Roman.flf
```
ooooooooo.                                                     
`888   `Y88.                                                   
 888   .d88'  .ooooo.  ooo. .oo.  .oo.    .oooo.   ooo. .oo.   
 888ooo88P'  d88' `88b `888P"Y88bP"Y88b  `P  )88b  `888P"Y88b  
 888`88b.    888   888  888   888   888   .oP"888   888   888  
 888  `88b.  888   888  888   888   888  d8(  888   888   888  
o888o  o888o `Y8bod8P' o888o o888o o888o `Y888""8o o888o o888o 
                                                               
                                                               
                                                               
```


Rot13.flf
```
Ebg13
```


Rotated.flf
```
____   _    _,_ _     _,_  _    _  
_/(_) (_)  ( '  _|)  ( '  (|)  (_)_
                                   
```


Rounded.flf
```
 ______                       _           _ 
(_____ \                     | |         | |
 _____) )___  _   _ ____   __| |_____  __| |
|  __  // _ \| | | |  _ \ / _  | ___ |/ _  |
| |  \ \ |_| | |_| | | | ( (_| | ____( (_| |
|_|   |_\___/|____/|_| |_|\____|_____)\____|
                                            
```


Rowan Cap.flf
```
    dMMMMb  .aMMMb  dMP dMP dMP .aMMMb  dMMMMb        .aMMMb  .aMMMb  dMMMMb 
   dMP.dMP dMP"dMP dMP dMP dMP dMP"dMP dMP dMP       dMP"VMP dMP"dMP dMP.dMP 
  dMMMMK" dMP dMP dMP dMP dMP dMMMMMP dMP dMP       dMP     dMMMMMP dMMMMP"  
 dMP"AMF dMP.aMP dMP.dMP.dMP dMP dMP dMP dMP       dMP.aMP dMP dMP dMP       
dMP dMP  VMMMP"  VMMMPVMMP" dMP dMP dMP dMP        VMMMP" dMP dMP dMP        
                                                                             
```


rowancap.flf
```
    dMMMMb  .aMMMb  dMP dMP dMP .aMMMb  dMMMMb  .aMMMb  .aMMMb  dMMMMb 
   dMP.dMP dMP"dMP dMP dMP dMP dMP"dMP dMP dMP dMP"VMP dMP"dMP dMP.dMP 
  dMMMMK" dMP dMP dMP dMP dMP dMMMMMP dMP dMP dMP     dMMMMMP dMMMMP"  
 dMP"AMF dMP.aMP dMP.dMP.dMP dMP dMP dMP dMP dMP.aMP dMP dMP dMP       
dMP dMP  VMMMP"  VMMMPVMMP" dMP dMP dMP dMP  VMMMP" dMP dMP dMP        
                                                                       
```


Rozzo.flf
```
888 88e                                    
888 888D  e88 88e  8P d8P 8P d8P  e88 88e  
888 88"  d888 888b P d8P  P d8P  d888 888b 
888 b,   Y888 888P  d8P d  d8P d Y888 888P 
888 88b,  "88 88"  d8P d8 d8P d8  "88 88"  
                                           
                                           
```


Runic.flf
```
|~\  
|  \ 
|  / 
|_/  
| \  
|  \ 
```


Runyc.flf
```
|~\                 
|  \                
|  /                
|_/  |\   |  |~\ |  
| \  | | `|  |_| |  
|  \ | |  |` ||| |\ 
```


Santa Clara.flf
```
  __,                        ,___ _             
 (               _/_        /   ///             
  `.  __,  _ _   /  __,    /    // __,  _   __, 
(___)(_/(_/ / /_(__(_/(_  (___/(/_(_/(_/ (_(_/(_
                                                
                                                
```


santaclara.flf
```
                             _             
                _/_         //             
 (   __,  _ _   /  __,  _, // __,  _   __, 
/_)_(_/(_/ / /_(__(_/(_(__(/_(_/(_/ (_(_/(_
                                           
                                           
```


S Blood.flf
```
  @@@@@@      @@@@@@@  @@@       @@@@@@   @@@@@@  @@@@@@@ 
 !@@          @@!  @@@ @@!      @@!  @@@ @@!  @@@ @@!  @@@
  !@@!!       @!@!@!@  @!!      @!@  !@! @!@  !@! @!@  !@!
     !:!      !!:  !!! !!:      !!:  !!! !!:  !!! !!:  !!!
 ::.: :       :: : ::  : ::.: :  : :. :   : :. :  :: :  : 
                                                          
```


sblood.flf
```
  @@@@@@ @@@@@@@  @@@       @@@@@@   @@@@@@  @@@@@@@ 
 !@@     @@!  @@@ @@!      @@!  @@@ @@!  @@@ @@!  @@@
  !@@!!  @!@!@!@  @!!      @!@  !@! @!@  !@! @!@  !@!
     !:! !!:  !!! !!:      !!:  !!! !!:  !!! !!:  !!!
 ::.: :  :: : ::  : ::.: :  : :. :   : :. :  :: :  : 
                                                     
```


Script.flf
```
                           
  ()            o          
  /\  __   ,_        _ _|_ 
 /  \/    /  |  |  |/ \_|  
/(__/\___/   |_/|_/|__/ |_/
                  /|       
                  \|       
```


Serifcap.flf
```
 ___  ___  ___   __  ___   __   __   ___ 
/ __)(  _)(  ,) (  )(  _) / _) (  ) (  ,\
\__ \ ) _) )  \  )(  ) _)( (_  /__\  ) _/
(___/(___)(_)\_)(__)(_)   \__)(_)(_)(_)  
```


Shadow.flf
```
  ___|  |               |                
\___ \  __ \   _` |  _` |  _ \\ \  \   / 
      | | | | (   | (   | (   |\ \  \ /  
_____/ _| |_|\__,_|\__,_|\___/  \_/\_/   
                                         
```


Shimrod.flf
```
 ,-.  .                     . 
(   ` |   o                 | 
 `-.  |-. . ;-.-. ;-. ,-. ,-| 
.   ) | | | | | | |   | | | | 
 `-'  ' ' ' ' ' ' '   `-' `-' 
                              
```


Short.flf
```
(`|_    |-
_)||()|`|_
          
```


Slant.flf
```
   _____ __            __ 
  / ___// /___ _____  / /_
  \__ \/ / __ `/ __ \/ __/
 ___/ / / /_/ / / / / /_  
/____/_/\__,_/_/ /_/\__/  
                          
```


Slant Relief.flf
```
_____/\\\\\\\\\\\____/\\\\\\_______________________________________________        
 ___/\\\/////////\\\_\////\\\_______________________________________________       
  __\//\\\______\///_____\/\\\_____________________________________/\\\______      
   ___\////\\\____________\/\\\_____/\\\\\\\\\_____/\\/\\\\\\____/\\\\\\\\\\\_     
    ______\////\\\_________\/\\\____\////////\\\___\/\\\////\\\__\////\\\////__    
     _________\////\\\______\/\\\______/\\\\\\\\\\__\/\\\__\//\\\____\/\\\______   
      __/\\\______\//\\\_____\/\\\_____/\\\/////\\\__\/\\\___\/\\\____\/\\\_/\\__  
       _\///\\\\\\\\\\\/____/\\\\\\\\\_\//\\\\\\\\/\\_\/\\\___\/\\\____\//\\\\\___ 
        ___\///////////_____\/////////___\////////\//__\///____\///______\/////____
____/\\\\\\\\\_____________________/\\\\\\________________________________/\\\\\_        
 __/\\\///////\\\__________________\////\\\______________________________/\\\///__       
  _\/\\\_____\/\\\_____________________\/\\\_____/\\\____________________/\\\______      
   _\/\\\\\\\\\\\/________/\\\\\\\\_____\/\\\____\///______/\\\\\\\\___/\\\\\\\\\___     
    _\/\\\//////\\\______/\\\/////\\\____\/\\\_____/\\\___/\\\/////\\\_\////\\\//____    
     _\/\\\____\//\\\____/\\\\\\\\\\\_____\/\\\____\/\\\__/\\\\\\\\\\\_____\/\\\______   
      _\/\\\_____\//\\\__\//\\///////______\/\\\____\/\\\_\//\\///////______\/\\\______  
       _\/\\\______\//\\\__\//\\\\\\\\\\__/\\\\\\\\\_\/\\\__\//\\\\\\\\\\____\/\\\______ 
        _\///________\///____\//////////__\/////////__\///____\//////////_____\///_______
```


Slide.flf
```
 #HH||#| #|   H|      
##    #|      H| #H|  
 #HH| #| #| #HH|##HH| 
    ||#| #|## H|##    
##HH| #H|#H|#HH| #HH| 
                      
```


SL Script.flf
```
  ()     _    ()                   
  /\   _//    /\                _/_
 /  )  /     /  )  _. __  o _   /  
/__/__/___  /__/__(__/ (_<_/_)_<__ 
                          /        
                         '         
```


slscript.flf
```
       _                    
      //                 _/_
 _   // _   _. __  o _   /  
/_)_</_/_)_(__/ (_<_/_)_<__ 
                   /        
                  '         
```


Small Caps.flf
```
  ___   _   _    _    _      _        ___    _    ____    ___  
 (  _( ) \_/ (  )_\  ) |    ) |      / _(   )_\  )  _)\  (  _( 
 _) \  |  _  | /( )\ | (__  | (__    ))_   /( )\ | '__/  _) \  
)____) )_( )_()_/ \_()____( )____(   \__( )_/ \_()_(    )____) 
                                                               
```


smallcaps.flf
```
  ___   _   _    _    _      _      ___    _    ____    ___  
 (  _( ) \_/ (  )_\  ) |    ) |    / _(   )_\  )  _)\  (  _( 
 _) \  |  _  | /( )\ | (__  | (__  ))_   /( )\ | '__/  _) \  
)____) )_( )_()_/ \_()____( )____( \__( )_/ \_()_(    )____) 
                                                             
```


Small.flf
```
 ___            _ _ 
/ __|_ __  __ _| | |
\__ \ '  \/ _` | | |
|___/_|_|_\__,_|_|_|
                    
```


Small Isometric1.flf
```
    ___       ___       ___       ___       ___            ___       ___       ___       ___       ___       ___       ___       ___       ___   
   /\  \     /\__\     /\  \     /\__\     /\__\          /\  \     /\  \     /\  \     /\__\     /\  \     /\  \     /\  \     /\  \     /\  \  
  /::\  \   /::L_L_   /::\  \   /:/  /    /:/  /         _\:\  \   /::\  \   /::\  \   /::L_L_   /::\  \    \:\  \   /::\  \   _\:\  \   /::\  \ 
 /\:\:\__\ /:/L:\__\ /::\:\__\ /:/__/    /:/__/         /\/::\__\ /\:\:\__\ /:/\:\__\ /:/L:\__\ /::\:\__\   /::\__\ /::\:\__\ /\/::\__\ /:/\:\__\
 \:\:\/__/ \/_/:/  / \/\::/  / \:\  \    \:\  \         \::/\/__/ \:\:\/__/ \:\/:/  / \/_/:/  / \:\:\/  /  /:/\/__/ \;:::/  / \::/\/__/ \:\ \/__/
  \::/  /    /:/  /    /:/  /   \:\__\    \:\__\         \:\__\    \::/  /   \::/  /    /:/  /   \:\/  /   \/__/     |:\/__/   \:\__\    \:\__\  
   \/__/     \/__/     \/__/     \/__/     \/__/          \/__/     \/__/     \/__/     \/__/     \/__/               \|__|     \/__/     \/__/  
```


Small Keyboard.flf
```
 ____ ____ ____ ____ ____ _________ ____ ____ ____ ____ ____ ____ ____ ____ 
||S |||m |||a |||l |||l |||       |||K |||e |||y |||b |||o |||a |||r |||d ||
||__|||__|||__|||__|||__|||_______|||__|||__|||__|||__|||__|||__|||__|||__||
|/__\|/__\|/__\|/__\|/__\|/_______\|/__\|/__\|/__\|/__\|/__\|/__\|/__\|/__\|
```


Small Poison.flf
```
                                                                                                  
 @@@@@@ @@@@@@@@@@   @@@@@@  @@@      @@@         @@@@@@@   @@@@@@  @@@  @@@@@@  @@@@@@  @@@  @@@ 
!@@     @@! @@! @@! @@!  @@@ @@!      @@!         @@!  @@@ @@!  @@@ @@! !@@     @@!  @@@ @@!@!@@@ 
 !@@!!  @!! !!@ @!@ @!@!@!@! @!!      @!!         @!@@!@!  @!@  !@! !!@  !@@!!  @!@  !@! @!@@!!@! 
    !:! !!:     !!: !!:  !!! !!:      !!:         !!:      !!:  !!! !!:     !:! !!:  !!! !!:  !!! 
::.: :   :      :    :   : : : ::.: : : ::.: :     :        : :. :  :   ::.: :   : :. :  ::    :  
                                                                                                  
```


Small Script.flf
```
                                                
 ()          _,  |\ |\     ()  _   ,_  o    _|_ 
 /\ /|/|/|  / |  |/ |/     /\ /   /  | | |/\_|  
/(_) | | |_/\/|_/|_/|_/   /(_)\__/   |/|/|_/ |_/
                                        (|      
```


Small Shadow.flf
```
  __|             | |   __| |              |              
\__ \  ` \   _` | | | \__ \   \   _` |  _` |  _ \\ \  \ / 
____/_|_|_|\__,_|_|_| ____/_| _|\__,_|\__,_|\___/ \_/\_/  
                                                          
```


Small Slant.flf
```
   ____           ____  ______          __ 
  / __/_ _  ___ _/ / / / __/ /__ ____  / /_
 _\ \/  ' \/ _ `/ / / _\ \/ / _ `/ _ \/ __/
/___/_/_/_/\_,_/_/_/ /___/_/\_,_/_//_/\__/ 
                                           
```


Small Tengwar.flf
```
 _   _ _  .',           _  ,'  _ _  _____     .',    
( ) |_)_)  |  --- ---  | )  | | ) ) (_(_| |~)  |  \/ 
 /            (_, (_,  |                | ~~~     (, 
```


smisome1.flf
```
    ___       ___       ___       ___       ___       ___       ___   
   /\  \     /\__\     /\  \     /\  \     /\  \     /\__\     /\  \  
  /::\  \   /::L_L_   _\:\  \   /::\  \   /::\  \   /::L_L_   /::\  \ 
 /\:\:\__\ /:/L:\__\ /\/::\__\ /\:\:\__\ /:/\:\__\ /:/L:\__\ /::\:\__\
 \:\:\/__/ \/_/:/  / \::/\/__/ \:\:\/__/ \:\/:/  / \/_/:/  / \:\:\/  /
  \::/  /    /:/  /   \:\__\    \::/  /   \::/  /    /:/  /   \:\/  / 
   \/__/     \/__/     \/__/     \/__/     \/__/     \/__/     \/__/  
```


smkeyboard.flf
```
 ____ ____ ____ ____ ____ ____ ____ ____ ____ ____ 
||s |||m |||k |||e |||y |||b |||o |||a |||r |||d ||
||__|||__|||__|||__|||__|||__|||__|||__|||__|||__||
|/__\|/__\|/__\|/__\|/__\|/__\|/__\|/__\|/__\|/__\|
```


smpoison.flf
```
                                                                    
 @@@@@@ @@@@@@@@@@  @@@@@@@   @@@@@@  @@@  @@@@@@  @@@@@@  @@@  @@@ 
!@@     @@! @@! @@! @@!  @@@ @@!  @@@ @@! !@@     @@!  @@@ @@!@!@@@ 
 !@@!!  @!! !!@ @!@ @!@@!@!  @!@  !@! !!@  !@@!!  @!@  !@! @!@@!!@! 
    !:! !!:     !!: !!:      !!:  !!! !!:     !:! !!:  !!! !!:  !!! 
::.: :   :      :    :        : :. :  :   ::.: :   : :. :  ::    :  
                                                                    
```


smscript.flf
```
                                  
 ,           ,   _   ,_  o    _|_ 
/ \_/|/|/|  / \_/   /  | | |/\_|  
 \/  | | |_/ \/ \__/   |/|/|_/ |_/
                          (|      
```


smshadow.flf
```
               |              |              
(_-<  ` \ (_-<   \   _` |  _` |  _ \\ \  \ / 
___/_|_|_|___/_| _|\__,_|\__,_|\___/ \_/\_/  
                                             
```


smslant.flf
```
                 __          __ 
  ___ __ _  ___ / /__ ____  / /_
 (_-</  ' \(_-</ / _ `/ _ \/ __/
/___/_/_/_/___/_/\_,_/_//_/\__/ 
                                
```


smtengwar.flf
```
     _ _      ,'  _ _  _____     .',    
(~) |_)_) |~)  | | ) ) (_(_| |~)  |  \/ 
 /        |                | ~~~     (, 
```


Soft.flf
```
                              
 ,---.          ,---.  ,--.   
'   .-'  ,---. /  .-',-'  '-. 
`.  `-. | .-. ||  `-,'-.  .-' 
.-'    |' '-' '|  .-'  |  |   
`-----'  `---' `--'    `--'   
                              
```


Speed.flf
```
________                 _________
__  ___/_______________________  /
_____ \___  __ \  _ \  _ \  __  / 
____/ /__  /_/ /  __/  __/ /_/ /  
/____/ _  .___/\___/\___/\__,_/   
       /_/                        
```


Spliff.flf
```
 _____  _____  ____   ___  _____  _____ 
/  ___>/  _  \/  _/  /___\/   __\/   __\
|___  ||   __/|  |---|   ||   __||   __|
<_____/\__/   \_____/\___/\__/   \__/   
                                        
```


s-relief.flf
```
__________________________________________________________/\\\\\\________________________________/\\\\\_        
 _________________________________________________________\////\\\______________________________/\\\///__       
  ____________________________________________________________\/\\\_____/\\\____________________/\\\______      
   __/\\\\\\\\\\__/\\\\\\\\\\\__/\\/\\\\\\\______/\\\\\\\\_____\/\\\____\///______/\\\\\\\\___/\\\\\\\\\___     
    _\/\\\//////__\///////////__\/\\\/////\\\___/\\\/////\\\____\/\\\_____/\\\___/\\\/////\\\_\////\\\//____    
     _\/\\\\\\\\\\_______________\/\\\___\///___/\\\\\\\\\\\_____\/\\\____\/\\\__/\\\\\\\\\\\_____\/\\\______   
      _\////////\\\_______________\/\\\_________\//\\///////______\/\\\____\/\\\_\//\\///////______\/\\\______  
       __/\\\\\\\\\\_______________\/\\\__________\//\\\\\\\\\\__/\\\\\\\\\_\/\\\__\//\\\\\\\\\\____\/\\\______ 
        _\//////////________________\///____________\//////////__\/////////__\///____\//////////_____\///_______
```


Stacey.flf
```
___________________________________________
7     77      77  _  77     77     77  7  7
|  ___!!__  __!|  _  ||  ___!|  ___!|  !  |
!__   7  7  7  |  7  ||  7___|  __|_!_   _!
7     |  |  |  |  |  ||     7|     7 7   7 
!_____!  !__!  !__!__!!_____!!_____! !___! 
                                           
```


Stampate.flf
```
.---. .                    .      
\___  |- ,-. ,-,-. ,-. ,-. |- ,-. 
    \ |  ,-| | | | | | ,-| |  |-' 
`---' `' `-^ ' ' ' |-' `-^ `' `-' 
                   |              
                   '              
```


Stampatello.flf
```
.---. .                    .      .  .      
\___  |- ,-. ,-,-. ,-. ,-. |- ,-. |  |  ,-. 
    \ |  ,-| | | | | | ,-| |  |-' |  |  | | 
`---' `' `-^ ' ' ' |-' `-^ `' `-' `' `' `-' 
                   |                        
                   '                        
```


Standard.flf
```
 ____  _                  _               _ 
/ ___|| |_ __ _ _ __   __| | __ _ _ __ __| |
\___ \| __/ _` | '_ \ / _` |/ _` | '__/ _` |
 ___) | || (_| | | | | (_| | (_| | | | (_| |
|____/ \__\__,_|_| |_|\__,_|\__,_|_|  \__,_|
                                            
```


Star Strips.flf
```
------------ ------------    ------    -----------       ------------ ------------ -----------  --------  -----------  ------------ 
************ ************   ********   ***********       ************ ************ ***********  ********  ************ ************ 
----         ------------  ----------  ----    ---       ----         ------------ ----    ---    ----    ---      --- ----         
************     ****     ****    **** *********         ************     ****     *********      ****    ************ ************ 
------------     ----     ------------ ---------         ------------     ----     ---------      ----    -----------  ------------ 
       *****     ****     ************ ****  ****               *****     ****     ****  ****     ****    ****                ***** 
------------     ----     ----    ---- ----   ----       ------------     ----     ----   ----  --------  ----         ------------ 
************     ****     ****    **** ****    ****      ************     ****     ****    **** ********  ****         ************ 
                                                                                                                                    
```


starstrips.flf
```
------------------------  ------   ----------- ----------------------------------- ------------------- ------------
************************ ********  *********** *********************************** ********************************
----        ---------------------- ----    --- ----        ----------------    ---   ----  ---      -------        
************    ****   ****    *************   ************    ****    *********     ****  ************************
------------    ----   ---------------------   ------------    ----    ---------     ----  ----------- ------------
       *****    ****   ****************  ****         *****    ****    ****  ****    ****  ****               *****
------------    ----   ----    --------   ---- ------------    ----    ----   ---- ------------        ------------
************    ****   ****    ********    ****************    ****    ****    ****************        ************
                                                                                                                   
```


Star Wars.flf
```
     _______.___________.    ___      .______         ____    __    ____  ___      .______          _______.
    /       |           |   /   \     |   _  \        \   \  /  \  /   / /   \     |   _  \        /       |
   |   (----`---|  |----`  /  ^  \    |  |_)  |        \   \/    \/   / /  ^  \    |  |_)  |      |   (----`
    \   \       |  |      /  /_\  \   |      /          \            / /  /_\  \   |      /        \   \    
.----)   |      |  |     /  _____  \  |  |\  \----.      \    /\    / /  _____  \  |  |\  \----.----)   |   
|_______/       |__|    /__/     \__\ | _| `._____|       \__/  \__/ /__/     \__\ | _| `._____|_______/    
                                                                                                            
```


starwars.flf
```
     _______.___________.    ___      .______     ____    __    ____  ___      .______          _______.
    /       |           |   /   \     |   _  \    \   \  /  \  /   / /   \     |   _  \        /       |
   |   (----`---|  |----`  /  ^  \    |  |_)  |    \   \/    \/   / /  ^  \    |  |_)  |      |   (----`
    \   \       |  |      /  /_\  \   |      /      \            / /  /_\  \   |      /        \   \    
.----)   |      |  |     /  _____  \  |  |\  \----.  \    /\    / /  _____  \  |  |\  \----.----)   |   
|_______/       |__|    /__/     \__\ | _| `._____|   \__/  \__/ /__/     \__\ | _| `._____|_______/    
                                                                                                        
```


Stellar.flf
```
  `.. ..    `..             `.. `..                 
`..    `..  `..             `.. `..                 
 `..      `.`. `.   `..     `.. `..   `..    `. `...
   `..      `..   `.   `..  `.. `.. `..  `..  `..   
      `..   `..  `..... `.. `.. `..`..   `..  `..   
`..    `..  `..  `.         `.. `..`..   `..  `..   
  `.. ..     `..   `....   `...`...  `.. `...`...   
                                                    
```


stencil.flf
```
   .=#@@-.%@#=#%  -@@@% *@@@@@@* @@@@- *@@@@@@@.=@@@@@+  *@@@@@@@@*   -@@@@@*     .=#%@-:%%*=%#  +@@@@@@@@=  *@@@@@@@@-      
  =@@@#.   -#@@@  -@@#. *@@@@@@* .#@@-  +@@@@@@: .:*@@+   .#@@@@@@@*    *@%:     +@@@@:  .=@@@%   -@@@@@@-    +@@@@@@:       
 =@@@@*      +@@  -@@   *@@@@@@*  .@@-  =@@@@@@:    =@+     +@@@@@@@#   .@+     #@@@@*     .%@%   :@@@@@@:    =@@@@@@.       
 %@@@@@%+-.   ##  :%+   *@@@@@@*   +%:  =@@@@@@:  =# -.    +:=@@@@@@@%. .@+    *@@@@@#      :@%   -@@@@@@:    =@@@@@@.       
 *@@@@@@@@@%*-          *@@@@@@*        =@@@@@@: -@@       *@ =@@@@@@@%. @+   .@@@@@@#       --   -@@@@@@:    =@@@@@@.       
 .#@@@@@@@@@@@%-        *@@@@@@*        =@@@@@@.=@@%       *@. -@@@@@@@@:=+   =@@@@@@#            -@@@@@@:    =@@@@@@.       
   -#@@@@@@@@@@@-       *@@@@@@*        =@@@@@@: -@@       *@   :@@@@@@@@-    -@@@@@@#            -@@@@@@:    =@@@@@@.       
 +*  .-+#@@@@@@@#       *@@@@@@*        =@@@@@@:  =# ..    *@    .%@@@@@@@-   .@@@@@@#            -@@@@@@:    =@@@@@@.    =* 
 %@+      -%@@@@+       *@@@@@@*        =@@@@@@:    .@#    *@     .#@@@@@@+    +@@@@@*       ##   -@@@@@@:    =@@@@@@.   .@@ 
 #@@+      *@@@#        *@@@@@@*        =@@@@@@:   =@@*    %@-      #@@@@@+     *@@@@#     .#@-   :@@@@@@:    =@@@@@@.  :%@@ 
 %@@@@*: +%@@#-       .*@@@@@@@@*.     +@@@@@@@.-#@@@@#  +@@@@*.     *@@@@+      :*@@@#..+#@#.   =%@@@@@@%-  +@@@@@@@.=%@@@@ 
 :- .-+- +=:.          -:::::::::      :::::::: .-::::.  ::::::       ::::.         :-+:.+-.     .::::::::.  :::::::: :-::::                                       
```


Stforek.flf
```
  __ _____ ___ __  ___ ___ _  __ 
/' _/_   _| __/__\| _ \ __| |/ / 
`._`. | | | _| \/ | v / _||   <  
|___/ |_| |_| \__/|_|_\___|_|\_\ 
```


Stick Letters.flf
```
 __  ___    __                ___ ___ ___  ___  __   __  
/__`  |  | /  ` |__/    |    |__   |   |  |__  |__) /__` 
.__/  |  | \__, |  \    |___ |___  |   |  |___ |  \ .__/ 
                                                         
```


Stop.flf
```
    _                    
   | |   _               
    \ \ | |_  ___  ____  
     \ \|  _)/ _ \|  _ \ 
 _____) ) |_| |_| | | | |
(______/ \___)___/| ||_/ 
                  |_|    
```


Straight.flf
```
 __                 
(_ |_ _ _ . _ |_ |_ 
__)|_| (_||(_)| )|_ 
           _/       
```


Stronger Than All.flf
```
._____________._.______  ._______  .______  ._____  ._______.______       _____._.___.__  .______  .______       .______  .___    .___    
|    ___/\__ _:|: __   \ : .___  \ :      \ :_ ___\ : .____/: __   \      \__ _:|:   |  \ :      \ :      \      :      \ |   |   |   |   
|___    \  |  :||  \____|| :   |  ||       ||   |___| : _/\ |  \____|       |  :||   :   ||   .   ||       |     |   .   ||   |   |   |   
|       /  |   ||   :  \ |     :  ||   |   ||   /  ||   /  \|   :  \        |   ||   .   ||   :   ||   |   |     |   :   ||   |/\ |   |/\ 
|__:___/   |   ||   |___\ \_. ___/ |___|   ||. __  ||_.: __/|   |___\       |   ||___|   ||___|   ||___|   |     |___|   ||   /  \|   /  \
   :       |___||___|       :/         |___| :/ |. |   :/   |___|           |___|    |___|    |___|    |___|         |___||______/|______/
                            :                :   :/                                                                                       
                                                 :                                                                                        
                                                                                                                                          
```


Sub-Zero.flf
```
 ______     __  __     ______     ______     ______     ______     ______    
/\  ___\   /\ \/\ \   /\  == \   /\___  \   /\  ___\   /\  == \   /\  __ \   
\ \___  \  \ \ \_\ \  \ \  __<   \/_/  /__  \ \  __\   \ \  __<   \ \ \/\ \  
 \/\_____\  \ \_____\  \ \_____\   /\_____\  \ \_____\  \ \_\ \_\  \ \_____\ 
  \/_____/   \/_____/   \/_____/   \/_____/   \/_____/   \/_/ /_/   \/_____/ 
                                                                             
```


Swamp Land.flf
```
 ______   __ __ __   ________   ___ __ __   ______     __       ________   ___   __    ______      
/_____/\ /_//_//_/\ /_______/\ /__//_//_/\ /_____/\   /_/\     /_______/\ /__/\ /__/\ /_____/\     
\::::_\/_\:\\:\\:\ \\::: _  \ \\::\| \| \ \\:::_ \ \  \:\ \    \::: _  \ \\::\_\\  \ \\:::_ \ \    
 \:\/___/\\:\\:\\:\ \\::(_)  \ \\:.      \ \\:(_) \ \  \:\ \    \::(_)  \ \\:. `-\  \ \\:\ \ \ \   
  \_::._\:\\:\\:\\:\ \\:: __  \ \\:.\-/\  \ \\: ___\/   \:\ \____\:: __  \ \\:. _    \ \\:\ \ \ \  
    /____\:\\:\\:\\:\ \\:.\ \  \ \\. \  \  \ \\ \ \      \:\/___/\\:.\ \  \ \\. \`-\  \ \\:\/.:| | 
    \_____\/ \_______\/ \__\/\__\/ \__\/ \__\/ \_\/       \_____\/ \__\/\__\/ \__\/ \__\/ \____/_/ 
                                                                                                   
```


swampland.flf
```
 ______   __ __ __   ________   ___ __ __   ______   __       ________   ___   __    ______      
/_____/\ /_//_//_/\ /_______/\ /__//_//_/\ /_____/\ /_/\     /_______/\ /__/\ /__/\ /_____/\     
\::::_\/_\:\\:\\:\ \\::: _  \ \\::\| \| \ \\:::_ \ \\:\ \    \::: _  \ \\::\_\\  \ \\:::_ \ \    
 \:\/___/\\:\\:\\:\ \\::(_)  \ \\:.      \ \\:(_) \ \\:\ \    \::(_)  \ \\:. `-\  \ \\:\ \ \ \   
  \_::._\:\\:\\:\\:\ \\:: __  \ \\:.\-/\  \ \\: ___\/ \:\ \____\:: __  \ \\:. _    \ \\:\ \ \ \  
    /____\:\\:\\:\\:\ \\:.\ \  \ \\. \  \  \ \\ \ \    \:\/___/\\:.\ \  \ \\. \`-\  \ \\:\/.:| | 
    \_____\/ \_______\/ \__\/\__\/ \__\/ \__\/ \_\/     \_____\/ \__\/\__\/ \__\/ \__\/ \____/_/ 
                                                                                                 
```


Swan.flf
```
                        
                        
 .-.                    
(   )                   
 `-..  .    ._.-.  .--. 
(   )\  \  / (   ) |  | 
 `-'  `' `'   `-'`-'  `-
                        
                        
```


Sweet.flf
```
                                              ___      
                                             (   )     
    .--.     ___  ___  ___   .--.     .--.    | |_     
  /  _  \   (   )(   )(   ) /    \   /    \  (   __)   
 . .' `. ;   | |  | |  | | |  .-. ; |  .-. ;  | |      
 | '   | |   | |  | |  | | |  | | | |  | | |  | | ___  
 _\_`.(___)  | |  | |  | | |  |/  | |  |/  |  | |(   ) 
(   ). '.    | |  | |  | | |  ' _.' |  ' _.'  | | | |  
 | |  `\ |   | |  ; '  | | |  .'.-. |  .'.-.  | ' | |  
 ; '._,' '   ' `-'   `-' ' '  `-' / '  `-' /  ' `-' ;  
  '.___.'     '.__.'.__.'   `.__.'   `.__.'    `.__.   
                                                       
                                                       
```


Tanja.flf
```
T)tttttt                      ##         
   T)                                    
   T)    a)AAAA  n)NNNN       j) a)AAAA  
   T)     a)AAA  n)   NN      j)  a)AAA  
   T)    a)   A  n)   NN      j) a)   A  
   T)     a)AAAA n)   NN      j)  a)AAAA 
                         j)   JJ         
                          j)JJJ          
```


Tengwar.flf
```
             .dP'                                               db               
           dP'                                               db    db            
                                 "Ybaaaaaaaaad8'                                 
`Yb.d888b   'Yb   `Yb d88b d88b   .dP'  dP'  88  `Yb d888b     'Yb    `Yb    dP' 
 88'    8Y   88    88P   8Y   8b  88   88    88   88P    88     88      Yb  dP   
 88     8P   88    88    8P   88  Y8   Y8   .88   88     8P     88       YbdP    
 88   ,dP   .8P   .8P  bdP  bdP   `Y88P`Y88P'88   88   .dP     .8P       .8P     
 88                                          88  .88888888b.           dP'  b    
 88                                          88                        Y.  ,P    
.8P                                          Y8.                        `""'     
```


Term.flf
```
Term
```


Test1.flf
```
 _________  __________ __________ _________ 
/__     __\/   /_____//_________//__     __\
`%%|___|%%'\___\%%%%%'`%%%%%%%%%/`%%|___|%%'
    `B'     `BBBBBBBB'`BBBBBBBB'     `B'    
```


The Edge.flf
```
   ▄▄▄▄▀ ▄  █ ▄███▄       ▄███▄   ██▄     ▄▀  ▄███▄   
▀▀▀ █   █   █ █▀   ▀      █▀   ▀  █  █  ▄▀    █▀   ▀  
    █   ██▀▀█ ██▄▄        ██▄▄    █   █ █ ▀▄  ██▄▄    
   █    █   █ █▄   ▄▀     █▄   ▄▀ █  █  █   █ █▄   ▄▀ 
  ▀        █  ▀███▀       ▀███▀   ███▀   ███  ▀███▀   
          ▀                                           
                                                      
```


Thick.flf
```
88888 8     w      8    
  8   8d8b. w .d8b 8.dP 
  8   8P Y8 8 8    88b  
  8   8   8 8 `Y8P 8 Yb 
                        
```


Thin.flf
```
                
--.--|    o     
  |  |---..,---.
  |  |   |||   |
  `  `   '``   '
                
```


THIS.flf
```
 ▄▀▀▀█▀▀▄  ▄▀▀▄ ▄▄   ▄▀▀█▀▄   ▄▀▀▀▀▄ 
█    █  ▐ █  █   ▄▀ █   █  █ █ █   ▐ 
▐   █     ▐  █▄▄▄█  ▐   █  ▐    ▀▄   
   █         █   █      █    ▀▄   █  
 ▄▀         ▄▀  ▄▀   ▄▀▀▀▀▀▄  █▀▀▀   
█          █   █    █       █ ▐      
▐          ▐   ▐    ▐       ▐        
```


Thorned.flf
```
 ___, ,  _, ,_  ,  ,  _,  ,_  
' | |_|,/ \,|_) |\ | /_,  | \,
  |'| |'\_/'| \ |'\|'\_  _|_/ 
  ' ' ` '   '  `'  `   `'     
                              
```


Three Point.flf
```
~|~|_  _ _  _   |~) _ . _ _|_
 | | || (/_(/_  |~ (_)|| | | 
                             
```


threepoint.flf
```
_|_|_  _ _  _  _  _ . _ _|_
 | | || (/_(/_|_)(_)|| | | 
              |            
```


Ticks.flf
```
_/\/\/\/\/\/\__/\/\________________/\/\___________________
_____/\/\________________/\/\/\/\__/\/\__/\/\____/\/\/\/\_
_____/\/\______/\/\____/\/\________/\/\/\/\____/\/\/\/\___
_____/\/\______/\/\____/\/\________/\/\/\/\__________/\/\_
_____/\/\______/\/\/\____/\/\/\/\__/\/\__/\/\__/\/\/\/\___
__________________________________________________________
```


Ticks Slant.flf
```
     _/\/\/\/\/\/\__/\/\________________/\/\__________________________/\/\/\/\/\__/\/\______________________________/\/\_____
    _____/\/\________________/\/\/\/\__/\/\__/\/\____/\/\/\/\______/\/\__________/\/\____/\/\/\______/\/\/\/\____/\/\/\/\/\_ 
   _____/\/\______/\/\____/\/\________/\/\/\/\____/\/\/\/\__________/\/\/\/\____/\/\________/\/\____/\/\__/\/\____/\/\_____  
  _____/\/\______/\/\____/\/\________/\/\/\/\__________/\/\______________/\/\__/\/\____/\/\/\/\____/\/\__/\/\____/\/\_____   
 _____/\/\______/\/\/\____/\/\/\/\__/\/\__/\/\__/\/\/\/\________/\/\/\/\/\____/\/\/\__/\/\/\/\/\__/\/\__/\/\____/\/\/\___    
________________________________________________________________________________________________________________________     
```


ticksslant.flf
```
     ___/\/\______/\/\________________/\/\________________________________/\/\______________________________/\/\_____
    _/\/\/\/\/\____________/\/\/\/\__/\/\__/\/\____/\/\/\/\____/\/\/\/\__/\/\____/\/\/\______/\/\/\/\____/\/\/\/\/\_ 
   ___/\/\______/\/\____/\/\________/\/\/\/\____/\/\/\/\____/\/\/\/\____/\/\________/\/\____/\/\__/\/\____/\/\_____  
  ___/\/\______/\/\____/\/\________/\/\/\/\__________/\/\________/\/\__/\/\____/\/\/\/\____/\/\__/\/\____/\/\_____   
 ___/\/\/\____/\/\/\____/\/\/\/\__/\/\__/\/\__/\/\/\/\____/\/\/\/\____/\/\/\__/\/\/\/\/\__/\/\__/\/\____/\/\/\___    
________________________________________________________________________________________________________________     
```


Tiles.flf
```
[... [......    [..                 
     [..     [. [..                 
     [..        [..   [..     [.... 
     [..    [.. [.. [.   [.. [..    
     [..    [.. [..[..... [..  [... 
     [..    [.. [..[.            [..
     [..    [..[...  [....   [.. [..
                                    
```


Tinker-Toy.flf
```
o-O-o        o                o-O-o          
  |   o      | /                |            
  |     o-o  OO   o-o o-o o-o   |   o-o o  o 
  |   | |  | | \  |-' |         |   | | |  | 
  o   | o  o o  o o-o o         o   o-o o--O 
                                           | 
                                        o--o 
```


Tombstone.flf
```
 ___  _, _, _ __,  _, ___  _, _, _ __,
  |  / \ |\/| |_) (_   |  / \ |\ | |_ 
  |  \ / |  | |_) , )  |  \ / | \| |  
  ~   ~  ~  ~ ~    ~   ~   ~  ~  ~ ~~~
                                      
```


Train.flf
```
  _____                     _            
 |_   _|    _ _   __ _     (_)    _ _    
   | |     | '_| / _` |    | |   | ' \   
  _|_|_   _|_|_  \__,_|   _|_|_  |_||_|  
_|"""""|_|"""""|_|"""""|_|"""""|_|"""""| 
"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-' 
```


Trek.flf
```
  dBBBBBBP dBBBBBb    dBBBP  dBP dBP
               dBP          d8P.dBP 
   dBP     dBBBBK   dBBP   dBBBBP   
  dBP     dBP  BB  dBP    dBP BB    
 dBP     dBP  dB' dBBBBP dBP dBP    
                                    
```


Tsalagi.flf
```
    __    __    __    ___     __     ___   ___   
 \  /    /  \  |  \    |     |  \     |_-_  |    
  \/   __\___  |   \   |     |   \ `\/\    .|()  
_ /        \   |   /   |  .  |   /  |  |  ()|'   
\/      \__/   |__/    `__'  |__/    \/    _|_   
```


Tubular.flf
```
O~~~ O~~~~~~        O~~               O~~                 
     O~~            O~~               O~~                 
     O~~    O~~  O~~O~~      O~~  O~~ O~~   O~~    O~ O~~~
     O~~    O~~  O~~O~~ O~~  O~~  O~~ O~~ O~~  O~~  O~~   
     O~~    O~~  O~~O~~   O~~O~~  O~~ O~~O~~   O~~  O~~   
     O~~    O~~  O~~O~~   O~~O~~  O~~ O~~O~~   O~~  O~~   
     O~~      O~~O~~O~~ O~~    O~~O~~O~~~  O~~ O~~~O~~~   
                                                          
```


Twisted.flf
```
  _______   _      _   __  ______   _______     _____  _____    
/\_______)\/_/\  /\_\ /\_\/ ____/\/\_______)\ /\_____\/\ __/\   
\(___  __\/) ) )( ( ( \/_/) ) __\/\(___  __\/( (_____/) )  \ \  
  / / /   /_/ //\\ \_\ /\_\\ \ \    / / /     \ \__\ / / /\ \ \ 
 ( ( (    \ \ /  \ / // / /_\ \ \  ( ( (      / /__/_\ \ \/ / / 
  \ \ \    )_) /\ (_(( (_()____) )  \ \ \    ( (_____\) )__/ /  
  /_/_/    \_\/  \/_/ \/_/\____\/   /_/_/     \/_____/\/___\/   
                                                                
```


Two Point.flf
```
~|~     _   |~) _ o._ _|_
 | \/\/(_)  |~ (_)|| | | 
```


twopoint.flf
```
_|_     _ |) _ o._ _|_
 | \/\/(_)| (_)|| | | 
```


Univers.flf
```
                                                                         
88        88             88                                              
88        88             ""                                              
88        88                                                             
88        88 8b,dPPYba,  88 8b       d8  ,adPPYba, 8b,dPPYba, ,adPPYba,  
88        88 88P'   `"8a 88 `8b     d8' a8P_____88 88P'   "Y8 I8[    ""  
88        88 88       88 88  `8b   d8'  8PP""""""" 88          `"Y8ba,   
Y8a.    .a8P 88       88 88   `8b,d8'   "8b,   ,aa 88         aa    ]8I  
 `"Y8888Y"'  88       88 88     "8"      `"Ybbd8"' 88         `"YbbdP"'  
                                                                         
                                                                         
```


USA Flag.flf
```
 :::  === :::===  :::====       :::===== :::      :::====  :::===== 
 :::  === :::     :::  ===      :::      :::      :::  === :::      
 ===  ===  =====  ========      ======   ===      ======== === =====
 ===  ===     === ===  ===      ===      ===      ===  === ===   ===
  ======  ======  ===  ===      ===      ======== ===  ===  ======= 
                                                                    
```


usaflag.flf
```
 :::  === :::===  :::====  :::===== :::      :::====  :::===== 
 :::  === :::     :::  === :::      :::      :::  === :::      
 ===  ===  =====  ======== ======   ===      ======== === =====
 ===  ===     === ===  === ===      ===      ===  === ===   ===
  ======  ======  ===  === ===      ======== ===  ===  ======= 
                                                               
```


Varsity.flf
```
 ____   ____                      _   _            
|_  _| |_  _|                    (_) / |_          
  \ \   / /,--.   _ .--.  .--.   __ `| |-' _   __  
   \ \ / /`'_\ : [ `/'`\]( (`\] [  | | |  [ \ [  ] 
    \ ' / // | |, | |     `'.'.  | | | |,  \ '/ /  
     \_/  \'-;__/[___]   [\__) )[___]\__/[\_:  /   
                                          \__.'    
```


Wavy.flf
```
                   
\  X  / _          
 \/ \/ (_( \) (_(  
                _) 
```


Weird.flf
```
                      
 /  |      /         |
(   | ___    ___  ___|
| / )|___)| |   )|   )
|/|/ |__  | |    |__/ 
                      
```


Wet Letter.flf
```
.-.  .-.,---. _______  ,-.    ,---. _______  _______ ,---.  ,---.    
| |/\| || .-'|__   __| | |    | .-'|__   __||__   __|| .-'  | .-.\   
| /  \ || `-.  )| |    | |    | `-.  )| |     )| |   | `-.  | `-'/   
|  /\  || .-' (_) |    | |    | .-' (_) |    (_) |   | .-'  |   (    
|(/  \ ||  `--. | |    | `--. |  `--. | |      | |   |  `--.| |\ \   
(_)   \|/( __.' `-'    |( __.'/( __.' `-'      `-'   /( __.'|_| \)\  
       (__)            (_)   (__)                   (__)        (__) 
```


wetletter.flf
```
.-.  .-.,---. _______ ,-.    ,---. _______  _______ ,---.  ,---.    
| |/\| || .-'|__   __|| |    | .-'|__   __||__   __|| .-'  | .-.\   
| /  \ || `-.  )| |   | |    | `-.  )| |     )| |   | `-.  | `-'/   
|  /\  || .-' (_) |   | |    | .-' (_) |    (_) |   | .-'  |   (    
|(/  \ ||  `--. | |   | `--. |  `--. | |      | |   |  `--.| |\ \   
(_)   \|/( __.' `-'   |( __.'/( __.' `-'      `-'   /( __.'|_| \)\  
       (__)           (_)   (__)                   (__)        (__) 
```


Whimsy.flf
```
                d8b        d8,                                
                ?88       `8P                                 
                 88b                                          
 ?88   d8P  d8P  888888b   88b  88bd8b,d88b  .d888b,?88   d8P 
 d88  d8P' d8P'  88P `?8b  88P  88P'`?8P'?8b ?8b,   d88   88  
 ?8b ,88b ,88'  d88   88P d88  d88  d88  88P   `?8b ?8(  d88  
 `?888P'888P'  d88'   88bd88' d88' d88'  88b`?888P' `?88P'?8b 
                                                           )88
                                                          ,d8P
                                                       `?888P'
```


Wow.flf
```
\\/\\/ [[]] \\/\\/ 
```

