import { buildASTSchema, Kind, OperationTypeNode } from 'graphql';

export const SCHEMA = buildASTSchema({
	kind: Kind.DOCUMENT,
	definitions: [
		{
			kind: Kind.DIRECTIVE_DEFINITION,
			name: {
				kind: Kind.NAME,
				value: 'requiredCapabilities',
			},
			arguments: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'requiredCapabilities',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
						},
					},
					directives: [],
				},
			],
			repeatable: false,
			locations: [
				{
					kind: Kind.NAME,
					value: 'ARGUMENT_DEFINITION',
				},
				{
					kind: Kind.NAME,
					value: 'ENUM',
				},
				{
					kind: Kind.NAME,
					value: 'ENUM_VALUE',
				},
				{
					kind: Kind.NAME,
					value: 'FIELD_DEFINITION',
				},
				{
					kind: Kind.NAME,
					value: 'INPUT_FIELD_DEFINITION',
				},
				{
					kind: Kind.NAME,
					value: 'INPUT_OBJECT',
				},
				{
					kind: Kind.NAME,
					value: 'INTERFACE',
				},
				{
					kind: Kind.NAME,
					value: 'OBJECT',
				},
				{
					kind: Kind.NAME,
					value: 'SCALAR',
				},
				{
					kind: Kind.NAME,
					value: 'UNION',
				},
			],
		},
		{
			kind: Kind.DIRECTIVE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Marks an element of a GraphQL schema as only available via a preview header',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'preview',
			},
			arguments: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The identifier of the API preview that toggles this field.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'toggledBy',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
			repeatable: false,
			locations: [
				{
					kind: Kind.NAME,
					value: 'ARGUMENT_DEFINITION',
				},
				{
					kind: Kind.NAME,
					value: 'ENUM',
				},
				{
					kind: Kind.NAME,
					value: 'ENUM_VALUE',
				},
				{
					kind: Kind.NAME,
					value: 'FIELD_DEFINITION',
				},
				{
					kind: Kind.NAME,
					value: 'INPUT_FIELD_DEFINITION',
				},
				{
					kind: Kind.NAME,
					value: 'INPUT_OBJECT',
				},
				{
					kind: Kind.NAME,
					value: 'INTERFACE',
				},
				{
					kind: Kind.NAME,
					value: 'OBJECT',
				},
				{
					kind: Kind.NAME,
					value: 'SCALAR',
				},
				{
					kind: Kind.NAME,
					value: 'UNION',
				},
			],
		},
		{
			kind: Kind.DIRECTIVE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Defines what type of global IDs are accepted for a mutation argument of type ID.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'possibleTypes',
			},
			arguments: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Abstract type of accepted global ID',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'abstractType',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Accepted types of global IDs.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'concreteTypes',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'String',
									},
								},
							},
						},
					},
					directives: [],
				},
			],
			repeatable: false,
			locations: [
				{
					kind: Kind.NAME,
					value: 'INPUT_FIELD_DEFINITION',
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AbortQueuedMigrations',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AbortQueuedMigrationsInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the organization that is running the migrations.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AbortQueuedMigrations',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AbortQueuedMigrationsPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Did the operation succeed?',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'success',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AcceptEnterpriseAdministratorInvitation',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AcceptEnterpriseAdministratorInvitationInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the invitation being accepted',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'invitationId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'EnterpriseAdministratorInvitation',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AcceptEnterpriseAdministratorInvitation',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AcceptEnterpriseAdministratorInvitationPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The invitation that was accepted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'invitation',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'EnterpriseAdministratorInvitation',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A message confirming the result of accepting an administrator invitation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'message',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AcceptTopicSuggestion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AcceptTopicSuggestionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the suggested topic.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AcceptTopicSuggestion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AcceptTopicSuggestionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The accepted topic.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'topic',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Topic',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INTERFACE_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents an object which can take actions on GitHub. Typically a User or Bot.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Actor',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A URL pointing to the actor's public avatar.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'avatarUrl',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The size of the resulting square image.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'size',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The username of the actor.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'login',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this actor.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this actor.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Location information for an actor',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ActorLocation',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'City',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'city',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Country name',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'country',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Country code',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'countryCode',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Region name',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'region',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Region or state code',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'regionCode',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "The actor's type.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ActorType',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates a team actor.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'TEAM',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates a user actor.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'USER',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddAssigneesToAssignable',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddAssigneesToAssignableInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the assignable object to add assignees to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'assignableId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Assignable',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of users to add as assignees.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'assigneeIds',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'ID',
									},
								},
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddAssigneesToAssignable',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddAssigneesToAssignablePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item that was assigned.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'assignable',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Assignable',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddCommentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The contents of the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the subject to modify.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subjectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'IssueOrPullRequest',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddCommentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The edge from the subject's comment connection.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commentEdge',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'IssueCommentEdge',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The subject',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subject',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Node',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The edge from the subject's timeline connection.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'timelineEdge',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'IssueTimelineItemEdge',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddDiscussionComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddDiscussionCommentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The contents of the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the discussion to comment on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'discussionId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Discussion',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the discussion comment within this discussion to reply to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'replyToId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'DiscussionComment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddDiscussionComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddDiscussionCommentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The newly created discussion comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiscussionComment',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddDiscussionPollVote',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddDiscussionPollVoteInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the discussion poll option to vote for.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pollOptionId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'DiscussionPollOption',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddDiscussionPollVote',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddDiscussionPollVotePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The poll option that a vote was added to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pollOption',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiscussionPollOption',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddEnterpriseOrganizationMember',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddEnterpriseOrganizationMemberInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the enterprise which owns the organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enterpriseId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Enterprise',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the organization the users will be added to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'organizationId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The role to assign the users in the organization',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'role',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'OrganizationMemberRole',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The IDs of the enterprise members to add.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'userIds',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'ID',
									},
								},
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddEnterpriseOrganizationMember',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddEnterpriseOrganizationMemberPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The users who were added to the organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'users',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'User',
								},
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddEnterpriseSupportEntitlement',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddEnterpriseSupportEntitlementInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the Enterprise which the admin belongs to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enterpriseId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Enterprise',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The login of a member who will receive the support entitlement.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'login',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddEnterpriseSupportEntitlement',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddEnterpriseSupportEntitlementPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A message confirming the result of adding the support entitlement.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'message',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddLabelsToLabelable',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddLabelsToLabelableInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ids of the labels to add.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'labelIds',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'ID',
									},
								},
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Label',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the labelable object to add labels to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'labelableId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Discussion',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Labelable',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddLabelsToLabelable',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddLabelsToLabelablePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item that was labeled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'labelable',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Labelable',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddProjectCard',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddProjectCardInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The content of the card. Must be a member of the ProjectCardItem union',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contentId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'ProjectCardItem',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The note on the card.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'note',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the ProjectColumn.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectColumnId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectColumn',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddProjectCard',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddProjectCardPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The edge from the ProjectColumn's card connection.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cardEdge',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectCardEdge',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ProjectColumn',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectColumn',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectColumn',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddProjectColumn',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddProjectColumnInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the column.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Project',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddProjectColumn',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddProjectColumnPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The edge from the project's column connection.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'columnEdge',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectColumnEdge',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The project',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'project',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Project',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddProjectV2DraftIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddProjectV2DraftIssueInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The IDs of the assignees of the draft issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'assigneeIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body of the draft issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the Project to add the draft issue to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The title of the draft issue. A project item can also be created by providing\nthe URL of an Issue or Pull Request if you have access.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddProjectV2DraftIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddProjectV2DraftIssuePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The draft issue added to the project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectItem',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2Item',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddProjectV2ItemById',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddProjectV2ItemByIdInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the Issue or Pull Request to add.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contentId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'DraftIssue',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'ProjectV2ItemContent',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the Project to add the item to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddProjectV2ItemById',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddProjectV2ItemByIdPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item added to the project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'item',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2Item',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddPullRequestReviewComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddPullRequestReviewCommentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The text of the comment. This field is required\n\n**Upcoming Change on 2023-10-01 UTC**\n**Description:** `body` will be removed. use addPullRequestReviewThread or addPullRequestReviewThreadReply instead\n**Reason:** We are deprecating the addPullRequestReviewComment mutation',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The SHA of the commit to comment on.\n\n**Upcoming Change on 2023-10-01 UTC**\n**Description:** `commitOID` will be removed. use addPullRequestReviewThread or addPullRequestReviewThreadReply instead\n**Reason:** We are deprecating the addPullRequestReviewComment mutation',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitOID',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'GitObjectID',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The comment id to reply to.\n\n**Upcoming Change on 2023-10-01 UTC**\n**Description:** `inReplyTo` will be removed. use addPullRequestReviewThread or addPullRequestReviewThreadReply instead\n**Reason:** We are deprecating the addPullRequestReviewComment mutation',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'inReplyTo',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequestReviewComment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The relative path of the file to comment on.\n\n**Upcoming Change on 2023-10-01 UTC**\n**Description:** `path` will be removed. use addPullRequestReviewThread or addPullRequestReviewThreadReply instead\n**Reason:** We are deprecating the addPullRequestReviewComment mutation',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'path',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The line index in the diff to comment on.\n\n**Upcoming Change on 2023-10-01 UTC**\n**Description:** `position` will be removed. use addPullRequestReviewThread or addPullRequestReviewThreadReply instead\n**Reason:** We are deprecating the addPullRequestReviewComment mutation',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'position',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The node ID of the pull request reviewing\n\n**Upcoming Change on 2023-10-01 UTC**\n**Description:** `pullRequestId` will be removed. use\naddPullRequestReviewThread or addPullRequestReviewThreadReply instead\n**Reason:** We are deprecating the addPullRequestReviewComment mutation',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The Node ID of the review to modify.\n\n**Upcoming Change on 2023-10-01 UTC**\n**Description:** `pullRequestReviewId` will be removed. use\naddPullRequestReviewThread or addPullRequestReviewThreadReply instead\n**Reason:** We are deprecating the addPullRequestReviewComment mutation',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReviewId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequestReview',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddPullRequestReviewComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddPullRequestReviewCommentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The newly created comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReviewComment',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The edge from the review's comment connection.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commentEdge',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReviewCommentEdge',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddPullRequestReview',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddPullRequestReviewInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The contents of the review body comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The review line comments.\n\n**Upcoming Change on 2023-10-01 UTC**\n**Description:** `comments` will be removed. use the `threads` argument instead\n**Reason:** We are deprecating comment fields that use diff-relative positioning',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comments',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DraftPullRequestReviewComment',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commit OID the review pertains to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitOID',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'GitObjectID',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The event to perform on the pull request review.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'event',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReviewEvent',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the pull request to modify.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The review line comment threads.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'threads',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DraftPullRequestReviewThread',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddPullRequestReview',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddPullRequestReviewPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The newly created pull request review.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReview',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReview',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The edge from the pull request's review connection.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reviewEdge',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReviewEdge',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddPullRequestReviewThread',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddPullRequestReviewThreadInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Body of the thread's first comment.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The line of the blob to which the thread refers. The end of the line range for multi-line comments.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'line',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Path to the file being commented on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'path',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The node ID of the pull request reviewing',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the review to modify.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReviewId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequestReview',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The side of the diff on which the line resides. For multi-line comments, this is the side for the end of the line range.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'side',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiffSide',
						},
					},
					defaultValue: {
						kind: Kind.ENUM,
						value: 'RIGHT',
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The first line of the range to which the comment refers.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startLine',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The side of the diff on which the start line resides.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startSide',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiffSide',
						},
					},
					defaultValue: {
						kind: Kind.ENUM,
						value: 'RIGHT',
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The level at which the comments in the corresponding thread are targeted, can be a diff line or a file',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subjectType',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReviewThreadSubjectType',
						},
					},
					defaultValue: {
						kind: Kind.ENUM,
						value: 'LINE',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddPullRequestReviewThread',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddPullRequestReviewThreadPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The newly created thread.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'thread',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReviewThread',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddReaction',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddReactionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the emoji to react with.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'content',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReactionContent',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the subject to modify.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subjectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'CommitComment',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Discussion',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'DiscussionComment',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'IssueComment',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequestReview',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequestReviewComment',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Release',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'TeamDiscussion',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'TeamDiscussionComment',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Reactable',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddReaction',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddReactionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reaction object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reaction',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Reaction',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reaction groups for the subject.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reactionGroups',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ReactionGroup',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reactable subject.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subject',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Reactable',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddStar',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddStarInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Starrable ID to star.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'starrableId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Gist',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Topic',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Starrable',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddStar',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddStarPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The starrable.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'starrable',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Starrable',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddUpvote',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddUpvoteInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the discussion or comment to upvote.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subjectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Discussion',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'DiscussionComment',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Votable',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddUpvote',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddUpvotePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The votable subject.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subject',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Votable',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of AddVerifiableDomain',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddVerifiableDomainInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The URL of the domain',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'domain',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the owner to add the domain to',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Enterprise',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'VerifiableDomainOwner',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of AddVerifiableDomain',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddVerifiableDomainPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The verifiable domain that was added.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'domain',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'VerifiableDomain',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'added_to_project' event on a given issue or pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AddedToProjectEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Project referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'project',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Project',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'preview',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'toggledBy',
									},
									value: {
										kind: Kind.STRING,
										value: 'starfox-preview',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Project card referenced by this project event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectCard',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectCard',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'preview',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'toggledBy',
									},
									value: {
										kind: Kind.STRING,
										value: 'starfox-preview',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Column name referenced by this project event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectColumnName',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'preview',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'toggledBy',
									},
									value: {
										kind: Kind.STRING,
										value: 'starfox-preview',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.INTERFACE_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents an announcement banner.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AnnouncementBanner',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The text of the announcement',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'announcement',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The expiration date of the announcement, if any',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'announcementExpiresAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether the announcement can be dismissed by the user',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'announcementUserDismissible',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A GitHub App.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'App',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The description of the app.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The IP addresses of the app.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ipAllowListEntries',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for IP allow list entries returned.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'IpAllowListEntryOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'field',
										},
										value: {
											kind: Kind.ENUM,
											value: 'ALLOW_LIST_VALUE',
										},
									},
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'ASC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'IpAllowListEntryConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The hex color code, without the leading '#', for the logo background.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'logoBackgroundColor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A URL pointing to the app's logo.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'logoUrl',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The size of the resulting image.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'size',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the app.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A slug based on the name of the app for use in URLs.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'slug',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The URL to the app's homepage.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ApproveDeployments',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ApproveDeploymentsInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Optional comment for approving deployments',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comment',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					defaultValue: {
						kind: Kind.STRING,
						value: '',
						block: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ids of environments to reject deployments',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environmentIds',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'ID',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The node ID of the workflow run containing the pending deployments.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'workflowRunId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'WorkflowRun',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ApproveDeployments',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ApproveDeploymentsPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The affected deployments.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deployments',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Deployment',
								},
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ApproveVerifiableDomain',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ApproveVerifiableDomainInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the verifiable domain to approve.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'VerifiableDomain',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ApproveVerifiableDomain',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ApproveVerifiableDomainPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The verifiable domain that was approved.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'domain',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'VerifiableDomain',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ArchiveProjectV2Item',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ArchiveProjectV2ItemInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the ProjectV2Item to archive.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'itemId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2Item',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the Project to archive the item from.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ArchiveProjectV2Item',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ArchiveProjectV2ItemPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item archived from the project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'item',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2Item',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ArchiveRepository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ArchiveRepositoryInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the repository to mark as archived.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ArchiveRepository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ArchiveRepositoryPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository that was marked as archived.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Repository',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INTERFACE_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An object that can have users assigned to it.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Assignable',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of Users assigned to this object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'assignees',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'UserConnection',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents an 'assigned' event on any assignable object.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AssignedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the assignable associated with the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'assignable',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Assignable',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the user or mannequin that was assigned.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'assignee',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Assignee',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the user who was assigned.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'User',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'deprecated',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'reason',
									},
									value: {
										kind: Kind.STRING,
										value:
											'Assignees can now be mannequins. Use the `assignee` field instead. Removal on 2020-01-01 UTC.',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Types that can be assigned to issues.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Assignee',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Bot',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Mannequin',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Organization',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'User',
					},
				},
			],
		},
		{
			kind: Kind.INTERFACE_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An entry in the audit log.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AuditEntry',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The action name',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'action',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who initiated the action',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'AuditEntryActor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The IP address of the actor',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actorIp',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A readable representation of the actor's location",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actorLocation',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ActorLocation',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The username of the user who initiated the action',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actorLogin',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for the actor.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actorResourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for the actor.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actorUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The time the action was initiated',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PreciseDateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The corresponding operation type for the action',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'operationType',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'OperationType',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user affected by the action',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'User',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'For actions involving two users, the actor is the initiator and the user is the affected user.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'userLogin',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for the user.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'userResourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for the user.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'userUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Types that can initiate an audit log event.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AuditEntryActor',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Bot',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Organization',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'User',
					},
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Ordering options for Audit Log connections.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AuditLogOrder',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ordering direction.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'direction',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'OrderDirection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The field to order Audit Logs by.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'field',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'AuditLogOrderField',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Properties by which Audit Log connections can be ordered.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AuditLogOrderField',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Order audit log entries by timestamp',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'CREATED_AT',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'auto_merge_disabled' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AutoMergeDisabledEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who disabled auto-merge for this Pull Request',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'disabler',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'User',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reason auto-merge was disabled',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reason',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reason_code relating to why auto-merge was disabled',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reasonCode',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'auto_merge_enabled' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AutoMergeEnabledEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who enabled auto-merge for this Pull Request',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enabler',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'User',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents an auto-merge request for a pull request',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AutoMergeRequest',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The email address of the author of this auto-merge request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authorEmail',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The commit message of the auto-merge request. If a merge queue is required by\nthe base branch, this value will be set by the merge queue when merging.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitBody',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The commit title of the auto-merge request. If a merge queue is required by\nthe base branch, this value will be set by the merge queue when merging',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitHeadline',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'When was this auto-merge request was enabled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enabledAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who created the auto-merge request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enabledBy',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The merge method of the auto-merge request. If a merge queue is required by\nthe base branch, this value will be set by the merge queue when merging.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'mergeMethod',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequestMergeMethod',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The pull request that this auto-merge request is set against.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'auto_rebase_enabled' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AutoRebaseEnabledEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who enabled auto-merge (rebase) for this Pull Request',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enabler',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'User',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'auto_squash_enabled' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AutoSquashEnabledEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who enabled auto-merge (squash) for this Pull Request',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enabler',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'User',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'automatic_base_change_failed' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AutomaticBaseChangeFailedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new base for this PR',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'newBase',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The old base for this PR',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'oldBase',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'automatic_base_change_succeeded' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'AutomaticBaseChangeSucceededEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new base for this PR',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'newBase',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The old base for this PR',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'oldBase',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.SCALAR_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A (potentially binary) string encoded using base64.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Base64String',
			},
			directives: [],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'base_ref_changed' event on a given issue or pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BaseRefChangedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the name of the base ref for the pull request after it was changed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'currentRefName',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the name of the base ref for the pull request before it was changed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'previousRefName',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'base_ref_deleted' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BaseRefDeletedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the name of the Ref associated with the `base_ref_deleted` event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'baseRefName',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'base_ref_force_pushed' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BaseRefForcePushedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Identifies the after commit SHA for the 'base_ref_force_pushed' event.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'afterCommit',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Commit',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Identifies the before commit SHA for the 'base_ref_force_pushed' event.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'beforeCommit',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Commit',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Identifies the fully qualified ref name for the 'base_ref_force_pushed' event.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ref',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Ref',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.SCALAR_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value:
					"Represents non-fractional signed whole numeric values. Since the value may\nexceed the size of a 32-bit integer, it's encoded as a string.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BigInt',
			},
			directives: [],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a Git blame.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Blame',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The list of ranges from a Git blame.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ranges',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'BlameRange',
									},
								},
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a range of information from a Git blame.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BlameRange',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Identifies the recency of the change, from 1 (new) to 10 (old). This is\ncalculated as a 2-quantile and determines the length of distance between the\nmedian age of all the changes in the file and the recency of the current\nrange's change.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'age',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the line author',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commit',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Commit',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ending line for the range',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'endingLine',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The starting line for the range',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startingLine',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a Git blob.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Blob',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'GitObject',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An abbreviated version of the Git object ID',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'abbreviatedOid',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Byte size of Blob object',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'byteSize',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this Git object',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitResourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this Git object',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates whether the Blob is binary or text. Returns null if unable to determine the encoding.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isBinary',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates whether the contents is truncated',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isTruncated',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Git object ID',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'oid',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObjectID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Repository the Git object belongs to',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'UTF8 text data or null if the Blob is binary',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'text',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A special type of user which takes actions on behalf of GitHub Apps.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Bot',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Actor',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'UniformResourceLocatable',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A URL pointing to the GitHub App's public avatar.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'avatarUrl',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The size of the resulting square image.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'size',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The username of the actor.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'login',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this bot',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this bot',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Types which can be actors for `BranchActorAllowance` objects.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BranchActorAllowanceActor',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'App',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Team',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'User',
					},
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A branch protection rule.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BranchProtectionRule',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can this branch be deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'allowsDeletions',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are force pushes allowed on this branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'allowsForcePushes',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Is branch creation a protected operation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'blocksCreations',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of conflicts matching branches protection rule and other branch protection rules',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branchProtectionRuleConflicts',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BranchProtectionRuleConflictConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of actors able to force push for this branch protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bypassForcePushAllowances',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BypassForcePushAllowanceConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of actors able to bypass PRs for this branch protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bypassPullRequestAllowances',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BypassPullRequestAllowanceConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who created this branch protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'creator',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Will new commits pushed to matching branches dismiss pull request review approvals.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'dismissesStaleReviews',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can admins overwrite branch protection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isAdminEnforced',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether users can pull changes from upstream when the branch is locked. Set to\n`true` to allow fork syncing. Set to `false` to prevent fork syncing.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'lockAllowsFetchAndMerge',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'lockBranch',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Repository refs that are protected by this rule',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'matchingRefs',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Filters refs with query on name',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'query',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'RefConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the protection rule pattern.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pattern',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list push allowances for this branch protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pushAllowances',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PushAllowanceConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository associated with this branch protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Repository',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether the most recent push must be approved by someone other than the person who pushed it',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requireLastPushApproval',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Number of approving reviews required to update matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredApprovingReviewCount',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'List of required deployment environments that must be deployed successfully to update matching branches',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredDeploymentEnvironments',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'List of required status check contexts that must pass for commits to be accepted to matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredStatusCheckContexts',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'List of required status checks that must pass for commits to be accepted to matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredStatusChecks',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'RequiredStatusCheckDescription',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are approving reviews required to update matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresApprovingReviews',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are reviews from code owners required to update matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresCodeOwnerReviews',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are commits required to be signed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresCommitSignatures',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are conversations required to be resolved before merging.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresConversationResolution',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Does this branch require deployment to specific environments before merging',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresDeployments',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are merge commits prohibited from being pushed to this branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresLinearHistory',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are status checks required to update matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresStatusChecks',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are branches required to be up to date before merging.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresStrictStatusChecks',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Is pushing to matching branches restricted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'restrictsPushes',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Is dismissal of pull request reviews restricted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'restrictsReviewDismissals',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list review dismissal allowances for this branch protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reviewDismissalAllowances',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReviewDismissalAllowanceConnection',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A conflict between two branch protection rules.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BranchProtectionRuleConflict',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the branch protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branchProtectionRule',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchProtectionRule',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the conflicting branch protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'conflictingBranchProtectionRule',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchProtectionRule',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the branch ref that has conflicting rules',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ref',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Ref',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for BranchProtectionRuleConflict.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BranchProtectionRuleConflictConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BranchProtectionRuleConflictEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BranchProtectionRuleConflict',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BranchProtectionRuleConflictEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchProtectionRuleConflict',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for BranchProtectionRule.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BranchProtectionRuleConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BranchProtectionRuleEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BranchProtectionRule',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BranchProtectionRuleEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchProtectionRule',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A user, team, or app who has the ability to bypass a force push requirement on a protected branch.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BypassForcePushAllowance',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor that can force push.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchActorAllowanceActor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the branch protection rule associated with the allowed user, team, or app.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branchProtectionRule',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchProtectionRule',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for BypassForcePushAllowance.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BypassForcePushAllowanceConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BypassForcePushAllowanceEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BypassForcePushAllowance',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BypassForcePushAllowanceEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BypassForcePushAllowance',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A user, team, or app who has the ability to bypass a pull request requirement on a protected branch.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BypassPullRequestAllowance',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor that can bypass.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchActorAllowanceActor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the branch protection rule associated with the allowed user, team, or app.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branchProtectionRule',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchProtectionRule',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for BypassPullRequestAllowance.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BypassPullRequestAllowanceConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BypassPullRequestAllowanceEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'BypassPullRequestAllowance',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'BypassPullRequestAllowanceEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BypassPullRequestAllowance',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The Common Vulnerability Scoring System',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CVSS',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The CVSS score associated with this advisory',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'score',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Float',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The CVSS vector string associated with this advisory',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'vectorString',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A common weakness enumeration',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CWE',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the CWE',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cweId',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A detailed description of this CWE',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of this CWE',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CWE.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CWEConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CWEEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CWE',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CWEEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CWE',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CancelEnterpriseAdminInvitation',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CancelEnterpriseAdminInvitationInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the pending enterprise administrator invitation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'invitationId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'EnterpriseAdministratorInvitation',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CancelEnterpriseAdminInvitation',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CancelEnterpriseAdminInvitationPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The invitation that was canceled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'invitation',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'EnterpriseAdministratorInvitation',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A message confirming the result of canceling an administrator invitation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'message',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CancelSponsorship',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CancelSponsorshipInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The ID of the user or organization who is acting as the sponsor, paying for\nthe sponsorship. Required if sponsorLogin is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Sponsor',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The username of the user or organization who is acting as the sponsor, paying\nfor the sponsorship. Required if sponsorId is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorLogin',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The ID of the user or organization who is receiving the sponsorship. Required if sponsorableLogin is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorableId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Sponsorable',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The username of the user or organization who is receiving the sponsorship. Required if sponsorableId is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorableLogin',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CancelSponsorship',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CancelSponsorshipPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The tier that was being used at the time of cancellation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorsTier',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'SponsorsTier',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ChangeUserStatus',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ChangeUserStatusInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The emoji to represent your status. Can either be a native Unicode emoji or an emoji name with colons, e.g., :grinning:.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'emoji',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'If set, the user status will not be shown after this date.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'expiresAt',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether this status should indicate you are not fully available on GitHub, e.g., you are away.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'limitedAvailability',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A short description of your current status.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'message',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The ID of the organization whose members will be allowed to see the status. If\nomitted, the status will be publicly visible.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'organizationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ChangeUserStatus',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ChangeUserStatusPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Your updated status.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'status',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'UserStatus',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A single check annotation.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckAnnotation',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The annotation's severity level.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'annotationLevel',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckAnnotationLevel',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The path to the file that this annotation was made on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'blobUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The position of this annotation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'location',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckAnnotationSpan',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The annotation's message.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'message',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The path that this annotation was made on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'path',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Additional information about the annotation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'rawDetails',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The annotation's title",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CheckAnnotation.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckAnnotationConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckAnnotationEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckAnnotation',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Information from a check run analysis to specific lines of code.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckAnnotationData',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Represents an annotation's information level",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'annotationLevel',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckAnnotationLevel',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The location of the annotation',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'location',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckAnnotationRange',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A short description of the feedback for these lines of code.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'message',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The path of the file to add an annotation to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'path',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Details about this annotation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'rawDetails',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title that represents the annotation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckAnnotationEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckAnnotation',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents an annotation's information level.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckAnnotationLevel',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An annotation indicating an inescapable error.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FAILURE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An annotation indicating some information.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'NOTICE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An annotation indicating an ignorable error.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'WARNING',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A character position in a check annotation.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckAnnotationPosition',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Column number (1 indexed).',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'column',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Line number (1 indexed).',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'line',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Information from a check run analysis to specific lines of code.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckAnnotationRange',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ending column of the range.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'endColumn',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ending line of the range.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'endLine',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The starting column of the range.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startColumn',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The starting line of the range.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startLine',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An inclusive pair of positions for a check annotation.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckAnnotationSpan',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'End position (inclusive).',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'end',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckAnnotationPosition',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Start position (inclusive).',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'start',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckAnnotationPosition',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible states for a check suite or run conclusion.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckConclusionState',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run requires action.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ACTION_REQUIRED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run has been cancelled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'CANCELLED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run has failed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FAILURE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run was neutral.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'NEUTRAL',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run was skipped.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'SKIPPED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run was marked stale by GitHub. Only GitHub can use this conclusion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'STALE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run has failed at startup.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'STARTUP_FAILURE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run has succeeded.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'SUCCESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run has timed out.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'TIMED_OUT',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A check run.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRun',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RequirableByPullRequest',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'UniformResourceLocatable',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The check run's annotations",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'annotations',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckAnnotationConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite that this run is a part of.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'checkSuite',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckSuite',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the check run was completed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'completedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The conclusion of the check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'conclusion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckConclusionState',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The corresponding deployment for this job, if any',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deployment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Deployment',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The URL from which to find full details of the check run on the integrator's site.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'detailsUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A reference for the check run on the integrator's system.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'externalId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether this is required to pass before merging for a specific pull request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRequired',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The id of the pull request this is required for',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'pullRequestId',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The number of the pull request this is required for',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'pullRequestNumber',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the check for this check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information about a pending deployment, if any, in this check run',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pendingDeploymentRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentRequest',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The permalink to the check run summary.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'permalink',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository associated with this check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the check run was started.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The current status of the check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'status',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckStatusState',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The check run's steps",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'steps',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Step number',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'number',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckStepConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A string representing the check run's summary",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'summary',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A string representing the check run's text",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'text',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A string representing the check run',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Possible further actions the integrator can perform.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunAction',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A short explanation of what this action would do.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A reference for the action on the integrator's system.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'identifier',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The text to be displayed on a button in the web UI.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'label',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CheckRun.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckRunEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckRun',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckRun',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The filters that are available when fetching check runs.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunFilter',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Filters the check runs created by this application ID.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'appId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Filters the check runs by this name.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'checkName',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Filters the check runs by this type.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'checkType',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckRunType',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Filters the check runs by these conclusions.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'conclusions',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CheckConclusionState',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Filters the check runs by this status. Superceded by statuses.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'status',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckStatusState',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Filters the check runs by this status. Overrides status.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'statuses',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CheckStatusState',
								},
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Descriptive details about the check run.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunOutput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The annotations that are made as part of the check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'annotations',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CheckAnnotationData',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Images attached to the check run output displayed in the GitHub pull request UI.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'images',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CheckRunOutputImage',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The summary of the check run (supports Commonmark).',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'summary',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The details of the check run (supports Commonmark).',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'text',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A title to provide for this check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Images attached to the check run output displayed in the GitHub pull request UI.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunOutputImage',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The alternative text for the image.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'alt',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A short image description.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'caption',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The full URL of the image.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'imageUrl',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible states of a check run in a status rollup.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunState',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run requires action.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ACTION_REQUIRED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run has been cancelled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'CANCELLED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run has been completed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'COMPLETED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run has failed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FAILURE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run is in progress.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'IN_PROGRESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run was neutral.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'NEUTRAL',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run is in pending state.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'PENDING',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run has been queued.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'QUEUED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run was skipped.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'SKIPPED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run was marked stale by GitHub. Only GitHub can use this conclusion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'STALE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run has failed at startup.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'STARTUP_FAILURE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run has succeeded.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'SUCCESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run has timed out.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'TIMED_OUT',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check run is in waiting state.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'WAITING',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a count of the state of a check run.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunStateCount',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The number of check runs with this state.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'count',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The state of a check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'state',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckRunState',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible types of check runs.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckRunType',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Every check run available.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ALL',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The latest check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'LATEST',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible states for a check suite or run status.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckStatusState',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run has been completed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'COMPLETED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run is in progress.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'IN_PROGRESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run is in pending state.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'PENDING',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run has been queued.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'QUEUED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run has been requested.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'REQUESTED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suite or run is in waiting state.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'WAITING',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A single check step.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckStep',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the check step was completed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'completedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The conclusion of the check step.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'conclusion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckConclusionState',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A reference for the check step on the integrator's system.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'externalId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The step's name.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The index of the step in the list of steps of the parent check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'number',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Number of seconds to completion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'secondsToCompletion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the check step was started.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The current status of the check step.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'status',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckStatusState',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CheckStep.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckStepConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckStepEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckStep',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckStepEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckStep',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A check suite.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckSuite',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The GitHub App which created this check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'app',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'App',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the branch for this check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branch',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Ref',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check runs associated with a check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'checkRuns',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Filters the check runs by this type.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'filterBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CheckRunFilter',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckRunConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commit for this check suite',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commit',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Commit',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The conclusion of this check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'conclusion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckConclusionState',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who triggered the check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'creator',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'User',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of open pull requests matching the check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'matchingPullRequests',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The base ref name to filter the pull requests by.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'baseRefName',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The head ref name to filter the pull requests by.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'headRefName',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'A list of label names to filter the pull requests by.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'labels',
							},
							type: {
								kind: Kind.LIST_TYPE,
								type: {
									kind: Kind.NON_NULL_TYPE,
									type: {
										kind: Kind.NAMED_TYPE,
										name: {
											kind: Kind.NAME,
											value: 'String',
										},
									},
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for pull requests returned from the connection.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'IssueOrder',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'A list of states to filter the pull requests by.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'states',
							},
							type: {
								kind: Kind.LIST_TYPE,
								type: {
									kind: Kind.NON_NULL_TYPE,
									type: {
										kind: Kind.NAMED_TYPE,
										name: {
											kind: Kind.NAME,
											value: 'PullRequestState',
										},
									},
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The push that triggered this check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'push',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Push',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository associated with this check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this check suite',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The status of this check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'status',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckStatusState',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this check suite',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The workflow run associated with this check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'workflowRun',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'WorkflowRun',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The auto-trigger preferences that are available for check suites.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckSuiteAutoTriggerPreference',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The node ID of the application that owns the check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'appId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Set to `true` to enable automatic creation of CheckSuite events upon pushes to the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'setting',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CheckSuite.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckSuiteConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckSuiteEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CheckSuite',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckSuiteEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckSuite',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The filters that are available when fetching check suites.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CheckSuiteFilter',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Filters the check suites created by this application ID.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'appId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Filters the check suites by this name.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'checkName',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An object which can have its data claimed or claim data from another.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Claimable',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Mannequin',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'User',
					},
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ClearLabelsFromLabelable',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ClearLabelsFromLabelableInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the labelable object to clear the labels from.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'labelableId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Discussion',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Labelable',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ClearLabelsFromLabelable',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ClearLabelsFromLabelablePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item that was unlabeled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'labelable',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Labelable',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ClearProjectV2ItemFieldValue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ClearProjectV2ItemFieldValueInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the field to be cleared.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'fieldId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2Field',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'ProjectV2IterationField',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'ProjectV2SingleSelectField',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'ProjectV2FieldConfiguration',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the item to be cleared.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'itemId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2Item',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the Project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ClearProjectV2ItemFieldValue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ClearProjectV2ItemFieldValuePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The updated item.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectV2Item',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2Item',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CloneProject',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CloneProjectInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The description of the project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Whether or not to clone the source project's workflows.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'includeWorkflows',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The visibility of the project, defaults to false (private).',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'public',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The source project to clone.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sourceId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Project',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The owner ID to create the project under.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'targetOwnerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'ProjectOwner',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CloneProject',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CloneProjectPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the JobStatus for populating cloned fields.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'jobStatusId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new cloned project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'project',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Project',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CloneTemplateRepository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CloneTemplateRepositoryInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A short description of the new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether to copy all branches from the template to the new repository. Defaults\nto copying only the default branch of the template.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'includeAllBranches',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the owner for the new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'RepositoryOwner',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the template repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Indicates the repository's visibility level.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'visibility',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'RepositoryVisibility',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CloneTemplateRepository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CloneTemplateRepositoryPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Repository',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INTERFACE_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An object that can be closed',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Closable',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates if the object is closed (definition of closed may depend on type)',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'closed',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'closedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates if the object can be closed by the viewer.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanClose',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates if the object can be reopened by the viewer.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanReopen',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CloseDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CloseDiscussionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'ID of the discussion to be closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'discussionId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Discussion',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reason why the discussion is being closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reason',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiscussionCloseReason',
						},
					},
					defaultValue: {
						kind: Kind.ENUM,
						value: 'RESOLVED',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CloseDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CloseDiscussionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion that was closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'discussion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Discussion',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CloseIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CloseIssueInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'ID of the issue to be closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issueId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reason the issue is to be closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'stateReason',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'IssueClosedStateReason',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CloseIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CloseIssuePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The issue that was closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issue',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Issue',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ClosePullRequest',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ClosePullRequestInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'ID of the pull request to be closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ClosePullRequest',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ClosePullRequestPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The pull request that was closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'closed' event on any `Closable`.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ClosedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'UniformResourceLocatable',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Object that was closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'closable',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Closable',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Object which triggered the creation of this event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'closer',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Closer',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this closed event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reason the issue state was changed to closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'stateReason',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'IssueStateReason',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this closed event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The object which triggered a `ClosedEvent`.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Closer',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Commit',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'PullRequest',
					},
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The Code of Conduct for a repository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CodeOfConduct',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body of the Code of Conduct',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The key for the Code of Conduct',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'key',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The formal name of the Code of Conduct',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this Code of Conduct',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this Code of Conduct',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Collaborators affiliation level with a subject.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CollaboratorAffiliation',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'All collaborators the authenticated user can see.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ALL',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'All collaborators with permissions to an organization-owned subject, regardless of organization membership status.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'DIRECT',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'All outside collaborators of an organization-owned subject.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'OUTSIDE',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INTERFACE_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a comment.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Comment',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who authored the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'author',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Author's association with the subject of the comment.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authorAssociation',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommentAuthorAssociation',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body as Markdown.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body rendered to HTML.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bodyHTML',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'HTML',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body rendered to text.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bodyText',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if this comment was created via an email reply.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdViaEmail',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who edited the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'editor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if this comment was edited and includes an edit with the creation data',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'includesCreatedEdit',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The moment the editor made the last edit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'lastEditedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies when the comment was published at.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'publishedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edits to this content.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'userContentEdits',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'UserContentEditConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Did the viewer author this comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerDidAuthor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A comment author association with repository.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommentAuthorAssociation',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Author has been invited to collaborate on the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'COLLABORATOR',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Author has previously committed to the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'CONTRIBUTOR',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Author has not previously committed to GitHub.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FIRST_TIMER',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Author has not previously committed to the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FIRST_TIME_CONTRIBUTOR',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Author is a placeholder for an unclaimed user.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'MANNEQUIN',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Author is a member of the organization that owns the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'MEMBER',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Author has no association with the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'NONE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Author is the owner of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'OWNER',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible errors that will prevent a user from updating a comment.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommentCannotUpdateReason',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Unable to create comment because repository is archived.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ARCHIVED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'You cannot update this comment',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'DENIED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'You must be the author or have write access to this repository to update this comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'INSUFFICIENT_ACCESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Unable to create comment because issue is locked.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'LOCKED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'You must be logged in to update this comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'LOGIN_REQUIRED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Repository is under maintenance.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'MAINTENANCE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'At least one email address must be verified to update this comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'VERIFIED_EMAIL_REQUIRED',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'comment_deleted' event on a given issue or pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommentDeletedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who authored the deleted comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deletedCommentAuthor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a Git commit.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Commit',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'GitObject',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Subscribable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'UniformResourceLocatable',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An abbreviated version of the Git object ID',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'abbreviatedOid',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The number of additions in this commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'additions',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The merged Pull Request that introduced the commit to the repository. If the\ncommit is not present in the default branch, additionally returns open Pull\nRequests associated with the commit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'associatedPullRequests',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for pull requests.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'PullRequestOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'field',
										},
										value: {
											kind: Kind.ENUM,
											value: 'CREATED_AT',
										},
									},
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'ASC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Authorship details of the commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'author',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'GitActor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the committer and the author match.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authoredByCommitter',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The datetime when this commit was authored.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authoredDate',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The list of authors for this commit based on the git author and the Co-authored-by\nmessage trailer. The git author will always be first.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authors',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitActorConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Fetches `git blame` information.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'blame',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The file whose Git blame information you want.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'path',
							},
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'String',
									},
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Blame',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'We recommend using the `changedFielsIfAvailable` field instead of\n`changedFiles`, as `changedFiles` will cause your request to return an error\nif GitHub is unable to calculate the number of changed files.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'changedFiles',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'deprecated',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'reason',
									},
									value: {
										kind: Kind.STRING,
										value:
											'`changedFiles` will be removed. Use `changedFilesIfAvailable` instead. Removal on 2023-01-01 UTC.',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The number of changed files in this commit. If GitHub is unable to calculate\nthe number of changed files (for example due to a timeout), this will return\n`null`. We recommend using this field instead of `changedFiles`.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'changedFilesIfAvailable',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The check suites associated with a commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'checkSuites',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Filters the check suites by this type.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'filterBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CheckSuiteFilter',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckSuiteConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Comments made on the commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comments',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitCommentConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this Git object',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitResourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this Git object',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The datetime when this commit was committed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'committedDate',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if committed via GitHub web UI.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'committedViaWeb',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Committer details of the commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'committer',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'GitActor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The number of deletions in this commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deletions',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployments associated with a commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deployments',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Environments to list deployments for',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'environments',
							},
							type: {
								kind: Kind.LIST_TYPE,
								type: {
									kind: Kind.NON_NULL_TYPE,
									type: {
										kind: Kind.NAMED_TYPE,
										name: {
											kind: Kind.NAME,
											value: 'String',
										},
									},
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for deployments returned from the connection.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'DeploymentOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'field',
										},
										value: {
											kind: Kind.ENUM,
											value: 'CREATED_AT',
										},
									},
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'ASC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The tree entry representing the file located at the given path.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'file',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'The path for the file',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'path',
							},
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'String',
									},
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'TreeEntry',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The linear commit history starting from (and including) this commit, in the same order as `git log`.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'history',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'If non-null, filters history to only show commits with matching authorship.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'author',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CommitAuthor',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'If non-null, filters history to only show commits touching files under this path.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'path',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Allows specifying a beginning time or date for fetching commits.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'since',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'GitTimestamp',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Allows specifying an ending time or date for fetching commits.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'until',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'GitTimestamp',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitHistoryConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Git commit message',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'message',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Git commit message body',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'messageBody',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commit message body rendered to HTML.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'messageBodyHTML',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'HTML',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Git commit message headline',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'messageHeadline',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commit message headline rendered to HTML.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'messageHeadlineHTML',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'HTML',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Git object ID',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'oid',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObjectID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The organization this commit was made on behalf of.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'onBehalfOf',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Organization',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The parents of a commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'parents',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The datetime when this commit was pushed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pushedDate',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'deprecated',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'reason',
									},
									value: {
										kind: Kind.STRING,
										value: '`pushedDate` is no longer supported. Removal on 2023-07-01 UTC.',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Repository this commit belongs to',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this commit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Commit signing information, if present.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'signature',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'GitSignature',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Status information for this commit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'status',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Status',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check and Status rollup information for this commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'statusCheckRollup',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'StatusCheckRollup',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Returns a list of all submodules in this repository as of this Commit parsed from the .gitmodules file.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'submodules',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'SubmoduleConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Returns a URL to download a tarball archive for a repository.\nNote: For private repositories, these links are temporary and expire after five minutes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'tarballUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Commit's root Tree",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'tree',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Tree',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for the tree of this commit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'treeResourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for the tree of this commit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'treeUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this commit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the viewer is able to change their subscription status for the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanSubscribe',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies if the viewer is watching, not watching, or ignoring the subscribable entity.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerSubscription',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'SubscriptionState',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Returns a URL to download a zipball archive for a repository.\nNote: For private repositories, these links are temporary and expire after five minutes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'zipballUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Specifies an author for filtering Git commits.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitAuthor',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Email addresses to filter by. Commits authored by any of the specified email addresses will be returned.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'emails',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'ID of a User to filter by. If non-null, only commits authored by this user\nwill be returned. This field takes precedence over emails.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a comment on a given Commit.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitComment',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Comment',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Deletable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Minimizable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Reactable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RepositoryNode',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Updatable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'UpdatableComment',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who authored the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'author',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Author's association with the subject of the comment.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authorAssociation',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommentAuthorAssociation',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the comment body.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body rendered to HTML.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bodyHTML',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'HTML',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body rendered to text.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bodyText',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the commit associated with the comment, if the commit exists.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commit',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Commit',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if this comment was created via an email reply.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdViaEmail',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who edited the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'editor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if this comment was edited and includes an edit with the creation data',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'includesCreatedEdit',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Returns whether or not a comment has been minimized.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isMinimized',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The moment the editor made the last edit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'lastEditedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Returns why the comment was minimized. One of `abuse`, `off-topic`,\n`outdated`, `resolved`, `duplicate` and `spam`. Note that the case and\nformatting of these values differs from the inputs to the `MinimizeComment` mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'minimizedReason',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the file path associated with the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'path',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the line position associated with the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'position',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies when the comment was published at.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'publishedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of reactions grouped by content left on the subject.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reactionGroups',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ReactionGroup',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of Reactions left on the Issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reactions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Allows filtering Reactions by emoji.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'content',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ReactionContent',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Allows specifying the order in which reactions are returned.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ReactionOrder',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReactionConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository associated with this node.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path permalink for this commit comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL permalink for this commit comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edits to this content.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'userContentEdits',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'UserContentEditConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the current viewer can delete this object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanDelete',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the current viewer can minimize this object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanMinimize',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can user react to this subject',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanReact',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the current viewer can update this object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanUpdate',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Reasons why the current viewer can not update this comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCannotUpdateReasons',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'CommentCannotUpdateReason',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Did the viewer author this comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerDidAuthor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CommitComment.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitCommentConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitCommentEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitComment',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitCommentEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CommitComment',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A thread of comments on a commit.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitCommentThread',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RepositoryNode',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The comments that exist in this thread.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comments',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitCommentConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commit the comments were made on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commit',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Commit',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The file the comments were made on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'path',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The position in the diff for the commit that the comment was made on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'position',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository associated with this node.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for Commit.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Commit',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Ordering options for commit contribution connections.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitContributionOrder',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ordering direction.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'direction',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'OrderDirection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The field by which to order commit contributions.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'field',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitContributionOrderField',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Properties by which commit contribution connections can be ordered.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitContributionOrderField',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Order commit contributions by how many commits they represent.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'COMMIT_COUNT',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Order commit contributions by when they were made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'OCCURRED_AT',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'This aggregates commits made by a user within one repository.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitContributionsByRepository',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commit contributions, each representing a day.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contributions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for commit contributions returned from the connection.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CommitContributionOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'field',
										},
										value: {
											kind: Kind.ENUM,
											value: 'OCCURRED_AT',
										},
									},
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'DESC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedCommitContributionConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository in which the commits were made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The HTTP path for the user's commits to the repository in this time range.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The HTTP URL for the user's commits to the repository in this time range.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Commit',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for Commit.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitHistoryConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Commit',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A message to include with a new commit',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommitMessage',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body of the message.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The headline of the message.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'headline',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value:
					'A git ref for a commit to be appended to.\n\nThe ref must be a branch, i.e. its fully qualified name must start\nwith `refs/heads/` (although the input is not required to be fully\nqualified).\n\nThe Ref may be specified by its global node ID or by the\n`repositoryNameWithOwner` and `branchName`.\n\n### Examples\n\nSpecify a branch using a global node ID:\n\n    { "id": "MDM6UmVmMTpyZWZzL2hlYWRzL21haW4=" }\n\nSpecify a branch using `repositoryNameWithOwner` and `branchName`:\n\n    {\n      "repositoryNameWithOwner": "github/graphql-client",\n      "branchName": "main"\n    }',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CommittableBranch',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The unqualified name of the branch to append the commit to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branchName',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the Ref to be updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The nameWithOwner of the repository to commit to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryNameWithOwner',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a comparison between two commit revisions.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Comparison',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The number of commits ahead of the base branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'aheadBy',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The base revision of this comparison.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'baseTarget',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObject',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The number of commits behind the base branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'behindBy',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commits which compose this comparison.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commits',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ComparisonCommitConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The head revision of this comparison.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'headTarget',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObject',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The status of this comparison.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'status',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ComparisonStatus',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for Commit.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ComparisonCommitConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The total count of authors and co-authors across all commits.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authorCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Commit',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The status of a git comparison between two refs.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ComparisonStatus',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The head ref is ahead of the base ref.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'AHEAD',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The head ref is behind the base ref.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'BEHIND',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The head ref is both ahead and behind of the base ref, indicating git history has diverged.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'DIVERGED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The head ref and base ref are identical.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'IDENTICAL',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'connected' event on a given issue or pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ConnectedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Reference originated in a different repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isCrossRepository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Issue or pull request that made the reference.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'source',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReferencedSubject',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Issue or pull request which was connected.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subject',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReferencedSubject',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INTERFACE_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a contribution a user made on GitHub, such as opening an issue.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Contribution',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Whether this contribution is associated with a record you do not have access to. For\nexample, your own 'first issue' contribution may have been made on a repository you can no\nlonger access.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRestricted',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'When this contribution was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'occurredAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who made this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'User',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A calendar of contributions made on GitHub by a user.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ContributionCalendar',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'A list of hex color codes used in this calendar. The darker the color, the more contributions it represents.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'colors',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'String',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Determine if the color set was chosen because it's currently Halloween.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isHalloween',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of the months of contributions in this calendar.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'months',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'ContributionCalendarMonth',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The count of total contributions in the calendar.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalContributions',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of the weeks of contributions in this calendar.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'weeks',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'ContributionCalendarWeek',
									},
								},
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a single day of contributions on GitHub by a user.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ContributionCalendarDay',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The hex color code that represents how many contributions were made on this day compared to others in the calendar.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'color',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many contributions were made by the user on this day.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contributionCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Indication of contributions, relative to other days. Can be used to indicate\nwhich color to represent this day on a calendar.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contributionLevel',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ContributionLevel',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The day this square represents.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'date',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Date',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A number representing which day of the week this square represents, e.g., 1 is Monday.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'weekday',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "A month of contributions in a user's contribution graph.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ContributionCalendarMonth',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The date of the first day of this month.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'firstDay',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Date',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the month.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many weeks started in this month.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalWeeks',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The year the month occurred in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'year',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "A week of contributions in a user's contribution graph.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ContributionCalendarWeek',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The days of contributions in this week.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contributionDays',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'ContributionCalendarDay',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The date of the earliest square in this week.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'firstDay',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Date',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Varying levels of contributions from none to many.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ContributionLevel',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Lowest 25% of days of contributions.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FIRST_QUARTILE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Highest 25% of days of contributions. More contributions than the third quartile.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FOURTH_QUARTILE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'No contributions occurred.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'NONE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Second lowest 25% of days of contributions. More contributions than the first quartile.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'SECOND_QUARTILE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Second highest 25% of days of contributions. More contributions than second quartile, less than the fourth quartile.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'THIRD_QUARTILE',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Ordering options for contribution connections.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ContributionOrder',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ordering direction.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'direction',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'OrderDirection',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value:
					'A contributions collection aggregates contributions such as opened issues and commits created by a user.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ContributionsCollection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Commit contributions made by the user, grouped by repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitContributionsByRepository',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'How many repositories should be included.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'maxRepositories',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							defaultValue: {
								kind: Kind.INT,
								value: '25',
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'CommitContributionsByRepository',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A calendar of this user's contributions on GitHub.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contributionCalendar',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ContributionCalendar',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The years the user has been making contributions with the most recent year first.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contributionYears',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'Int',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Determine if this collection's time span ends in the current month.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'doesEndInCurrentMonth',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The date of the first restricted contribution the user made in this time\nperiod. Can only be non-null when the user has enabled private contribution counts.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'earliestRestrictedContributionDate',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Date',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ending date and time of this collection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'endedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"The first issue the user opened on GitHub. This will be null if that issue was\nopened outside the collection's time range and ignoreTimeRange is false. If\nthe issue is not visible but the user has opted to show private contributions,\na RestrictedContribution will be returned.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'firstIssueContribution',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedIssueOrRestrictedContribution',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"The first pull request the user opened on GitHub. This will be null if that\npull request was opened outside the collection's time range and\nignoreTimeRange is not true. If the pull request is not visible but the user\nhas opted to show private contributions, a RestrictedContribution will be returned.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'firstPullRequestContribution',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedPullRequestOrRestrictedContribution',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"The first repository the user created on GitHub. This will be null if that\nfirst repository was created outside the collection's time range and\nignoreTimeRange is false. If the repository is not visible, then a\nRestrictedContribution is returned.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'firstRepositoryContribution',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedRepositoryOrRestrictedContribution',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Does the user have any more activity in the timeline that occurred prior to the collection's time range?",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'hasActivityInThePast',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Determine if there are any contributions in this collection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'hasAnyContributions',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Determine if the user made any contributions in this time frame whose details\nare not visible because they were made in a private repository. Can only be\ntrue if the user enabled private contribution counts.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'hasAnyRestrictedContributions',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Whether or not the collector's time span is all within the same day.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isSingleDay',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of issues the user opened.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issueContributions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first issue ever be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's most commented issue be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludePopular',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for contributions returned from the connection.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ContributionOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'DESC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedIssueContributionConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Issue contributions made by the user, grouped by repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issueContributionsByRepository',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first issue ever be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's most commented issue be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludePopular',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'How many repositories should be included.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'maxRepositories',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							defaultValue: {
								kind: Kind.INT,
								value: '25',
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'IssueContributionsByRepository',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"When the user signed up for GitHub. This will be null if that sign up date\nfalls outside the collection's time range and ignoreTimeRange is false.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'joinedGitHubContribution',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'JoinedGitHubContribution',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The date of the most recent restricted contribution the user made in this time\nperiod. Can only be non-null when the user has enabled private contribution counts.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'latestRestrictedContributionDate',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Date',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"When this collection's time range does not include any activity from the user, use this\nto get a different collection from an earlier time range that does have activity.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'mostRecentCollectionWithActivity',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ContributionsCollection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Returns a different contributions collection from an earlier time range than this one\nthat does not have any contributions.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'mostRecentCollectionWithoutActivity',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ContributionsCollection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The issue the user opened on GitHub that received the most comments in the specified\ntime frame.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'popularIssueContribution',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedIssueContribution',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The pull request the user opened on GitHub that received the most comments in the\nspecified time frame.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'popularPullRequestContribution',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedPullRequestContribution',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Pull request contributions made by the user.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestContributions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first pull request ever be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's most commented pull request be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludePopular',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for contributions returned from the connection.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ContributionOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'DESC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedPullRequestContributionConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Pull request contributions made by the user, grouped by repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestContributionsByRepository',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first pull request ever be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's most commented pull request be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludePopular',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'How many repositories should be included.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'maxRepositories',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							defaultValue: {
								kind: Kind.INT,
								value: '25',
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'PullRequestContributionsByRepository',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Pull request review contributions made by the user. Returns the most recently\nsubmitted review for each PR reviewed by the user.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReviewContributions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for contributions returned from the connection.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ContributionOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'DESC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedPullRequestReviewContributionConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Pull request review contributions made by the user, grouped by repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReviewContributionsByRepository',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'How many repositories should be included.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'maxRepositories',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							defaultValue: {
								kind: Kind.INT,
								value: '25',
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'PullRequestReviewContributionsByRepository',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of repositories owned by the user that the user created in this time range.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryContributions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first repository ever be excluded from the result.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for contributions returned from the connection.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ContributionOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'DESC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedRepositoryContributionConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'A count of contributions made by the user that the viewer cannot access. Only\nnon-zero when the user has chosen to share their private contribution counts.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'restrictedContributionsCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The beginning date and time of this collection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many commits were made by the user in this time span.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCommitContributions',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many issues the user opened.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalIssueContributions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first issue ever be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's most commented issue be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludePopular',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many pull requests the user opened.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalPullRequestContributions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first pull request ever be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's most commented pull request be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludePopular',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many pull request reviews the user left.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalPullRequestReviewContributions',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many different repositories the user committed to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalRepositoriesWithContributedCommits',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many different repositories the user opened issues in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalRepositoriesWithContributedIssues',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first issue ever be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's most commented issue be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludePopular',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many different repositories the user left pull request reviews in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalRepositoriesWithContributedPullRequestReviews',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many different repositories the user opened pull requests in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalRepositoriesWithContributedPullRequests',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first pull request ever be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's most commented pull request be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludePopular',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many repositories the user created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalRepositoryContributions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: "Should the user's first repository ever be excluded from this count.",
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'excludeFirst',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Boolean',
								},
							},
							defaultValue: {
								kind: Kind.BOOLEAN,
								value: false,
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who made the contributions in this collection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'User',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ConvertProjectCardNoteToIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ConvertProjectCardNoteToIssueInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body of the newly created issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ProjectCard ID to convert.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectCardId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectCard',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the repository to create the issue in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The title of the newly created issue. Defaults to the card's note text.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ConvertProjectCardNoteToIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ConvertProjectCardNoteToIssuePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The updated ProjectCard.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectCard',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectCard',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of ConvertPullRequestToDraft',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ConvertPullRequestToDraftInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'ID of the pull request to convert to draft',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of ConvertPullRequestToDraft',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ConvertPullRequestToDraftPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The pull request that is now a draft.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'convert_to_draft' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ConvertToDraftEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'UniformResourceLocatable',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this convert to draft event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this convert to draft event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'converted_note_to_issue' event on a given issue or pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ConvertedNoteToIssueEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Project referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'project',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Project',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'preview',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'toggledBy',
									},
									value: {
										kind: Kind.STRING,
										value: 'starfox-preview',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Project card referenced by this project event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectCard',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectCard',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'preview',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'toggledBy',
									},
									value: {
										kind: Kind.STRING,
										value: 'starfox-preview',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Column name referenced by this project event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectColumnName',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'preview',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'toggledBy',
									},
									value: {
										kind: Kind.STRING,
										value: 'starfox-preview',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'converted_to_discussion' event on a given issue.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'ConvertedToDiscussionEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion that the issue was converted into.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'discussion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Discussion',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CopyProjectV2',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CopyProjectV2Input',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Include draft issues in the new project',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'includeDraftIssues',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The owner ID of the new project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'OrganizationOrUser',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the source Project to copy.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title of the project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CopyProjectV2',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CopyProjectV2Payload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The copied project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectV2',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateAttributionInvitation',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateAttributionInvitationInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the owner scoping the reattributable data.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Bot',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Enterprise',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Mannequin',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the account owning the data to reattribute.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sourceId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Bot',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Enterprise',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Mannequin',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the account which may claim the data.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'targetId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Bot',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Enterprise',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Mannequin',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateAttributionInvitation',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateAttributionInvitationPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The owner scoping the reattributable data.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'owner',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Organization',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The account owning the data to reattribute.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'source',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Claimable',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The account which may claim the data.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'target',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Claimable',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateBranchProtectionRule',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateBranchProtectionRuleInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can this branch be deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'allowsDeletions',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are force pushes allowed on this branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'allowsForcePushes',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Is branch creation a protected operation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'blocksCreations',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of User, Team, or App IDs allowed to bypass force push targeting matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bypassForcePushActorIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of User, Team, or App IDs allowed to bypass pull requests targeting matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bypassPullRequestActorIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Will new commits pushed to matching branches dismiss pull request review approvals.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'dismissesStaleReviews',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can admins overwrite branch protection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isAdminEnforced',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether users can pull changes from upstream when the branch is locked. Set to\n`true` to allow fork syncing. Set to `false` to prevent fork syncing.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'lockAllowsFetchAndMerge',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'lockBranch',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The glob-like pattern used to determine matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pattern',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of User, Team, or App IDs allowed to push to matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pushActorIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The global relay id of the repository in which a new branch protection rule should be created in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether the most recent push must be approved by someone other than the person who pushed it',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requireLastPushApproval',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Number of approving reviews required to update matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredApprovingReviewCount',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The list of required deployment environments',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredDeploymentEnvironments',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'List of required status check contexts that must pass for commits to be accepted to matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredStatusCheckContexts',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The list of required status checks',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredStatusChecks',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'RequiredStatusCheckInput',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are approving reviews required to update matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresApprovingReviews',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are reviews from code owners required to update matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresCodeOwnerReviews',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are commits required to be signed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresCommitSignatures',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are conversations required to be resolved before merging.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresConversationResolution',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are successful deployments required before merging.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresDeployments',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are merge commits prohibited from being pushed to this branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresLinearHistory',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are status checks required to update matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresStatusChecks',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Are branches required to be up to date before merging.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiresStrictStatusChecks',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Is pushing to matching branches restricted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'restrictsPushes',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Is dismissal of pull request reviews restricted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'restrictsReviewDismissals',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'A list of User, Team, or App IDs allowed to dismiss reviews on pull requests targeting matching branches.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reviewDismissalActorIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateBranchProtectionRule',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateBranchProtectionRulePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The newly created BranchProtectionRule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branchProtectionRule',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'BranchProtectionRule',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateCheckRun',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateCheckRunInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Possible further actions the integrator can perform, which a user may trigger.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actions',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'CheckRunAction',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The time that the check run finished.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'completedAt',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The final conclusion of the check.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'conclusion',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckConclusionState',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The URL of the integrator's site that has the full details of the check.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'detailsUrl',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "A reference for the run on the integrator's system.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'externalId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The SHA of the head commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'headSha',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObjectID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the check.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Descriptive details about the run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'output',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckRunOutput',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The time that the check run began.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'startedAt',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The current status.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'status',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'RequestableCheckStatusState',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateCheckRun',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateCheckRunPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The newly created check run.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'checkRun',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckRun',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateCheckSuite',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateCheckSuiteInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The SHA of the head commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'headSha',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObjectID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateCheckSuite',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateCheckSuitePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The newly created check suite.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'checkSuite',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CheckSuite',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateCommitOnBranch',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateCommitOnBranchInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Ref to be updated.  Must be a branch.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branch',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommittableBranch',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The git commit oid expected at the head of the branch prior to the commit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'expectedHeadOid',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObjectID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A description of changes to files in this commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'fileChanges',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'FileChanges',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commit message the be included with the commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'message',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommitMessage',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateCommitOnBranch',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateCommitOnBranchPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commit',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Commit',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ref which has been updated to point to the new commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ref',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Ref',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateDeployment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateDeploymentInput',
			},
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'flash-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Attempt to automatically merge the default branch into the requested ref, defaults to true.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'autoMerge',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: true,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Short description of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					defaultValue: {
						kind: Kind.STRING,
						value: '',
						block: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Name for the target deployment environment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environment',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					defaultValue: {
						kind: Kind.STRING,
						value: 'production',
						block: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'JSON payload with extra information about the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'payload',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					defaultValue: {
						kind: Kind.STRING,
						value: '{}',
						block: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The node ID of the ref to be deployed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'refId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Ref',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The status contexts to verify against commit status checks. To bypass required\ncontexts, pass an empty array. Defaults to all unique contexts.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requiredContexts',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Specifies a task to execute.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'task',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					defaultValue: {
						kind: Kind.STRING,
						value: 'deploy',
						block: false,
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateDeployment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateDeploymentPayload',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'flash-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'True if the default branch has been auto-merged into the deployment ref.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'autoMerged',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deployment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Deployment',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateDeploymentStatus',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateDeploymentStatusInput',
			},
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'flash-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Adds a new inactive status to all non-transient, non-production environment\ndeployments with the same repository and environment name as the created\nstatus's deployment.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'autoInactive',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: true,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The node ID of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deploymentId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Deployment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A short description of the status. Maximum length of 140 characters.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					defaultValue: {
						kind: Kind.STRING,
						value: '',
						block: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'If provided, updates the environment of the deploy. Otherwise, does not modify the environment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environment',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Sets the URL for accessing your environment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environmentUrl',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					defaultValue: {
						kind: Kind.STRING,
						value: '',
						block: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The log URL to associate with this status.       This URL should contain\noutput to keep the user updated while the task is running       or serve as\nhistorical information for what happened in the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'logUrl',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					defaultValue: {
						kind: Kind.STRING,
						value: '',
						block: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The state of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'state',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentStatusState',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateDeploymentStatus',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateDeploymentStatusPayload',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'flash-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new deployment status.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deploymentStatus',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentStatus',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateDiscussionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body of the discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the discussion category to associate with this discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'categoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'DiscussionCategory',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the repository on which to create the discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title of the discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateDiscussionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion that was just created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'discussion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Discussion',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateEnterpriseOrganization',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateEnterpriseOrganizationInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The logins for the administrators of the new organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'adminLogins',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.LIST_TYPE,
							type: {
								kind: Kind.NON_NULL_TYPE,
								type: {
									kind: Kind.NAMED_TYPE,
									name: {
										kind: Kind.NAME,
										value: 'String',
									},
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The email used for sending billing receipts.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'billingEmail',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the enterprise owning the new organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enterpriseId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Enterprise',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The login of the new organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'login',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The profile name of the new organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'profileName',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateEnterpriseOrganization',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateEnterpriseOrganizationPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The enterprise that owns the created organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'enterprise',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Enterprise',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The organization that was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'organization',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Organization',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateEnvironment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateEnvironmentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the environment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateEnvironment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateEnvironmentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new or existing environment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Environment',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateIpAllowListEntry',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateIpAllowListEntryInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An IP address or range of addresses in CIDR notation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'allowListValue',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether the IP allow list entry is active when an IP allow list is enabled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isActive',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An optional name for the IP allow list entry.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the owner for which to create the new IP allow list entry.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'App',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Enterprise',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'IpAllowListOwner',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateIpAllowListEntry',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateIpAllowListEntryPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The IP allow list entry that was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ipAllowListEntry',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'IpAllowListEntry',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateIssueInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID for the user assignee for this issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'assigneeIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body for the issue description.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The name of an issue template in the repository, assigns labels and assignees from the template to the issue',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issueTemplate',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An array of Node IDs of labels for this issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'labelIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Label',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the milestone for this issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'milestoneId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Milestone',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An array of Node IDs for projects associated with this issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Project',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title for the issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateIssuePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issue',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Issue',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateLabel',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateLabelInput',
			},
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'bane-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A 6 character hex code, without the leading #, identifying the color of the label.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'color',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A brief description of the label, such as its purpose.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the label.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateLabel',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateLabelPayload',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'bane-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new label.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'label',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Label',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateLinkedBranch',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateLinkedBranchInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'ID of the issue to link to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issueId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the new branch. Defaults to issue number and title.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The commit SHA to base the new branch on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'oid',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObjectID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'ID of the repository to create the branch in. Defaults to the issue repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateLinkedBranch',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateLinkedBranchPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new branch issue reference.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'linkedBranch',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'LinkedBranch',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateMigrationSource',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateMigrationSourceInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The migration source access token.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'accessToken',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The GitHub personal access token of the user importing to the target repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'githubPat',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The migration source name.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the organization that will own the migration source.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The migration source type.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'type',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'MigrationSourceType',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The migration source URL, for example `https://github.com` or `https://monalisa.ghe.com`.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateMigrationSource',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateMigrationSourcePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The created migration source.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'migrationSource',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'MigrationSource',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateProject',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateProjectInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The description of project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The owner ID to create the project under.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'ProjectOwner',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of repository IDs to create as linked repositories for the project',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryIds',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ID',
								},
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the GitHub-provided template.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'template',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectTemplate',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateProject',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateProjectPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'project',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Project',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateProjectV2Field',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateProjectV2FieldInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The data type of the field.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'dataType',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ProjectV2CustomFieldType',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the field.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the Project to create the field in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Options for a single select field. At least one value is required if data_type is SINGLE_SELECT',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'singleSelectOptions',
					},
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ProjectV2SingleSelectFieldOptionInput',
								},
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateProjectV2Field',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateProjectV2FieldPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new field.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectV2Field',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2FieldConfiguration',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateProjectV2',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateProjectV2Input',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The owner ID to create the project under.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'OrganizationOrUser',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository to link the project to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The team to link the project to. The team will be granted read permissions.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'teamId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Team',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title of the project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateProjectV2',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateProjectV2Payload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectV2',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreatePullRequest',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatePullRequestInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The name of the branch you want your changes pulled into. This should be an existing branch\non the current repository. You cannot update the base branch on a pull request to point\nto another repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'baseRefName',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The contents of the pull request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates whether this pull request should be a draft.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'draft',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The name of the branch where your changes are implemented. For cross-repository pull requests\nin the same network, namespace `head_ref_name` with a user like this: `username:branch`.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'headRefName',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the head repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'headRepositoryId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates whether maintainers can modify the pull request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'maintainerCanModify',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: true,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title of the pull request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreatePullRequest',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatePullRequestPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new pull request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateRef',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateRefInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The fully qualified name of the new Ref (ie: `refs/heads/my_new_branch`).',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The GitObjectID that the new Ref shall target. Must point to a commit.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'oid',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'GitObjectID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the Repository to create the Ref in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateRef',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateRefPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The newly created ref.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ref',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Ref',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateRepository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateRepositoryInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A short description of the new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates if the repository should have the issues feature enabled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'hasIssuesEnabled',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: true,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates if the repository should have the wiki feature enabled.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'hasWikiEnabled',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The URL for a web page about this repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'homepageUrl',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the owner for the new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ownerId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'RepositoryOwner',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'When an organization is specified as the owner, this ID identifies the team\nthat should be granted access to the new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'teamId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Team',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether this repository should be marked as a template such that anyone who\ncan access it can create new repositories with the same files and directory structure.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'template',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Indicates the repository's visibility level.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'visibility',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'RepositoryVisibility',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateRepository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateRepositoryPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Repository',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateSponsorsListing',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateSponsorsListingInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"The country or region where the sponsorable's bank account is located.\nRequired if fiscalHostLogin is not specified, ignored when fiscalHostLogin is specified.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'billingCountryOrRegionCode',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'SponsorsCountryOrRegionCode',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The email address we should use to contact you about the GitHub Sponsors\nprofile being created. This will not be shared publicly. Must be a verified\nemail address already on your GitHub account. Only relevant when the\nsponsorable is yourself. Defaults to your primary email address on file if omitted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'contactEmail',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"The username of the supported fiscal host's GitHub organization, if you want\nto receive sponsorship payouts through a fiscal host rather than directly to a\nbank account. For example, 'Open-Source-Collective' for Open Source Collective\nor 'numfocus' for numFOCUS. Case insensitive. See https://docs.github.com/sponsors/receiving-sponsorships-through-github-sponsors/using-a-fiscal-host-to-receive-github-sponsors-payouts\nfor more information.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'fiscalHostLogin',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"The URL for your profile page on the fiscal host's website, e.g.,\nhttps://opencollective.com/babel or https://numfocus.org/project/bokeh.\nRequired if fiscalHostLogin is specified.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'fiscallyHostedProjectProfileUrl',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Provide an introduction to serve as the main focus that appears on your GitHub\nSponsors profile. It's a great opportunity to help potential sponsors learn\nmore about you, your work, and why their sponsorship is important to you.\nGitHub-flavored Markdown is supported.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'fullDescription',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The country or region where the sponsorable resides. This is for tax purposes.\nRequired if the sponsorable is yourself, ignored when sponsorableLogin\nspecifies an organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'residenceCountryOrRegionCode',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'SponsorsCountryOrRegionCode',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The username of the organization to create a GitHub Sponsors profile for, if\ndesired. Defaults to creating a GitHub Sponsors profile for the authenticated\nuser if omitted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorableLogin',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateSponsorsListing',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateSponsorsListingPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new GitHub Sponsors profile.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorsListing',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'SponsorsListing',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateSponsorsTier',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateSponsorsTierInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The value of the new tier in US dollars. Valid values: 1-12000.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'amount',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'A description of what this tier is, what perks sponsors might receive, what a sponsorship at this tier means for you, etc.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether sponsorships using this tier should happen monthly/yearly or just once.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRecurring',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: true,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether to make the tier available immediately for sponsors to choose.\nDefaults to creating a draft tier that will not be publicly visible.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'publish',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: false,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Optional ID of the private repository that sponsors at this tier should gain\nread-only access to. Must be owned by an organization.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Optional name of the private repository that sponsors at this tier should gain\nread-only access to. Must be owned by an organization. Necessary if\nrepositoryOwnerLogin is given. Will be ignored if repositoryId is given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryName',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Optional login of the organization owner of the private repository that\nsponsors at this tier should gain read-only access to. Necessary if\nrepositoryName is given. Will be ignored if repositoryId is given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryOwnerLogin',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The ID of the user or organization who owns the GitHub Sponsors profile.\nDefaults to the current user if omitted and sponsorableLogin is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorableId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Sponsorable',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The username of the user or organization who owns the GitHub Sponsors profile.\nDefaults to the current user if omitted and sponsorableId is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorableLogin',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Optional message new sponsors at this tier will receive.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'welcomeMessage',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateSponsorsTier',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateSponsorsTierPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new tier.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorsTier',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'SponsorsTier',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateSponsorship',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateSponsorshipInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The amount to pay to the sponsorable in US dollars. Required if a tierId is not specified. Valid values: 1-12000.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'amount',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether the sponsorship should happen monthly/yearly or just this one time. Required if a tierId is not specified.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRecurring',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Specify whether others should be able to see that the sponsor is sponsoring\nthe sponsorable. Public visibility still does not reveal which tier is used.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'privacyLevel',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'SponsorshipPrivacy',
						},
					},
					defaultValue: {
						kind: Kind.ENUM,
						value: 'PUBLIC',
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether the sponsor should receive email updates from the sponsorable.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'receiveEmails',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					defaultValue: {
						kind: Kind.BOOLEAN,
						value: true,
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The ID of the user or organization who is acting as the sponsor, paying for\nthe sponsorship. Required if sponsorLogin is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Sponsor',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The username of the user or organization who is acting as the sponsor, paying\nfor the sponsorship. Required if sponsorId is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorLogin',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The ID of the user or organization who is receiving the sponsorship. Required if sponsorableLogin is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorableId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Organization',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'User',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'Sponsorable',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The username of the user or organization who is receiving the sponsorship. Required if sponsorableId is not given.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorableLogin',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The ID of one of sponsorable's existing tiers to sponsor at. Required if amount is not specified.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'tierId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'SponsorsTier',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateSponsorship',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateSponsorshipPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The sponsorship that was started.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'sponsorship',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Sponsorship',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateTeamDiscussionComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateTeamDiscussionCommentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The content of the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the discussion to which the comment belongs.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'discussionId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'TeamDiscussion',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateTeamDiscussionComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateTeamDiscussionCommentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'teamDiscussionComment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'TeamDiscussionComment',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of CreateTeamDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateTeamDiscussionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The content of the discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'If true, restricts the visibility of this discussion to team members and\norganization admins. If false or not specified, allows any organization member\nto view this discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'private',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the team to which the discussion belongs.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'teamId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Team',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title of the discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of CreateTeamDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreateTeamDiscussionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The new discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'teamDiscussion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'TeamDiscussion',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents the contribution a user made by committing to a repository.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedCommitContribution',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Contribution',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'How many commits were made on this day to this repository by the user.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Whether this contribution is associated with a record you do not have access to. For\nexample, your own 'first issue' contribution may have been made on a repository you can no\nlonger access.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRestricted',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'When this contribution was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'occurredAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository the user made a commit in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who made this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'User',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CreatedCommitContribution.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedCommitContributionConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedCommitContributionEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedCommitContribution',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of commits across days and repositories in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedCommitContributionEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedCommitContribution',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents the contribution a user made on GitHub by opening an issue.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedIssueContribution',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Contribution',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Whether this contribution is associated with a record you do not have access to. For\nexample, your own 'first issue' contribution may have been made on a repository you can no\nlonger access.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRestricted',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The issue that was opened.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issue',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Issue',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'When this contribution was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'occurredAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who made this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'User',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CreatedIssueContribution.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedIssueContributionConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedIssueContributionEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedIssueContribution',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedIssueContributionEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedIssueContribution',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents either a issue the viewer can access or a restricted contribution.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedIssueOrRestrictedContribution',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'CreatedIssueContribution',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RestrictedContribution',
					},
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents the contribution a user made on GitHub by opening a pull request.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedPullRequestContribution',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Contribution',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Whether this contribution is associated with a record you do not have access to. For\nexample, your own 'first issue' contribution may have been made on a repository you can no\nlonger access.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRestricted',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'When this contribution was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'occurredAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The pull request that was opened.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who made this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'User',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CreatedPullRequestContribution.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedPullRequestContributionConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedPullRequestContributionEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedPullRequestContribution',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedPullRequestContributionEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedPullRequestContribution',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents either a pull request the viewer can access or a restricted contribution.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedPullRequestOrRestrictedContribution',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'CreatedPullRequestContribution',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RestrictedContribution',
					},
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents the contribution a user made by leaving a review on a pull request.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedPullRequestReviewContribution',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Contribution',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Whether this contribution is associated with a record you do not have access to. For\nexample, your own 'first issue' contribution may have been made on a repository you can no\nlonger access.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRestricted',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'When this contribution was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'occurredAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The pull request the user reviewed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The review the user left on the pull request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReview',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequestReview',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository containing the pull request that the user reviewed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who made this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'User',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CreatedPullRequestReviewContribution.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedPullRequestReviewContributionConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedPullRequestReviewContributionEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedPullRequestReviewContribution',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedPullRequestReviewContributionEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedPullRequestReviewContribution',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents the contribution a user made on GitHub by creating a repository.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedRepositoryContribution',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Contribution',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							"Whether this contribution is associated with a record you do not have access to. For\nexample, your own 'first issue' contribution may have been made on a repository you can no\nlonger access.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isRestricted',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'When this contribution was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'occurredAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository that was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user who made this contribution.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'User',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for CreatedRepositoryContribution.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedRepositoryContributionConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedRepositoryContributionEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CreatedRepositoryContribution',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedRepositoryContributionEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'CreatedRepositoryContribution',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents either a repository the viewer can access or a restricted contribution.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CreatedRepositoryOrRestrictedContribution',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'CreatedRepositoryContribution',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RestrictedContribution',
					},
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents a mention made by one issue or pull request to another.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'CrossReferencedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'UniformResourceLocatable',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Reference originated in a different repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isCrossRepository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies when the reference was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'referencedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP path for this pull request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Issue or pull request that made the reference.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'source',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReferencedSubject',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Issue or pull request to which the reference was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'target',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReferencedSubject',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The HTTP URL for this pull request.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Checks if the target will be closed when the source is merged.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'willCloseTarget',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.SCALAR_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An ISO-8601 encoded date string.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Date',
			},
			directives: [],
		},
		{
			kind: Kind.SCALAR_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An ISO-8601 encoded UTC date string.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DateTime',
			},
			directives: [],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeclineTopicSuggestion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeclineTopicSuggestionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of the suggested topic.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The reason why the suggested topic is declined.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reason',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'TopicSuggestionDeclineReason',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repositoryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Repository',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeclineTopicSuggestion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeclineTopicSuggestionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The declined topic.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'topic',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Topic',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible base permissions for repositories.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DefaultRepositoryPermissionField',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can read, write, and administrate repos by default',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ADMIN',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'No access',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'NONE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can read repos by default',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'READ',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can read and write repos by default',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'WRITE',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INTERFACE_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Entities that can be deleted.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Deletable',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the current viewer can delete this object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanDelete',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteBranchProtectionRule',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteBranchProtectionRuleInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The global relay id of the branch protection rule to be deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'branchProtectionRuleId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'BranchProtectionRule',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteBranchProtectionRule',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteBranchProtectionRulePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteDeployment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteDeploymentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the deployment to be deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Deployment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteDeployment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteDeploymentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteDiscussionComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteDiscussionCommentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node id of the discussion comment to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'DiscussionComment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteDiscussionComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteDiscussionCommentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion comment that was just deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiscussionComment',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteDiscussionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the discussion to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Discussion',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteDiscussionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion that was just deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'discussion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Discussion',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteEnvironment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteEnvironmentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the environment to be deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Environment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteEnvironment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteEnvironmentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteIpAllowListEntry',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteIpAllowListEntryInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the IP allow list entry to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ipAllowListEntryId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'IpAllowListEntry',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteIpAllowListEntry',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteIpAllowListEntryPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The IP allow list entry that was deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ipAllowListEntry',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'IpAllowListEntry',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteIssueComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteIssueCommentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the comment to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'IssueComment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteIssueComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteIssueCommentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteIssueInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the issue to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issueId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Issue',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteIssue',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteIssuePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository the issue belonged to',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Repository',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteLabel',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteLabelInput',
			},
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'bane-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the label to be deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Label',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteLabel',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteLabelPayload',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'bane-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteLinkedBranch',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteLinkedBranchInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the linked branch',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'linkedBranchId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'LinkedBranch',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteLinkedBranch',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteLinkedBranchPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The issue the linked branch was unlinked from.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'issue',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Issue',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeletePackageVersion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeletePackageVersionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the package version to be deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'packageVersionId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PackageVersion',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeletePackageVersion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeletePackageVersionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether or not the operation succeeded.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'success',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Boolean',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteProjectCard',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectCardInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the card to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cardId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectCard',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteProjectCard',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectCardPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The column the deleted card was in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'column',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectColumn',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deleted card ID.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deletedCardId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteProjectColumn',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectColumnInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The id of the column to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'columnId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectColumn',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteProjectColumn',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectColumnPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deleted column ID.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deletedColumnId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The project the deleted column was in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'project',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Project',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteProject',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Project ID to update.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Project',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteProject',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository or organization the project was removed from.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'owner',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectOwner',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteProjectV2Field',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectV2FieldInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the field to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'fieldId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2Field',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'ProjectV2IterationField',
												block: false,
											},
											{
												kind: Kind.STRING,
												value: 'ProjectV2SingleSelectField',
												block: false,
											},
										],
									},
								},
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'abstractType',
									},
									value: {
										kind: Kind.STRING,
										value: 'ProjectV2FieldConfiguration',
										block: false,
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteProjectV2Field',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectV2FieldPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deleted field.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectV2Field',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2FieldConfiguration',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteProjectV2',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectV2Input',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the Project to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteProjectV2Item',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectV2ItemInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the item to be removed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'itemId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2Item',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the Project from which the item should be removed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteProjectV2Item',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectV2ItemPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the deleted item.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deletedItemId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteProjectV2',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectV2Payload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deleted Project.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectV2',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteProjectV2Workflow',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectV2WorkflowInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the workflow to be removed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'workflowId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'ProjectV2Workflow',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteProjectV2Workflow',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteProjectV2WorkflowPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the deleted workflow.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deletedWorkflowId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ID',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The project the deleted workflow was in.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'projectV2',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'ProjectV2',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeletePullRequestReviewComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeletePullRequestReviewCommentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the comment to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequestReviewComment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeletePullRequestReviewComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeletePullRequestReviewCommentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The pull request review the deleted comment belonged to.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReview',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReview',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deleted pull request review comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReviewComment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReviewComment',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeletePullRequestReview',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeletePullRequestReviewInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the pull request review to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReviewId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequestReview',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeletePullRequestReview',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeletePullRequestReviewPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deleted pull request review.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestReview',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequestReview',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteRef',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteRefInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The Node ID of the Ref to be deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'refId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'Ref',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteRef',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteRefPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteTeamDiscussionComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteTeamDiscussionCommentInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the comment to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'TeamDiscussionComment',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteTeamDiscussionComment',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteTeamDiscussionCommentPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteTeamDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteTeamDiscussionInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion ID to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'TeamDiscussion',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteTeamDiscussion',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteTeamDiscussionPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DeleteVerifiableDomain',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteVerifiableDomainInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ID of the verifiable domain to delete.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'VerifiableDomain',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DeleteVerifiableDomain',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeleteVerifiableDomainPayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The owning account from which the domain was deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'owner',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'VerifiableDomainOwner',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'demilestoned' event on a given issue or pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DemilestonedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Identifies the milestone title associated with the 'demilestoned' event.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'milestoneTitle',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Object referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subject',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'MilestoneItem',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A Dependabot Update for a dependency in a repository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependabotUpdate',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RepositoryNode',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The error from a dependency update',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'error',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DependabotUpdateError',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The associated pull request',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository associated with this node.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An error produced from a Dependabot Update',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependabotUpdateError',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body of the error',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The error code',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'errorType',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title of the error',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A dependency manifest entry',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependencyGraphDependency',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'hawkgirl-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Does the dependency itself have dependencies?',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'hasDependencies',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The original name of the package, as it appears in the manifest.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'packageLabel',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'deprecated',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'reason',
									},
									value: {
										kind: Kind.STRING,
										value:
											'`packageLabel` will be removed. Use normalized `packageName` field instead. Removal on 2022-10-01 UTC.',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The dependency package manager',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'packageManager',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'The name of the package in the canonical form used by the package manager.\nThis may differ from the original textual form (see packageLabel), for example\nin a package manager that uses case-insensitive comparisons.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'packageName',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository containing the package',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Repository',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The dependency version requirements',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'requirements',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DependencyGraphDependency.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependencyGraphDependencyConnection',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'hawkgirl-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DependencyGraphDependencyEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DependencyGraphDependency',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependencyGraphDependencyEdge',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'hawkgirl-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DependencyGraphDependency',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible ecosystems of a dependency graph package.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependencyGraphEcosystem',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'GitHub Actions',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ACTIONS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PHP packages hosted at packagist.org',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'COMPOSER',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Go modules',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'GO',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Java artifacts hosted at the Maven central repository',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'MAVEN',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'JavaScript packages hosted at npmjs.com',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'NPM',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: '.NET packages hosted at the NuGet Gallery',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'NUGET',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Python packages hosted at PyPI.org',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'PIP',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Dart packages hosted at pub.dev',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'PUB',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Ruby gems hosted at RubyGems.org',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'RUBYGEMS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Rust crates',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'RUST',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Dependency manifest for a repository',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependencyGraphManifest',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'hawkgirl-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Path to view the manifest file blob',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'blobPath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of manifest dependencies',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'dependencies',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DependencyGraphDependencyConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The number of dependencies listed in the manifest',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'dependenciesCount',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Is the manifest too big to parse?',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'exceedsMaxSize',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Fully qualified manifest filename',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'filename',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Were we able to parse the manifest?',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'parseable',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository containing the manifest',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DependencyGraphManifest.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependencyGraphManifestConnection',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'hawkgirl-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DependencyGraphManifestEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DependencyGraphManifest',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DependencyGraphManifestEdge',
			},
			interfaces: [],
			directives: [
				{
					kind: Kind.DIRECTIVE,
					name: {
						kind: Kind.NAME,
						value: 'preview',
					},
					arguments: [
						{
							kind: Kind.ARGUMENT,
							name: {
								kind: Kind.NAME,
								value: 'toggledBy',
							},
							value: {
								kind: Kind.STRING,
								value: 'hawkgirl-preview',
								block: false,
							},
						},
					],
				},
			],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DependencyGraphManifest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A repository deploy key.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeployKey',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deploy key.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'key',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether or not the deploy key is read only.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'readOnly',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deploy key title.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether or not the deploy key has been verified.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'verified',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DeployKey.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeployKeyConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeployKeyEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeployKey',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeployKeyEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeployKey',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'deployed' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeployedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The deployment associated with the 'deployed' event.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deployment',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Deployment',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The ref associated with the 'deployed' event.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ref',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Ref',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Represents triggered deployment instance.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Deployment',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the commit sha of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commit',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Commit',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the oid of the deployment commit, even if the commit has been deleted.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'commitOid',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who triggered the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'creator',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Actor',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment description.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The latest environment to which this deployment was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The latest environment to which this deployment was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'latestEnvironment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The latest status of this deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'latestStatus',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentStatus',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The original environment to which this deployment was made.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'originalEnvironment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Extra information that a deployment system might need.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'payload',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the Ref of the deployment, if the deployment was created by ref.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ref',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Ref',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the repository associated with the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The current state of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'state',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentState',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of statuses associated with the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'statuses',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentStatusConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment task.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'task',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for Deployment.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Deployment',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Deployment',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'deployment_environment_changed' event on a given pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentEnvironmentChangedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment status that updated the deployment environment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deploymentStatus',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentStatus',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'PullRequest referenced by event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PullRequest',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Ordering options for deployment connections',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentOrder',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The ordering direction.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'direction',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'OrderDirection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The field to order deployments by.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'field',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentOrderField',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Properties by which deployment connections can be ordered.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentOrderField',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Order collection by creation time',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'CREATED_AT',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A protection rule.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentProtectionRule',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The teams or users that can review the deployment',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reviewers',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentReviewerConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The timeout in minutes for this protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'timeout',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The type of protection rule.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'type',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentProtectionRuleType',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DeploymentProtectionRule.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentProtectionRuleConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentProtectionRuleEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentProtectionRule',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentProtectionRuleEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentProtectionRule',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible protection rule types.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentProtectionRuleType',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Required reviewers',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'REQUIRED_REVIEWERS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Wait timer',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'WAIT_TIMER',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A request to deploy a workflow run to an environment.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentRequest',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether or not the current user can approve the deployment',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'currentUserCanApprove',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The target environment of the deployment',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environment',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Environment',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The teams or users that can review the deployment',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reviewers',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentReviewerConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The wait timer in minutes configured in the environment',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'waitTimer',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The wait timer in minutes configured in the environment',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'waitTimerStartedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DeploymentRequest.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentRequestConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentRequestEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentRequest',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentRequestEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A deployment review.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentReview',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The comment the user left.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comment',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The environments approved or rejected',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environments',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'EnvironmentConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The decision of the user.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'state',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentReviewState',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The user that reviewed the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'user',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'User',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DeploymentReview.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentReviewConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentReviewEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentReview',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentReviewEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentReview',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible states for a deployment review.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentReviewState',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment was approved.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'APPROVED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment was rejected.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'REJECTED',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.UNION_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Users and teams.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentReviewer',
			},
			directives: [],
			types: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Team',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'User',
					},
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DeploymentReviewer.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentReviewerConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentReviewerEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentReviewer',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentReviewerEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentReviewer',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible states in which a deployment can be.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentState',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The pending deployment was not updated after 30 minutes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ABANDONED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is currently active.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ACTIVE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An inactive transient deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'DESTROYED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment experienced an error.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ERROR',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment has failed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FAILURE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is inactive.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'INACTIVE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is in progress.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'IN_PROGRESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is pending.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'PENDING',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment has queued',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'QUEUED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment was successful.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'SUCCESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is waiting.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'WAITING',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Describes the status of a given deployment attempt.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentStatus',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who triggered the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'creator',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Actor',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the deployment associated with status.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deployment',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Deployment',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the description of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the environment of the deployment at the time of this deployment status',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environment',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'preview',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'toggledBy',
									},
									value: {
										kind: Kind.STRING,
										value: 'flash-preview',
										block: false,
									},
								},
							],
						},
					],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the environment URL of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'environmentUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the log URL of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'logUrl',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'URI',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the current state of the deployment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'state',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentStatusState',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DeploymentStatus.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentStatusConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentStatusEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DeploymentStatus',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentStatusEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DeploymentStatus',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible states for a deployment status.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DeploymentStatusState',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment experienced an error.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'ERROR',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment has failed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'FAILURE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is inactive.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'INACTIVE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is in progress.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'IN_PROGRESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is pending.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'PENDING',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is queued',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'QUEUED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment was successful.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'SUCCESS',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The deployment is waiting.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'WAITING',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible sides of a diff.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DiffSide',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The left side of the diff.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'LEFT',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The right side of the diff.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'RIGHT',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated input type of DisablePullRequestAutoMerge',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DisablePullRequestAutoMergeInput',
			},
			directives: [],
			fields: [
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.INPUT_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'ID of the pull request to disable auto merge on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequestId',
					},
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [
						{
							kind: Kind.DIRECTIVE,
							name: {
								kind: Kind.NAME,
								value: 'possibleTypes',
							},
							arguments: [
								{
									kind: Kind.ARGUMENT,
									name: {
										kind: Kind.NAME,
										value: 'concreteTypes',
									},
									value: {
										kind: Kind.LIST,
										values: [
											{
												kind: Kind.STRING,
												value: 'PullRequest',
												block: false,
											},
										],
									},
								},
							],
						},
					],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'Autogenerated return type of DisablePullRequestAutoMerge',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DisablePullRequestAutoMergePayload',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A unique identifier for the client performing the mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'clientMutationId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The pull request auto merge was disabled on.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pullRequest',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'PullRequest',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: "Represents a 'disconnected' event on a given issue or pull request.",
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DisconnectedEvent',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the actor who performed the event.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'actor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Reference originated in a different repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isCrossRepository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Issue or pull request from which the issue was disconnected.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'source',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReferencedSubject',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Issue or pull request which was disconnected.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'subject',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReferencedSubject',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A discussion in a repository.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'Discussion',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Closable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Comment',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Deletable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Labelable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Lockable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Reactable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RepositoryNode',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Subscribable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Updatable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Votable',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Reason that the conversation was locked.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'activeLockReason',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'LockReason',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The comment chosen as this discussion's answer, if any.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'answer',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiscussionComment',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The time when a user chose this discussion's answer, if answered.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'answerChosenAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "The user who chose this discussion's answer, if answered.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'answerChosenBy',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who authored the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'author',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Author's association with the subject of the comment.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authorAssociation',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommentAuthorAssociation',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The main text of the discussion post.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body rendered to HTML.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bodyHTML',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'HTML',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body rendered to text.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bodyText',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The category for this discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'category',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DiscussionCategory',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates if the object is closed (definition of closed may depend on type)',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'closed',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was closed.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'closedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The replies to the discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'comments',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DiscussionCommentConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if this comment was created via an email reply.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdViaEmail',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who edited the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'editor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if this comment was edited and includes an edit with the creation data',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'includesCreatedEdit',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of labels associated with the object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'labels',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Ordering options for labels returned from the connection.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'LabelOrder',
								},
							},
							defaultValue: {
								kind: Kind.OBJECT,
								fields: [
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'field',
										},
										value: {
											kind: Kind.ENUM,
											value: 'CREATED_AT',
										},
									},
									{
										kind: Kind.OBJECT_FIELD,
										name: {
											kind: Kind.NAME,
											value: 'direction',
										},
										value: {
											kind: Kind.ENUM,
											value: 'ASC',
										},
									},
								],
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'LabelConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The moment the editor made the last edit',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'lastEditedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: '`true` if the object is locked',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'locked',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The number identifying this discussion within the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'number',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The poll associated with this discussion, if one exists.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'poll',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiscussionPoll',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies when the comment was published at.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'publishedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of reactions grouped by content left on the subject.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reactionGroups',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NON_NULL_TYPE,
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ReactionGroup',
								},
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of Reactions left on the Issue.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'reactions',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Allows filtering Reactions by emoji.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'content',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ReactionContent',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Allows specifying the order in which reactions are returned.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'orderBy',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'ReactionOrder',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ReactionConnection',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository associated with this node.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The path for this discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'resourcePath',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Identifies the reason for the discussion's state.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'stateReason',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiscussionStateReason',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The title of this discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'title',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Number of upvotes that this subject has received.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'upvoteCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The URL for this discussion.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'url',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'URI',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edits to this content.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'userContentEdits',
					},
					arguments: [
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come after the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'after',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the elements in the list that come before the specified cursor.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'before',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'String',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the first _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'first',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
						{
							kind: Kind.INPUT_VALUE_DEFINITION,
							description: {
								kind: Kind.STRING,
								value: 'Returns the last _n_ elements from the list.',
								block: true,
							},
							name: {
								kind: Kind.NAME,
								value: 'last',
							},
							type: {
								kind: Kind.NAMED_TYPE,
								name: {
									kind: Kind.NAME,
									value: 'Int',
								},
							},
							directives: [],
						},
					],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'UserContentEditConnection',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates if the object can be closed by the viewer.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanClose',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the current viewer can delete this object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanDelete',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Can user react to this subject',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanReact',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Indicates if the object can be reopened by the viewer.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanReopen',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the viewer is able to change their subscription status for the repository.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanSubscribe',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if the current viewer can update this object.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanUpdate',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether or not the current user can add or remove an upvote on this subject.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerCanUpvote',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Did the viewer author this comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerDidAuthor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Whether or not the current user has already upvoted this subject.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerHasUpvoted',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies if the viewer is watching, not watching, or ignoring the subscribable entity.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'viewerSubscription',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'SubscriptionState',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A category for discussions in a repository.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DiscussionCategory',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'RepositoryNode',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A description of this category.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'description',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'String',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'An emoji representing this category.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'emoji',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "This category's emoji rendered as HTML.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'emojiHTML',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'HTML',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value:
							'Whether or not discussions in this category support choosing an answer with the markDiscussionCommentAsAnswer mutation.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'isAnswerable',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The name of this category.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'name',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The repository associated with this node.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'repository',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Repository',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The slug of this category.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'slug',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was last updated.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'updatedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The connection type for DiscussionCategory.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DiscussionCategoryConnection',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of edges.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'edges',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DiscussionCategoryEdge',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A list of nodes.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'nodes',
					},
					arguments: [],
					type: {
						kind: Kind.LIST_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DiscussionCategory',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Information to aid in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'pageInfo',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'PageInfo',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the total count of items in the connection.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'totalCount',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Int',
							},
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'An edge in a connection.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DiscussionCategoryEdge',
			},
			interfaces: [],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'A cursor for use in pagination.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'cursor',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The item at the end of the edge.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'node',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DiscussionCategory',
						},
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.ENUM_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'The possible reasons for closing a discussion.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DiscussionCloseReason',
			},
			directives: [],
			values: [
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion is a duplicate of another',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'DUPLICATE',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion is no longer relevant',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'OUTDATED',
					},
					directives: [],
				},
				{
					kind: Kind.ENUM_VALUE_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion has been resolved',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'RESOLVED',
					},
					directives: [],
				},
			],
		},
		{
			kind: Kind.OBJECT_TYPE_DEFINITION,
			description: {
				kind: Kind.STRING,
				value: 'A comment on a discussion.',
				block: true,
			},
			name: {
				kind: Kind.NAME,
				value: 'DiscussionComment',
			},
			interfaces: [
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Comment',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Deletable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Minimizable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Node',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Reactable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Updatable',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'UpdatableComment',
					},
				},
				{
					kind: Kind.NAMED_TYPE,
					name: {
						kind: Kind.NAME,
						value: 'Votable',
					},
				},
			],
			directives: [],
			fields: [
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who authored the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'author',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: "Author's association with the subject of the comment.",
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'authorAssociation',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'CommentAuthorAssociation',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body as Markdown.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'body',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body rendered to HTML.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bodyHTML',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'HTML',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The body rendered to text.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'bodyText',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'String',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the date and time when the object was created.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdAt',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'DateTime',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if this comment was created via an email reply.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'createdViaEmail',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'Boolean',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Identifies the primary key from the database.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'databaseId',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Int',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The time when this replied-to comment was deleted',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'deletedAt',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'DateTime',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The discussion this comment was created in',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'discussion',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Discussion',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'The actor who edited the comment.',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'editor',
					},
					arguments: [],
					type: {
						kind: Kind.NAMED_TYPE,
						name: {
							kind: Kind.NAME,
							value: 'Actor',
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					name: {
						kind: Kind.NAME,
						value: 'id',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value: 'ID',
							},
						},
					},
					directives: [],
				},
				{
					kind: Kind.FIELD_DEFINITION,
					description: {
						kind: Kind.STRING,
						value: 'Check if this comment was edited and includes an edit with the creation data',
						block: true,
					},
					name: {
						kind: Kind.NAME,
						value: 'includesCreatedEdit',
					},
					arguments: [],
					type: {
						kind: Kind.NON_NULL_TYPE,
						type: {
							kind: Kind.NAMED_TYPE,
							name: {
								kind: Kind.NAME,
								value