import {
	authProviders,
	configureWunderGraphApplication,
	cors,
	EnvironmentVariable,
	introspect,
	templates,
} from '@wundergraph/sdk';
import { NextJsTemplate } from '@wundergraph/nextjs/dist/template';
import server from './wundergraph.server';
import operations from './wundergraph.operations';

const faunaDB = introspect.graphql({
	apiNamespace: 'faunaDB',
	url: new EnvironmentVariable('FAUNADB_GRAPHQL_URL'),
	headers: (builder) => {
		builder.addStaticHeader('Authorization', new EnvironmentVariable('FAUNADB_TOKEN'));
		return builder;
	},
});

// configureWunderGraph emits the configuration
configureWunderGraphApplication({
	apis: [faunaDB],
	server,
	operations,
	generate: {
		codeGenerators: [
			{
				templates: [new NextJsTemplate()],
				path: '../components/generated',
			},
		],
	},
	cors: {
		...cors.allowAll,
		allowedOrigins: process.env.NODE_ENV === 'production' ? ['http://localhost:3000'] : ['http://localhost:3000'],
	},
	authentication: {
		cookieBased: {
			providers: [authProviders.demo()],
			authorizedRedirectUris: ['http://localhost:3000'],
		},
	},
	security: {
		enableGraphQLEndpoint: process.env.NODE_ENV !== 'production',
	},
});
