---
title: Use Cases
pageTitle: WunderGraph - Use Cases
description: An overview of most common use cases for WunderGraph.
hideTableOfContents: true
fullWidthContent: true
isIndexFile: true
---

Find below a list of the most common use cases for WunderGraph.

{% quick-links %}
{% quick-link title="Programmable API Gateway" icon="note" href="/docs/use-cases/programmable-api-gateway" description="WunderGraph is the first API Gateway that perfectly blends into the rest of your stack. We're blurring the lines between Gateway and Backend for Frontend (BFF), allowing for a much better developer experience. All configuration is done using code, and you can easily customize the Gateway using TypeScript." /%}
{% quick-link title="API Management" icon="note" href="/docs/use-cases/api-management" description="The next evolution of API Management is \"Gateway-less API Management\". Similar to Serverless, we will still have gateways, but they are abstracted away, reducing the mental load on the developer." /%}
{% quick-link title="Backend for Frontend" icon="note" href="/docs/use-cases/backend-for-frontend" description="Most applications need to interact with multiple backends. Our approach is to blur the lines between API Gateway and BFF, allowing for an all new developer experience to generate BFFs with as little code as possible, while still giving you the flexibility to customize." /%}
{% quick-link title="API Composition & Integration" icon="note" href="/docs/use-cases/api-composition-and-integration" description="Companies all around the world are picking up on going \"API first\". Our approach to support this is to make composition and integration of APIs as easy as possible. Each new API composition is an opportunity to enable a new use case." /%}
{% quick-link title="Versionless APIs: Easily build backwards compatible APIs" icon="note" href="/docs/use-cases/versionless-apis-easily-build-backwards-compatible-apis" description="To enable and further boost the trend of API first, it's important to be able to build backwards compatible APIs. Our take on this is to make APIs versionless. Our tooling automatically detects breaking changes, prevents you from breaking clients, and gives you a simple solution to keep your APIs backwards compatible without hindering API evolution." /%}
{% quick-link title="Generate SDKs for all your APIs" icon="note" href="/docs/use-cases/generate-sdks-for-all-your-apis" description="Most API Management tools stop at the Gateway level. We provide an end-to-end solution up until the client side. While configuring your Gateway using code, you're also able to generate clients and SDKs out of the box, giving you type-safety and a great developer experience from end to end." /%}
{% quick-link title="Centralized Governance, Monitoring, Access Controls and Logging across your APIs" icon="note" href="/docs/use-cases/centralized-governance-monitoring-access-controls-and-logging-across-your-apis" description="Piping all your APIs, services, databases, and other resources through a single unified API layer allows you to apply security policies, monitoring and logging across all your APIs. WunderGraph gives you a single pane of glass to manage all your resources." /%}
{% quick-link title="Enabling your Organization to become API First" icon="note" href="/docs/use-cases/enabling-your-organization-to-become-api-first" description="Becoming API First is a great way to get your organization to the next level, enabling new ways of collaboration and help developers do more meaningful work. Check out how WunderGraph can help your organization to become API First." /%}
{% /quick-links %}
