---
title: How to enable your organization to become API First
description: 'It is pivotal for organizations to understand the importance of API First, how to implement it, and how to make it work for your team.'
---

Before we talk about how to enable your organization to become API First,
let's discuss why an organization should go API first in the first place.

In 2002, Jeff Bezos sent the legendary "API Mandate" to the AWS employees:

> 1. All teams will henceforth expose their data and functionality through service interfaces.
> 2. Teams must communicate with each other through these interfaces.
> 3. There will be no other form of interprocess communication allowed: no direct linking, no direct reads of another team’s data store, no shared-memory model, no back-doors whatsoever. The only communication allowed is via service interface calls over the network.
> 4. It doesn’t matter what technology they use. HTTP, Corba, Pubsub, custom protocols — doesn’t matter.
> 5. All service interfaces, without exception, must be designed from the ground up to be externalizable. That is to say, the team must plan and design to be able to expose the interface to developers in the outside world. No exceptions.
> 6. Anyone who doesn’t do this will be fired.
> 7. Thank you; have a nice day!

What followed is history. AWS dominates the cloud market and created a wave of innovations,
like Microservices, S3, Serverless, which led to the thinking of "API First".

## What is API first?

API First means to change your software design paradigm to start with the API, not the functionality.
The goal is to enable API consumers to generate maximum value from your service and the data your provide.
As a consequence and just like Amazon, your teams will expose all their data and business functionality through APIs.
They can expose their APIs to other teams across the organization,
or even make them publicly available to other companies.

Also, you only build the services that you don't have available yet.
Never re-implement functionality, but use it through its API.

## The benefits of API First

Communicating with other teams and companies using interfaces instead of directly accessing the implementation,
like the database, means that each unit can operate independently and at its own pace.

A team can change their database or API implementation without affecting the other teams.
Developers can choose the best language and frameworks for their services.
Companies can refactor their internal systems,
but as long as their external API contract is the same,
their partners can continue to use the same API.

Some companies, like Stripe, took this to the extreme and went "API only".
Their whole business model is based on exposing their functionality through APIs.

## Why your organization should go API First as well

API First is a substantial business advantage.
Industry leaders will be, by default, API First companies
as they are faster, more efficient and part of more value creating business
than their competitors. Here are some examples:

### Faster time-to-market

Going API First means that your teams can move a lot faster
because they are able to operate independently.

### Superior security

Running all your data and requests through defined APIs
allows you to establish a high level of security - if done right.

### New business opportunities

If you're opening up your APIs to the public,
other companies can build on top of your APIs,
enabling new ways of collaboration and developing new business opportunities,
with you being part of the value chain.

### Full control of your service landscape

All your services can be monitored and managed through a central control plane.
This enables you to find out which APIs create value because they are used frequently
and which need to be reviewed or discontinued.
Access management and compliance can also be managed from here.

### API marketplace

With all your services accessible through APIs,
it's just a small step to create an API marketplace
for internal and external consumers alike.
They are able to find the right API for their task
and integrate it into their software with one single command.

There will always be a competitor in the market who understands this and goes API first.
Those who go API first will leave the competition behind,
as it will give them a clear advantage.

Here's a simple example:

In a virtual universe, two car-makers are competing to own the market.
The first company is called "Big Rim" and the second is called "Smart Wheel".
Big Rim focuses on big engines and doesn't understand the concept of "API First".
Smart Wheel builds small electric cars, and their strategy is to go API first.

Small Wheel starts with an API first design approach.
First, they design their externally facing APIs.
They build a beautiful inviting API Developer Portal.
Developers all over the world can register their own applications and use the API.

Over the next couple of years,
developers start building more and more applications using the Small Wheel API.
Eventually, the two big smartphone makers Peach and B-Droid are building native integrations into their phones.
You're now able to drive your Smart Wheel car to drive out of the garage just by clicking a button on your phone.

Meanwhile, Big Rim has released the newest version of their engine,
a V8 engine with 788 horsepower.

A few years later, Big Rim files for bankruptcy.
People are no longer interested in owning a car.
Instead, you just tap an app on your phone whenever you need a car.

Smart Wheel found a way to efficiently re-charge their cars' batteries.
They've built an alliance with electricity providers to build smart charging stations.
Cars communicate with APIs to report their battery status.
Charging stations use APIs to report if they have free slots.
Solar panels use APIs to report how much energy they are producing,
all via APIs.

Together, this alliance of companies is connected through APIs,
keeping the self-driving fleet of cars running 24/7.

Sounds like fiction? We're probably just a few years away from turning this into reality.
The enabler is going to be API First.

> Now the question is, who are you going to be -- a Big Rim or a Smart Wheel?

## How to go API first

Let's say you'd like to become a Smart Wheel of your industry.
What's a good strategy to go API first?

The ingredients for a successful API first strategy are:

- You need to convince your company why it's important to go API first
- You need to educate your company on API design
- You need the tools to make going API first seamless
  - How can you support the API design process?
  - How can you enable collaboration between API providers and API consumers?
  - How can you make integrating APIs easy?
  - How can you manage your APIs?

## How can WunderGraph help you achieve these goals?

Our customer success team offers workshops and training to help your employees understand the API first paradigm.
We've got years of experience in helping companies make the transition.
Our experts can also help you to build a process to continuously improve your API design.

Most importantly, we can give you the tools and framework to define a successful API First strategy.
Instead of trying to combine multiple tools and frameworks of different quality and focus,
we can help you to build a single, cohesive, and easy-to-use solution.
This starts with architecture, training, adoption and leads up to management and a single API marketplace
as the heart of your API First culture.

Think: GitHub, but for APIs.
A single platform to share APIs and enable collaboration across the whole organization and beyond.

We enable your teams to start thinking about APIs as dependencies.
API dependencies should be easy to share with other teams.
Communicating (breaking) changes needs to be efficient,
and the process should be transparent.
Teams should have an easy way to gather feedback on their API design,
and potential users should be able to test new APIs easily.

We enable all of this with a single, developer-friendly, API Developer Platform.
If you're interested in going API First, please reach out to our Sales Team.
