---
title: Guides
pageTitle: WunderGraph - Guides
description: An overview of all the available guides.
hideTableOfContents: true
fullWidthContent: true
isIndexFile: true
---

Here's an overview of all the available guides.

{% quick-links %}

{% quick-link title="Enable autocompletion in your IDE" icon="core" href="/docs/guides/enable-autocompletion-in-your-ide" description="Follow this guide to enable autocompletion in your IDE. This helps a lot when defining your (GraphQL) Operations." /%}

{% quick-link title="Debug your WunderGraph application" icon="core" href="/docs/guides/debugging" description="Learn how to run your WunderGraph application in a debugger." /%}

{% quick-link title="Inject short-lived token into upstream requests" icon="core" href="/docs/guides/inject-short-lived-token-into-upstream-requests" description="This guide helps you to add a middleware to inject short-lived auth tokens into origin requests." /%}

{% quick-link title="Expose a GraphQL API from WunderGraph" icon="core" href="/docs/guides/expose-a-graphql-api-from-wundergraph" description="A fundamental feature of WunderGraph is to secure your GraphQL API by putting a RPC interface in front of it. But sometimes, you really want to directly expose your GraphQL API instead. In this case, you can follow this guide." /%}

{% quick-link title="Extend JSON fields with more specific types" icon="core" href="/docs/guides/extend-json-fields-with-more-specific-types" description="Some databases expose APIs with generic JSON fields. This guide helps you to extend these fields with more specific types to increase type-safety." /%}

{% quick-link title="Logging" icon="core" href="/docs/guides/logging" description="Learn how to use WunderGraph's built-in logging system." /%}

{% quick-link title="Monitoring and observability" icon="core" href="/docs/guides/monitoring-and-observability" description="Learn how to monitor your WunderGraph application." /%}

{% quick-link title="Token based authentication with NextAuth.js" icon="core" href="/docs/guides/token-based-authentication-with-next-auth" description="This Guide helps you to configure Token based authentication." /%}

{% quick-link title="Signing origin requests" icon="core" href="/docs/guides/signing-origin-requests" description="Similarly to injecting a short-lived token, this guide helps you to sign requests, which is a requirement for some APIs." /%}

{% quick-link title="Configure Authorization" icon="core" href="/docs/guides/configure-authorization" description="This Guide helps you to configure Authorization with RBAC." /%}

{% quick-link title="TypeSafe API Integrations" icon="core" href="/docs/guides/typesafe_api_integrations_with_typescript_operations_and_graphql" description="Easily integrate APIs with TypeScript Operations & GraphQL." /%}

{% quick-link title="Integration testing" icon="core" href="/docs/guides/using-http-proxies" description="Use our built-in test server in combination with your auto-generated client to write type-safe tests." /%}

{% quick-link title="End to end testing" icon="core" href="/docs/guides/end-to-end-testing" description="Our recommended approach to test your frontend in combination with WunderGraph." /%}

{% quick-link title="Using HTTP proxies" icon="core" href="/docs/guides/using-http-proxies" description="Use HTTP proxies when communicating with your upstream APIs." /%}

{% quick-link title="Mock Datasources" icon="core" href="/docs/guides/mocking" description="Use our built-in mocking server to write integrations tests with ease." /%}

{% quick-link title="Enable autocompletion in your IDE" icon="core" href="/docs/guides/enable-autocompletion-in-your-ide" description="Enable autocompletion in your IDE to leverage the full power of the virtual graph." /%}

{% quick-link title="Extend third party GraphQL APIs" icon="core" href="/docs/guides/extend-third-party-graphql-apis" description="Add custom fields and resolvers to third party APIs that you cannot control." /%}

{% quick-link title="Extend the WunderGraph server context" icon="core" href="/docs/guides/context-factory" description="Use a context factory to extend the WunderGraph server context." /%}

{% /quick-links %}
