---
title: Expose a GraphQL API from Wundergraph
pageTitle: WunderGraph - Expose a GraphQL API from Wundergraph
description: You don't always want to use the RPC layer, generated by WunderGraph, but directly expose the GraphQL API. This Guide will help you to do that.
---

Occasionally, developers ask us how they can access their WunderGraph API using GraphQL.
Let me start by saying that it's possible! Yes, you can expose your WunderGraph API using GraphQL.
I'll explain how to do that in this guide.

That said, we strongly advise against following this guide.
99.9% of all GraphQL APIs should not be exposed to the public.
In fact, they don't even need to be exposed,
but we'll come back to that later.

## The Solution: exposing your GraphQL from WunderGraph

In order to enable the GraphQL Endpoint,
you have to add the following config to your `wundergraph.config.ts`.
Add the security object to `configureWunderGraphApplication` and set `enableGraphQLEndpoint` to `true`,
that's it.

```typescript
// wundergraph.config.ts
configureWunderGraphApplication({
  security: {
    enableGraphQLEndpoint: true,
  },
});
```

Your GraphQL Endpoint will be available at `http://localhost:9991/graphql`.

## Why you should not follow this guide

In 99.9% of all cases, you will not change your GraphQL Operations once you've deployed your application.
This means, you will not benefit from exposing a GraphQL in production because you're just using predefined GraphQL Operations that are statically defined in your client application code.

So why expose something if you don't need to?
[Why make yourself vulnerable to a wide array of attacks](https://wundergraph.com/blog/the_complete_graphql_security_guide_fixing_the_13_most_common_graphql_vulnerabilities_to_make_your_api_production_ready)?

After all, we believe that [GraphQL is not meant to be exposed over the internet](https://wundergraph.com/blog/graphql_is_not_meant_to_be_exposed_over_the_internet).

What's a better solution?
When you define your GraphQL Operations using WunderGraph,
we automatically generate a JSON REST(ish) API for you.
Additionally, we also generate a 100% typesafe client.
This means, you're getting the same developer experience as if you were using a standard GraphQL API,
but without the tradeoffs in terms of security and scalability.

You might be wondering what the 0.01% are?
It's very rare but if you're a service provider and want to give your customers access to your GraphQL API,
it's probably the only use case where it's acceptable to do so.

Just keep in mind that it's a huge responsibility to publicly expose a GraphQL API.
API Gateway providers are slowly adding support to help secure your GraphQL APIs.
That said, even when using a GraphQL API Gateway,
you still have to put a lot of thought into your Schema design and how you secure the Data Layer of your API.

The easiest way to handle the situation is to not expose your GraphQL API if you don't have to.
