---
title: WunderGraph Examples
pageTitle: WunderGraph - Examples
description:
hideTableOfContents: true
fullWidthContent: true
isIndexFile: true
---

Here's an overview of all the available examples.

{% quick-links %}
{% quick-link title="Hello world" icon="core" href="/docs/examples/hello-world" description="The simplest example of WunderGraph." /%}
{% quick-link title="Cross API Joins" icon="core" href="/docs/examples/cross-api-joins" description="An example demonstrating how to join data across two APIs." /%}
{% quick-link title="Next.js" icon="core" href="/docs/examples/nextjs" description="This example integrates WunderGraph with Next.js." /%}
{% quick-link title="Next.js TypeScript Operations" icon="core" href="/docs/examples/nextjs-typescript-operations" description="TypeScript Operations with Next.js" /%}
{% quick-link title="Next.js + Clerk" icon="core" href="/docs/examples/nextjs-clerk" description="WunderGraph with Clerk and Next.js" /%}
{% quick-link title="Vite + SWR" icon="core" href="/docs/examples/vite-swr" description="This example integrates WunderGraph with Vite and SWR." /%}
{% quick-link title="Hooks" icon="core" href="/docs/examples/hooks" description="This example demonstrates how to use hooks in WunderGraph." /%}
{% quick-link title="Caching" icon="core" href="/docs/examples/caching" description="This example demonstrates how to use caching in WunderGraph." /%}
{% quick-link title="FaunaDB Next.js" icon="core" href="/docs/examples/fauna-db-nextjs" description="This example demonstrates how to integrate FaunaDB into your WunderGraph applications." /%}
{% quick-link title="Inject Bearer Token" icon="core" href="/docs/examples/inject-bearer-token" description="This example demonstrates how to inject a bearer token into your upstream requests." /%}
{% quick-link title="PostgreSQL" icon="core" href="/docs/examples/postgresql" description="This example demonstrates how to use PostgreSQL in WunderGraph." /%}
{% quick-link title="NextJS PostgreSQL Prisma" icon="core" href="/docs/examples/nextjs-postgresql-prisma" description="This example demonstrates how to use NextJS, PostgreSQL and Prisma in WunderGraph." /%}
{% quick-link title="Apollo Federation" icon="core" href="/docs/examples/apollo-federation" description="This example demonstrates how to use Apollo Federation in WunderGraph." /%}
{% quick-link title="Auth0 OpenID Connect Authentication" icon="core" href="/docs/examples/auth0-openid-connect-authentication" description="This example demonstrates how to use Auth0 OpenID Connect Authentication in WunderGraph." /%}
{% quick-link title="Fragments" icon="core" href="/docs/examples/fragments" description="This example show how to use GraphQL Fragments with WunderGraph." /%}
{% quick-link title="Keycloak OpenID Connect Authentication" icon="core" href="/docs/examples/keycloak-openid-connect-authentication" description="This example demonstrates how to use Keycloak OpenID Connect Authentication in WunderGraph." /%}
{% quick-link title="GraphQL apollo subscriptions" icon="core" href="/docs/examples/graphql-apollo-subscriptions" description="This example demonstrates how to use GraphQL apollo WS subscriptions with WunderGraph." /%}
{% quick-link title="GraphQL WS subscriptions" icon="core" href="/docs/examples/graphql-ws-subscriptions" description="This example demonstrates how to use GraphQL WS subscriptions with WunderGraph." /%}
{% quick-link title="GraphQL SSE subscriptions" icon="core" href="/docs/examples/graphql-sse-subscriptions" description="This example demonstrates how to use GraphQL SSE subscriptions with WunderGraph." /%}
{% quick-link title="GraphQL yoga SSE subscriptions" icon="core" href="/docs/examples/graphql-yoga-subscriptions" description="This example demonstrates how to use GraphQL yoga SSE subscriptions with WunderGraph." /%}
{% quick-link title="GraphQL hasura subscriptions" icon="core" href="/docs/examples/graphql-hasura-subscriptions" description="This example demonstrates how to use GraphQL hasura WS subscriptions with WunderGraph." /%}
{% quick-link title="GraphQL subscriptions hooks" icon="core" href="/docs/examples/graphql-subscriptions-hooks" description="This example demonstrates how to use GraphQL subscriptions hooks with WunderGraph." /%}
{% quick-link title="WunderGraph schema extension" icon="core" href="/docs/examples/schema-extension" description="This example demonstrates how to use GraphQL schema extension with WunderGraph." /%}
{% quick-link title="Nextjs Todos" icon="core" href="/docs/examples/nextjs-todos" description="This Todo app demonstrate how to use SWR with WunderGraph" /%}
{% quick-link title="TypeScript ORM" icon="core" href="/docs/examples/orm" description="A simple example demonstrating the TypeScript ORM" /%}
{% /quick-links %}
