<!--
Thank you for your pull request. Please provide a description above and review
the requirements below.

Bug fixes and new features should include tests and possibly benchmarks.

Contributors guide: https://github.com/wundergraph/wundergraph/blob/main/CONTRIBUTING.md
Squashed commit must follow https://www.conventionalcommits.org/en/v1.0.0/ so we can generate the changelog.

By making a contribution to this project, I certify that:

* (a) The contribution was created in whole or in part by me and I
  have the right to submit it under the open source license
  indicated in the file; or

* (b) The contribution is based upon previous work that, to the best
  of my knowledge, is covered under an appropriate open source
  license and I have the right under that license to submit that
  work with modifications, whether created in whole or in part
  by me, under the same open source license (unless I am
  permitted to submit under a different license), as indicated
  in the file; or

* (c) The contribution was provided directly to me by some other
  person who certified (a), (b) or (c) and I have not modified
  it.

* (d) I understand and agree that this project and the contribution
  are public and that a record of the contribution (including all
  personal information I submit with it, including my sign-off) is
  maintained indefinitely and may be redistributed consistent with
  this project or the open source license(s) involved.
-->

## Motivation and Context

<!--
Why is this change required? What problem does it solve? Which issues are linked?
Please try to describe in detail the impact of this change. Add screenshots if it helps.
-->

## Marketing Changelog

<!--
What changes does this PR introduce? Please describe the changes in simple terms that a user can understand
without being familiar with the codebase. Mention @advocates for review and tracking.
-->

#### Checklist

- [ ] run `make test`
- [ ] PR title must follow [conventional-commit-standard](https://github.com/wundergraph/wundergraph/blob/main/CONTRIBUTING.md#conventional-commit-standard)
- [ ] tests and/or benchmarks are included
- [ ] documentation is changed or added
- [ ] commit message and code follows the [Code of conduct](https://github.com/wundergraph/wundergraph/blob/main/CODE_OF_CONDUCT.md)
