$(function(){
	var h = WST.pageHeight();
	$('#main').height(400);
	var laydate = layui.laydate;
	laydate.render({
	    elem: '#startDate'
	});
	laydate.render({
	    elem: '#endDate'
	});
    loadStat();
});
function loadStat(){
    var loading = WST.msg('正在查询数据，请稍后...', {icon: 16,time:60000});
    $('#dataTbl').hide();
	$.post(WST.U('shop/reports/statOrders'),WST.getParams('.ipt'),function(data,textStatus){
	    layer.close(loading);
	    var json = WST.toShopJson(data);
	    var myChart = echarts.init(document.getElementById('main'));
	    myChart.clear();
	    if(json.status=='1' && json.data){
			var option = {
			    tooltip : {
			        trigger: 'axis'
			    },
			    toolbox: {
			        show : true,
			        y: 'top',
			        feature : {
			            mark : {show: true},
			            dataView : {show: false, readOnly: false},
			            magicType : {show: true, type: ['line', 'bar', 'tiled']},
			            restore : {show: true},
			            saveAsImage : {show: true}
			        }
			    },
			    calculable : true,
			    legend: {
			        data:['在线支付','货到付款']
			    },
			    xAxis : [
			        {
			            type : 'category',
			            splitLine : {show : false},
			            data : json.data.days
			        }
			    ],
			    yAxis : [
			        {
			            type : 'value',
			            position: 'right'
			        }
			    ],
			    series : [
			        {
			            name:'货到付款',
			            type:'line',
			            tooltip : {trigger: 'item'},
			            stack: '来源',
			            data:json.data['p0']
			        },
			        {
			            name:'在线支付',
			            type:'line',
			            tooltip : {trigger: 'item'},
			            stack: '来源',
			            data:json.data['p1']
			        },
			        {
			            name:'订单总数',
			            type:'line',
			            data:json.data['total']
			        },
			        {
			            name:'支付来源细分',
			            type:'pie',
			            tooltip : {
			                trigger: 'item',
			                formatter: '{a} <br/>{b} : {c} ({d}%)'
			            },
			            center: [160,130],
			            radius : [0, 50],
			            itemStyle :　{
			                normal : {
			                    labelLine : {
			                        length : 20
			                    }
			                }
			            },
			            data:[
			                {value:json.data.map.p0, name:'货到付款'},
			                {value:json.data.map.p1, name:'在线支付'},
			            ]
			        }
			    ]
			};       
			myChart.setOption(option);
			if(json.data.days.length)$('#dataTbl').show();
			var getTpl = $('#dataTpl').html();
	        layui.laytpl(getTpl).render(json, function(html){
				$('#dataTby').html(html);
		    });
	    }else{
	    	WST.msg('没有查询到记录');
	    }

	});  
}