<?php 
namespace wststore\shop\validate;
use think\Validate;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 库存验证器
 */
class GoodsStocks extends Validate{
	protected $rule = [
        'goodsId'=>'require',
        'stockPrice'=>'require',
        'stockType'=>'in:-1,1',
        'stockQty'=>'gt:0',
        'stockRemarks'=>'require|max:600',
    ];

    protected $message  =   [
        'goodsId.require'=>'无效的商品',
        'stockPrice.require'=>'请输入出/入库价格',
        'stockType.in' => '非法的入库类型',
        'stockQty.gt' => '数量必须大于0',
        'stockRemarks.require' => '请输入备注'
    ];

    protected $scene = [
        'add'   =>  ['stockType','stockPrice','stockQty','stockRemarks']
    ];
}