<?php
namespace wststore\shop\model;
use wststore\shop\model\ShopRoles;
use wststore\shop\model\LogStaffLogins;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 职员业务处理
 */
class Staffs extends Base{
	protected $pk = 'staffId';
	/**
	 * 判断用户登录帐号密码
	 */
	public function checkLogin(){
		$loginName = input("post.loginName");
		$loginPwd = input("post.loginPwd");
		$code = input("post.verifyCode");
		if(!WSTVerifyCheck($code)){
			return WSTReturn('验证码错误!');
		}
		
		$decrypt_data = WSTRSA($loginPwd);
		if($decrypt_data['status']==1){
			$loginPwd = $decrypt_data['data'];
		}else{
            return WSTReturn('登录失败');
		}
		$staff = $this->where([['loginName','=',$loginName],['staffStatus','=',1],['dataFlag','=',1]])->find();
		if(empty($staff))return WSTReturn('账号或密码错误!');
		if($staff['loginPwd']==md5($loginPwd.$staff['secretKey'])){
			if($staff['shopId']==0)return WSTReturn('登录失败');
			//获取店铺
			$shop = Db::name('shops')->where([['shopId','=',$staff['shopId'],['dataFlag','=',1],'shopStatus','=',1]])->find();
	 		if(empty($shop))return WSTReturn('登录失败');
	 		$staff->lastTime = date('Y-m-d H:i:s');
	 		$staff->lastIP = request()->ip();
	 		$staff->save();
	 		$staff['shop'] = $shop;
	 		//记录登录日志
		 	LogStaffLogins::create(['staffId'=>$staff['staffId'],'loginTime'=> date('Y-m-d H:i:s'),'loginIp'=>request()->ip()]);
	 		//获取角色权限
	 		$role = ShopRoles::get(['dataFlag'=>1,'roleId'=>$staff['shopRoleId']]);
	 		$staff['roleName'] = $role['roleName'];
		 	$staff['privileges'] = explode(',',$role['privileges']);
		 	$staff['menuIds'] = [];
		 	//获取拥有的菜单
		 	if(!empty($staff['privileges'])){
		 		$menus = Db::name('shop_menus')->alias('m')->join('__SHOP_PRIVILEGES__ p','m.menuId=p.menuId and p.dataFlag=1','inner')
		 		                ->where([['p.privilegeCode','in',$staff['privileges']]])->field('m.menuId')->select();
		 		$menuIds = [];
		 		if(!empty($menus)){
		 		    foreach ($menus as $key => $v){
		 		     	$menuIds[] = $v['menuId'];
		 		    }
		 		    $staff['menuIds'] = $menuIds;
		 		}
		 	}
	 		session("WST_SHOP",$staff);
			return WSTReturn("登录成功",1,$staff);
		}
		return WSTReturn('账号或密码错误!');
	}
	
	/**
	 * 获取角色权限
	 */
	public function getById($id){
		return $this->get(['dataFlag'=>1,'staffId'=>$id,'shopId'=>(int)session('WST_SHOP.shopId')]);
	}

	/**
	 * 获取门店职员列表
	 */
	public function pageQuery(){
		$where = [];
		$where[] = ['s.dataFlag','=',1];
		$where[] = ['s.shopId','=',(int)session('WST_SHOP.shopId')];
		$page = Db::name('staffs')->alias('s')->join('__SHOP_ROLES__ r','s.shopRoleId=r.roleId and r.dataFlag=1','left')
		       ->where($where)->field('staffId,staffName,loginName,r.roleId,staffNo,lastTime,lastIP,roleName')
		       ->order('staffId', 'desc')->paginate(input('limit/d'))->toArray();
		return $page;
	}
	/**
	 * 修改自己密码
	 */
	public function editMyPass($staffId){
		if(input("post.newPass")=='')WSTReturn("密码不能为空");
		$staff = $this->where([['staffId','=',$staffId]])->field('secretKey,loginPwd')->find();
		if(empty($staff))return WSTReturn("修改失败");
		$srcPass = md5(input("post.srcPass").$staff["secretKey"]);
		if($srcPass!=$staff['loginPwd'])return WSTReturn("原密码错误");
		$staff->loginPwd = md5(input("post.newPass").$staff["secretKey"]);
		$result = $staff->save();
        if(false !== $result){
        	return WSTReturn("修改成功", 1);
        }else{
        	return WSTReturn($this->getError(),-1);
        }
	}
	/**
	 * 修改自己密码
	 */
	public function editPass($staffId){
		if(input("post.newPass")=='')WSTReturn("密码不能为空");
		$staff = $this->where([['staffId','=',$staffId],['shopId','=',(int)session('WST_SHOP.shopId')]])->field('secretKey')->find();
		if(empty($staff))return WSTReturn("修改失败");
		$staff->loginPwd = md5(input("post.newPass").$staff["secretKey"]);
		$result = $staff->save();
        if(false !== $result){
        	return WSTReturn("修改成功", 1);
        }else{
        	return WSTReturn($this->getError());
        }
	}

    /**
	 * 修改店铺职员角色
	 */
	public function changeShopRole(){
		$staffId = (int)input('staffId/d');
		$shopRoleId = (int)input('shopRoleId/d');
		$result = $this->where([['staffId','=',$staffId],['shopId','=',(int)session('WST_SHOP.shopId')]])->update(['shopRoleId'=>$shopRoleId]);
		if(false !== $result){
        	return WSTReturn("设置成功", 1);
        }else{
        	return WSTReturn($this->getError());
        }
	}

	/**
	 * 获取职员列表
	 */
	public function listQuery(){
		$where = [];
		$where[] = ['s.dataFlag','=',1];
		$where[] = ['s.shopId','=',(int)session('WST_SHOP.shopId')];
		$page = Db::name('staffs')->alias('s')->join('__SHOP_ROLES__ r','s.shopRoleId=r.roleId and r.dataFlag=1','left')
		       ->where($where)->field('staffId,staffName')
		       ->order('staffId', 'desc')->select();
		return $page;
	}
}
