<?php
namespace wststore\shop\model;
use wststore\shop\validate\Shops as validate;
use think\Db;
use think\Loader;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 店铺设置业务处理
 */
class Shops extends Base{
	protected $pk = 'shopId';
	
	/**
	 * 获取店铺信息
	 */
	public function getById($id){
		$shop = $this->alias('s')
                   ->where('s.shopId',$id)
                   ->find()
                   ->toArray();
		//获取认证类型
	    $shopAccreds = Db::name('shop_accreds')->where('shopId',$id)->select();
	    $shop['accreds'] = [];
		foreach ($shopAccreds as $v){
			$shop['accreds'][$v['accredId']] = true;
		}
        return $shop;
	}
	
    /**
	 * 编辑
	 */
	public function edit(){
		$data = input('post.');
		$shopId = (int)session('WST_SHOP.shopId');
		$shops = $this->get($shopId);
		if(empty($shops) || $shops->dataFlag!=1)return WSTReturn('门店不存在');
		$validate = new validate();
		if(!$validate->scene('edit')->check($data))return WSTReturn($validate->getError());	
        Db::startTrans();
        try{
        	$areaIds = model('Areas')->getParentIs($data['bankAreaId']);
		    if(!empty($areaIds))$data['bankAreaIdPath'] = implode('_',$areaIds)."_";
	        //保存店铺基础信息
	        WSTAllow($data,'shopTel,shopkeeper,shopQQ,bankAreaIdPath,serviceStartTime,serviceEndTime,shopWangWang,telephone,serviceRadius,shopAtive,bankUserName,bankNo,bankId,bankAreaId');
	        $result = $this->save($data,['shopId'=>$shopId,'dataFlag'=>1]);
	        if($result !== false){
                Db::commit();
	            return WSTReturn("编辑成功", 1);
	        } 
        }catch (\Exception $e) {
            Db::rollback();
        }
        return WSTReturn('编辑失败',-1);
	}
}
