<?php
namespace wststore\shop\model;
use wststore\shop\validate\ShopRoles as validate;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 店铺角色业务处理
 */
class ShopRoles extends Base{
	/**
	 * 分页
	 */
	public function pageQuery(){
		$shopId = (int)session('WST_SHOP.shopId');
		return $this->where(['dataFlag'=>1,'shopId'=>$shopId])->field('roleId,roleName')->paginate(input('limit/d'));
	}
	/**
	 * 列表
	 */
	public function listQuery(){
		$shopId = (int)session('WST_SHOP.shopId');
		return $this->where(['dataFlag'=>1,'shopId'=>$shopId])->field('roleId,roleName')->select();
	}
	
	/**
	 * 获取角色权限
	 */
	public function getById($id){
		$shopId = (int)session('WST_SHOP.shopId');
		return $this->get(['dataFlag'=>1,'roleId'=>$id,'shopId'=>$shopId]);
	}
}
