<?php 
namespace wststore\shop\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 报表业务处理
 */
class Reports extends Base{   
    /**
     * 获取商品销售统计
     */
    public function topSaleGoodsByPage(){
    	$start = date('Y-m-d 00:00:00',strtotime(input('startDate')));
    	$end = date('Y-m-d 23:59:59',strtotime(input('endDate')));
      $shopId = (int)session('WST_SHOP.shopId');
      $prefix = config('database.prefix');
    	return Db::table($prefix.'order_goods')
          ->alias([$prefix.'order_goods'=>'og',$prefix.'orders'=>'o',$prefix.'goods'=>'g',$prefix.'goods_libs'=>'gl'])
          ->field('gl.goodsLibId,gl.goodsName,gl.goodsSn,sum(og.goodsNum) goodsNum,gl.goodsImg')
    	  ->join($prefix.'orders','og.orderId=o.orderId')
    	  ->join($prefix.'goods','og.goodsId=g.goodsId')
    	  ->join($prefix.'goods_libs','gl.goodsLibId=g.goodsLibId')
    	  ->order('goodsNum','desc')
    	  ->whereTime('o.createTime','between',[$start,$end])
          ->where('g.shopId='.$shopId.' and (o.payType=0 or (o.payType=1 and o.isPay=1)) and o.orderStatus=2 and o.dataFlag=1')->group('gl.goodsLibId,gl.goodsName,gl.goodsSn,gl.goodsImg')
          ->paginate(input('limit/d'));
    }
  
    /**
     * 获取订单统计
     */
    public function statOrders(){
        $start = date('Y-m-d 00:00:00',strtotime(input('startDate')));
        $end = date('Y-m-d 23:59:59',strtotime(input('endDate')));
        $payType = (int)input('payType',-1);
        $shopId = (int)session('WST_SHOP.shopId');
        $rs = Db::field('left(createTime,10) createTime,payType,count(orderId) orderNum')
                ->name('orders')->whereTime('createTime','between',[$start,$end])
                ->where('shopId='.$shopId.' and ((payType=0 or (payType=1 and isPay=1)) and orderStatus=2 and dataFlag=1) '.(in_array($payType,[0,1])?" and payType=".$payType:''))
                ->order('createTime asc')
                ->group('left(createTime,10),payType')->select();
        $rdata = [];
        if(count($rs)>0){
            $days = [];
            $payTypes = [0,1];
            $tmp = [];
            foreach($rs as $key => $v){
                if(!in_array($v['createTime'],$days))$days[] = $v['createTime'];
                $tmp[$v['payType']."_".$v['createTime']] = $v['orderNum'];
            }
            $rdata['map'] = ['p0'=>0,'p1'=>0];
            foreach($days as $v){
                $total = 0;
                foreach($payTypes as $p){
                    $pv = isset($tmp[$p."_".$v])?$tmp[$p."_".$v]:0;
                    $rdata['p'.$p][] = (float)$pv;
                    $total = $total + (float)$pv;
                    $rdata['map']['p'.$p] = $rdata['map']['p'.$p] + (float)$pv;
                }
                $rdata['total'][] = $total;
            }
            $rdata['days'] = $days;
        }
        return WSTReturn('',1,$rdata);
    }
}