<?php
namespace wststore\shop\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 进货单控制器
 */
class Purchases extends Base{
	/**
	 * 添加商品库存
	 */
	public function add(){
		$shopId = (int)session('WST_SHOP.shopId');
		$ids = WSTFormatIn(',',input('ids'));
		if($ids=='')return WSTReturn('请选择要进货的商品');
		$ids = explode(',',$ids);
		//判断商品合法性
		$goods = Db::name('goods')->alias('g')
		           ->join('__GOODS_LIBS__ gl','gl.goodsLibId=g.goodsLibId')
		           ->field('gl.goodsLibId,gl.shopCostPrice,g.goodsId')
		           ->where([['gl.goodsLibId','in',$ids],['gl.isSale','=',1],['gl.dataFlag','=',1]])
		           ->select();
		if(count($goods)==0)return WSTReturn('无效的进货商品，请先上架商品');
        Db::startTrans();
		try{
			//获取最新的进货单号
			$purchaseNo = $this->where([['purchaseNo','like',date('ymd').'%']])->max('purchaseNo');
			if($purchaseNo==0){
				$purchaseNo = date('ymd')."00001";
			}else{
                $purchaseNo = (int)str_replace(date('ymd'),'',$purchaseNo);
                $purchaseNo = date('ymd').sprintf('%05d',$purchaseNo+1);
			}
			$pdata = [];
			$pdata['purchaseNo'] = $purchaseNo;
			$pdata['shopId'] = $shopId;
			$pdata['requireDate'] = input('requireDate');
			$pdata['createTime'] = date('Y-m-d H:i:s');
			$pdata['dataFlag'] = 1;
			$pdata['staffId'] = (int)session('WST_SHOP.staffId');
            $result = $this->save($pdata);
            if($result !== false){
            	$rdata = [];
				foreach ($goods as $key => $v) {
					if((int)input('goodsQty_'.$v['goodsLibId'])<=0)continue;
					$data = [];
					$data['purchaseId'] = $this->id;
					$data['shopId'] = $shopId;
					$data['goodsId'] = $v['goodsId'];
					$data['goodsPrice'] = $v['shopCostPrice'];
		            $data['goodsLibId'] = $v['goodsLibId'];
		            $data['goodsQty'] = (int)input('goodsQty_'.$v['goodsLibId']);
		            $rdata[] = $data;
				}
				if(count($rdata)==0)return WSTReturn('无效的进货商品数');
				Db::name('purchase_goods')->insertAll($rdata);
				Db::commit();
				return WSTReturn('进货申请成功，请等待总部送货',1);
			}
		}catch (\Exception $e) {
            Db::rollback();
        }
        return WSTReturn('新增进货单失败',-1); 
	}

	/**
	 * 获取进货单列表
	 */
	public function pageQuery(){
		$key = input('key');
		$startDate = input('startDate');
		$endDate = input('endDate');
		$where = [];		
		$where[] = ['p.shopId','=',(int)session('WST_SHOP.shopId')];
		if($key!='')$where[] = ['p.purchaseNo','like','%'.$key.'%'];
		if($startDate!='')$where[] = ['p.createTime','>=',$startDate." 00:00:00"];
		if($endDate!='')$where[] = ['p.createTime','<=',$endDate." 23:59:59"];
        return $this->alias('p')->join('__STAFFS__ s','s.staffId=p.staffId')
                    ->field('p.*,s.staffName')
                    ->where($where)->order('id desc')
                    ->paginate(input('limit/d'))->toArray();
	}

	/**
	 * 获取进货单明细
	 */
	public function getById(){
		$id = input('id/d');
		$shopId = (int)session('WST_SHOP.shopId');
		$rs = $this->where([['id','=',$id],['dataFlag','=',1],['shopId','=',$shopId]])->find();
		if(empty($rs))return [];
		$rs['list']  = Db::name('purchase_goods')->alias('pg')
		         ->join('__GOODS_LIBS__ gl','gl.goodsLibId=pg.goodsLibId')
		         ->where([['pg.purchaseId','=',$id],['pg.shopId','=',$shopId]])
		         ->field('gl.goodsLibId,gl.goodsName,pg.goodsPrice,pg.goodsQty,pg.receiveQty')
		         ->select();
        return $rs;
	}

	/**
	 * 确认收货
	 */
	public function receive(){
		$id = input('id/d');
		$shopId = (int)session('WST_SHOP.shopId');
		$ids = WSTFormatIn(',',input('ids'));
		//判断商品是否有效
		if($ids=='')return WSTReturn('请选择要进货的商品');
		$rs = $this->where([['id','=',$id],['purchaseStatus','=',2]])->find();
		if(empty($rs))return WSTReturn('无效的进货单状态，请刷新后再查看');
		Db::startTrans();
		try{
			$this->save(['purchaseStatus'=>3],[['id','=',$id],['purchaseStatus','=',2]]);
			$ids = explode(',',$ids);
			$pg = Db::name('purchase_goods')->where([['purchaseId','=',$id],['goodsLibId','in',$ids]])->select();
			foreach ($pg as $key => $v) {
				Db::name('purchase_goods')->where([['id','=',$v['id']]])->update(['receiveQty'=>(int)input('receiveQty_'.$v['goodsLibId'])]);
			    //创建库存记录
			    $stock = [];
			    $stock['shopId'] = $shopId;
			    $stock['goodsId'] = $v['goodsId'];
			    $stock['stockPrice'] = $v['goodsPrice'];
			    $stock['stockType'] = 1; 
			    $stock['stockQty'] = (int)input('receiveQty_'.$v['goodsLibId']); 
			    $stock['stockRemarks'] = '采购单【'.$rs['purchaseNo'].'】入库数量'.$stock['stockQty']; 
			    $stock['createTime'] = date('Y-m-d H:i:s');
			    Db::name('goods_stocks')->insert($stock);
			    Db::name('goods')->where([['goodsId','=',$v['goodsId']]])->setInc('goodsStock',(int)input('receiveQty_'.$v['goodsLibId']));
			}
			Db::commit();
			return WSTReturn('确认成功',1);
		}catch (\Exception $e) {
			print_r($e);
            Db::rollback();
        }
        return WSTReturn('确认失败');
	}
}
