<?php
namespace wststore\shop\model;
use think\Db;
use think\Loader;
use Env;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 订单业务处理类
 */
class Orders extends Base{
	protected $pk = 'orderId';
	/**
	 * 获取订单
	 */
	public function pageQuery($orderStatus,$payType = 0){
		$shopId = session('WST_SHOP.shopId');
		$orderNo = input('orderNo');
		$payType = $payType>0?$payType:(int)input('payType',-1);
		$deliverType = (int)input('deliverType',-1);
		$sort = input('sort');
		$where = ['dataFlag'=>1];
		$where['shopId'] = $shopId;
		if($orderStatus==1000){
			$where[] = ['orderStatus','in','-1,-3'];
		}else{
			$where['orderStatus'] = $orderStatus;
		}
		if($orderNo!=''){
			$where[] = ['orderNo','like',"%$orderNo%"];
		}
		if($payType > -1){
			$where['payType'] =  $payType;
		}
		if($deliverType > -1){
			$where['deliverType'] =  $deliverType;
		}
		$order = 'o.createTime desc';
		if($sort){
			$sort =  str_replace('.',' ',$sort);
			$order = $sort;
		}
		$page = $this->alias('o')->where($where)
		->field('o.orderRemarks,o.noticeDeliver,o.orderId,orderNo,goodsMoney,totalMoney,realTotalMoney,orderStatus,deliverType,deliverMoney,isAppraise,deliveryTime,receiveTime
		              ,payType,payFrom,userAddress,orderStatus,useScore,isPay,isAppraise,userName,orderSrc,o.createTime,o.isRefund,o.bookTime')
			              ->order($order)
			              ->paginate(input('limit/d'))->toArray();
		if(count($page['data'])>0){
			foreach ($page['data'] as $key => $v){
				$allowDel = true;
				if($v['orderStatus']!=2){
					//如果是在线支付的，已经支付但是没有退款的都不允许删除
					if($v['payType']==1 && $v['isPay']==1 && $v['isRefund']==0)$allowDel = false;
				}
				$page['data'][$key]['allowDel'] = $allowDel;
				$page['data'][$key]['payTypeName'] = WSTLangPayType($v['payType']);
				$page['data'][$key]['deliverTypeName'] = WSTLangDeliverType($v['deliverType']==1);
				$page['data'][$key]['status'] = WSTLangOrderStatus($v['orderStatus']);
			}
		}
		return $page;
	}
	
	/**
	 * 获取订单详情
	 */
	public function getByView($orderId){
		$shopId = session('WST_SHOP.shopId');
		$orders = $this->alias('o')->join('__EXPRESS__ e','o.expressId=e.expressId','left')
		->where('o.dataFlag=1 and o.shopId='.$shopId.' and o.orderId='.$orderId)
		->field('o.*,e.expressName')->find();
		if(empty($orders))return WSTReturn("无效的订单信息");
		$orders = $orders->toArray();
		//获取订单信息
		$orders['log'] = Db::name('log_orders')->where('orderId',$orderId)->order('logId asc')->select();
		//获取订单商品
		$orders['goods'] = Db::name('order_goods')->where('orderId',$orderId)->order('id asc')->select();
		//获取退款信息
		$orders['refund'] = [];
		if(in_array($orders['orderStatus'],[-1,-3])){
			$orders['refund'] = Db::name('order_refunds')->where([['orderId','=',$orders['orderId']]])->find();
		}
		return $orders;
	}
	/**
     * 发货
     */
    public function deliver(){
    	$shopId = session('WST_SHOP.shopId');
    	$orderId = (int)input('post.id');
    	$shopDeliverType = (int)input('post.shopDeliverType');
    	$order = $this->where(['orderId'=>$orderId,'orderStatus'=>0,'shopId'=>$shopId])->field('orderId,orderNo,userId,deliverType')->find();
        if(empty($order))return WSTReturn('操作失败，请检查订单状态是否已改变');
        if($order['deliverType']==1){
        	return $this->selfPick($order,$shopId,$orderId);
        }else{
        	if($shopDeliverType==1){
	        	return $this->shopDeliver1($order,$shopId,$orderId);
	        }else{
                return $this->shopDeliver0($order,$shopId,$orderId);
	        }
        }
    }
	/**
	 * 自提
	 */
	public function selfPick($order,$shopId,$orderId){
		Db::startTrans();
		try{
			$data = ['orderStatus'=>2,'deliveryTime'=>date('Y-m-d H:i:s'),'receiveTime'=>date('Y-m-d H:i:s')];
			$result = $this->where('orderId',$order['orderId'])->update($data);
			if(false != $result){
				//新增订单日志
				$logOrder = [];
				$logOrder['orderId'] = $orderId;
				$logOrder['orderStatus'] = 2;
				$logOrder['logContent'] = "用户上门自提";
				$logOrder['logUserId'] = $order['userId'];
				$logOrder['logType'] = 0;
				$logOrder['logTime'] = date('Y-m-d H:i:s');
				Db::name('log_orders')->insert($logOrder);
				//给用户增加积分
				if(WSTConf("CONF.isOrderScore")==1){
					$score = [];
					$score['userId'] = $userId;
					$score['score'] = $order['orderScore'];
					$score['dataSrc'] = 1;
					$score['dataId'] = $orderId;
					$score['dataRemarks'] = "交易订单【".$order['orderNo']."】获得积分".$order['orderScore']."个";
					$score['scoreType'] = 1;
					$score['createTime'] = date('Y-m-d H:i:s');
					model('common/UserScores')->add($score);
				}
				Db::commit();
				return WSTReturn('操作成功',1);
			}
		}catch (\Exception $e) {
			Db::rollback();
			return WSTReturn('操作失败',-1);
		}
		return WSTReturn('操作失败，请检查订单状态是否已改变');
	}
    /**
     * 商家配送
     */
    public function shopDeliver0($order,$shopId,$orderId){
    	$id = (int)input('post.deliveryersid');
		$deliveryers = Db::name('deliveryers')->where(['id'=>$id,'dataFlag'=>1])->field('deliveryerName,deliveryerPhone')->find();
		// echo $this->getLastSql($deliveryers);
		if(empty($deliveryers))return WSTReturn('无效的配送员信息');
		Db::startTrans();
		try{
			$data = ['orderStatus'=>1,'deliveryTime'=>date('Y-m-d H:i:s'),'shopDeliverType'=>0,'distributor'=>$deliveryers['deliveryerName'],'distributorPhone'=>$deliveryers['deliveryerPhone']];
			$result = $this->where('orderId',$order['orderId'])->update($data);
			if(false != $result){
				//新增订单日志
				$logOrder = [];
				$logOrder['orderId'] = $orderId;
				$logOrder['orderStatus'] = 1;
				$logOrder['logContent'] = "门店已发货，配送员：".$deliveryers['deliveryerName']."(".$deliveryers['deliveryerPhone'].")";
				$logOrder['logUserId'] = $order['userId'];
				$logOrder['logType'] = 0;
				$logOrder['logTime'] = date('Y-m-d H:i:s');
				
				Db::name('log_orders')->insert($logOrder);
				//发送一条用户信息
				$tpl = WSTMsgTemplates('ORDER_DELIVERY');
				if($tpl['tplContent']!='' && $tpl['status']=='1'){
					$find = ['${ORDER_NO}','${EXPRESS_NO}'];
					$replace = [$order['orderNo'],$deliveryers['deliveryerName']."(".$deliveryers['deliveryerPhone'].")"];
					WSTSendMsg($order['userId'],str_replace($find,$replace,$tpl['tplContent']),['from'=>1,'dataId'=>$orderId]);
				}
				//微信消息
		        if((int)WSTConf('CONF.wxenabled')==1){
		            $params = [];
		            $params['EXPRESS'] = '门店配送';
		            $params['EXPRESS_NO'] = $deliveryers['deliveryerName']."(".$deliveryers['deliveryerPhone'].")";
		            $params['ORDER_NO'] = $order['orderNo'];  
	                WSTWxMessage(['CODE'=>'WX_ORDER_DELIVERY','userId'=>$order['userId'],'URL'=>Url('wechat/orders/index',['type'=>'waitReceive'],true,true),'params'=>$params]);
		        } 
				Db::commit();
				return WSTReturn('操作成功',1);
			}
		}catch (\Exception $e) {
			print_r($e);
			Db::rollback();
			return WSTReturn('操作失败',-1);
		}
		return WSTReturn('操作失败，请检查订单状态是否已改变');
    }


	/**
	 * 快递发货
	 */
	public function shopDeliver1($order,$shopId,$orderId){
		$expressId = (int)input('post.expressId');
		$expressNo = input('post.expressNo');
		if($expressId>0)$expressName = Db::name('express')->where(['expressId'=>$expressId,'dataFlag'=>1])->field('expressName')->find();
		Db::startTrans();
		try{
			$data = ['orderStatus'=>1,'expressId'=>$expressId,'shopDeliverType'=>1,'expressNo'=>$expressNo,'deliveryTime'=>date('Y-m-d H:i:s')];
			$result = $this->where('orderId',$order['orderId'])->update($data);
			if(false != $result){
				//新增订单日志
				$logOrder = [];
				$logOrder['orderId'] = $orderId;
				$logOrder['orderStatus'] = 1;
				$logOrder['logContent'] = "门店已发货".(($expressNo!='')?"，快递号为：".$expressNo:"");
				$logOrder['logUserId'] = $order['userId'];
				$logOrder['logType'] = 0;
				$logOrder['logTime'] = date('Y-m-d H:i:s');
				Db::name('log_orders')->insert($logOrder);
				//发送一条用户信息
				$tpl = WSTMsgTemplates('ORDER_DELIVERY');
				if($tpl['tplContent']!='' && $tpl['status']=='1'){
					$find = ['${ORDER_NO}','${EXPRESS_NO}'];
					$replace = [$order['orderNo'],($expressNo=='')?'无':$expressNo];
					WSTSendMsg($order['userId'],str_replace($find,$replace,$tpl['tplContent']),['from'=>1,'dataId'=>$orderId]);
				}
				//微信消息
		        if((int)WSTConf('CONF.wxenabled')==1){
		            $params = [];
		            if($expressId>0){
		            	$express = model('express')->where('expressId','=',$expressId)->find();
		            	$params['EXPRESS'] = $express->expressName;          
		                $params['EXPRESS_NO'] = $expressNo;       
		            }else{
		            	$params['EXPRESS'] = '无';
		            	$params['EXPRESS_NO'] = '无';
		            }
		            $params['ORDER_NO'] = $order['orderNo'];  
	                WSTWxMessage(['CODE'=>'WX_ORDER_DELIVERY','userId'=>$order['userId'],'URL'=>Url('wechat/orders/index',['type'=>'waitReceive'],true,true),'params'=>$params]);
		        } 
				Db::commit();
				return WSTReturn('操作成功',1);
			}
		}catch (\Exception $e) {
			print_r($e);
			Db::rollback();
			return WSTReturn('操作失败',-1);
		}
		return WSTReturn('操作失败，请检查订单状态是否已改变');
	}
	/**
	 * 删除订单
	 */
	public function del(){
		$id = (int)input('id');
		$orders = $this->where([['orderId','=',$id],['shopId','=',(int)session('WST_SHOP.shopId')]])->find();
		if(empty($orders))return WSTReturn('删除失败，无效的订单信息');
		$allowDel = true;
		if($orders->orderStatus!=2){
			//如果是在线支付的，已经支付但是没有退款的都不允许删除
			if($orders->payType==1 && $orders->isPay==1 && $order->isRefund==0)$allowDel = false;
		}
		if(!$allowDel)return WSTReturn('不允许删除该订单');
		if(!empty($orders)){
			$orders->dataFlag = -1;
			$orders->save();
			return WSTReturn('操作成功',1);
		}
		return WSTReturn('操作失败，无效的订单ID');
	}
	/**
	 * 取消订单
	 */
	public function cancel(){
		$shopId = session('WST_SHOP.shopId');
		$orderId = (int)input('post.id');
		$reason = (int)input('post.reason');
		$content = input('post.content');
		$order = $this->where([['orderStatus','in',[-2,0]],['shopId','=',$shopId],['orderId','=',$orderId]])
		              ->field('userId,orderId,orderNo,realTotalMoney,orderStatus,payType,isPay,useScore')->find();
		$reasonData = WSTDatas('ORDER_CANCEL',$reason);
		if(empty($reasonData))return WSTReturn("无效的取消原因");
		if(!empty($order)){
			Db::startTrans();
		    try{
				$data = ['orderStatus'=>-1,'interruptCode'=>$reason];
				//如果是货到付款的话，则把实付金额设置为0
				if($order['payType']==0 || ($order['orderStatus']==-2 && $order['payType']==1))$data['realTotalMoney'] = 0;
			    $result = $this->where('orderId',$order['orderId'])->update($data);
				if(false != $result){
					$userId = $order['userId'];
                    //有使用积分的则直接退回积分
                    if($order['useScore']>0){
                    	$score = [];
						$score['userId'] = $userId;
						$score['score'] = $order['useScore'];
						$score['dataSrc'] = 1;
						$score['dataId'] = $orderId;
						$score['dataRemarks'] = "取消交易订单【".$order['orderNo']."】，退回积分".$order['useScore']."个";
						$score['scoreType'] = 1;
						model('common/UserScores')->add($score);
                    }
                    //如果是在线付款的则创建退款记录
                    if($order['payType']==1 && $order['isPay']==1){
						$data = [];
						$data['orderId'] = $orderId;
						$data['refundMoney'] = $order['realTotalMoney'];
						$data['createTime'] = date('Y-m-d H:i:s');
						$data['refundStatus'] = 0;
						Db::name('order_refunds')->insert($data);
					}
					//返还商品库存
					$goods = Db::name('order_goods')->where('orderId',$orderId)->select();
					foreach ($goods as $key => $v){
						Db::name('goods')->where('goodsId',$v['goodsId'])->setInc('goodsStock',$v['goodsNum']);
					}
					//新增订单日志
					$logOrder = [];
					$logOrder['orderId'] = $orderId;
					$logOrder['orderStatus'] = -1;
					$logOrder['logContent'] = "门店取消订单，取消原因：".$reasonData['dataName'];
					if($reason==10000)$logOrder['logContent'] .= ":$content";
					$logOrder['logUserId'] = $userId;
					$logOrder['logType'] = 0;
					$logOrder['logTime'] = date('Y-m-d H:i:s');
					Db::name('log_orders')->insert($logOrder);
					Db::commit();
					return WSTReturn('订单取消成功',1);
				}
			}catch (\Exception $e) {
		        Db::rollback();
	            return WSTReturn('操作失败',-1);
	        }
		}
		return WSTReturn('操作失败，请检查订单状态是否已改变');
	}
	/**
	 * 获取订单价格
	 */
	public function getMoneyByOrder($orderId = 0){
		$shopId = session('WST_SHOP.shopId');
		$orderId = ($orderId>0)?$orderId:(int)input('post.id');
		return $this->where([['shopId','=',$shopId],['orderId','=',$orderId]])->field('orderId,goodsMoney,deliverMoney,totalMoney,realTotalMoney')->find();
	}
	/**
	 * 修改订单价格
	 */
	public function editOrderMoney(){
		$orderId = input('post.id');
		$orderMoney = (float)input('post.orderMoney');
		if($orderMoney<0.01)return WSTReturn("订单价格必须大于0.01");
		Db::startTrans();
		try{
			$orders = $this->where([['orderId','=',$orderId],['shopId','=',(int)session('WST_SHOP.shopId')]])->find();
			if(empty($orders))return WSTReturn('操作失败，无效的订单信息');
			if($orders->orderStatus==-2){
				$orders->realTotalMoney = $orderMoney;
				$orders->needPay = $orderMoney;
				$orders->payRand = array("exp","payRand+1");
				$result = $orders->save();
				if(false !== $result){
					//新增订单日志
					$logOrder = [];
					$logOrder['orderId'] = $orderId;
					$logOrder['orderStatus'] = -2;
					$logOrder['logContent'] = "门店修改订单价格为：".$orderMoney;
					$logOrder['logUserId'] = $orders['userId'];
					$logOrder['logType'] = 0;
					$logOrder['logTime'] = date('Y-m-d H:i:s');
					Db::name('log_orders')->insert($logOrder);
					Db::commit();
					return WSTReturn('操作成功',1);
				}
			}
		}catch (\Exception $e) {
			Db::rollback();
			return WSTReturn('操作失败',-1);
		}
	}
	/**
	 * 导出订单
	 */
	public function toExport(){
		$name='订单表';
		$orderNo = input('orderNo');
		$userId = (int)input('userId');
		$type = (int)input('type',-1);
		$payType = $type>0?$type:(int)input('payType',-1);
		$deliverType = (int)input('deliverType',-1);
		$orderStatus = (int)input('orderStatus',0);
		if($orderStatus==0){
			$name='待发货订单表';
		}else if($orderStatus==-2){
			$name='待付款订单表';
		}else if($orderStatus==1){
			$name='已发货订单表';
		}else if($orderStatus==-1){
			$name='取消订单表';
		}else if($orderStatus==-2){
			$name='拒收订单表';
		}else if($orderStatus==2){
			$name='已收货订单表';
		}else if($orderStatus==1000){
			$name='取消/拒收订单表';
		}else if($orderStatus==1001){
			$name='退款订单表';
		}
		$where = ['dataFlag'=>1];
        $where['o.shopId'] = session('WST_SHOP.shopId');;
		if($orderStatus==1000){
			$where[] = ['o.orderStatus','in','-1,-3'];
		}else{
			$where['o.orderStatus'] = $orderStatus;
		}
		if($orderNo!=''){
			$where['orderNo'] = ['like',"%$orderNo%"];
		}
		if($userId>0){
			$where['o.userId'] = $userId;
			$user = Db::name('users')->where('userId',$userId)->field('userName')->find();
			$name = $user['userName'].'的订单表';
		}
		if($payType > -1){
			$where['payType'] =  $payType;
		}
		if($deliverType > -1){
			$where['deliverType'] =  $deliverType;
		}
		$page = $this->alias('o')->where($where)
		->join('__LOG_ORDERS__ lo','lo.orderId=o.orderId and lo.orderStatus in (-1,-3) ','left')
		->field('o.orderId,orderNo,goodsMoney,totalMoney,realTotalMoney,o.orderStatus,deliverType,deliverMoney,isAppraise,lo.logContent
		              ,payType,payFrom,userAddress,isPay,isAppraise,userName,userPhone,orderRemarks,orderSrc,o.isInvoice,o.invoiceJson,o.receiveTime,o.bookTime,o.deliveryTime,o.createTime')
			              ->order('o.createTime', 'desc')
			              ->select();
		if(count($page)>0){
			foreach ($page as $key => $v){
				$page[$key]['invoiceClient'] = '';
				if($v['isInvoice']==1){
					$invoiceArr = json_decode($v['invoiceJson'],true);
					$page[$key]['invoiceClient'] = " ".$invoiceArr['invoiceHead'];
					if(isset($invoiceArr['invoiceCode'])){
						$page[$key]['invoiceClient'] = " ".$invoiceArr['invoiceHead'].'|'.$invoiceArr['invoiceCode'];
					}
				}
				$page[$key]['payTypeName'] = WSTLangPayType($v['payType']);
				$page[$key]['deliverType'] = WSTLangDeliverType($v['deliverType']==1);
				$page[$key]['status'] = WSTLangOrderStatus($v['orderStatus']);
			}
		}
		require Env::get('root_path') . 'extend/phpexcel/PHPExcel/IOFactory.php';
		$objPHPExcel = new \PHPExcel();
		// 设置excel文档的属性
		$objPHPExcel->getProperties()->setCreator("WSTShop")//创建人
		->setLastModifiedBy("WSTShop")//最后修改人
		->setTitle($name)//标题
		->setSubject($name)//题目
		->setDescription($name)//描述
		->setKeywords("订单")//关键字
		->setCategory("Test result file");//种类
	
		// 开始操作excel表
		$objPHPExcel->setActiveSheetIndex(0);
		// 设置工作薄名称
		$objPHPExcel->getActiveSheet()->setTitle(iconv('gbk', 'utf-8', 'Sheet'));
		// 设置默认字体和大小
		$objPHPExcel->getDefaultStyle()->getFont()->setName(iconv('gbk', 'utf-8', ''));
		$objPHPExcel->getDefaultStyle()->getFont()->setSize(11);
		$styleArray = array(
				'font' => array(
						'bold' => true,
						'color'=>array(
								'argb' => 'ffffffff',
						)
				),
				'borders' => array (
						'outline' => array (
								'style' => \PHPExcel_Style_Border::BORDER_THIN,  //设置border样式
								'color' => array ('argb' => 'FF000000'),     //设置border颜色
						)
				)
		);
		//设置宽
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(50);
		$objPHPExcel->getActiveSheet()->getStyle('A1:Q1')->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID);
		$objPHPExcel->getActiveSheet()->getStyle('A1:Q1')->getFill()->getStartColor()->setARGB('333399');
	
		$objPHPExcel->getActiveSheet()->setCellValue('A1', '订单编号')->setCellValue('B1', '订单状态')->setCellValue('C1', '收货人')->setCellValue('D1', '收货地址')->setCellValue('E1', '联系方式')
		->setCellValue('F1', '支付方式')->setCellValue('G1', '配送方式')->setCellValue('H1', '买家留言')->setCellValue('I1', '发票信息')->setCellValue('J1', '订单总金额')->setCellValue('K1', '运费')
		->setCellValue('L1', '实付金额')->setCellValue('M1', '下单时间')->setCellValue('N1', '预定配送时间')->setCellValue('O1', '发货时间')->setCellValue('P1', '收货时间')->setCellValue('Q1', '取消/拒收原因');
		$objPHPExcel->getActiveSheet()->getStyle('A1:Q1')->applyFromArray($styleArray);
	
		for ($row = 0; $row < count($page); $row++){
			$i = $row+2;
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$i, " ".$page[$row]['orderNo'])->setCellValue('B'.$i, $page[$row]['status'])->setCellValue('C'.$i, $page[$row]['userName'])->setCellValue('D'.$i, $page[$row]['userAddress'])
			->setCellValue('E'.$i, " ".$page[$row]['userPhone'])->setCellValue('F'.$i, $page[$row]['payTypeName'])->setCellValue('G'.$i, $page[$row]['deliverType'])->setCellValue('H'.$i, $page[$row]['orderRemarks'])->setCellValue('I'.$i, $page[$row]['invoiceClient'])
			->setCellValue('J'.$i, $page[$row]['totalMoney'])->setCellValue('K'.$i, $page[$row]['deliverMoney'])->setCellValue('L'.$i, $page[$row]['realTotalMoney'])->setCellValue('M'.$i, $page[$row]['createTime'])->setCellValue('N'.$i, $page[$row]['bookTime'])
			->setCellValue('O'.$i, $page[$row]['deliveryTime'])->setCellValue('P'.$i, $page[$row]['receiveTime'])->setCellValue('Q'.$i, $page[$row]['logContent']);
		}
	
		//输出EXCEL格式
		$objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		// 从浏览器直接输出$filename
		header('Content-Type:application/csv;charset=UTF-8');
		header("Pragma: public");
		header("Expires: 0");
		header("Cache-Control:must-revalidate, post-check=0, pre-check=0");
		header("Content-Type:application/force-download");
		header("Content-Type:application/vnd.ms-excel;");
		header("Content-Type:application/octet-stream");
		header("Content-Type:application/download");
		header('Content-Disposition: attachment;filename="'.$name.'.xls"');
		header("Content-Transfer-Encoding:binary");
		$objWriter->save('php://output');
	}
}
