<?php
namespace wststore\admin\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 店铺资金流水日志业务处理
 */
class LogShopMoneys extends Base{

    /**
	 * 分页
	 */
	public function pageQuery(){
		$key = input('key');
		$userId = input('id');
		$startDate = input('startDate');
		$endDate = input('endDate');
		$where = [];
		if($startDate!='')$where[] = ['l.createTime','>=',$startDate." 00:00:00"];
		if($endDate!='')$where[] = [' l.createTime','<=',$endDate." 23:59:59"];
		if($userId!='')$where[] = ['l.userId','=',$userId];
		if($key!='')$where[] = ['s.shopName','like','%'.$key.'%'];
		$page = $this->alias('l')
					 ->join('__SHOPS__ s','l.shopId=s.shopId ','left')
					 ->where($where)->field('l.*,s.shopName')->order('l.id', 'desc')
					 ->paginate(input('l.limit/d'))->toArray();
		if(count($page['data'])>0){
			foreach ($page['data'] as $key => $v) {
				$page['data'][$key]['dataSrc'] = WSTLangMoneySrc($v['dataSrc']);
			}
		}
		return $page;
	}

	/**
     * 新增记录
     */
    public function add($log){
          $log['createTime'] = date('Y-m-d H:i:s');
          $this->create($log);
          if($log['moneyType']==1){
		      Db::name('shops')->where(["shopId"=>$log['shopId']])->setInc('shopMoney',$log['money']);
          }else{
		      Db::name('shops')->where(["shopId"=>$log['shopId']])->setDec('shopMoney',$log['money']);
          }
      }
}
