<?php
namespace wststore\shop\model;
use wststore\shop\validate\GoodsStocks as validate;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品库存类
 */
class GoodsStocks extends Base{
	/**
	 * 添加商品库存
	 */
	public function add(){
		$data = input('post.');
		WSTUnset($data,'id');
		$data['shopId'] = (int)session('WST_SHOP.shopId');
		$data['createTime'] = date('Y-m-d H:i:s');
		//查询商品
		$goods = Db::name('goods')->where([['goodsId','=',$data['goodsId']],['shopId','=',$data['shopId']]])->find();
		if(!$goods)return WSTReturn('非法的入库操作');
		Db::startTrans();
		try{
			$validate = new validate();
		    if(!$validate->scene('add')->check($data))return WSTReturn($validate->getError());
			$result = $this->allowField(true)->save($data);
        	if(false !== $result){
        		$stock = ($data['stockType']==1)?$data['stockQty']:-1*$data['stockQty'];
        		Db::name('goods')->where('goodsId',$data['goodsId'])->setInc('goodsStock',$stock);
        		Db::commit();
        	    return WSTReturn("新增成功", 1);
        	}
		}catch (\Exception $e) {
            Db::rollback();
        }
        return WSTReturn('新增失败',-1); 
	}

	/**
	 * 获取库存列表
	 */
	public function pageQuery(){
		$startDate = input('startDate');
		$endDate = input('endDate');
		$stockType = input('stock',0);
		$where = [];
		$where[] = ['goodsId','=',input('goodsId/d')];
		if($stockType!=0)$where[] = ['stockType','=',$stockType];
		$where[] = ['shopId','=',(int)session('WST_SHOP.shopId')];
		if($startDate!='')$where[] = ['createTime','>=',$startDate];
		if($endDate!='')$where[] = ['createTime','<=',$endDate];
        return $this->where($where)->order('id desc')->paginate(input('limit/d'))->toArray();
	}
}
