<?php
namespace wststore\shop\model;
use wststore\shop\validate\GoodsLibs as Validate;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品库类
 */
class GoodsLibs extends Base{
    protected $pk = 'goodsLibId';
	/**
	 * 获取商品信息
	 */
	public function getById($id){
        $data = $this->where(['goodsLibId'=>$id,'dataFlag'=>1])->find();
        if($data['gallery']!='')$data['gallery'] = explode(',',$data['gallery']);
        //获取商品分类
        $data['catName'] = Db::name('goods_cats')->where('catId',$data['goodsCatId'])->value('catName');
        //获取品牌
        if($data['brandId']>0){
            $data['brandName'] = '';
        }else{
            $data['brandName'] = Db::name('brands')->where('brandId',$data['brandId'])->value('brandName');	
        }
        //获取属性值
		$data['attrs'] = Db::name('attributes')->alias('a')->join('goods_attributes ga','a.attrId=ga.attrId','inner')
			                   ->where(['a.isShow'=>1,'dataFlag'=>1,'goodsLibId'=>$data['goodsLibId']])->field('a.attrName,ga.attrVal')
			                   ->order('attrSort asc')->select();
		return $data;
	}
     /**
      *  标准商品库列表
      */
	public function pageQuery(){
		$where = [];
		$where['gl.dataFlag'] = 1;
		$where['gl.isSale'] = 1;
		$goodsCatId = (int)input('goodsCatId');
		$goodsName = input('goodsName');
		if($goodsCatId>0)$where[] = ['gl.goodsCatId','=',$goodsCatId];
		if($goodsName != '')$where[] = ['gl.goodsName|gl.goodsSn','like',"%$goodsName%"];
		// 排序
		$sort = input('sort');
		$order = 'g.goodsId desc,gl.saleTime desc';
		if($sort!=''){
			$sortArr = explode('.',$sort);
			$order = $sortArr[0].' '.$sortArr[1];
		}
		$rs = $this->alias('gl')->join('__GOODS_CATS__ s','gl.goodsCatId=s.catId','left')
		    ->join('__GOODS__ g','gl.goodsLibId=g.goodsLibId and g.shopId='.(int)session('WST_SHOP.shopId'),'left')
		    ->where($where)
			->field('gl.goodsLibId,goodsName,goodsSn,retailPrice,shopCostPrice,goodsImg,goodsCatId,s.catName,g.goodsId')
			->order($order)
			->paginate(input('limit/d'))->toArray();
		return $rs;
	}
	/**
	 * 已选商品列表
	 */
    public function listQuery(){
		$where = [];
		$where['dataFlag'] = 1;
		$where['isSale'] = 1;
		$ids = WSTFormatIn(',',input('ids'));
		$where[] = ['goodsLibId','in',$ids];
		$rs = $this->where($where)
			->field('goodsLibId,goodsName,retailPrice,shopCostPrice,goodsImg')
			->order('saleTime desc')
			->select();
		return $rs;
	}

	 /**
	 * 获取商品规格属性
	 */
	public function getAttrs(){
		$goodsCatId = Input('post.goodsCatId/d');
		$goodsCatIds = model('GoodsCats')->getParentIs($goodsCatId);
		$data = [];
		$data['attrs'] = Db::name('attributes')->where([['dataFlag','=',1],['isShow','=',1],['goodsCatId','in',$goodsCatIds]])->field('attrId,attrName,attrType,attrVal')->order('attrSort asc,attrId asc')->select();
	    return WSTReturn("", 1,$data);
	}

}
