<?php
namespace wststore\shop\model;
use think\Db;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 商品库类
 */
class Goods extends Base{
    protected $pk = 'goodsId';
	/**
	 * 从商品库中上架商品
	 */
	public function add(){
		$shopId = (int)session('WST_SHOP.shopId');
		$ids = WSTFormatIn(',',input('ids'));
		if($ids=='')return WSTReturn('请选择上架的商品');
		$ids = explode(',',$ids);
        //判断商品是否已存在
        $filter = $this->field('goodsLibId')->where([['goodsLibId','in',$ids],['shopId','=',$shopId]])->select();
        if(count($filter)>0){
        	foreach ($filter as $key => $v) {
        		for ($i=0;$i<count($ids);$i++) {
        			if((int)$ids[$i]==$v['goodsLibId'])array_splice($ids,$i,1);
        		}
        	}
        }
        if(count($ids)==0)return WSTReturn('无效的商品，请选择要上架的商品');
		//判断商品合法性
		$goods = Db::name('goods_libs')->field('goodsLibId,shopCostPrice')->where([['goodsLibId','in',$ids],['isSale','=',1],['dataFlag','=',1]])->select();
		if(count($goods)==0)return WSTReturn('无效的商品，请选择要上架的商品');
		Db::startTrans();
		try{
			foreach ($goods as $key => $v) {
				$data = [];
				$data['shopId'] = $shopId;
	            $data['goodsLibId'] = $v['goodsLibId'];
	            $data['costPrice'] = $v['shopCostPrice'];
	            $data['shopPrice'] = (float)input('goodsPrice_'.$v['goodsLibId']);
	            $data['goodsStock'] = (int)input('goodsStock_'.$v['goodsLibId']);
	            $data['saleTime'] = date('Y-m-d H:i:s');
	            $obj = $this->create($data);
	            if($obj!==false){
	            	$goodsId = $obj->goodsId;
	            	//增加入库记录
	            	$stock = [];
	            	$stock['shopId'] = $shopId;
	            	$stock['goodsId'] = $goodsId;
	            	$stock['stockPrice'] = $data['costPrice'];
	            	$stock['stockType'] = 1;
	            	$stock['stockQty'] = $data['goodsStock'];
	            	$stock['stockRemarks'] = '商品初次入库';
	            	$stock['createTime'] = date('Y-m-d H:i:s');
	            	model('GoodsStocks')->create($stock);
	            }

			}
			Db::commit();
			return WSTReturn('上架成功',1);
		}catch (\Exception $e) {
			print_r($e);
            Db::rollback();
        }
		return WSTReturn('上架失败');
	}

	/**
	 * 获取商品分页
	 */
	public function pageQuery($sale){
		$shopId = (int)session('WST_SHOP.shopId');
		$goodsCatId = (int)input('goodsCatId');
		$goodsName = input('goodsName');
		$where = [];
		$where[] = ['gl.dataFlag','=',1];
		$where[] = ['gl.isSale','=',1];
		$where[] = ['g.isSale','=',$sale];
		$where[] = ['g.shopId','=',$shopId];
		if($goodsCatId>0)$where[] = ['gl.goodsCatId','=',$goodsCatId];
		if($goodsName != '')$where[] = ['gl.goodsName|goodsSn','like',"%$goodsName%"];
		// 排序
		$sort = input('sort');
		$order = 'g.saleTime desc';
		if($sort!=''){
			$sortArr = explode('.',$sort);
			$order = $sortArr[0].' '.$sortArr[1];
		}
		$rs = $this->alias('g')
		    ->join('__GOODS_LIBS__ gl','gl.goodsLibId=g.goodsLibId','left')
		    ->join('__GOODS_CATS__ s','gl.goodsCatId=s.catId','left')
		    ->where($where)
			->field('g.goodsLibId,g.goodsId,gl.goodsName,gl.goodsSn,g.goodsStock,g.saleNum,g.costPrice,g.shopPrice,gl.goodsImg,g.isNew,g.isHot,g.isRecom,g.isBest,g.warnStock')
			->order($order)
			->paginate(input('limit/d'))->toArray();
		return $rs;
	}

		/**
	 * 获取商品分页
	 */
	public function warnByPage(){
		$shopId = (int)session('WST_SHOP.shopId');
		$goodsCatId = (int)input('goodsCatId');
		$goodsName = input('goodsName');
		$where = [];
		$where[] = ['gl.dataFlag','=',1];
		$where[] = ['gl.isSale','=',1];
		$where[] = ['g.shopId','=',$shopId];
		$where[] = ['g.goodsStock','<=',10];
		if($goodsCatId>0)$where[] = ['gl.goodsCatId','=',$goodsCatId];
		if($goodsName != '')$where[] = ['gl.goodsName|goodsSn','like',"%$goodsName%"];
		// 排序
		$sort = input('sort');
		$order = 'g.saleTime desc';
		if($sort!=''){
			$sortArr = explode('.',$sort);
			$order = $sortArr[0].' '.$sortArr[1];
		}
		$rs = $this->alias('g')
		    ->join('__GOODS_LIBS__ gl','gl.goodsLibId=g.goodsLibId','left')
		    ->join('__GOODS_CATS__ s','gl.goodsCatId=s.catId','left')
		    ->where($where)
			->field('g.goodsLibId,g.goodsId,gl.goodsName,gl.goodsSn,g.goodsStock,g.saleNum,g.costPrice,g.shopPrice,gl.goodsImg,g.isNew,g.isHot,g.isRecom,g.isBest,g.isSale')
			->order($order)
			->paginate(input('limit/d'))->toArray();
		return $rs;
	}

	/**
	 * 批量上架商品
	 */
	public function changeSale(){
		$shopId = (int)session('WST_SHOP.shopId');
		$ids = input('ids');
		$isSale = (int)input('isSale',1);
		$ids = explode(',' , $ids);
		//判断商品是否满足上架要求
		if($isSale==1){
	 		//直接设置上架 返回受影响条数
	 		$where = [];
	 		$where[] = ['g.goodsId','in',$ids];
	 		$where[] = ['gl.dataFlag','=',1];
	 		$where[] = ['gl.isSale','=',1];
	 		$where[] = ['g.shopId','=',$shopId];
			$rs = $this->alias('g')
				  ->join('__GOODS_LIBS__ gl','gl.goodsLibId=g.goodsLibId','inner')
				  ->where($where)->update(['g.isSale'=>1]);
			if($rs!==false){
				$status = ($rs==count($ids))?1:2;
				if($status==1){
					return WSTReturn('商品上架成功', 1,['num'=>$rs]);
				}else{
					return WSTReturn('已成功上架商品'.$rs.'件。', 2,['num'=>$rs]);
				}
			}else{
	 			return WSTReturn('上架失败!', -2);
	 		}

		}else{
			$rs = $this->where([['goodsId','in',$ids],['shopId','=',$shopId]])->update(['isSale'=>0]);
			if($rs !== false){
				return WSTReturn('商品下架成功', 1);
			}else{
				return WSTReturn($this->getError(), -1);
			}
		}
	}
	
   /**
	* 修改商品状态
	*/
	public function changSaleStatus(){
		$shopId = (int)session('WST_SHOP.shopId');
		$is = input('post.is');
		if(!in_array($is,['isRecom','isBest','isHot','isNew']))return WSTReturn('非法的操作');
		$status = (input('post.status',1)==1)?0:1;
		$id = (int)input('post.id');
		$rs = $this->update([$is=>$status],['goodsId'=>$id,'shopId'=>$shopId]);
		if($rs!==false){
			return WSTReturn('设置成功',1);
		}else{
			return WSTReturn($this->getError(),-1);
		}
	}

    /**
     * 修改商品信息
     */
    public function editGoodsBase(){
    	$shopId = (int)session('WST_SHOP.shopId');
		$code = input('post.code');
		$val = input('post.val');
		$goodsId = (int)input('post.goodsId');
		if(!in_array($code,['costPrice','shopPrice','warnStock']))return WSTReturn('非法的操作');
		$rs = $this->update([$code=>$val],['goodsId'=>$goodsId,'shopId'=>$shopId]);
		if($rs!==false){
			return WSTReturn('修改成功',1);
		}else{
			return WSTReturn($this->getError(),-1);
		}
    }
	/**
	 * 获取商品信息
	 */
	public function getById($id){
        $data = $this->alias('g')->join('__GOODS_LIBS__ gl','g.goodsLibId=gl.goodsLibId')
                     ->where(['g.goodsId'=>$id,'gl.dataFlag'=>1])->find();
        if($data['gallery']!='')$data['gallery'] = explode(',',$data['gallery']);
        //获取商品分类
        $data['catName'] = Db::name('goods_cats')->where('catId',$data['goodsCatId'])->value('catName');
        //获取品牌
        if($data['brandId']>0){
            $data['brandName'] = '';
        }else{
            $data['brandName'] = Db::name('brands')->where('brandId',$data['brandId'])->value('brandName');	
        }
        //获取属性值
		$data['attrs'] = Db::name('attributes')->alias('a')->join('goods_attributes ga','a.attrId=ga.attrId','inner')
			                   ->where(['a.isShow'=>1,'dataFlag'=>1,'goodsLibId'=>$data['goodsLibId']])->field('a.attrName,ga.attrVal')
			                   ->order('attrSort asc')->select();
		return $data;
	}

	/**
	 * 根据下架指定店铺下的所有商品
	 */
	public function unsaleByShopId($shopId){
        //下架商品
		$data = [];
		$data['isSale'] = 0;
		$goodsIds = [];
		$goods = $this->where([['shopId','=',$shopId],['isSale','=',1]])->field('goodsId')->select();
		if(!empty($goods)){
			foreach ($goods as $key => $v) {
				$goodsIds[] = $v['goodsId'];
			}
		}
		$result = $this->where([['shopId','=',$shopId]])->update($data);
		if(false !== $result){
		    //删除推荐商品,删除购物车里的商品
		    if(count($goodsIds)>0){
		    	//执行钩子事件
		    	// foreach ($goodsIds as $key => $v) {
		    	// 	hook('afterChangeGoodsStatus',['goodsId','=',$v]);
		    	// }
		    	Db::name('recommends')->where([['dataSrc','=',0],['dataId','in',$goodsIds]])->delete();
		        Db::name('carts')->whereIn('goodsId',$goodsIds)->delete();
		    }
		    Db::commit();
			return WSTReturn('操作成功',1);
		}
        return WSTReturn('删除失败',-1);
    }
}
