<?php
namespace wststore\shop\model;
use wststore\shop\validate\Areas as validate;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 地区业务处理
 */
class Areas extends Base{
	/**
	 * 分页
	 */
	public function pageQuery(){
		$parentId = input('get.parentId/d',0);
		return $this->where([['dataFlag','=',1],['parentId','=',$parentId]])->order('areaId desc')->paginate(input('post.limit/d'));
	}
	
	/**
	 * 获取指定对象
	 */
	public function getById($id){
		return $this->get(['dataFlag'=>1,'areaId'=>$id]);
	}
	
	/**
	 * 获取地区
	 */
	public function getFieldsById($id,$fileds){
		return $this->where(['dataFlag'=>1,'areaId'=>$id])->field($fileds)->find();
	}
	
	/**
	 *  获取地区列表
	 */
	public function listQuery($parentId){
		return $this->where(['dataFlag'=>1,'parentId'=>$parentId,'isShow'=>1])->field('areaId,areaName,parentId')->order('areaSort desc')->select();
	}

	/**
	 * 根据子分类获取其父级分类
	 */
	public function getParentIs($id,$data = array()){
		$data[] = $id;
		$parentId = $this->where('areaId',$id)->value('parentId');
		if($parentId==0){
			krsort($data);
			return $data;
		}else{
			return $this->getParentIs($parentId, $data);
		}
	}
}