<?php
namespace wststore\shop\controller;
use wststore\shop\model\Orders as M;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 订单控制器
 */
class Orders extends Base{
	/**
	 * 待发货订单列表
	 */
    public function waitDelivery(){
        $express = model('common/Express')->listQuery();
        $this->assign('express',$express);
        $deliveryers = model('shop/Deliveryers')->listQuery();
        $this->assign('deliveryers',$deliveryers);
    	return $this->fetch("list_wait_delivery");
    }
    /**
     * 获取分页
     */
    public function waitDeliveryByPage(){
    	$m = new M();
    	return WSTGrid($m->pageQuery(0));
    }
    /**
     * 待付款订单列表
     */
    public function waitPay(){
    	return $this->fetch("list_wait_pay");
    }
    /**
     * 获取分页
     */
    public function waitPayByPage(){
    	$m = new M();
    	return WSTGrid($m->pageQuery(-2,1));
    }
    /**
     * 已发货订单列表
     */
    public function delivery(){
    	return $this->fetch("list_delivery");
    }
    /**
     * 获取分页
     */
    public function deliveryByPage(){
    	$m = new M();
    	return WSTGrid($m->pageQuery(1));
    }
    /**
     * 已收货订单列表
     */
    public function received(){
    	return $this->fetch("list_received");
    }
    /**
     * 获取分页
     */
    public function receivedByPage(){
    	$m = new M();
    	return WSTGrid($m->pageQuery(2));
    }
    /**
     * 取消/拒收订单列表
     */
    public function abnormal(){
        return $this->fetch("list_abnormal");
    }
    /**
     * 获取分页
     */
    public function abnormalByPage(){
    	$m = new M();
        $orderStatus = (int)input('orderStatus',1000);
        return WSTGrid($m->pageQuery($orderStatus));
    }
    
    /**
     * 获取订单详情
     */
    public function view(){
    	$m = new M();
    	$rs = $m->getByView(Input("id/d",0));
    	$this->assign("object",$rs);
    	$this->assign("from",Input("from/d",0));
    	return $this->fetch("view");
    }
    /**
     * 发货
     */
    public function deliver(){
    	$m = new M();
    	$rs = $m->deliver();
    	return $rs;
    }
    /**
     * 删除订单
     */
    public function del(){
    	$m = new M();
    	$rs = $m->del();
    	return $rs;
    }
    /**
     * 取消订单
     */
    public function cancel(){
    	$m = new M();
    	return $m->cancel();
    }
    /**
     * 获取订单价格
     */
    public function getMoneyByOrder(){
    	$m = new M();
    	$rs = $m->getMoneyByOrder();
    	return WSTReturn('',1,$rs);
    }
    /**
     * 修改订单价格
     */
    public function editOrderMoney(){
    	$m = new M();
    	$rs = $m->editOrderMoney();
    	return $rs;
    }
    /**
     * 导出订单
     */
    public function toExport(){
    	$m = new M();
    	$rs = $m->toExport();
    	$this->assign('rs',$rs);
    }
}

