<?php
namespace wststore\shop\controller;
use wststore\shop\model\Goods as M;
/**
 * ============================================================================
 * WSTStore连锁商店系统
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wststore.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 店铺商品控制器
 */
class Goods extends Base{
   /**
    *  上架商品列表
    */
	public function onSale(){
		return $this->fetch('list_sale');
	}
	/**
	 * 获取上架商品列表
	 */
	public function saleByPage(){
		$m = new M();
		$rs = $m->pageQuery(1);
		$rs['status'] = 1;
		return WSTGrid($rs);
	}
	/**
	 * 从商品库中上架商品
	 */
	public function add(){
		$m = new M();
		return $m->add();
	}

   /**
    *  仓库商品列表
    */
	public function onStore(){
		return $this->fetch('list_store');
	}
	/**
	 * 获取仓库商品列表
	 */
	public function storeByPage(){
		$m = new M();
		$rs = $m->pageQuery(0);
		$rs['status'] = 1;
		return WSTGrid($rs);
	}

	/**
	 * 批量上下架
	 */
	public function changeSale(){
		$m = new M();
		return $m->changeSale();
	}

   /**
    * 修改商品状态
    */
    public function changSaleStatus(){
        $m = new M();
        return $m->changSaleStatus();
    }
    /**
     * 修改商品数据
     */
    public function editGoodsBase(){
    	$m = new M();
        return $m->editGoodsBase();
    }

    /**
     * 查看商品
     */
    public function toView(){
    	$m = new M();
    	$data = $m->getById(input("id/d",0));
        return $this->fetch("view",['object'=>$data,'src'=>input('src')]);
    }

    /**
    *  仓库商品列表
    */
	public function onWarn(){
		return $this->fetch('list_warn');
	}
	/**
	 * 获取仓库商品列表
	 */
	public function warnByPage(){
		$m = new M();
		$rs = $m->warnByPage();
		$rs['status'] = 1;
		return WSTGrid($rs);
	}
}
