<?php
/**
 * 判断有没有权限
 * @param $code 权限代码
 * @param $type 返回的类型  true-boolean   false-string
 */
function WSTGrant($code){
	$STAFF = session("WST_SHOP");
	if(in_array($code,$STAFF['privileges']))return true;
	return false;
}

/**
 * 加载系统访问路径
 */
function WSTVisitShopPrivilege(){
	 $listenUrl = cache('WST_SHOP_PROTTECT_URL');
	 if(!$listenUrl){
	     $list = model('shop/ShopPrivileges')->getAllPrivileges();
	     $listenUrl = [];
	     foreach ($list as $v){
	     	if($v['privilegeUrl']=='')continue;
	        $listenUrl[strtolower($v['privilegeUrl'])][$v['privilegeCode']] = ['code'=>$v['privilegeCode'],
												          'url'=>$v['privilegeUrl'],
												          'name'=>$v['privilegeName'],
												          'isParent'=>true,
	        			                                  'menuId'=>$v['menuId']
	                                                     ];
	        if(strpos($v['otherPrivilegeUrl'],'/')!==false){
	        	$t = explode(',',$v['otherPrivilegeUrl']);
	        	foreach ($t as $vv){
	        		if(strpos($vv,'/')!==false){
	        			$listenUrl[strtolower($vv)][$v['privilegeCode']] = ['code'=>$v['privilegeCode'],
									        		   'url'=>$vv,
									        		   'name'=>$v['privilegeName'],
									        		   'isParent'=>false,
	        			                               'menuId'=>$v['menuId']
									        		  ];
	        		}
	        	}
	        }
	     }
	     cache('WST_SHOP_PROTTECT_URL',$listenUrl);
	 }
     return $listenUrl;
}
