//切换
function switchOrder(obj,n){
	$(obj).addClass('active').siblings('.wst-or-item .item').removeClass('active');
	$('#type').val(n);
    $('#currPage').val(0);
    $('#totalPage').val(0);
    $('.wst-or-list').html('<div id="orders-list"></div>');
	load(n);
}
// 刷新列表页
function reFlashList(){
	$('#currPage').val(0);
	$('#totalPage').val(0);
	$('.wst-or-list').html('<div id="orders-list"></div>');
	load($('#type').val());
}
//订单列表
function orderList(){
	load($('#type').val());
}
function load(n){
	var param = {};
	loading = true;
	param.type = n;
	param.page = Number( $('#currPage').val() ) + 1;
	param.pagesize = 10;
	$.post(WST.U('mobile/orders/orderList'), param, function(data){
		var json = WST.toJson(data);
		var html = '';
		if(json && json.data && json.data.length>0){
			$('#currPage').val(json.current_page);
			$('#totalPage').val(json.last_page);
			var gettpl = document.getElementById('list').innerHTML;
			laytpl(gettpl).render(json.data, function(html){
				$('#orders-list').append(html);
				echo.init();//图片懒加载
			});
			if($('.wst-goods-swiper a').hasClass("goodsImg")){
				//中间小广告
				new Swiper('.swiper-container', {
					slidesPerView: 5,
					freeMode : true,
					spaceBetween: 10,
					autoplay : false,
					speed:1200,
					loop : false,
					autoHeight: true, //高度随内容变化
					on: {
						resize: function(){
							this.params.width = window.innerWidth;
							this.update();
						},
						slideChange(){
							echo.init();
						}
					}
				});
			}else{
				$('.wst-goods-swiper').hide();
			}
		}else{
			html += '<div class="wst-prompt-icon"><img style="margin-left:0.07rem" src="'+ WST.conf.VIEW +'/img/nothing-order.png"></div>';
			html += '<div class="wst-prompt-info">';
			html += '<p>暂无订单</p>';
			html += '<button class="ui-btn-s" onclick="javascript:WST.intoIndex();">去逛逛</button>';
			html += '</div>';
			$('#orders-list').html(html);
		}
		loading = false;
		// echo.init();//图片懒加载
	});
}
//详情
var detailsId = 0;
function details(id){
	detailsId = id;
	$.post(WST.U('mobile/orders/getDetail'),{id:id},function(data){
	    var json = WST.toJson(data);
	    if(json.status==1){
            var gettpl = document.getElementById('list2').innerHTML;
            laytpl(gettpl).render(json.data, function(html){
                $('#orders-details').html(html);
                $('#details-tel').attr('href','tel:'+json.data.shopTel);
                if(json.data.isComplain==0){
                	$('.wst-or-details').addClass('after');
                	$('#orders-details-footer').show();
                }else{
                	$('.wst-or-details').removeClass('after');
                	$('#orders-details-footer').hide();
                }
                setTimeout(function(){
                    echo.init();//图片懒加载
                },1000);
            });
	    }else{
	    	$.toptips(json.msg);
	    }
	});
}
//取消订单
function choiceBox(type,n){
	if(type==1){
		$('.weui_mask').addClass('weui_mask_visible');
		$('.wst-or-'+n).addClass('weui-dialog-visible');
	}else{
     	$('.weui_mask').removeClass('weui_mask_visible');
		$('.wst-or-'+n).removeClass('weui-dialog-visible');
	}
}

//投诉
function complaint(type){
	if(type==1){
		$('#or-complaint').addClass('weui-popup-container-visible');
		$('.wst-or-complaint').addClass('weui-popup-modal-visible');
	}else{
		$('#or-complaint').removeClass('weui-popup-container-visible');
		$('.wst-or-complaint').removeClass('weui-popup-modal-visible');
	}
}
function complaintSelect(obj,v){
	$(obj).addClass('active').siblings('.wst-or-complaint ul li').removeClass('active');
	if(v==10000){
		$('#complaintFrame').show();
	}else{
		$('#complaintFrame').hide();
	}
	$('#complaintReason').val(v);
}
function confirmComplaint(){
	var param = {};
	param.orderId=detailsId;
	param.complainType=$('#complaintReason').val();
	param.complainContent=$('#complaintReason2').val();
	if(param.complainType==0){
		$.toptips('请选择投诉原因','info');
		return false;
	}
	if(param.complainType==10000){
		if(param.complainContent == ''){
		  $.toptips('请输入投诉原因','info');
		  return false;
		}
	}
    $.post(WST.U('mobile/ordercomplains/complaint'), param, function(data){
        var json = WST.toJson(data);
        if( json.status == 1 ){
        	complaint(0);
        	$('.close-popup').trigger("click");
        	$.toast(json.msg);
        }else{
        	$.toptips(json.msg);
        }
        data = json = null;
    });
}
//确认收货
function receive(id){
	$.confirm("确认收货吗？", "", function() {
	    $.post(WST.U('mobile/orders/receive'), {id:id}, function(data){
	        var json = WST.toJson(data);
	        if( json.status == 1 ){
	        	$.toast(json.msg);
	            setTimeout(function(){
	            	orderList();
	            },1500);
	        }else{
	        	$.toptips(json.msg);
	        }
	        data = json = null;
	    });
	}, function() {});
}
//评价
function appraise(id){
	location.href=WST.U('mobile/orders/orderAppraise',{'id':id});
}
//支付
function pay(pkey){
	location.href=WST.U('mobile/orders/payMode',{'pkey':pkey});
}
//跳转支付
function toPay(pkey,n){
	if(n=='alipays'){
		   location.href=WST.U('mobile/alipays/toPay',{'pkey':pkey});
	}else if(n=='wallets'){
    location.href = WST.U('mobile/wallets/toPay',{'pkey':pkey});
  }else if(n=='weixinpays'){
    location.href = WST.U('mobile/weixinpays/toPay',{'pkey':pkey});
  }
}
//余额支付
function walletPay(type){
	var payPwd = $('#payPwd').val();
	if(!payPwd){
		$.toptips('请输入支付密码','info');
		return false;
	}
	if(type==0){
		var payPwd2 = $('#payPwd2').val();
		if(payPwd2==''){
	    	$.toptips('请输入确认密码','info');
	        return false;
	    }
		if(payPwd!=payPwd2){
	    	$.toptips('确认密码不一致','info');
	        return false;
	    }
	}
    if(WST.conf.IS_CRYPTPWD==1){
        var public_key=$('#key').val();
        var exponent="10001";
   	    var rsa = new RSAKey();
        rsa.setPublic(public_key, exponent);
        var payPwd = rsa.encrypt(payPwd);
    }
	var params = {};
	if(type==0){
		params.newPass = payPwd;
		$.post(WST.U('mobile/users/editpayPwd'),params,function(data,textStatus){
			var json = WST.toJson(data);
		    if(json.status==1){
		    	$('.wst-loading').show();
		    	$('#wst-loading-prompt').html('成功设置密码，<br>订单支付中···');
		    }else{
		    	$.toptips(json.msg);
		    }
		});
	}else{
    	$('.wst-loading').show();
    	$('#wst-loading-prompt').html('订单支付中···');
	}
    params.payPwd = payPwd;
    params.id = $('#orderId').val();
    $('#pay-button').attr('disabled', 'disabled');
    setTimeout(function(){
	$.post(WST.U('mobile/wallets/payByWallet'),params,function(data,textStatus){
		var json = WST.toJson(data);
    	$('.wst-loading').hide();
	    if(json.status==1){
	    	$.toast(json.msg);
	        setTimeout(function(){
	        	location.href = WST.U('mobile/orders/index');
	        },1500);
	    }else{
	    	$.toptips(json.msg);
	        $('#pay-button').removeAttr('disabled');
	    }
	});
    },1000);
}

// 取消订单
function cancelOnSwitch(obj,val){
	$('.ui-icon-cancel').removeClass('weui_icon_success').addClass('weui_icon_circle');
	$(obj).children('.ui-icon-cancel').removeClass('weui_icon_circle').addClass('weui_icon_success');
	if(val==10000){
		$('#cancelTr').show();
	}else{
		$('#cancelTr').hide();
	}
}
function showCancelBox(event){
	$("#wst-event0").attr("onclick","javascript:"+event);
	$('#cover2').attr("onclick","javascript:hideCancelBox();").show();
	$('#cancelBox').animate({"bottom": 0}, 500);
}
function hideCancelBox(){
	$('#cancelBox').animate({'bottom': '-100%'}, 500);
	$('#cover2').hide();
}
function cancelOrder(oid){
	var flag=false;
	$('.ui-icon-cancel').each(function(k,v){
		if($(this).hasClass('weui_icon_success')){
			flag = true;
			$('#cancelReason').val($(this).attr('value'));
		}
	});
	if(!flag){
		$.toptips('请选择取消订单的原因','info');
		return;
	}
	var param = {};
	param.id=oid;
	param.reason=$('#cancelReason').val();
	param.content=$('#cancelContent').val();
	if(param.reason==10000){
		if(param.content == ''){
			$.toptips('请输入取消原因','info');
			return;
		}
	}
	$.post(WST.U('mobile/orders/cancel'),param,function(data){
		var json = WST.toJson(data);
		if(json.status==1){
			$.toast(json.msg,'success');
			hideCancelBox();
			setTimeout(function(){
				reFlashList();
			},1500);
		}else{
			$.toast(json.msg,'info');
		}
	});
}

// 拒收订单
function rejectOnSwitch(obj,val){
	$('.ui-icon-reject').removeClass('weui_icon_success').addClass('weui_icon_circle');
	$(obj).children('.ui-icon-reject').removeClass('weui_icon_circle').addClass('weui_icon_success');
	if(val==10000){
		$('#rejectTr').show();
	}else{
		$('#rejectTr').hide();
	}
}
function showRejectBox(event){
	$("#wst-event2").attr("onclick","javascript:"+event);
	$('#cover2').attr("onclick","javascript:hideRejectBox();").show();
	$('#rejectBox').animate({"bottom": 0}, 500);
}
function hideRejectBox(){
	$('#rejectBox').animate({'bottom': '-100%'}, 500);
	$('#cover2').hide();
}
function rejectOrder(oid){
	var flag=false;
	$('.ui-icon-reject').each(function(k,v){
		if($(this).hasClass('weui_icon_success')){
			flag = true;
			$('#rejectReason').val($(this).attr('value'));
		}
	});
	if(!flag){
		$.toptips('请选择拒收订单的原因','info');
		return;
	}
	var param = {};
	param.id=oid;
	param.reason=$('#rejectReason').val();
	param.content=$('#rejectContent').val();
	if(param.reason==10000){
		if(param.content == ''){
			$.toptips('请输入拒收原因','info');
			return;
		}
	}
	$.post(WST.U('mobile/orders/reject'),param,function(data){
		var json = WST.toJson(data);
		if(json.status==1){
			$.toast(json.msg,'success');
			hideRejectBox();
			setTimeout(function(){
				reFlashList();
			},1500);
		}else{
			$.toast(json.msg,'info');
		}
	});
}
